// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.documentapi.messagebus.protocol;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of document-protocol-policies
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentProtocolPoliciesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "b97766709a49f349f355d4379d6f9afa";
  public final static String CONFIG_DEF_NAME = "document-protocol-policies";
  public final static String CONFIG_DEF_NAMESPACE = "documentapi.messagebus.protocol";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=documentapi.messagebus.protocol",
    "cluster{}.defaultRoute string",
    "cluster{}.route[].name string",
    "cluster{}.route[].messageType int",
    "cluster{}.selector string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public Map<String, Cluster.Builder> cluster = new LinkedHashMap<>();

    public Builder() { }

    public Builder(DocumentProtocolPoliciesConfig config) {
      for (Map.Entry<String, Cluster> __entry : config.cluster().entrySet()) {
        cluster(__entry.getKey(), new Cluster.Builder(__entry.getValue()));
      }
    }

    private Builder override(Builder __superior) {
      cluster(__superior.cluster);
      return this;
    }

    public Builder cluster(String __key, Cluster.Builder __value) {
      cluster.put(__key, __value);
      return this;
    }

    public Builder cluster(Map<String, Cluster.Builder> __values) {
      cluster.putAll(__values);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before using it as the value
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder cluster(String __key, java.util.function.Consumer<Cluster.Builder> __func) {
      Cluster.Builder __inner = new Cluster.Builder();
      __func.accept(__inner);
      cluster.put(__key, __inner);
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentProtocolPoliciesConfig build() {
      return new DocumentProtocolPoliciesConfig(this);
    }

  }

  private final Map<String, Cluster> cluster;

  public DocumentProtocolPoliciesConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentProtocolPoliciesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "document-protocol-policies must be initialized: " + builder.__uninitialized);

    cluster = Cluster.createMap(builder.cluster);
  }

  /**
   * @return document-protocol-policies.cluster{}
   */
  public Map<String, Cluster> cluster() {
    return Collections.unmodifiableMap(cluster);
  }

  /**
   * @param key the key of the value to return
   * @return document-protocol-policies.cluster{}
   */
  public Cluster cluster(String key) {
    return cluster.get(key);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentProtocolPoliciesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("document-protocol-policies");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents document-protocol-policies.cluster{}
   */
  public final static class Cluster extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "defaultRoute",
        "selector"
        ));

      private String defaultRoute = null;
      public List<Route.Builder> route = new ArrayList<>();
      private String selector = null;

      public Builder() { }

      public Builder(Cluster config) {
        defaultRoute(config.defaultRoute());
        for (Route r : config.route()) {
          route(new Route.Builder(r));
        }
        selector(config.selector());
      }

      private Builder override(Builder __superior) {
        if (__superior.defaultRoute != null)
          defaultRoute(__superior.defaultRoute);
        if (!__superior.route.isEmpty())
          route.addAll(__superior.route);
        if (__superior.selector != null)
          selector(__superior.selector);
        return this;
      }

      public Builder defaultRoute(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        defaultRoute = __value;
        __uninitialized.remove("defaultRoute");
        return this;
      }


      /**
       * Add the given builder to this builder's list of Route builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder route(Route.Builder __builder) {
        route.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder route(java.util.function.Consumer<Route.Builder> __func) {
        Route.Builder __inner = new Route.Builder();
        __func.accept(__inner);
        route.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Route builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder route(List<Route.Builder> __builders) {
        route = __builders;
        return this;
      }

      public Builder selector(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        selector = __value;
        __uninitialized.remove("selector");
        return this;
      }


      public Cluster build() {
        return new Cluster(this);
      }

    }

    //  
    // Super config for all policies in the document protocol, keyed by content cluster ids.
    // Note: ContentPolicy also uses the "distribution" config.
    //  
    //  
    // Config used by MessageTypeRouteSelectorPolicy
    //  
    // Default route if no override is set for a type.
    private final StringNode defaultRoute;
    private final InnerNodeVector<Route> route;
    //  
    // Config used by DocumentRouteSelectorPolicy
    //  
    // The document selector for this cluster route.
    private final StringNode selector;

    public Cluster(Builder builder) {
      this(builder, true);
    }

    private Cluster(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "document-protocol-policies.cluster{} must be initialized: " + builder.__uninitialized);

      defaultRoute = (builder.defaultRoute == null) ?
          new StringNode() : new StringNode(builder.defaultRoute);
      route = Route.createVector(builder.route);
      selector = (builder.selector == null) ?
          new StringNode() : new StringNode(builder.selector);
    }

    /**
     * @return document-protocol-policies.cluster{}.defaultRoute
     */
    public String defaultRoute() {
      return defaultRoute.value();
    }

    /**
     * @return document-protocol-policies.cluster{}.route[]
     */
    public List<Route> route() {
      return route;
    }

    /**
     * @param i the index of the value to return
     * @return document-protocol-policies.cluster{}.route[]
     */
    public Route route(int i) {
      return route.get(i);
    }

    /**
     * @return document-protocol-policies.cluster{}.selector
     */
    public String selector() {
      return selector.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Cluster newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster");
      return changes;
    }

    private static Map<String, Cluster> createMap(Map<String, Builder> builders) {
      Map<String, Cluster> ret = new LinkedHashMap<>();
      for(String key : builders.keySet()) {
        ret.put(key, new Cluster(builders.get(key)));
      }
      return Collections.unmodifiableMap(ret);
    }

    /**
     * This class represents document-protocol-policies.cluster{}.route[]
     */
    public final static class Route extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "messageType"
          ));

        private String name = null;
        private Integer messageType = null;

        public Builder() { }

        public Builder(Route config) {
          name(config.name());
          messageType(config.messageType());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.messageType != null)
            messageType(__superior.messageType);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder messageType(int __value) {
          messageType = __value;
          __uninitialized.remove("messageType");
          return this;
        }

        private Builder messageType(String __value) {
          return messageType(Integer.valueOf(__value));
        }

        public Route build() {
          return new Route(this);
        }

      }

      // The name of the route.
      private final StringNode name;
      // The document protocol message type triggering this route.
      private final IntegerNode messageType;

      public Route(Builder builder) {
        this(builder, true);
      }

      private Route(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "document-protocol-policies.cluster{}.route[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        messageType = (builder.messageType == null) ?
            new IntegerNode() : new IntegerNode(builder.messageType);
      }

      /**
       * @return document-protocol-policies.cluster{}.route[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return document-protocol-policies.cluster{}.route[].messageType
       */
      public int messageType() {
        return messageType.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Route newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("route");
        return changes;
      }

      private static InnerNodeVector<Route> createVector(List<Builder> builders) {
          List<Route> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Route(b));
          }
          return new InnerNodeVector<Route>(elems);
      }
    }
  }

}
