/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.config;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public final class DocumentmanagerConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "f561458d6dc187c7e5f048be6fac6199";
    public static final String CONFIG_DEF_NAME = "documentmanager";
    public static final String CONFIG_DEF_NAMESPACE = "document.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=document.config", "ignoreundefinedfields bool default=false", "usev8geopositions bool default=true", "datatype[].id int", "datatype[].arraytype[].datatype int", "datatype[].maptype[].keytype int", "datatype[].maptype[].valtype int", "datatype[].weightedsettype[].datatype int", "datatype[].weightedsettype[].createifnonexistant bool default=false", "datatype[].weightedsettype[].removeifzero bool default=false", "datatype[].structtype[].name string", "datatype[].structtype[].version int default=0", "datatype[].structtype[].compresstype enum { NONE, UNCOMPRESSABLE, LZ4 } default=NONE", "datatype[].structtype[].compresslevel int default=0", "datatype[].structtype[].compressthreshold int default=95", "datatype[].structtype[].compressminsize int default=800", "datatype[].structtype[].field[].name string", "datatype[].structtype[].field[].id[].id int", "datatype[].structtype[].field[].datatype int", "datatype[].structtype[].field[].detailedtype string default=\"\"", "datatype[].structtype[].inherits[].name string", "datatype[].structtype[].inherits[].version int default=0", "datatype[].annotationreftype[].annotation string", "datatype[].documenttype[].name string", "datatype[].documenttype[].version int default=0", "datatype[].documenttype[].inherits[].name string", "datatype[].documenttype[].inherits[].version int default=0", "datatype[].documenttype[].headerstruct int", "datatype[].documenttype[].bodystruct int default=0", "datatype[].documenttype[].fieldsets{}.fields[] string", "datatype[].documenttype[].importedfield[].name string", "datatype[].referencetype[].target_type_id int", "annotationtype[].id int", "annotationtype[].name string", "annotationtype[].datatype int default=-1", "annotationtype[].inherits[].id int", "doctype[].name string", "doctype[].idx int", "doctype[].inherits[].idx int", "doctype[].contentstruct int", "doctype[].fieldsets{}.fields[] string", "doctype[].importedfield[].name string", "doctype[].primitivetype[].idx int", "doctype[].primitivetype[].name string", "doctype[].arraytype[].idx int", "doctype[].arraytype[].elementtype int", "doctype[].maptype[].idx int", "doctype[].maptype[].keytype int", "doctype[].maptype[].valuetype int", "doctype[].wsettype[].idx int", "doctype[].wsettype[].elementtype int", "doctype[].wsettype[].createifnonexistent bool default=false", "doctype[].wsettype[].removeifzero bool default=false", "doctype[].tensortype[].idx int", "doctype[].tensortype[].detailedtype string", "doctype[].documentref[].idx int", "doctype[].documentref[].targettype int", "doctype[].annotationtype[].idx int", "doctype[].annotationtype[].name string", "doctype[].annotationtype[].internalid int default=-1", "doctype[].annotationtype[].datatype int default=-1", "doctype[].annotationtype[].inherits[].idx int", "doctype[].annotationref[].idx int", "doctype[].annotationref[].annotationtype int", "doctype[].structtype[].idx int", "doctype[].structtype[].name string", "doctype[].structtype[].inherits[].type int", "doctype[].structtype[].field[].name string", "doctype[].structtype[].field[].internalid int", "doctype[].structtype[].field[].type int"};
    private final BooleanNode ignoreundefinedfields;
    private final BooleanNode usev8geopositions;
    private final InnerNodeVector<Datatype> datatype;
    private final InnerNodeVector<Annotationtype> annotationtype;
    private final InnerNodeVector<Doctype> doctype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public DocumentmanagerConfig(Builder builder) {
        this(builder, true);
    }

    private DocumentmanagerConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for documentmanager must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.ignoreundefinedfields = builder.ignoreundefinedfields == null ? new BooleanNode(false) : new BooleanNode(builder.ignoreundefinedfields.booleanValue());
        this.usev8geopositions = builder.usev8geopositions == null ? new BooleanNode(true) : new BooleanNode(builder.usev8geopositions.booleanValue());
        this.datatype = Datatype.createVector(builder.datatype);
        this.annotationtype = Annotationtype.createVector(builder.annotationtype);
        this.doctype = Doctype.createVector(builder.doctype);
    }

    public boolean ignoreundefinedfields() {
        return this.ignoreundefinedfields.value();
    }

    public boolean usev8geopositions() {
        return this.usev8geopositions.value();
    }

    public List<Datatype> datatype() {
        return this.datatype;
    }

    public Datatype datatype(int i) {
        return (Datatype)((Object)this.datatype.get(i));
    }

    public List<Annotationtype> annotationtype() {
        return this.annotationtype;
    }

    public Annotationtype annotationtype(int i) {
        return (Annotationtype)((Object)this.annotationtype.get(i));
    }

    public List<Doctype> doctype() {
        return this.doctype;
    }

    public Doctype doctype(int i) {
        return (Doctype)((Object)this.doctype.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(DocumentmanagerConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Boolean ignoreundefinedfields = null;
        private Boolean usev8geopositions = null;
        public List<Datatype.Builder> datatype = new ArrayList<Datatype.Builder>();
        public List<Annotationtype.Builder> annotationtype = new ArrayList<Annotationtype.Builder>();
        public List<Doctype.Builder> doctype = new ArrayList<Doctype.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(DocumentmanagerConfig config) {
            this.ignoreundefinedfields(config.ignoreundefinedfields());
            this.usev8geopositions(config.usev8geopositions());
            for (Datatype datatype : config.datatype()) {
                this.datatype(new Datatype.Builder(datatype));
            }
            for (Annotationtype annotationtype : config.annotationtype()) {
                this.annotationtype(new Annotationtype.Builder(annotationtype));
            }
            for (Doctype doctype : config.doctype()) {
                this.doctype(new Doctype.Builder(doctype));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.ignoreundefinedfields != null) {
                this.ignoreundefinedfields(__superior.ignoreundefinedfields);
            }
            if (__superior.usev8geopositions != null) {
                this.usev8geopositions(__superior.usev8geopositions);
            }
            if (!__superior.datatype.isEmpty()) {
                this.datatype.addAll(__superior.datatype);
            }
            if (!__superior.annotationtype.isEmpty()) {
                this.annotationtype.addAll(__superior.annotationtype);
            }
            if (!__superior.doctype.isEmpty()) {
                this.doctype.addAll(__superior.doctype);
            }
            return this;
        }

        public Builder ignoreundefinedfields(boolean __value) {
            this.ignoreundefinedfields = __value;
            return this;
        }

        private Builder ignoreundefinedfields(String __value) {
            return this.ignoreundefinedfields(Boolean.valueOf(__value));
        }

        public Builder usev8geopositions(boolean __value) {
            this.usev8geopositions = __value;
            return this;
        }

        private Builder usev8geopositions(String __value) {
            return this.usev8geopositions(Boolean.valueOf(__value));
        }

        public Builder datatype(Datatype.Builder __builder) {
            this.datatype.add(__builder);
            return this;
        }

        public Builder datatype(Consumer<Datatype.Builder> __func) {
            Datatype.Builder __inner = new Datatype.Builder();
            __func.accept(__inner);
            this.datatype.add(__inner);
            return this;
        }

        public Builder datatype(List<Datatype.Builder> __builders) {
            this.datatype = __builders;
            return this;
        }

        public Builder annotationtype(Annotationtype.Builder __builder) {
            this.annotationtype.add(__builder);
            return this;
        }

        public Builder annotationtype(Consumer<Annotationtype.Builder> __func) {
            Annotationtype.Builder __inner = new Annotationtype.Builder();
            __func.accept(__inner);
            this.annotationtype.add(__inner);
            return this;
        }

        public Builder annotationtype(List<Annotationtype.Builder> __builders) {
            this.annotationtype = __builders;
            return this;
        }

        public Builder doctype(Doctype.Builder __builder) {
            this.doctype.add(__builder);
            return this;
        }

        public Builder doctype(Consumer<Doctype.Builder> __func) {
            Doctype.Builder __inner = new Doctype.Builder();
            __func.accept(__inner);
            this.doctype.add(__inner);
            return this;
        }

        public Builder doctype(List<Doctype.Builder> __builders) {
            this.doctype = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return DocumentmanagerConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return DocumentmanagerConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return DocumentmanagerConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public DocumentmanagerConfig build() {
            return new DocumentmanagerConfig(this);
        }
    }

    public static final class Datatype
    extends InnerNode {
        private final IntegerNode id;
        private final InnerNodeVector<Arraytype> arraytype;
        private final InnerNodeVector<Maptype> maptype;
        private final InnerNodeVector<Weightedsettype> weightedsettype;
        private final InnerNodeVector<Structtype> structtype;
        private final InnerNodeVector<Annotationreftype> annotationreftype;
        private final InnerNodeVector<Documenttype> documenttype;
        private final InnerNodeVector<Referencetype> referencetype;

        public Datatype(Builder builder) {
            this(builder, true);
        }

        private Datatype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.arraytype = Arraytype.createVector(builder.arraytype);
            this.maptype = Maptype.createVector(builder.maptype);
            this.weightedsettype = Weightedsettype.createVector(builder.weightedsettype);
            this.structtype = Structtype.createVector(builder.structtype);
            this.annotationreftype = Annotationreftype.createVector(builder.annotationreftype);
            this.documenttype = Documenttype.createVector(builder.documenttype);
            this.referencetype = Referencetype.createVector(builder.referencetype);
        }

        public int id() {
            return this.id.value();
        }

        public List<Arraytype> arraytype() {
            return this.arraytype;
        }

        public Arraytype arraytype(int i) {
            return (Arraytype)((Object)this.arraytype.get(i));
        }

        public List<Maptype> maptype() {
            return this.maptype;
        }

        public Maptype maptype(int i) {
            return (Maptype)((Object)this.maptype.get(i));
        }

        public List<Weightedsettype> weightedsettype() {
            return this.weightedsettype;
        }

        public Weightedsettype weightedsettype(int i) {
            return (Weightedsettype)((Object)this.weightedsettype.get(i));
        }

        public List<Structtype> structtype() {
            return this.structtype;
        }

        public Structtype structtype(int i) {
            return (Structtype)((Object)this.structtype.get(i));
        }

        public List<Annotationreftype> annotationreftype() {
            return this.annotationreftype;
        }

        public Annotationreftype annotationreftype(int i) {
            return (Annotationreftype)((Object)this.annotationreftype.get(i));
        }

        public List<Documenttype> documenttype() {
            return this.documenttype;
        }

        public Documenttype documenttype(int i) {
            return (Documenttype)((Object)this.documenttype.get(i));
        }

        public List<Referencetype> referencetype() {
            return this.referencetype;
        }

        public Referencetype referencetype(int i) {
            return (Referencetype)((Object)this.referencetype.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Datatype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("datatype");
            return changes;
        }

        private static InnerNodeVector<Datatype> createVector(List<Builder> builders) {
            ArrayList<Datatype> elems = new ArrayList<Datatype>();
            for (Builder b : builders) {
                elems.add(new Datatype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id"));
            private Integer id = null;
            public List<Arraytype.Builder> arraytype = new ArrayList<Arraytype.Builder>();
            public List<Maptype.Builder> maptype = new ArrayList<Maptype.Builder>();
            public List<Weightedsettype.Builder> weightedsettype = new ArrayList<Weightedsettype.Builder>();
            public List<Structtype.Builder> structtype = new ArrayList<Structtype.Builder>();
            public List<Annotationreftype.Builder> annotationreftype = new ArrayList<Annotationreftype.Builder>();
            public List<Documenttype.Builder> documenttype = new ArrayList<Documenttype.Builder>();
            public List<Referencetype.Builder> referencetype = new ArrayList<Referencetype.Builder>();

            public Builder() {
            }

            public Builder(Datatype config) {
                this.id(config.id());
                for (Arraytype arraytype : config.arraytype()) {
                    this.arraytype(new Arraytype.Builder(arraytype));
                }
                for (Maptype maptype : config.maptype()) {
                    this.maptype(new Maptype.Builder(maptype));
                }
                for (Weightedsettype weightedsettype : config.weightedsettype()) {
                    this.weightedsettype(new Weightedsettype.Builder(weightedsettype));
                }
                for (Structtype structtype : config.structtype()) {
                    this.structtype(new Structtype.Builder(structtype));
                }
                for (Annotationreftype annotationreftype : config.annotationreftype()) {
                    this.annotationreftype(new Annotationreftype.Builder(annotationreftype));
                }
                for (Documenttype documenttype : config.documenttype()) {
                    this.documenttype(new Documenttype.Builder(documenttype));
                }
                for (Referencetype referencetype : config.referencetype()) {
                    this.referencetype(new Referencetype.Builder(referencetype));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (!__superior.arraytype.isEmpty()) {
                    this.arraytype.addAll(__superior.arraytype);
                }
                if (!__superior.maptype.isEmpty()) {
                    this.maptype.addAll(__superior.maptype);
                }
                if (!__superior.weightedsettype.isEmpty()) {
                    this.weightedsettype.addAll(__superior.weightedsettype);
                }
                if (!__superior.structtype.isEmpty()) {
                    this.structtype.addAll(__superior.structtype);
                }
                if (!__superior.annotationreftype.isEmpty()) {
                    this.annotationreftype.addAll(__superior.annotationreftype);
                }
                if (!__superior.documenttype.isEmpty()) {
                    this.documenttype.addAll(__superior.documenttype);
                }
                if (!__superior.referencetype.isEmpty()) {
                    this.referencetype.addAll(__superior.referencetype);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder arraytype(Arraytype.Builder __builder) {
                this.arraytype.add(__builder);
                return this;
            }

            public Builder arraytype(Consumer<Arraytype.Builder> __func) {
                Arraytype.Builder __inner = new Arraytype.Builder();
                __func.accept(__inner);
                this.arraytype.add(__inner);
                return this;
            }

            public Builder arraytype(List<Arraytype.Builder> __builders) {
                this.arraytype = __builders;
                return this;
            }

            public Builder maptype(Maptype.Builder __builder) {
                this.maptype.add(__builder);
                return this;
            }

            public Builder maptype(Consumer<Maptype.Builder> __func) {
                Maptype.Builder __inner = new Maptype.Builder();
                __func.accept(__inner);
                this.maptype.add(__inner);
                return this;
            }

            public Builder maptype(List<Maptype.Builder> __builders) {
                this.maptype = __builders;
                return this;
            }

            public Builder weightedsettype(Weightedsettype.Builder __builder) {
                this.weightedsettype.add(__builder);
                return this;
            }

            public Builder weightedsettype(Consumer<Weightedsettype.Builder> __func) {
                Weightedsettype.Builder __inner = new Weightedsettype.Builder();
                __func.accept(__inner);
                this.weightedsettype.add(__inner);
                return this;
            }

            public Builder weightedsettype(List<Weightedsettype.Builder> __builders) {
                this.weightedsettype = __builders;
                return this;
            }

            public Builder structtype(Structtype.Builder __builder) {
                this.structtype.add(__builder);
                return this;
            }

            public Builder structtype(Consumer<Structtype.Builder> __func) {
                Structtype.Builder __inner = new Structtype.Builder();
                __func.accept(__inner);
                this.structtype.add(__inner);
                return this;
            }

            public Builder structtype(List<Structtype.Builder> __builders) {
                this.structtype = __builders;
                return this;
            }

            public Builder annotationreftype(Annotationreftype.Builder __builder) {
                this.annotationreftype.add(__builder);
                return this;
            }

            public Builder annotationreftype(Consumer<Annotationreftype.Builder> __func) {
                Annotationreftype.Builder __inner = new Annotationreftype.Builder();
                __func.accept(__inner);
                this.annotationreftype.add(__inner);
                return this;
            }

            public Builder annotationreftype(List<Annotationreftype.Builder> __builders) {
                this.annotationreftype = __builders;
                return this;
            }

            public Builder documenttype(Documenttype.Builder __builder) {
                this.documenttype.add(__builder);
                return this;
            }

            public Builder documenttype(Consumer<Documenttype.Builder> __func) {
                Documenttype.Builder __inner = new Documenttype.Builder();
                __func.accept(__inner);
                this.documenttype.add(__inner);
                return this;
            }

            public Builder documenttype(List<Documenttype.Builder> __builders) {
                this.documenttype = __builders;
                return this;
            }

            public Builder referencetype(Referencetype.Builder __builder) {
                this.referencetype.add(__builder);
                return this;
            }

            public Builder referencetype(Consumer<Referencetype.Builder> __func) {
                Referencetype.Builder __inner = new Referencetype.Builder();
                __func.accept(__inner);
                this.referencetype.add(__inner);
                return this;
            }

            public Builder referencetype(List<Referencetype.Builder> __builders) {
                this.referencetype = __builders;
                return this;
            }

            public Datatype build() {
                return new Datatype(this);
            }
        }

        public static final class Arraytype
        extends InnerNode {
            private final IntegerNode datatype;

            public Arraytype(Builder builder) {
                this(builder, true);
            }

            private Arraytype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].arraytype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
            }

            public int datatype() {
                return this.datatype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
                return changes;
            }

            private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
                ArrayList<Arraytype> elems = new ArrayList<Arraytype>();
                for (Builder b : builders) {
                    elems.add(new Arraytype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("datatype"));
                private Integer datatype = null;

                public Builder() {
                }

                public Builder(Arraytype config) {
                    this.datatype(config.datatype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    return this;
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    this.__uninitialized.remove("datatype");
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Arraytype build() {
                    return new Arraytype(this);
                }
            }
        }

        public static final class Maptype
        extends InnerNode {
            private final IntegerNode keytype;
            private final IntegerNode valtype;

            public Maptype(Builder builder) {
                this(builder, true);
            }

            private Maptype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].maptype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.keytype = builder.keytype == null ? new IntegerNode() : new IntegerNode(builder.keytype.intValue());
                this.valtype = builder.valtype == null ? new IntegerNode() : new IntegerNode(builder.valtype.intValue());
            }

            public int keytype() {
                return this.keytype.value();
            }

            public int valtype() {
                return this.valtype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
                return changes;
            }

            private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
                ArrayList<Maptype> elems = new ArrayList<Maptype>();
                for (Builder b : builders) {
                    elems.add(new Maptype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("keytype", "valtype"));
                private Integer keytype = null;
                private Integer valtype = null;

                public Builder() {
                }

                public Builder(Maptype config) {
                    this.keytype(config.keytype());
                    this.valtype(config.valtype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.keytype != null) {
                        this.keytype(__superior.keytype);
                    }
                    if (__superior.valtype != null) {
                        this.valtype(__superior.valtype);
                    }
                    return this;
                }

                public Builder keytype(int __value) {
                    this.keytype = __value;
                    this.__uninitialized.remove("keytype");
                    return this;
                }

                private Builder keytype(String __value) {
                    return this.keytype(Integer.valueOf(__value));
                }

                public Builder valtype(int __value) {
                    this.valtype = __value;
                    this.__uninitialized.remove("valtype");
                    return this;
                }

                private Builder valtype(String __value) {
                    return this.valtype(Integer.valueOf(__value));
                }

                public Maptype build() {
                    return new Maptype(this);
                }
            }
        }

        public static final class Weightedsettype
        extends InnerNode {
            private final IntegerNode datatype;
            private final BooleanNode createifnonexistant;
            private final BooleanNode removeifzero;

            public Weightedsettype(Builder builder) {
                this(builder, true);
            }

            private Weightedsettype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].weightedsettype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
                this.createifnonexistant = builder.createifnonexistant == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistant.booleanValue());
                this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
            }

            public int datatype() {
                return this.datatype.value();
            }

            public boolean createifnonexistant() {
                return this.createifnonexistant.value();
            }

            public boolean removeifzero() {
                return this.removeifzero.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Weightedsettype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("weightedsettype");
                return changes;
            }

            private static InnerNodeVector<Weightedsettype> createVector(List<Builder> builders) {
                ArrayList<Weightedsettype> elems = new ArrayList<Weightedsettype>();
                for (Builder b : builders) {
                    elems.add(new Weightedsettype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("datatype"));
                private Integer datatype = null;
                private Boolean createifnonexistant = null;
                private Boolean removeifzero = null;

                public Builder() {
                }

                public Builder(Weightedsettype config) {
                    this.datatype(config.datatype());
                    this.createifnonexistant(config.createifnonexistant());
                    this.removeifzero(config.removeifzero());
                }

                private Builder override(Builder __superior) {
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    if (__superior.createifnonexistant != null) {
                        this.createifnonexistant(__superior.createifnonexistant);
                    }
                    if (__superior.removeifzero != null) {
                        this.removeifzero(__superior.removeifzero);
                    }
                    return this;
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    this.__uninitialized.remove("datatype");
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Builder createifnonexistant(boolean __value) {
                    this.createifnonexistant = __value;
                    return this;
                }

                private Builder createifnonexistant(String __value) {
                    return this.createifnonexistant(Boolean.valueOf(__value));
                }

                public Builder removeifzero(boolean __value) {
                    this.removeifzero = __value;
                    return this;
                }

                private Builder removeifzero(String __value) {
                    return this.removeifzero(Boolean.valueOf(__value));
                }

                public Weightedsettype build() {
                    return new Weightedsettype(this);
                }
            }
        }

        public static final class Structtype
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode version;
            private final Compresstype compresstype;
            private final IntegerNode compresslevel;
            private final IntegerNode compressthreshold;
            private final IntegerNode compressminsize;
            private final InnerNodeVector<Field> field;
            private final InnerNodeVector<Inherits> inherits;

            public Structtype(Builder builder) {
                this(builder, true);
            }

            private Structtype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                this.compresstype = builder.compresstype == null ? new Compresstype(Compresstype.NONE) : new Compresstype(builder.compresstype);
                this.compresslevel = builder.compresslevel == null ? new IntegerNode(0) : new IntegerNode(builder.compresslevel.intValue());
                this.compressthreshold = builder.compressthreshold == null ? new IntegerNode(95) : new IntegerNode(builder.compressthreshold.intValue());
                this.compressminsize = builder.compressminsize == null ? new IntegerNode(800) : new IntegerNode(builder.compressminsize.intValue());
                this.field = Field.createVector(builder.field);
                this.inherits = Inherits.createVector(builder.inherits);
            }

            public String name() {
                return this.name.value();
            }

            public int version() {
                return this.version.value();
            }

            public Compresstype.Enum compresstype() {
                return (Compresstype.Enum)((Object)this.compresstype.value());
            }

            public int compresslevel() {
                return this.compresslevel.value();
            }

            public int compressthreshold() {
                return this.compressthreshold.value();
            }

            public int compressminsize() {
                return this.compressminsize.value();
            }

            public List<Field> field() {
                return this.field;
            }

            public Field field(int i) {
                return (Field)((Object)this.field.get(i));
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
                return changes;
            }

            private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
                ArrayList<Structtype> elems = new ArrayList<Structtype>();
                for (Builder b : builders) {
                    elems.add(new Structtype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;
                private Integer version = null;
                private Compresstype.Enum compresstype = null;
                private Integer compresslevel = null;
                private Integer compressthreshold = null;
                private Integer compressminsize = null;
                public List<Field.Builder> field = new ArrayList<Field.Builder>();
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

                public Builder() {
                }

                public Builder(Structtype config) {
                    this.name(config.name());
                    this.version(config.version());
                    this.compresstype(config.compresstype());
                    this.compresslevel(config.compresslevel());
                    this.compressthreshold(config.compressthreshold());
                    this.compressminsize(config.compressminsize());
                    for (Field f : config.field()) {
                        this.field(new Field.Builder(f));
                    }
                    for (Inherits i : config.inherits()) {
                        this.inherits(new Inherits.Builder(i));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.version != null) {
                        this.version(__superior.version);
                    }
                    if (__superior.compresstype != null) {
                        this.compresstype(__superior.compresstype);
                    }
                    if (__superior.compresslevel != null) {
                        this.compresslevel(__superior.compresslevel);
                    }
                    if (__superior.compressthreshold != null) {
                        this.compressthreshold(__superior.compressthreshold);
                    }
                    if (__superior.compressminsize != null) {
                        this.compressminsize(__superior.compressminsize);
                    }
                    if (!__superior.field.isEmpty()) {
                        this.field.addAll(__superior.field);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder version(int __value) {
                    this.version = __value;
                    return this;
                }

                private Builder version(String __value) {
                    return this.version(Integer.valueOf(__value));
                }

                public Builder compresstype(Compresstype.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.compresstype = __value;
                    return this;
                }

                private Builder compresstype(String __value) {
                    return this.compresstype(Compresstype.Enum.valueOf(__value));
                }

                public Builder compresslevel(int __value) {
                    this.compresslevel = __value;
                    return this;
                }

                private Builder compresslevel(String __value) {
                    return this.compresslevel(Integer.valueOf(__value));
                }

                public Builder compressthreshold(int __value) {
                    this.compressthreshold = __value;
                    return this;
                }

                private Builder compressthreshold(String __value) {
                    return this.compressthreshold(Integer.valueOf(__value));
                }

                public Builder compressminsize(int __value) {
                    this.compressminsize = __value;
                    return this;
                }

                private Builder compressminsize(String __value) {
                    return this.compressminsize(Integer.valueOf(__value));
                }

                public Builder field(Field.Builder __builder) {
                    this.field.add(__builder);
                    return this;
                }

                public Builder field(Consumer<Field.Builder> __func) {
                    Field.Builder __inner = new Field.Builder();
                    __func.accept(__inner);
                    this.field.add(__inner);
                    return this;
                }

                public Builder field(List<Field.Builder> __builders) {
                    this.field = __builders;
                    return this;
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(Consumer<Inherits.Builder> __func) {
                    Inherits.Builder __inner = new Inherits.Builder();
                    __func.accept(__inner);
                    this.inherits.add(__inner);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Structtype build() {
                    return new Structtype(this);
                }
            }

            public static final class Compresstype
            extends EnumNode<Enum> {
                public static final Enum NONE = Enum.NONE;
                public static final Enum UNCOMPRESSABLE = Enum.UNCOMPRESSABLE;
                public static final Enum LZ4 = Enum.LZ4;

                public Compresstype() {
                    this.value = null;
                }

                public Compresstype(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NONE,
                    UNCOMPRESSABLE,
                    LZ4;

                }
            }

            public static final class Field
            extends InnerNode {
                private final StringNode name;
                private final InnerNodeVector<Id> id;
                private final IntegerNode datatype;
                private final StringNode detailedtype;

                public Field(Builder builder) {
                    this(builder, true);
                }

                private Field(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].field[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.id = Id.createVector(builder.id);
                    this.datatype = builder.datatype == null ? new IntegerNode() : new IntegerNode(builder.datatype.intValue());
                    this.detailedtype = builder.detailedtype == null ? new StringNode("") : new StringNode(builder.detailedtype);
                }

                public String name() {
                    return this.name.value();
                }

                public List<Id> id() {
                    return this.id;
                }

                public Id id(int i) {
                    return (Id)((Object)this.id.get(i));
                }

                public int datatype() {
                    return this.datatype.value();
                }

                public String detailedtype() {
                    return this.detailedtype.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                    return changes;
                }

                private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                    ArrayList<Field> elems = new ArrayList<Field>();
                    for (Builder b : builders) {
                        elems.add(new Field(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name", "datatype"));
                    private String name = null;
                    public List<Id.Builder> id = new ArrayList<Id.Builder>();
                    private Integer datatype = null;
                    private String detailedtype = null;

                    public Builder() {
                    }

                    public Builder(Field config) {
                        this.name(config.name());
                        for (Id i : config.id()) {
                            this.id(new Id.Builder(i));
                        }
                        this.datatype(config.datatype());
                        this.detailedtype(config.detailedtype());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (!__superior.id.isEmpty()) {
                            this.id.addAll(__superior.id);
                        }
                        if (__superior.datatype != null) {
                            this.datatype(__superior.datatype);
                        }
                        if (__superior.detailedtype != null) {
                            this.detailedtype(__superior.detailedtype);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder id(Id.Builder __builder) {
                        this.id.add(__builder);
                        return this;
                    }

                    public Builder id(Consumer<Id.Builder> __func) {
                        Id.Builder __inner = new Id.Builder();
                        __func.accept(__inner);
                        this.id.add(__inner);
                        return this;
                    }

                    public Builder id(List<Id.Builder> __builders) {
                        this.id = __builders;
                        return this;
                    }

                    public Builder datatype(int __value) {
                        this.datatype = __value;
                        this.__uninitialized.remove("datatype");
                        return this;
                    }

                    private Builder datatype(String __value) {
                        return this.datatype(Integer.valueOf(__value));
                    }

                    public Builder detailedtype(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.detailedtype = __value;
                        return this;
                    }

                    public Field build() {
                        return new Field(this);
                    }
                }

                public static final class Id
                extends InnerNode {
                    private final IntegerNode id;

                    public Id(Builder builder) {
                        this(builder, true);
                    }

                    private Id(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].field[].id[] must be initialized: " + String.valueOf(builder.__uninitialized));
                        }
                        this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
                    }

                    public int id() {
                        return this.id.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Id newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("id");
                        return changes;
                    }

                    private static InnerNodeVector<Id> createVector(List<Builder> builders) {
                        ArrayList<Id> elems = new ArrayList<Id>();
                        for (Builder b : builders) {
                            elems.add(new Id(b));
                        }
                        return new InnerNodeVector(elems);
                    }

                    public static final class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>(List.of("id"));
                        private Integer id = null;

                        public Builder() {
                        }

                        public Builder(Id config) {
                            this.id(config.id());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.id != null) {
                                this.id(__superior.id);
                            }
                            return this;
                        }

                        public Builder id(int __value) {
                            this.id = __value;
                            this.__uninitialized.remove("id");
                            return this;
                        }

                        private Builder id(String __value) {
                            return this.id(Integer.valueOf(__value));
                        }

                        public Id build() {
                            return new Id(this);
                        }
                    }
                }
            }

            public static final class Inherits
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode version;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].structtype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                }

                public String name() {
                    return this.name.value();
                }

                public int version() {
                    return this.version.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                    private String name = null;
                    private Integer version = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.name(config.name());
                        this.version(config.version());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.version != null) {
                            this.version(__superior.version);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder version(int __value) {
                        this.version = __value;
                        return this;
                    }

                    private Builder version(String __value) {
                        return this.version(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }
        }

        public static final class Annotationreftype
        extends InnerNode {
            private final StringNode annotation;

            public Annotationreftype(Builder builder) {
                this(builder, true);
            }

            private Annotationreftype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].annotationreftype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.annotation = builder.annotation == null ? new StringNode() : new StringNode(builder.annotation);
            }

            public String annotation() {
                return this.annotation.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Annotationreftype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationreftype");
                return changes;
            }

            private static InnerNodeVector<Annotationreftype> createVector(List<Builder> builders) {
                ArrayList<Annotationreftype> elems = new ArrayList<Annotationreftype>();
                for (Builder b : builders) {
                    elems.add(new Annotationreftype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("annotation"));
                private String annotation = null;

                public Builder() {
                }

                public Builder(Annotationreftype config) {
                    this.annotation(config.annotation());
                }

                private Builder override(Builder __superior) {
                    if (__superior.annotation != null) {
                        this.annotation(__superior.annotation);
                    }
                    return this;
                }

                public Builder annotation(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.annotation = __value;
                    this.__uninitialized.remove("annotation");
                    return this;
                }

                public Annotationreftype build() {
                    return new Annotationreftype(this);
                }
            }
        }

        public static final class Documenttype
        extends InnerNode {
            private final StringNode name;
            private final IntegerNode version;
            private final InnerNodeVector<Inherits> inherits;
            private final IntegerNode headerstruct;
            private final IntegerNode bodystruct;
            private final Map<String, Fieldsets> fieldsets;
            private final InnerNodeVector<Importedfield> importedfield;

            public Documenttype(Builder builder) {
                this(builder, true);
            }

            private Documenttype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                this.inherits = Inherits.createVector(builder.inherits);
                this.headerstruct = builder.headerstruct == null ? new IntegerNode() : new IntegerNode(builder.headerstruct.intValue());
                this.bodystruct = builder.bodystruct == null ? new IntegerNode(0) : new IntegerNode(builder.bodystruct.intValue());
                this.fieldsets = Fieldsets.createMap(builder.fieldsets);
                this.importedfield = Importedfield.createVector(builder.importedfield);
            }

            public String name() {
                return this.name.value();
            }

            public int version() {
                return this.version.value();
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            public int headerstruct() {
                return this.headerstruct.value();
            }

            public int bodystruct() {
                return this.bodystruct.value();
            }

            public Map<String, Fieldsets> fieldsets() {
                return Collections.unmodifiableMap(this.fieldsets);
            }

            public Fieldsets fieldsets(String key) {
                return this.fieldsets.get(key);
            }

            public List<Importedfield> importedfield() {
                return this.importedfield;
            }

            public Importedfield importedfield(int i) {
                return (Importedfield)((Object)this.importedfield.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
                return changes;
            }

            private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
                ArrayList<Documenttype> elems = new ArrayList<Documenttype>();
                for (Builder b : builders) {
                    elems.add(new Documenttype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name", "headerstruct"));
                private String name = null;
                private Integer version = null;
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();
                private Integer headerstruct = null;
                private Integer bodystruct = null;
                public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<String, Fieldsets.Builder>();
                public List<Importedfield.Builder> importedfield = new ArrayList<Importedfield.Builder>();

                public Builder() {
                }

                public Builder(Documenttype config) {
                    this.name(config.name());
                    this.version(config.version());
                    for (Inherits inherits : config.inherits()) {
                        this.inherits(new Inherits.Builder(inherits));
                    }
                    this.headerstruct(config.headerstruct());
                    this.bodystruct(config.bodystruct());
                    for (Map.Entry entry : config.fieldsets().entrySet()) {
                        this.fieldsets((String)entry.getKey(), new Fieldsets.Builder((Fieldsets)((Object)entry.getValue())));
                    }
                    for (Importedfield importedfield : config.importedfield()) {
                        this.importedfield(new Importedfield.Builder(importedfield));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.version != null) {
                        this.version(__superior.version);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    if (__superior.headerstruct != null) {
                        this.headerstruct(__superior.headerstruct);
                    }
                    if (__superior.bodystruct != null) {
                        this.bodystruct(__superior.bodystruct);
                    }
                    this.fieldsets(__superior.fieldsets);
                    if (!__superior.importedfield.isEmpty()) {
                        this.importedfield.addAll(__superior.importedfield);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder version(int __value) {
                    this.version = __value;
                    return this;
                }

                private Builder version(String __value) {
                    return this.version(Integer.valueOf(__value));
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(Consumer<Inherits.Builder> __func) {
                    Inherits.Builder __inner = new Inherits.Builder();
                    __func.accept(__inner);
                    this.inherits.add(__inner);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Builder headerstruct(int __value) {
                    this.headerstruct = __value;
                    this.__uninitialized.remove("headerstruct");
                    return this;
                }

                private Builder headerstruct(String __value) {
                    return this.headerstruct(Integer.valueOf(__value));
                }

                public Builder bodystruct(int __value) {
                    this.bodystruct = __value;
                    return this;
                }

                private Builder bodystruct(String __value) {
                    return this.bodystruct(Integer.valueOf(__value));
                }

                public Builder fieldsets(String __key, Fieldsets.Builder __value) {
                    this.fieldsets.put(__key, __value);
                    return this;
                }

                public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
                    this.fieldsets.putAll(__values);
                    return this;
                }

                public Builder fieldsets(String __key, Consumer<Fieldsets.Builder> __func) {
                    Fieldsets.Builder __inner = new Fieldsets.Builder();
                    __func.accept(__inner);
                    this.fieldsets.put(__key, __inner);
                    return this;
                }

                public Builder importedfield(Importedfield.Builder __builder) {
                    this.importedfield.add(__builder);
                    return this;
                }

                public Builder importedfield(Consumer<Importedfield.Builder> __func) {
                    Importedfield.Builder __inner = new Importedfield.Builder();
                    __func.accept(__inner);
                    this.importedfield.add(__inner);
                    return this;
                }

                public Builder importedfield(List<Importedfield.Builder> __builders) {
                    this.importedfield = __builders;
                    return this;
                }

                public Documenttype build() {
                    return new Documenttype(this);
                }
            }

            public static final class Inherits
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode version;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.version = builder.version == null ? new IntegerNode(0) : new IntegerNode(builder.version.intValue());
                }

                public String name() {
                    return this.name.value();
                }

                public int version() {
                    return this.version.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                    private String name = null;
                    private Integer version = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.name(config.name());
                        this.version(config.version());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.version != null) {
                            this.version(__superior.version);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder version(int __value) {
                        this.version = __value;
                        return this;
                    }

                    private Builder version(String __value) {
                        return this.version(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }

            public static final class Fieldsets
            extends InnerNode {
                private final LeafNodeVector<String, StringNode> fields;

                public Fieldsets(Builder builder) {
                    this(builder, true);
                }

                private Fieldsets(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].fieldsets{} must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.fields = new LeafNodeVector(builder.fields, (LeafNode)new StringNode());
                }

                public List<String> fields() {
                    return this.fields.asList();
                }

                public String fields(int i) {
                    return ((StringNode)this.fields.get(i)).value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
                    return changes;
                }

                private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
                    LinkedHashMap<String, Fieldsets> ret = new LinkedHashMap<String, Fieldsets>();
                    for (String key : builders.keySet()) {
                        ret.put(key, new Fieldsets(builders.get(key)));
                    }
                    return Collections.unmodifiableMap(ret);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public List<String> fields = new ArrayList<String>();

                    public Builder() {
                    }

                    public Builder(Fieldsets config) {
                        this.fields(config.fields());
                    }

                    private Builder override(Builder __superior) {
                        if (!__superior.fields.isEmpty()) {
                            this.fields.addAll(__superior.fields);
                        }
                        return this;
                    }

                    public Builder fields(String __value) {
                        this.fields.add(__value);
                        return this;
                    }

                    public Builder fields(Collection<String> __values) {
                        this.fields.addAll(__values);
                        return this;
                    }

                    public Fieldsets build() {
                        return new Fieldsets(this);
                    }
                }
            }

            public static final class Importedfield
            extends InnerNode {
                private final StringNode name;

                public Importedfield(Builder builder) {
                    this(builder, true);
                }

                private Importedfield(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].documenttype[].importedfield[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                }

                public String name() {
                    return this.name.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
                    return changes;
                }

                private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
                    ArrayList<Importedfield> elems = new ArrayList<Importedfield>();
                    for (Builder b : builders) {
                        elems.add(new Importedfield(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                    private String name = null;

                    public Builder() {
                    }

                    public Builder(Importedfield config) {
                        this.name(config.name());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Importedfield build() {
                        return new Importedfield(this);
                    }
                }
            }
        }

        public static final class Referencetype
        extends InnerNode {
            private final IntegerNode target_type_id;

            public Referencetype(Builder builder) {
                this(builder, true);
            }

            private Referencetype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.datatype[].referencetype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.target_type_id = builder.target_type_id == null ? new IntegerNode() : new IntegerNode(builder.target_type_id.intValue());
            }

            public int target_type_id() {
                return this.target_type_id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Referencetype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("referencetype");
                return changes;
            }

            private static InnerNodeVector<Referencetype> createVector(List<Builder> builders) {
                ArrayList<Referencetype> elems = new ArrayList<Referencetype>();
                for (Builder b : builders) {
                    elems.add(new Referencetype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("target_type_id"));
                private Integer target_type_id = null;

                public Builder() {
                }

                public Builder(Referencetype config) {
                    this.target_type_id(config.target_type_id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.target_type_id != null) {
                        this.target_type_id(__superior.target_type_id);
                    }
                    return this;
                }

                public Builder target_type_id(int __value) {
                    this.target_type_id = __value;
                    this.__uninitialized.remove("target_type_id");
                    return this;
                }

                private Builder target_type_id(String __value) {
                    return this.target_type_id(Integer.valueOf(__value));
                }

                public Referencetype build() {
                    return new Referencetype(this);
                }
            }
        }
    }

    public static final class Annotationtype
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final IntegerNode datatype;
        private final InnerNodeVector<Inherits> inherits;

        public Annotationtype(Builder builder) {
            this(builder, true);
        }

        private Annotationtype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documentmanager.annotationtype[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.datatype = builder.datatype == null ? new IntegerNode(-1) : new IntegerNode(builder.datatype.intValue());
            this.inherits = Inherits.createVector(builder.inherits);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public int datatype() {
            return this.datatype.value();
        }

        public List<Inherits> inherits() {
            return this.inherits;
        }

        public Inherits inherits(int i) {
            return (Inherits)((Object)this.inherits.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
            return changes;
        }

        private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
            ArrayList<Annotationtype> elems = new ArrayList<Annotationtype>();
            for (Builder b : builders) {
                elems.add(new Annotationtype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id", "name"));
            private Integer id = null;
            private String name = null;
            private Integer datatype = null;
            public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

            public Builder() {
            }

            public Builder(Annotationtype config) {
                this.id(config.id());
                this.name(config.name());
                this.datatype(config.datatype());
                for (Inherits i : config.inherits()) {
                    this.inherits(new Inherits.Builder(i));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.datatype != null) {
                    this.datatype(__superior.datatype);
                }
                if (!__superior.inherits.isEmpty()) {
                    this.inherits.addAll(__superior.inherits);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder datatype(int __value) {
                this.datatype = __value;
                return this;
            }

            private Builder datatype(String __value) {
                return this.datatype(Integer.valueOf(__value));
            }

            public Builder inherits(Inherits.Builder __builder) {
                this.inherits.add(__builder);
                return this;
            }

            public Builder inherits(Consumer<Inherits.Builder> __func) {
                Inherits.Builder __inner = new Inherits.Builder();
                __func.accept(__inner);
                this.inherits.add(__inner);
                return this;
            }

            public Builder inherits(List<Inherits.Builder> __builders) {
                this.inherits = __builders;
                return this;
            }

            public Annotationtype build() {
                return new Annotationtype(this);
            }
        }

        public static final class Inherits
        extends InnerNode {
            private final IntegerNode id;

            public Inherits(Builder builder) {
                this(builder, true);
            }

            private Inherits(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.annotationtype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            }

            public int id() {
                return this.id.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                return changes;
            }

            private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                ArrayList<Inherits> elems = new ArrayList<Inherits>();
                for (Builder b : builders) {
                    elems.add(new Inherits(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("id"));
                private Integer id = null;

                public Builder() {
                }

                public Builder(Inherits config) {
                    this.id(config.id());
                }

                private Builder override(Builder __superior) {
                    if (__superior.id != null) {
                        this.id(__superior.id);
                    }
                    return this;
                }

                public Builder id(int __value) {
                    this.id = __value;
                    this.__uninitialized.remove("id");
                    return this;
                }

                private Builder id(String __value) {
                    return this.id(Integer.valueOf(__value));
                }

                public Inherits build() {
                    return new Inherits(this);
                }
            }
        }
    }

    public static final class Doctype
    extends InnerNode {
        private final StringNode name;
        private final IntegerNode idx;
        private final InnerNodeVector<Inherits> inherits;
        private final IntegerNode contentstruct;
        private final Map<String, Fieldsets> fieldsets;
        private final InnerNodeVector<Importedfield> importedfield;
        private final InnerNodeVector<Primitivetype> primitivetype;
        private final InnerNodeVector<Arraytype> arraytype;
        private final InnerNodeVector<Maptype> maptype;
        private final InnerNodeVector<Wsettype> wsettype;
        private final InnerNodeVector<Tensortype> tensortype;
        private final InnerNodeVector<Documentref> documentref;
        private final InnerNodeVector<Annotationtype> annotationtype;
        private final InnerNodeVector<Annotationref> annotationref;
        private final InnerNodeVector<Structtype> structtype;

        public Doctype(Builder builder) {
            this(builder, true);
        }

        private Doctype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
            this.inherits = Inherits.createVector(builder.inherits);
            this.contentstruct = builder.contentstruct == null ? new IntegerNode() : new IntegerNode(builder.contentstruct.intValue());
            this.fieldsets = Fieldsets.createMap(builder.fieldsets);
            this.importedfield = Importedfield.createVector(builder.importedfield);
            this.primitivetype = Primitivetype.createVector(builder.primitivetype);
            this.arraytype = Arraytype.createVector(builder.arraytype);
            this.maptype = Maptype.createVector(builder.maptype);
            this.wsettype = Wsettype.createVector(builder.wsettype);
            this.tensortype = Tensortype.createVector(builder.tensortype);
            this.documentref = Documentref.createVector(builder.documentref);
            this.annotationtype = Annotationtype.createVector(builder.annotationtype);
            this.annotationref = Annotationref.createVector(builder.annotationref);
            this.structtype = Structtype.createVector(builder.structtype);
        }

        public String name() {
            return this.name.value();
        }

        public int idx() {
            return this.idx.value();
        }

        public List<Inherits> inherits() {
            return this.inherits;
        }

        public Inherits inherits(int i) {
            return (Inherits)((Object)this.inherits.get(i));
        }

        public int contentstruct() {
            return this.contentstruct.value();
        }

        public Map<String, Fieldsets> fieldsets() {
            return Collections.unmodifiableMap(this.fieldsets);
        }

        public Fieldsets fieldsets(String key) {
            return this.fieldsets.get(key);
        }

        public List<Importedfield> importedfield() {
            return this.importedfield;
        }

        public Importedfield importedfield(int i) {
            return (Importedfield)((Object)this.importedfield.get(i));
        }

        public List<Primitivetype> primitivetype() {
            return this.primitivetype;
        }

        public Primitivetype primitivetype(int i) {
            return (Primitivetype)((Object)this.primitivetype.get(i));
        }

        public List<Arraytype> arraytype() {
            return this.arraytype;
        }

        public Arraytype arraytype(int i) {
            return (Arraytype)((Object)this.arraytype.get(i));
        }

        public List<Maptype> maptype() {
            return this.maptype;
        }

        public Maptype maptype(int i) {
            return (Maptype)((Object)this.maptype.get(i));
        }

        public List<Wsettype> wsettype() {
            return this.wsettype;
        }

        public Wsettype wsettype(int i) {
            return (Wsettype)((Object)this.wsettype.get(i));
        }

        public List<Tensortype> tensortype() {
            return this.tensortype;
        }

        public Tensortype tensortype(int i) {
            return (Tensortype)((Object)this.tensortype.get(i));
        }

        public List<Documentref> documentref() {
            return this.documentref;
        }

        public Documentref documentref(int i) {
            return (Documentref)((Object)this.documentref.get(i));
        }

        public List<Annotationtype> annotationtype() {
            return this.annotationtype;
        }

        public Annotationtype annotationtype(int i) {
            return (Annotationtype)((Object)this.annotationtype.get(i));
        }

        public List<Annotationref> annotationref() {
            return this.annotationref;
        }

        public Annotationref annotationref(int i) {
            return (Annotationref)((Object)this.annotationref.get(i));
        }

        public List<Structtype> structtype() {
            return this.structtype;
        }

        public Structtype structtype(int i) {
            return (Structtype)((Object)this.structtype.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Doctype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("doctype");
            return changes;
        }

        private static InnerNodeVector<Doctype> createVector(List<Builder> builders) {
            ArrayList<Doctype> elems = new ArrayList<Doctype>();
            for (Builder b : builders) {
                elems.add(new Doctype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("name", "idx", "contentstruct"));
            private String name = null;
            private Integer idx = null;
            public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();
            private Integer contentstruct = null;
            public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<String, Fieldsets.Builder>();
            public List<Importedfield.Builder> importedfield = new ArrayList<Importedfield.Builder>();
            public List<Primitivetype.Builder> primitivetype = new ArrayList<Primitivetype.Builder>();
            public List<Arraytype.Builder> arraytype = new ArrayList<Arraytype.Builder>();
            public List<Maptype.Builder> maptype = new ArrayList<Maptype.Builder>();
            public List<Wsettype.Builder> wsettype = new ArrayList<Wsettype.Builder>();
            public List<Tensortype.Builder> tensortype = new ArrayList<Tensortype.Builder>();
            public List<Documentref.Builder> documentref = new ArrayList<Documentref.Builder>();
            public List<Annotationtype.Builder> annotationtype = new ArrayList<Annotationtype.Builder>();
            public List<Annotationref.Builder> annotationref = new ArrayList<Annotationref.Builder>();
            public List<Structtype.Builder> structtype = new ArrayList<Structtype.Builder>();

            public Builder() {
            }

            public Builder(Doctype config) {
                this.name(config.name());
                this.idx(config.idx());
                for (Inherits inherits : config.inherits()) {
                    this.inherits(new Inherits.Builder(inherits));
                }
                this.contentstruct(config.contentstruct());
                for (Map.Entry entry : config.fieldsets().entrySet()) {
                    this.fieldsets((String)entry.getKey(), new Fieldsets.Builder((Fieldsets)((Object)entry.getValue())));
                }
                for (Importedfield importedfield : config.importedfield()) {
                    this.importedfield(new Importedfield.Builder(importedfield));
                }
                for (Primitivetype primitivetype : config.primitivetype()) {
                    this.primitivetype(new Primitivetype.Builder(primitivetype));
                }
                for (Arraytype arraytype : config.arraytype()) {
                    this.arraytype(new Arraytype.Builder(arraytype));
                }
                for (Maptype maptype : config.maptype()) {
                    this.maptype(new Maptype.Builder(maptype));
                }
                for (Wsettype wsettype : config.wsettype()) {
                    this.wsettype(new Wsettype.Builder(wsettype));
                }
                for (Tensortype tensortype : config.tensortype()) {
                    this.tensortype(new Tensortype.Builder(tensortype));
                }
                for (Documentref documentref : config.documentref()) {
                    this.documentref(new Documentref.Builder(documentref));
                }
                for (Annotationtype annotationtype : config.annotationtype()) {
                    this.annotationtype(new Annotationtype.Builder(annotationtype));
                }
                for (Annotationref annotationref : config.annotationref()) {
                    this.annotationref(new Annotationref.Builder(annotationref));
                }
                for (Structtype structtype : config.structtype()) {
                    this.structtype(new Structtype.Builder(structtype));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.idx != null) {
                    this.idx(__superior.idx);
                }
                if (!__superior.inherits.isEmpty()) {
                    this.inherits.addAll(__superior.inherits);
                }
                if (__superior.contentstruct != null) {
                    this.contentstruct(__superior.contentstruct);
                }
                this.fieldsets(__superior.fieldsets);
                if (!__superior.importedfield.isEmpty()) {
                    this.importedfield.addAll(__superior.importedfield);
                }
                if (!__superior.primitivetype.isEmpty()) {
                    this.primitivetype.addAll(__superior.primitivetype);
                }
                if (!__superior.arraytype.isEmpty()) {
                    this.arraytype.addAll(__superior.arraytype);
                }
                if (!__superior.maptype.isEmpty()) {
                    this.maptype.addAll(__superior.maptype);
                }
                if (!__superior.wsettype.isEmpty()) {
                    this.wsettype.addAll(__superior.wsettype);
                }
                if (!__superior.tensortype.isEmpty()) {
                    this.tensortype.addAll(__superior.tensortype);
                }
                if (!__superior.documentref.isEmpty()) {
                    this.documentref.addAll(__superior.documentref);
                }
                if (!__superior.annotationtype.isEmpty()) {
                    this.annotationtype.addAll(__superior.annotationtype);
                }
                if (!__superior.annotationref.isEmpty()) {
                    this.annotationref.addAll(__superior.annotationref);
                }
                if (!__superior.structtype.isEmpty()) {
                    this.structtype.addAll(__superior.structtype);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder idx(int __value) {
                this.idx = __value;
                this.__uninitialized.remove("idx");
                return this;
            }

            private Builder idx(String __value) {
                return this.idx(Integer.valueOf(__value));
            }

            public Builder inherits(Inherits.Builder __builder) {
                this.inherits.add(__builder);
                return this;
            }

            public Builder inherits(Consumer<Inherits.Builder> __func) {
                Inherits.Builder __inner = new Inherits.Builder();
                __func.accept(__inner);
                this.inherits.add(__inner);
                return this;
            }

            public Builder inherits(List<Inherits.Builder> __builders) {
                this.inherits = __builders;
                return this;
            }

            public Builder contentstruct(int __value) {
                this.contentstruct = __value;
                this.__uninitialized.remove("contentstruct");
                return this;
            }

            private Builder contentstruct(String __value) {
                return this.contentstruct(Integer.valueOf(__value));
            }

            public Builder fieldsets(String __key, Fieldsets.Builder __value) {
                this.fieldsets.put(__key, __value);
                return this;
            }

            public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
                this.fieldsets.putAll(__values);
                return this;
            }

            public Builder fieldsets(String __key, Consumer<Fieldsets.Builder> __func) {
                Fieldsets.Builder __inner = new Fieldsets.Builder();
                __func.accept(__inner);
                this.fieldsets.put(__key, __inner);
                return this;
            }

            public Builder importedfield(Importedfield.Builder __builder) {
                this.importedfield.add(__builder);
                return this;
            }

            public Builder importedfield(Consumer<Importedfield.Builder> __func) {
                Importedfield.Builder __inner = new Importedfield.Builder();
                __func.accept(__inner);
                this.importedfield.add(__inner);
                return this;
            }

            public Builder importedfield(List<Importedfield.Builder> __builders) {
                this.importedfield = __builders;
                return this;
            }

            public Builder primitivetype(Primitivetype.Builder __builder) {
                this.primitivetype.add(__builder);
                return this;
            }

            public Builder primitivetype(Consumer<Primitivetype.Builder> __func) {
                Primitivetype.Builder __inner = new Primitivetype.Builder();
                __func.accept(__inner);
                this.primitivetype.add(__inner);
                return this;
            }

            public Builder primitivetype(List<Primitivetype.Builder> __builders) {
                this.primitivetype = __builders;
                return this;
            }

            public Builder arraytype(Arraytype.Builder __builder) {
                this.arraytype.add(__builder);
                return this;
            }

            public Builder arraytype(Consumer<Arraytype.Builder> __func) {
                Arraytype.Builder __inner = new Arraytype.Builder();
                __func.accept(__inner);
                this.arraytype.add(__inner);
                return this;
            }

            public Builder arraytype(List<Arraytype.Builder> __builders) {
                this.arraytype = __builders;
                return this;
            }

            public Builder maptype(Maptype.Builder __builder) {
                this.maptype.add(__builder);
                return this;
            }

            public Builder maptype(Consumer<Maptype.Builder> __func) {
                Maptype.Builder __inner = new Maptype.Builder();
                __func.accept(__inner);
                this.maptype.add(__inner);
                return this;
            }

            public Builder maptype(List<Maptype.Builder> __builders) {
                this.maptype = __builders;
                return this;
            }

            public Builder wsettype(Wsettype.Builder __builder) {
                this.wsettype.add(__builder);
                return this;
            }

            public Builder wsettype(Consumer<Wsettype.Builder> __func) {
                Wsettype.Builder __inner = new Wsettype.Builder();
                __func.accept(__inner);
                this.wsettype.add(__inner);
                return this;
            }

            public Builder wsettype(List<Wsettype.Builder> __builders) {
                this.wsettype = __builders;
                return this;
            }

            public Builder tensortype(Tensortype.Builder __builder) {
                this.tensortype.add(__builder);
                return this;
            }

            public Builder tensortype(Consumer<Tensortype.Builder> __func) {
                Tensortype.Builder __inner = new Tensortype.Builder();
                __func.accept(__inner);
                this.tensortype.add(__inner);
                return this;
            }

            public Builder tensortype(List<Tensortype.Builder> __builders) {
                this.tensortype = __builders;
                return this;
            }

            public Builder documentref(Documentref.Builder __builder) {
                this.documentref.add(__builder);
                return this;
            }

            public Builder documentref(Consumer<Documentref.Builder> __func) {
                Documentref.Builder __inner = new Documentref.Builder();
                __func.accept(__inner);
                this.documentref.add(__inner);
                return this;
            }

            public Builder documentref(List<Documentref.Builder> __builders) {
                this.documentref = __builders;
                return this;
            }

            public Builder annotationtype(Annotationtype.Builder __builder) {
                this.annotationtype.add(__builder);
                return this;
            }

            public Builder annotationtype(Consumer<Annotationtype.Builder> __func) {
                Annotationtype.Builder __inner = new Annotationtype.Builder();
                __func.accept(__inner);
                this.annotationtype.add(__inner);
                return this;
            }

            public Builder annotationtype(List<Annotationtype.Builder> __builders) {
                this.annotationtype = __builders;
                return this;
            }

            public Builder annotationref(Annotationref.Builder __builder) {
                this.annotationref.add(__builder);
                return this;
            }

            public Builder annotationref(Consumer<Annotationref.Builder> __func) {
                Annotationref.Builder __inner = new Annotationref.Builder();
                __func.accept(__inner);
                this.annotationref.add(__inner);
                return this;
            }

            public Builder annotationref(List<Annotationref.Builder> __builders) {
                this.annotationref = __builders;
                return this;
            }

            public Builder structtype(Structtype.Builder __builder) {
                this.structtype.add(__builder);
                return this;
            }

            public Builder structtype(Consumer<Structtype.Builder> __func) {
                Structtype.Builder __inner = new Structtype.Builder();
                __func.accept(__inner);
                this.structtype.add(__inner);
                return this;
            }

            public Builder structtype(List<Structtype.Builder> __builders) {
                this.structtype = __builders;
                return this;
            }

            public Doctype build() {
                return new Doctype(this);
            }
        }

        public static final class Inherits
        extends InnerNode {
            private final IntegerNode idx;

            public Inherits(Builder builder) {
                this(builder, true);
            }

            private Inherits(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
            }

            public int idx() {
                return this.idx.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                return changes;
            }

            private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                ArrayList<Inherits> elems = new ArrayList<Inherits>();
                for (Builder b : builders) {
                    elems.add(new Inherits(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx"));
                private Integer idx = null;

                public Builder() {
                }

                public Builder(Inherits config) {
                    this.idx(config.idx());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Inherits build() {
                    return new Inherits(this);
                }
            }
        }

        public static final class Fieldsets
        extends InnerNode {
            private final LeafNodeVector<String, StringNode> fields;

            public Fieldsets(Builder builder) {
                this(builder, true);
            }

            private Fieldsets(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].fieldsets{} must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.fields = new LeafNodeVector(builder.fields, (LeafNode)new StringNode());
            }

            public List<String> fields() {
                return this.fields.asList();
            }

            public String fields(int i) {
                return ((StringNode)this.fields.get(i)).value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
                return changes;
            }

            private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
                LinkedHashMap<String, Fieldsets> ret = new LinkedHashMap<String, Fieldsets>();
                for (String key : builders.keySet()) {
                    ret.put(key, new Fieldsets(builders.get(key)));
                }
                return Collections.unmodifiableMap(ret);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public List<String> fields = new ArrayList<String>();

                public Builder() {
                }

                public Builder(Fieldsets config) {
                    this.fields(config.fields());
                }

                private Builder override(Builder __superior) {
                    if (!__superior.fields.isEmpty()) {
                        this.fields.addAll(__superior.fields);
                    }
                    return this;
                }

                public Builder fields(String __value) {
                    this.fields.add(__value);
                    return this;
                }

                public Builder fields(Collection<String> __values) {
                    this.fields.addAll(__values);
                    return this;
                }

                public Fieldsets build() {
                    return new Fieldsets(this);
                }
            }
        }

        public static final class Importedfield
        extends InnerNode {
            private final StringNode name;

            public Importedfield(Builder builder) {
                this(builder, true);
            }

            private Importedfield(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].importedfield[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
                return changes;
            }

            private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
                ArrayList<Importedfield> elems = new ArrayList<Importedfield>();
                for (Builder b : builders) {
                    elems.add(new Importedfield(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("name"));
                private String name = null;

                public Builder() {
                }

                public Builder(Importedfield config) {
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Importedfield build() {
                    return new Importedfield(this);
                }
            }
        }

        public static final class Primitivetype
        extends InnerNode {
            private final IntegerNode idx;
            private final StringNode name;

            public Primitivetype(Builder builder) {
                this(builder, true);
            }

            private Primitivetype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].primitivetype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            }

            public int idx() {
                return this.idx.value();
            }

            public String name() {
                return this.name.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Primitivetype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("primitivetype");
                return changes;
            }

            private static InnerNodeVector<Primitivetype> createVector(List<Builder> builders) {
                ArrayList<Primitivetype> elems = new ArrayList<Primitivetype>();
                for (Builder b : builders) {
                    elems.add(new Primitivetype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "name"));
                private Integer idx = null;
                private String name = null;

                public Builder() {
                }

                public Builder(Primitivetype config) {
                    this.idx(config.idx());
                    this.name(config.name());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Primitivetype build() {
                    return new Primitivetype(this);
                }
            }
        }

        public static final class Arraytype
        extends InnerNode {
            private final IntegerNode idx;
            private final IntegerNode elementtype;

            public Arraytype(Builder builder) {
                this(builder, true);
            }

            private Arraytype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].arraytype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.elementtype = builder.elementtype == null ? new IntegerNode() : new IntegerNode(builder.elementtype.intValue());
            }

            public int idx() {
                return this.idx.value();
            }

            public int elementtype() {
                return this.elementtype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
                return changes;
            }

            private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
                ArrayList<Arraytype> elems = new ArrayList<Arraytype>();
                for (Builder b : builders) {
                    elems.add(new Arraytype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "elementtype"));
                private Integer idx = null;
                private Integer elementtype = null;

                public Builder() {
                }

                public Builder(Arraytype config) {
                    this.idx(config.idx());
                    this.elementtype(config.elementtype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.elementtype != null) {
                        this.elementtype(__superior.elementtype);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder elementtype(int __value) {
                    this.elementtype = __value;
                    this.__uninitialized.remove("elementtype");
                    return this;
                }

                private Builder elementtype(String __value) {
                    return this.elementtype(Integer.valueOf(__value));
                }

                public Arraytype build() {
                    return new Arraytype(this);
                }
            }
        }

        public static final class Maptype
        extends InnerNode {
            private final IntegerNode idx;
            private final IntegerNode keytype;
            private final IntegerNode valuetype;

            public Maptype(Builder builder) {
                this(builder, true);
            }

            private Maptype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].maptype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.keytype = builder.keytype == null ? new IntegerNode() : new IntegerNode(builder.keytype.intValue());
                this.valuetype = builder.valuetype == null ? new IntegerNode() : new IntegerNode(builder.valuetype.intValue());
            }

            public int idx() {
                return this.idx.value();
            }

            public int keytype() {
                return this.keytype.value();
            }

            public int valuetype() {
                return this.valuetype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
                return changes;
            }

            private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
                ArrayList<Maptype> elems = new ArrayList<Maptype>();
                for (Builder b : builders) {
                    elems.add(new Maptype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "keytype", "valuetype"));
                private Integer idx = null;
                private Integer keytype = null;
                private Integer valuetype = null;

                public Builder() {
                }

                public Builder(Maptype config) {
                    this.idx(config.idx());
                    this.keytype(config.keytype());
                    this.valuetype(config.valuetype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.keytype != null) {
                        this.keytype(__superior.keytype);
                    }
                    if (__superior.valuetype != null) {
                        this.valuetype(__superior.valuetype);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder keytype(int __value) {
                    this.keytype = __value;
                    this.__uninitialized.remove("keytype");
                    return this;
                }

                private Builder keytype(String __value) {
                    return this.keytype(Integer.valueOf(__value));
                }

                public Builder valuetype(int __value) {
                    this.valuetype = __value;
                    this.__uninitialized.remove("valuetype");
                    return this;
                }

                private Builder valuetype(String __value) {
                    return this.valuetype(Integer.valueOf(__value));
                }

                public Maptype build() {
                    return new Maptype(this);
                }
            }
        }

        public static final class Wsettype
        extends InnerNode {
            private final IntegerNode idx;
            private final IntegerNode elementtype;
            private final BooleanNode createifnonexistent;
            private final BooleanNode removeifzero;

            public Wsettype(Builder builder) {
                this(builder, true);
            }

            private Wsettype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].wsettype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.elementtype = builder.elementtype == null ? new IntegerNode() : new IntegerNode(builder.elementtype.intValue());
                this.createifnonexistent = builder.createifnonexistent == null ? new BooleanNode(false) : new BooleanNode(builder.createifnonexistent.booleanValue());
                this.removeifzero = builder.removeifzero == null ? new BooleanNode(false) : new BooleanNode(builder.removeifzero.booleanValue());
            }

            public int idx() {
                return this.idx.value();
            }

            public int elementtype() {
                return this.elementtype.value();
            }

            public boolean createifnonexistent() {
                return this.createifnonexistent.value();
            }

            public boolean removeifzero() {
                return this.removeifzero.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Wsettype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("wsettype");
                return changes;
            }

            private static InnerNodeVector<Wsettype> createVector(List<Builder> builders) {
                ArrayList<Wsettype> elems = new ArrayList<Wsettype>();
                for (Builder b : builders) {
                    elems.add(new Wsettype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "elementtype"));
                private Integer idx = null;
                private Integer elementtype = null;
                private Boolean createifnonexistent = null;
                private Boolean removeifzero = null;

                public Builder() {
                }

                public Builder(Wsettype config) {
                    this.idx(config.idx());
                    this.elementtype(config.elementtype());
                    this.createifnonexistent(config.createifnonexistent());
                    this.removeifzero(config.removeifzero());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.elementtype != null) {
                        this.elementtype(__superior.elementtype);
                    }
                    if (__superior.createifnonexistent != null) {
                        this.createifnonexistent(__superior.createifnonexistent);
                    }
                    if (__superior.removeifzero != null) {
                        this.removeifzero(__superior.removeifzero);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder elementtype(int __value) {
                    this.elementtype = __value;
                    this.__uninitialized.remove("elementtype");
                    return this;
                }

                private Builder elementtype(String __value) {
                    return this.elementtype(Integer.valueOf(__value));
                }

                public Builder createifnonexistent(boolean __value) {
                    this.createifnonexistent = __value;
                    return this;
                }

                private Builder createifnonexistent(String __value) {
                    return this.createifnonexistent(Boolean.valueOf(__value));
                }

                public Builder removeifzero(boolean __value) {
                    this.removeifzero = __value;
                    return this;
                }

                private Builder removeifzero(String __value) {
                    return this.removeifzero(Boolean.valueOf(__value));
                }

                public Wsettype build() {
                    return new Wsettype(this);
                }
            }
        }

        public static final class Tensortype
        extends InnerNode {
            private final IntegerNode idx;
            private final StringNode detailedtype;

            public Tensortype(Builder builder) {
                this(builder, true);
            }

            private Tensortype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].tensortype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.detailedtype = builder.detailedtype == null ? new StringNode() : new StringNode(builder.detailedtype);
            }

            public int idx() {
                return this.idx.value();
            }

            public String detailedtype() {
                return this.detailedtype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Tensortype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("tensortype");
                return changes;
            }

            private static InnerNodeVector<Tensortype> createVector(List<Builder> builders) {
                ArrayList<Tensortype> elems = new ArrayList<Tensortype>();
                for (Builder b : builders) {
                    elems.add(new Tensortype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "detailedtype"));
                private Integer idx = null;
                private String detailedtype = null;

                public Builder() {
                }

                public Builder(Tensortype config) {
                    this.idx(config.idx());
                    this.detailedtype(config.detailedtype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.detailedtype != null) {
                        this.detailedtype(__superior.detailedtype);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder detailedtype(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.detailedtype = __value;
                    this.__uninitialized.remove("detailedtype");
                    return this;
                }

                public Tensortype build() {
                    return new Tensortype(this);
                }
            }
        }

        public static final class Documentref
        extends InnerNode {
            private final IntegerNode idx;
            private final IntegerNode targettype;

            public Documentref(Builder builder) {
                this(builder, true);
            }

            private Documentref(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].documentref[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.targettype = builder.targettype == null ? new IntegerNode() : new IntegerNode(builder.targettype.intValue());
            }

            public int idx() {
                return this.idx.value();
            }

            public int targettype() {
                return this.targettype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Documentref newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("documentref");
                return changes;
            }

            private static InnerNodeVector<Documentref> createVector(List<Builder> builders) {
                ArrayList<Documentref> elems = new ArrayList<Documentref>();
                for (Builder b : builders) {
                    elems.add(new Documentref(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "targettype"));
                private Integer idx = null;
                private Integer targettype = null;

                public Builder() {
                }

                public Builder(Documentref config) {
                    this.idx(config.idx());
                    this.targettype(config.targettype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.targettype != null) {
                        this.targettype(__superior.targettype);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder targettype(int __value) {
                    this.targettype = __value;
                    this.__uninitialized.remove("targettype");
                    return this;
                }

                private Builder targettype(String __value) {
                    return this.targettype(Integer.valueOf(__value));
                }

                public Documentref build() {
                    return new Documentref(this);
                }
            }
        }

        public static final class Annotationtype
        extends InnerNode {
            private final IntegerNode idx;
            private final StringNode name;
            private final IntegerNode internalid;
            private final IntegerNode datatype;
            private final InnerNodeVector<Inherits> inherits;

            public Annotationtype(Builder builder) {
                this(builder, true);
            }

            private Annotationtype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].annotationtype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.internalid = builder.internalid == null ? new IntegerNode(-1) : new IntegerNode(builder.internalid.intValue());
                this.datatype = builder.datatype == null ? new IntegerNode(-1) : new IntegerNode(builder.datatype.intValue());
                this.inherits = Inherits.createVector(builder.inherits);
            }

            public int idx() {
                return this.idx.value();
            }

            public String name() {
                return this.name.value();
            }

            public int internalid() {
                return this.internalid.value();
            }

            public int datatype() {
                return this.datatype.value();
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
                return changes;
            }

            private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
                ArrayList<Annotationtype> elems = new ArrayList<Annotationtype>();
                for (Builder b : builders) {
                    elems.add(new Annotationtype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "name"));
                private Integer idx = null;
                private String name = null;
                private Integer internalid = null;
                private Integer datatype = null;
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();

                public Builder() {
                }

                public Builder(Annotationtype config) {
                    this.idx(config.idx());
                    this.name(config.name());
                    this.internalid(config.internalid());
                    this.datatype(config.datatype());
                    for (Inherits i : config.inherits()) {
                        this.inherits(new Inherits.Builder(i));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.internalid != null) {
                        this.internalid(__superior.internalid);
                    }
                    if (__superior.datatype != null) {
                        this.datatype(__superior.datatype);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder internalid(int __value) {
                    this.internalid = __value;
                    return this;
                }

                private Builder internalid(String __value) {
                    return this.internalid(Integer.valueOf(__value));
                }

                public Builder datatype(int __value) {
                    this.datatype = __value;
                    return this;
                }

                private Builder datatype(String __value) {
                    return this.datatype(Integer.valueOf(__value));
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(Consumer<Inherits.Builder> __func) {
                    Inherits.Builder __inner = new Inherits.Builder();
                    __func.accept(__inner);
                    this.inherits.add(__inner);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Annotationtype build() {
                    return new Annotationtype(this);
                }
            }

            public static final class Inherits
            extends InnerNode {
                private final IntegerNode idx;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].annotationtype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                }

                public int idx() {
                    return this.idx.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("idx"));
                    private Integer idx = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.idx(config.idx());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.idx != null) {
                            this.idx(__superior.idx);
                        }
                        return this;
                    }

                    public Builder idx(int __value) {
                        this.idx = __value;
                        this.__uninitialized.remove("idx");
                        return this;
                    }

                    private Builder idx(String __value) {
                        return this.idx(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }
        }

        public static final class Annotationref
        extends InnerNode {
            private final IntegerNode idx;
            private final IntegerNode annotationtype;

            public Annotationref(Builder builder) {
                this(builder, true);
            }

            private Annotationref(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].annotationref[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.annotationtype = builder.annotationtype == null ? new IntegerNode() : new IntegerNode(builder.annotationtype.intValue());
            }

            public int idx() {
                return this.idx.value();
            }

            public int annotationtype() {
                return this.annotationtype.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Annotationref newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationref");
                return changes;
            }

            private static InnerNodeVector<Annotationref> createVector(List<Builder> builders) {
                ArrayList<Annotationref> elems = new ArrayList<Annotationref>();
                for (Builder b : builders) {
                    elems.add(new Annotationref(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "annotationtype"));
                private Integer idx = null;
                private Integer annotationtype = null;

                public Builder() {
                }

                public Builder(Annotationref config) {
                    this.idx(config.idx());
                    this.annotationtype(config.annotationtype());
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.annotationtype != null) {
                        this.annotationtype(__superior.annotationtype);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder annotationtype(int __value) {
                    this.annotationtype = __value;
                    this.__uninitialized.remove("annotationtype");
                    return this;
                }

                private Builder annotationtype(String __value) {
                    return this.annotationtype(Integer.valueOf(__value));
                }

                public Annotationref build() {
                    return new Annotationref(this);
                }
            }
        }

        public static final class Structtype
        extends InnerNode {
            private final IntegerNode idx;
            private final StringNode name;
            private final InnerNodeVector<Inherits> inherits;
            private final InnerNodeVector<Field> field;

            public Structtype(Builder builder) {
                this(builder, true);
            }

            private Structtype(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].structtype[] must be initialized: " + String.valueOf(builder.__uninitialized));
                }
                this.idx = builder.idx == null ? new IntegerNode() : new IntegerNode(builder.idx.intValue());
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.inherits = Inherits.createVector(builder.inherits);
                this.field = Field.createVector(builder.field);
            }

            public int idx() {
                return this.idx.value();
            }

            public String name() {
                return this.name.value();
            }

            public List<Inherits> inherits() {
                return this.inherits;
            }

            public Inherits inherits(int i) {
                return (Inherits)((Object)this.inherits.get(i));
            }

            public List<Field> field() {
                return this.field;
            }

            public Field field(int i) {
                return (Field)((Object)this.field.get(i));
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
                return changes;
            }

            private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
                ArrayList<Structtype> elems = new ArrayList<Structtype>();
                for (Builder b : builders) {
                    elems.add(new Structtype(b));
                }
                return new InnerNodeVector(elems);
            }

            public static final class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(List.of("idx", "name"));
                private Integer idx = null;
                private String name = null;
                public List<Inherits.Builder> inherits = new ArrayList<Inherits.Builder>();
                public List<Field.Builder> field = new ArrayList<Field.Builder>();

                public Builder() {
                }

                public Builder(Structtype config) {
                    this.idx(config.idx());
                    this.name(config.name());
                    for (Inherits i : config.inherits()) {
                        this.inherits(new Inherits.Builder(i));
                    }
                    for (Field f : config.field()) {
                        this.field(new Field.Builder(f));
                    }
                }

                private Builder override(Builder __superior) {
                    if (__superior.idx != null) {
                        this.idx(__superior.idx);
                    }
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (!__superior.inherits.isEmpty()) {
                        this.inherits.addAll(__superior.inherits);
                    }
                    if (!__superior.field.isEmpty()) {
                        this.field.addAll(__superior.field);
                    }
                    return this;
                }

                public Builder idx(int __value) {
                    this.idx = __value;
                    this.__uninitialized.remove("idx");
                    return this;
                }

                private Builder idx(String __value) {
                    return this.idx(Integer.valueOf(__value));
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder inherits(Inherits.Builder __builder) {
                    this.inherits.add(__builder);
                    return this;
                }

                public Builder inherits(Consumer<Inherits.Builder> __func) {
                    Inherits.Builder __inner = new Inherits.Builder();
                    __func.accept(__inner);
                    this.inherits.add(__inner);
                    return this;
                }

                public Builder inherits(List<Inherits.Builder> __builders) {
                    this.inherits = __builders;
                    return this;
                }

                public Builder field(Field.Builder __builder) {
                    this.field.add(__builder);
                    return this;
                }

                public Builder field(Consumer<Field.Builder> __func) {
                    Field.Builder __inner = new Field.Builder();
                    __func.accept(__inner);
                    this.field.add(__inner);
                    return this;
                }

                public Builder field(List<Field.Builder> __builders) {
                    this.field = __builders;
                    return this;
                }

                public Structtype build() {
                    return new Structtype(this);
                }
            }

            public static final class Inherits
            extends InnerNode {
                private final IntegerNode type;

                public Inherits(Builder builder) {
                    this(builder, true);
                }

                private Inherits(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].structtype[].inherits[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.type = builder.type == null ? new IntegerNode() : new IntegerNode(builder.type.intValue());
                }

                public int type() {
                    return this.type.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
                    return changes;
                }

                private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
                    ArrayList<Inherits> elems = new ArrayList<Inherits>();
                    for (Builder b : builders) {
                        elems.add(new Inherits(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("type"));
                    private Integer type = null;

                    public Builder() {
                    }

                    public Builder(Inherits config) {
                        this.type(config.type());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.type != null) {
                            this.type(__superior.type);
                        }
                        return this;
                    }

                    public Builder type(int __value) {
                        this.type = __value;
                        this.__uninitialized.remove("type");
                        return this;
                    }

                    private Builder type(String __value) {
                        return this.type(Integer.valueOf(__value));
                    }

                    public Inherits build() {
                        return new Inherits(this);
                    }
                }
            }

            public static final class Field
            extends InnerNode {
                private final StringNode name;
                private final IntegerNode internalid;
                private final IntegerNode type;

                public Field(Builder builder) {
                    this(builder, true);
                }

                private Field(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for documentmanager.doctype[].structtype[].field[] must be initialized: " + String.valueOf(builder.__uninitialized));
                    }
                    this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                    this.internalid = builder.internalid == null ? new IntegerNode() : new IntegerNode(builder.internalid.intValue());
                    this.type = builder.type == null ? new IntegerNode() : new IntegerNode(builder.type.intValue());
                }

                public String name() {
                    return this.name.value();
                }

                public int internalid() {
                    return this.internalid.value();
                }

                public int type() {
                    return this.type.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
                    return changes;
                }

                private static InnerNodeVector<Field> createVector(List<Builder> builders) {
                    ArrayList<Field> elems = new ArrayList<Field>();
                    for (Builder b : builders) {
                        elems.add(new Field(b));
                    }
                    return new InnerNodeVector(elems);
                }

                public static final class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>(List.of("name", "internalid", "type"));
                    private String name = null;
                    private Integer internalid = null;
                    private Integer type = null;

                    public Builder() {
                    }

                    public Builder(Field config) {
                        this.name(config.name());
                        this.internalid(config.internalid());
                        this.type(config.type());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.name != null) {
                            this.name(__superior.name);
                        }
                        if (__superior.internalid != null) {
                            this.internalid(__superior.internalid);
                        }
                        if (__superior.type != null) {
                            this.type(__superior.type);
                        }
                        return this;
                    }

                    public Builder name(String __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.name = __value;
                        this.__uninitialized.remove("name");
                        return this;
                    }

                    public Builder internalid(int __value) {
                        this.internalid = __value;
                        this.__uninitialized.remove("internalid");
                        return this;
                    }

                    private Builder internalid(String __value) {
                        return this.internalid(Integer.valueOf(__value));
                    }

                    public Builder type(int __value) {
                        this.type = __value;
                        this.__uninitialized.remove("type");
                        return this;
                    }

                    private Builder type(String __value) {
                        return this.type(Integer.valueOf(__value));
                    }

                    public Field build() {
                        return new Field(this);
                    }
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

