/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.DataType;
import com.yahoo.document.ExtendedField;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.StructuredFieldValue;
import java.util.HashMap;
import java.util.Map;

public class ExtendedStringField
extends ExtendedField {
    private final ExtractSpanTrees extractSpanTrees;

    public ExtendedStringField(String name, DataType type, ExtendedField.Extract extract, ExtractSpanTrees extractSpanTrees) {
        super(name, type, extract);
        this.extractSpanTrees = extractSpanTrees;
    }

    @Override
    public FieldValue getFieldValue(StructuredFieldValue doc) {
        StringFieldValue sfv = (StringFieldValue)super.getFieldValue(doc);
        Map<String, SpanTree> trees = this.extractSpanTrees.get(doc);
        if (trees != null) {
            for (SpanTree tree : trees.values()) {
                sfv.setSpanTree(tree);
            }
        }
        return sfv;
    }

    @Override
    public FieldValue setFieldValue(StructuredFieldValue doc, FieldValue fv) {
        FieldValue old = this.getFieldValue(doc);
        StringFieldValue sfv = (StringFieldValue)fv;
        super.setFieldValue(doc, sfv);
        Map<String, SpanTree> trees = null;
        if (sfv != null && (trees = sfv.getSpanTreeMap()) == null) {
            trees = new HashMap<String, SpanTree>();
        }
        this.extractSpanTrees.set(doc, trees);
        return old;
    }

    public static interface ExtractSpanTrees {
        public Map<String, SpanTree> get(StructuredFieldValue var1);

        public void set(StructuredFieldValue var1, Map<String, SpanTree> var2);
    }
}

