/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.annotation;

import java.util.ListIterator;

class PeekableListIterator<E>
implements ListIterator<E> {
    private E next;
    private ListIterator<E> base;
    boolean traversed = false;
    private int position = -1;

    PeekableListIterator(ListIterator<E> base) {
        this.base = base;
        this.traversed = false;
    }

    @Override
    public boolean hasNext() {
        return this.next != null || this.base.hasNext();
    }

    @Override
    public E next() {
        if (this.next == null) {
            E n = this.base.next();
            ++this.position;
            return n;
        }
        E retval = this.next;
        this.next = null;
        ++this.position;
        return retval;
    }

    @Override
    public boolean hasPrevious() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E previous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove() {
        if (this.position < 0) {
            throw new IllegalStateException("Cannot remove() before next()");
        }
        if (this.next != null) {
            this.base.previous();
            this.base.previous();
            this.base.remove();
        } else {
            this.base.remove();
        }
        this.next = null;
    }

    @Override
    public void set(E e) {
        if (this.position < 0) {
            throw new IllegalStateException("Cannot set() before next()");
        }
        if (this.next != null) {
            this.base.previous();
            this.base.previous();
        }
        this.base.set(e);
        this.next = null;
    }

    @Override
    public void add(E e) {
        if (this.next != null) {
            this.base.previous();
        }
        this.base.add(e);
        this.next = null;
    }

    public E peek() {
        if (this.next == null && this.base.hasNext()) {
            this.next = this.base.next();
        }
        return this.next;
    }
}

