/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.document.Document;
import com.yahoo.document.DocumentPut;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.parser.ParseException;
import com.yahoo.document.select.parser.SelectInput;
import com.yahoo.document.select.parser.SelectParser;
import com.yahoo.document.select.rule.ComparisonNode;
import java.util.Map;

public class DocumentCalculator {
    private ComparisonNode comparison;

    public DocumentCalculator(String expression) throws ParseException {
        SelectParser parser = new SelectParser(new SelectInput(expression + " == 0"));
        this.comparison = (ComparisonNode)parser.expression();
    }

    public Number evaluate(Document doc, Map<String, Object> variables) {
        Context context = new Context(new DocumentPut(doc));
        context.setVariables(variables);
        try {
            Object o = this.comparison.getLHS().evaluate(context);
            if (Double.isInfinite(((Number)o).doubleValue())) {
                throw new IllegalArgumentException("Expression evaluated to an infinite number");
            }
            return ((Number)o).doubleValue();
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Arithmetic exception " + e.getMessage(), e);
        }
    }
}

