// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.document.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of documenttypes
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumenttypesConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "ae358370c3b44ec6e365d44dff202ae4";
  public final static String CONFIG_DEF_NAME = "documenttypes";
  public final static String CONFIG_DEF_NAMESPACE = "document.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=document.config",
    "ignoreundefinedfields bool default=false",
    "usev8geopositions bool default=false",
    "documenttype[].id int",
    "documenttype[].name string",
    "documenttype[].version int default=0",
    "documenttype[].headerstruct int",
    "documenttype[].bodystruct int default=0",
    "documenttype[].inherits[].id int",
    "documenttype[].datatype[].id int",
    "documenttype[].datatype[].type enum {STRUCT, ARRAY, WSET, MAP, ANNOTATIONREF, PRIMITIVE, TENSOR}",
    "documenttype[].datatype[].array.element.id int default=0",
    "documenttype[].datatype[].map.key.id int default=0",
    "documenttype[].datatype[].map.value.id int default=0",
    "documenttype[].datatype[].wset.key.id int default=0",
    "documenttype[].datatype[].wset.createifnonexistent bool default=false",
    "documenttype[].datatype[].wset.removeifzero bool default=false",
    "documenttype[].datatype[].annotationref.annotation.id int default=0",
    "documenttype[].datatype[].sstruct.name string default=\"\"",
    "documenttype[].datatype[].sstruct.version int default=0",
    "documenttype[].datatype[].sstruct.compression.type enum {NONE, LZ4} default=NONE",
    "documenttype[].datatype[].sstruct.compression.level int default=0",
    "documenttype[].datatype[].sstruct.compression.threshold int default=95",
    "documenttype[].datatype[].sstruct.compression.minsize int default=200",
    "documenttype[].datatype[].sstruct.field[].name string",
    "documenttype[].datatype[].sstruct.field[].id int",
    "documenttype[].datatype[].sstruct.field[].datatype int",
    "documenttype[].datatype[].sstruct.field[].detailedtype string default=\"\"",
    "documenttype[].annotationtype[].id int",
    "documenttype[].annotationtype[].name string",
    "documenttype[].annotationtype[].datatype int default=-1",
    "documenttype[].annotationtype[].inherits[].id int",
    "documenttype[].fieldsets{}.fields[] string",
    "documenttype[].referencetype[].id int",
    "documenttype[].referencetype[].target_type_id int",
    "documenttype[].importedfield[].name string",
    "doctype[].name string",
    "doctype[].idx int",
    "doctype[].internalid int",
    "doctype[].inherits[].idx int",
    "doctype[].contentstruct int",
    "doctype[].fieldsets{}.fields[] string",
    "doctype[].importedfield[].name string",
    "doctype[].primitivetype[].idx int",
    "doctype[].primitivetype[].name string",
    "doctype[].arraytype[].idx int",
    "doctype[].arraytype[].elementtype int",
    "doctype[].arraytype[].internalid int",
    "doctype[].maptype[].idx int",
    "doctype[].maptype[].keytype int",
    "doctype[].maptype[].valuetype int",
    "doctype[].maptype[].internalid int",
    "doctype[].wsettype[].idx int",
    "doctype[].wsettype[].elementtype int",
    "doctype[].wsettype[].createifnonexistent bool default=false",
    "doctype[].wsettype[].removeifzero bool default=false",
    "doctype[].wsettype[].internalid int",
    "doctype[].tensortype[].idx int",
    "doctype[].tensortype[].detailedtype string",
    "doctype[].documentref[].idx int",
    "doctype[].documentref[].targettype int",
    "doctype[].documentref[].internalid int",
    "doctype[].annotationtype[].idx int",
    "doctype[].annotationtype[].name string",
    "doctype[].annotationtype[].internalid int",
    "doctype[].annotationtype[].datatype int default=-1",
    "doctype[].annotationtype[].inherits[].idx int",
    "doctype[].annotationref[].idx int",
    "doctype[].annotationref[].annotationtype int",
    "doctype[].annotationref[].internalid int",
    "doctype[].structtype[].idx int",
    "doctype[].structtype[].name string",
    "doctype[].structtype[].inherits[].type int",
    "doctype[].structtype[].field[].name string",
    "doctype[].structtype[].field[].internalid int",
    "doctype[].structtype[].field[].type int",
    "doctype[].structtype[].internalid int"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean ignoreundefinedfields = null;
    private Boolean usev8geopositions = null;
    public List<Documenttype.Builder> documenttype = new ArrayList<>();
    public List<Doctype.Builder> doctype = new ArrayList<>();

    public Builder() { }

    public Builder(DocumenttypesConfig config) {
      ignoreundefinedfields(config.ignoreundefinedfields());
      usev8geopositions(config.usev8geopositions());
      for (Documenttype d : config.documenttype()) {
        documenttype(new Documenttype.Builder(d));
      }
      for (Doctype d : config.doctype()) {
        doctype(new Doctype.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.ignoreundefinedfields != null)
        ignoreundefinedfields(__superior.ignoreundefinedfields);
      if (__superior.usev8geopositions != null)
        usev8geopositions(__superior.usev8geopositions);
      if (!__superior.documenttype.isEmpty())
        documenttype.addAll(__superior.documenttype);
      if (!__superior.doctype.isEmpty())
        doctype.addAll(__superior.doctype);
      return this;
    }

    public Builder ignoreundefinedfields(boolean __value) {
      ignoreundefinedfields = __value;
      return this;
    }

    private Builder ignoreundefinedfields(String __value) {
      return ignoreundefinedfields(Boolean.valueOf(__value));
    }

    public Builder usev8geopositions(boolean __value) {
      usev8geopositions = __value;
      return this;
    }

    private Builder usev8geopositions(String __value) {
      return usev8geopositions(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Documenttype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder documenttype(Documenttype.Builder __builder) {
      documenttype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder documenttype(java.util.function.Consumer<Documenttype.Builder> __func) {
      Documenttype.Builder __inner = new Documenttype.Builder();
      __func.accept(__inner);
      documenttype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Documenttype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder documenttype(List<Documenttype.Builder> __builders) {
      documenttype = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Doctype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder doctype(Doctype.Builder __builder) {
      doctype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder doctype(java.util.function.Consumer<Doctype.Builder> __func) {
      Doctype.Builder __inner = new Doctype.Builder();
      __func.accept(__inner);
      doctype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Doctype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder doctype(List<Doctype.Builder> __builders) {
      doctype = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumenttypesConfig build() {
      return new DocumenttypesConfig(this);
    }

  }

  // Whether attempts to set an undefined field should be ignored rather than causing an error
  private final BooleanNode ignoreundefinedfields;
  // Prefer "Vespa 8" format for the "position" type
  private final BooleanNode usev8geopositions;
  private final InnerNodeVector<Documenttype> documenttype;
  private final InnerNodeVector<Doctype> doctype;

  public DocumenttypesConfig(Builder builder) {
    this(builder, true);
  }

  private DocumenttypesConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "documenttypes must be initialized: " + builder.__uninitialized);

    ignoreundefinedfields = (builder.ignoreundefinedfields == null) ?
        new BooleanNode(false) : new BooleanNode(builder.ignoreundefinedfields);
    usev8geopositions = (builder.usev8geopositions == null) ?
        new BooleanNode(false) : new BooleanNode(builder.usev8geopositions);
    documenttype = Documenttype.createVector(builder.documenttype);
    doctype = Doctype.createVector(builder.doctype);
  }

  /**
   * @return documenttypes.ignoreundefinedfields
   */
  public boolean ignoreundefinedfields() {
    return ignoreundefinedfields.value();
  }

  /**
   * @return documenttypes.usev8geopositions
   */
  public boolean usev8geopositions() {
    return usev8geopositions.value();
  }

  /**
   * @return documenttypes.documenttype[]
   */
  public List<Documenttype> documenttype() {
    return documenttype;
  }

  /**
   * @param i the index of the value to return
   * @return documenttypes.documenttype[]
   */
  public Documenttype documenttype(int i) {
    return documenttype.get(i);
  }

  /**
   * @return documenttypes.doctype[]
   */
  public List<Doctype> doctype() {
    return doctype;
  }

  /**
   * @param i the index of the value to return
   * @return documenttypes.doctype[]
   */
  public Doctype doctype(int i) {
    return doctype.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumenttypesConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttypes");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents documenttypes.documenttype[]
   */
  public final static class Documenttype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "name",
        "headerstruct"
        ));

      private Integer id = null;
      private String name = null;
      private Integer version = null;
      private Integer headerstruct = null;
      private Integer bodystruct = null;
      public List<Inherits.Builder> inherits = new ArrayList<>();
      public List<Datatype.Builder> datatype = new ArrayList<>();
      public List<Annotationtype.Builder> annotationtype = new ArrayList<>();
      public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<>();
      public List<Referencetype.Builder> referencetype = new ArrayList<>();
      public List<Importedfield.Builder> importedfield = new ArrayList<>();

      public Builder() { }

      public Builder(Documenttype config) {
        id(config.id());
        name(config.name());
        version(config.version());
        headerstruct(config.headerstruct());
        bodystruct(config.bodystruct());
        for (Inherits i : config.inherits()) {
          inherits(new Inherits.Builder(i));
        }
        for (Datatype d : config.datatype()) {
          datatype(new Datatype.Builder(d));
        }
        for (Annotationtype a : config.annotationtype()) {
          annotationtype(new Annotationtype.Builder(a));
        }
        for (Map.Entry<String, Fieldsets> __entry : config.fieldsets().entrySet()) {
          fieldsets(__entry.getKey(), new Fieldsets.Builder(__entry.getValue()));
        }
        for (Referencetype r : config.referencetype()) {
          referencetype(new Referencetype.Builder(r));
        }
        for (Importedfield i : config.importedfield()) {
          importedfield(new Importedfield.Builder(i));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.version != null)
          version(__superior.version);
        if (__superior.headerstruct != null)
          headerstruct(__superior.headerstruct);
        if (__superior.bodystruct != null)
          bodystruct(__superior.bodystruct);
        if (!__superior.inherits.isEmpty())
          inherits.addAll(__superior.inherits);
        if (!__superior.datatype.isEmpty())
          datatype.addAll(__superior.datatype);
        if (!__superior.annotationtype.isEmpty())
          annotationtype.addAll(__superior.annotationtype);
        fieldsets(__superior.fieldsets);
        if (!__superior.referencetype.isEmpty())
          referencetype.addAll(__superior.referencetype);
        if (!__superior.importedfield.isEmpty())
          importedfield.addAll(__superior.importedfield);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder version(int __value) {
        version = __value;
        return this;
      }

      private Builder version(String __value) {
        return version(Integer.valueOf(__value));
      }

      public Builder headerstruct(int __value) {
        headerstruct = __value;
        __uninitialized.remove("headerstruct");
        return this;
      }

      private Builder headerstruct(String __value) {
        return headerstruct(Integer.valueOf(__value));
      }

      public Builder bodystruct(int __value) {
        bodystruct = __value;
        return this;
      }

      private Builder bodystruct(String __value) {
        return bodystruct(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Inherits builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder inherits(Inherits.Builder __builder) {
        inherits.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
        Inherits.Builder __inner = new Inherits.Builder();
        __func.accept(__inner);
        inherits.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Inherits builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder inherits(List<Inherits.Builder> __builders) {
        inherits = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Datatype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder datatype(Datatype.Builder __builder) {
        datatype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder datatype(java.util.function.Consumer<Datatype.Builder> __func) {
        Datatype.Builder __inner = new Datatype.Builder();
        __func.accept(__inner);
        datatype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Datatype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder datatype(List<Datatype.Builder> __builders) {
        datatype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationtype(Annotationtype.Builder __builder) {
        annotationtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationtype(java.util.function.Consumer<Annotationtype.Builder> __func) {
        Annotationtype.Builder __inner = new Annotationtype.Builder();
        __func.accept(__inner);
        annotationtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationtype(List<Annotationtype.Builder> __builders) {
        annotationtype = __builders;
        return this;
      }

      public Builder fieldsets(String __key, Fieldsets.Builder __value) {
        fieldsets.put(__key, __value);
        return this;
      }

      public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
        fieldsets.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fieldsets(String __key, java.util.function.Consumer<Fieldsets.Builder> __func) {
        Fieldsets.Builder __inner = new Fieldsets.Builder();
        __func.accept(__inner);
        fieldsets.put(__key, __inner);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Referencetype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder referencetype(Referencetype.Builder __builder) {
        referencetype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder referencetype(java.util.function.Consumer<Referencetype.Builder> __func) {
        Referencetype.Builder __inner = new Referencetype.Builder();
        __func.accept(__inner);
        referencetype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Referencetype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder referencetype(List<Referencetype.Builder> __builders) {
        referencetype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Importedfield builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder importedfield(Importedfield.Builder __builder) {
        importedfield.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder importedfield(java.util.function.Consumer<Importedfield.Builder> __func) {
        Importedfield.Builder __inner = new Importedfield.Builder();
        __func.accept(__inner);
        importedfield.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Importedfield builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder importedfield(List<Importedfield.Builder> __builders) {
        importedfield = __builders;
        return this;
      }

      public Documenttype build() {
        return new Documenttype(this);
      }

    }

    // The Id of the documenttype. Must be unique among all document types.
    private final IntegerNode id;
    // Specify the name of the document type. Must be unique.
    private final StringNode name;
    // Version is not used
    private final IntegerNode version;
    // Name of header struct defining document header.
    private final IntegerNode headerstruct;
    // Specify a document field id. Must be unique within the document type.
    private final IntegerNode bodystruct;
    private final InnerNodeVector<Inherits> inherits;
    private final InnerNodeVector<Datatype> datatype;
    private final InnerNodeVector<Annotationtype> annotationtype;
    private final Map<String, Fieldsets> fieldsets;
    private final InnerNodeVector<Referencetype> referencetype;
    private final InnerNodeVector<Importedfield> importedfield;

    public Documenttype(Builder builder) {
      this(builder, true);
    }

    private Documenttype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documenttypes.documenttype[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      version = (builder.version == null) ?
          new IntegerNode(0) : new IntegerNode(builder.version);
      headerstruct = (builder.headerstruct == null) ?
          new IntegerNode() : new IntegerNode(builder.headerstruct);
      bodystruct = (builder.bodystruct == null) ?
          new IntegerNode(0) : new IntegerNode(builder.bodystruct);
      inherits = Inherits.createVector(builder.inherits);
      datatype = Datatype.createVector(builder.datatype);
      annotationtype = Annotationtype.createVector(builder.annotationtype);
      fieldsets = Fieldsets.createMap(builder.fieldsets);
      referencetype = Referencetype.createVector(builder.referencetype);
      importedfield = Importedfield.createVector(builder.importedfield);
    }

    /**
     * @return documenttypes.documenttype[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return documenttypes.documenttype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documenttypes.documenttype[].version
     */
    public int version() {
      return version.value();
    }

    /**
     * @return documenttypes.documenttype[].headerstruct
     */
    public int headerstruct() {
      return headerstruct.value();
    }

    /**
     * @return documenttypes.documenttype[].bodystruct
     */
    public int bodystruct() {
      return bodystruct.value();
    }

    /**
     * @return documenttypes.documenttype[].inherits[]
     */
    public List<Inherits> inherits() {
      return inherits;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.documenttype[].inherits[]
     */
    public Inherits inherits(int i) {
      return inherits.get(i);
    }

    /**
     * @return documenttypes.documenttype[].datatype[]
     */
    public List<Datatype> datatype() {
      return datatype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.documenttype[].datatype[]
     */
    public Datatype datatype(int i) {
      return datatype.get(i);
    }

    /**
     * @return documenttypes.documenttype[].annotationtype[]
     */
    public List<Annotationtype> annotationtype() {
      return annotationtype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.documenttype[].annotationtype[]
     */
    public Annotationtype annotationtype(int i) {
      return annotationtype.get(i);
    }

    /**
     * @return documenttypes.documenttype[].fieldsets{}
     */
    public Map<String, Fieldsets> fieldsets() {
      return Collections.unmodifiableMap(fieldsets);
    }

    /**
     * @param key the key of the value to return
     * @return documenttypes.documenttype[].fieldsets{}
     */
    public Fieldsets fieldsets(String key) {
      return fieldsets.get(key);
    }

    /**
     * @return documenttypes.documenttype[].referencetype[]
     */
    public List<Referencetype> referencetype() {
      return referencetype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.documenttype[].referencetype[]
     */
    public Referencetype referencetype(int i) {
      return referencetype.get(i);
    }

    /**
     * @return documenttypes.documenttype[].importedfield[]
     */
    public List<Importedfield> importedfield() {
      return importedfield;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.documenttype[].importedfield[]
     */
    public Importedfield importedfield(int i) {
      return importedfield.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
      return changes;
    }

    private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
        List<Documenttype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Documenttype(b));
        }
        return new InnerNodeVector<Documenttype>(elems);
    }

    /**
     * This class represents documenttypes.documenttype[].inherits[]
     */
    public final static class Inherits extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id"
          ));

        private Integer id = null;

        public Builder() { }

        public Builder(Inherits config) {
          id(config.id());
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          return this;
        }

        public Builder id(int __value) {
          id = __value;
          __uninitialized.remove("id");
          return this;
        }

        private Builder id(String __value) {
          return id(Integer.valueOf(__value));
        }

        public Inherits build() {
          return new Inherits(this);
        }

      }

      // Specify a document type to inherit (id)
      private final IntegerNode id;

      public Inherits(Builder builder) {
        this(builder, true);
      }

      private Inherits(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].inherits[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new IntegerNode() : new IntegerNode(builder.id);
      }

      /**
       * @return documenttypes.documenttype[].inherits[].id
       */
      public int id() {
        return id.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
        return changes;
      }

      private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
          List<Inherits> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Inherits(b));
          }
          return new InnerNodeVector<Inherits>(elems);
      }
    }

    /**
     * This class represents documenttypes.documenttype[].datatype[]
     */
    public final static class Datatype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id",
          "type"
          ));

        private Integer id = null;
        private Type.Enum type = null;
        public Array.Builder array = new Array.Builder();
        public Map.Builder map = new Map.Builder();
        public Wset.Builder wset = new Wset.Builder();
        public Annotationref.Builder annotationref = new Annotationref.Builder();
        public Sstruct.Builder sstruct = new Sstruct.Builder();

        public Builder() { }

        public Builder(Datatype config) {
          id(config.id());
          type(config.type());
          array(new Array.Builder(config.array()));
          map(new Map.Builder(config.map()));
          wset(new Wset.Builder(config.wset()));
          annotationref(new Annotationref.Builder(config.annotationref()));
          sstruct(new Sstruct.Builder(config.sstruct()));
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          if (__superior.type != null)
            type(__superior.type);
          array(array.override(__superior.array));
          map(map.override(__superior.map));
          wset(wset.override(__superior.wset));
          annotationref(annotationref.override(__superior.annotationref));
          sstruct(sstruct.override(__superior.sstruct));
          return this;
        }

        public Builder id(int __value) {
          id = __value;
          __uninitialized.remove("id");
          return this;
        }

        private Builder id(String __value) {
          return id(Integer.valueOf(__value));
        }

        public Builder type(Type.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          type = __value;
          __uninitialized.remove("type");
          return this;
        }

        private Builder type(String __value) {
          return type(Type.Enum.valueOf(__value));
        }

        public Builder array(Array.Builder __builder) {
          array = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder array(java.util.function.Consumer<Array.Builder> __func) {
          Array.Builder __inner = new Array.Builder();
          __func.accept(__inner);
          array = __inner;
          return this;
        }

        public Builder map(Map.Builder __builder) {
          map = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder map(java.util.function.Consumer<Map.Builder> __func) {
          Map.Builder __inner = new Map.Builder();
          __func.accept(__inner);
          map = __inner;
          return this;
        }

        public Builder wset(Wset.Builder __builder) {
          wset = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder wset(java.util.function.Consumer<Wset.Builder> __func) {
          Wset.Builder __inner = new Wset.Builder();
          __func.accept(__inner);
          wset = __inner;
          return this;
        }

        public Builder annotationref(Annotationref.Builder __builder) {
          annotationref = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder annotationref(java.util.function.Consumer<Annotationref.Builder> __func) {
          Annotationref.Builder __inner = new Annotationref.Builder();
          __func.accept(__inner);
          annotationref = __inner;
          return this;
        }

        public Builder sstruct(Sstruct.Builder __builder) {
          sstruct = __builder;
          return this;
        }
        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder sstruct(java.util.function.Consumer<Sstruct.Builder> __func) {
          Sstruct.Builder __inner = new Sstruct.Builder();
          __func.accept(__inner);
          sstruct = __inner;
          return this;
        }

        public Datatype build() {
          return new Datatype(this);
        }

      }

      // This is the id of a datatype defined in the document.
      private final IntegerNode id;
      // This is the type of the datatype.
      private final Type type;
      private final Array array;
      private final Map map;
      private final Wset wset;
      private final Annotationref annotationref;
      private final Sstruct sstruct;

      public Datatype(Builder builder) {
        this(builder, true);
      }

      private Datatype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].datatype[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new IntegerNode() : new IntegerNode(builder.id);
        type = (builder.type == null) ?
            new Type() : new Type(builder.type);
        array = new Array(builder.array, throwIfUninitialized);
        map = new Map(builder.map, throwIfUninitialized);
        wset = new Wset(builder.wset, throwIfUninitialized);
        annotationref = new Annotationref(builder.annotationref, throwIfUninitialized);
        sstruct = new Sstruct(builder.sstruct, throwIfUninitialized);
      }

      /**
       * @return documenttypes.documenttype[].datatype[].id
       */
      public int id() {
        return id.value();
      }

      /**
       * @return documenttypes.documenttype[].datatype[].type
       */
      public Type.Enum type() {
        return type.value();
      }

      /**
       * @return documenttypes.documenttype[].datatype[].array
       */
      public Array array() {
        return array;
      }

      /**
       * @return documenttypes.documenttype[].datatype[].map
       */
      public Map map() {
        return map;
      }

      /**
       * @return documenttypes.documenttype[].datatype[].wset
       */
      public Wset wset() {
        return wset;
      }

      /**
       * @return documenttypes.documenttype[].datatype[].annotationref
       */
      public Annotationref annotationref() {
        return annotationref;
      }

      /**
       * @return documenttypes.documenttype[].datatype[].sstruct
       */
      public Sstruct sstruct() {
        return sstruct;
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Datatype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("datatype");
        return changes;
      }

      private static InnerNodeVector<Datatype> createVector(List<Builder> builders) {
          List<Datatype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Datatype(b));
          }
          return new InnerNodeVector<Datatype>(elems);
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].type
       * 
       * This is the type of the datatype.
       */
      public final static class Type extends EnumNode<Type.Enum> {

        public Type(){
          this.value = null;
        }

        public Type(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {STRUCT, ARRAY, WSET, MAP, ANNOTATIONREF, PRIMITIVE, TENSOR}
        public final static Enum STRUCT = Enum.STRUCT;
        public final static Enum ARRAY = Enum.ARRAY;
        public final static Enum WSET = Enum.WSET;
        public final static Enum MAP = Enum.MAP;
        public final static Enum ANNOTATIONREF = Enum.ANNOTATIONREF;
        public final static Enum PRIMITIVE = Enum.PRIMITIVE;
        public final static Enum TENSOR = Enum.TENSOR;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].array
       */
      public final static class Array extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Element.Builder element = new Element.Builder();

          public Builder() { }

          public Builder(Array config) {
            element(new Element.Builder(config.element()));
          }

          private Builder override(Builder __superior) {
            element(element.override(__superior.element));
            return this;
          }

          public Builder element(Element.Builder __builder) {
            element = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder element(java.util.function.Consumer<Element.Builder> __func) {
            Element.Builder __inner = new Element.Builder();
            __func.accept(__inner);
            element = __inner;
            return this;
          }

          public Array build() {
            return new Array(this);
          }

        }

        private final Element element;

        public Array(Builder builder) {
          this(builder, true);
        }

        private Array(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].datatype[].array must be initialized: " + builder.__uninitialized);

          element = new Element(builder.element, throwIfUninitialized);
        }

        /**
         * @return documenttypes.documenttype[].datatype[].array.element
         */
        public Element element() {
          return element;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Array newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("array");
          return changes;
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].array.element
         */
        public final static class Element extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Integer id = null;

            public Builder() { }

            public Builder(Element config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Element build() {
              return new Element(this);
            }

          }

          // This is the id of the datatype of the element in the array.
          private final IntegerNode id;

          public Element(Builder builder) {
            this(builder, true);
          }

          private Element(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].array.element must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode(0) : new IntegerNode(builder.id);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].array.element.id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Element newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("element");
            return changes;
          }
        }
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].map
       */
      public final static class Map extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Key.Builder key = new Key.Builder();
          public Value.Builder value = new Value.Builder();

          public Builder() { }

          public Builder(Map config) {
            key(new Key.Builder(config.key()));
            value(new Value.Builder(config.value()));
          }

          private Builder override(Builder __superior) {
            key(key.override(__superior.key));
            value(value.override(__superior.value));
            return this;
          }

          public Builder key(Key.Builder __builder) {
            key = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder key(java.util.function.Consumer<Key.Builder> __func) {
            Key.Builder __inner = new Key.Builder();
            __func.accept(__inner);
            key = __inner;
            return this;
          }

          public Builder value(Value.Builder __builder) {
            value = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder value(java.util.function.Consumer<Value.Builder> __func) {
            Value.Builder __inner = new Value.Builder();
            __func.accept(__inner);
            value = __inner;
            return this;
          }

          public Map build() {
            return new Map(this);
          }

        }

        private final Key key;
        private final Value value;

        public Map(Builder builder) {
          this(builder, true);
        }

        private Map(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].datatype[].map must be initialized: " + builder.__uninitialized);

          key = new Key(builder.key, throwIfUninitialized);
          value = new Value(builder.value, throwIfUninitialized);
        }

        /**
         * @return documenttypes.documenttype[].datatype[].map.key
         */
        public Key key() {
          return key;
        }

        /**
         * @return documenttypes.documenttype[].datatype[].map.value
         */
        public Value value() {
          return value;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Map newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("map");
          return changes;
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].map.key
         */
        public final static class Key extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Integer id = null;

            public Builder() { }

            public Builder(Key config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Key build() {
              return new Key(this);
            }

          }

          // This is the id of the datatype of the key in the map.
          private final IntegerNode id;

          public Key(Builder builder) {
            this(builder, true);
          }

          private Key(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].map.key must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode(0) : new IntegerNode(builder.id);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].map.key.id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Key newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("key");
            return changes;
          }
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].map.value
         */
        public final static class Value extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Integer id = null;

            public Builder() { }

            public Builder(Value config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Value build() {
              return new Value(this);
            }

          }

          // This is the id of the datatype of the value in the map.
          private final IntegerNode id;

          public Value(Builder builder) {
            this(builder, true);
          }

          private Value(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].map.value must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode(0) : new IntegerNode(builder.id);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].map.value.id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Value newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("value");
            return changes;
          }
        }
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].wset
       */
      public final static class Wset extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Key.Builder key = new Key.Builder();
          private Boolean createifnonexistent = null;
          private Boolean removeifzero = null;

          public Builder() { }

          public Builder(Wset config) {
            key(new Key.Builder(config.key()));
            createifnonexistent(config.createifnonexistent());
            removeifzero(config.removeifzero());
          }

          private Builder override(Builder __superior) {
            key(key.override(__superior.key));
            if (__superior.createifnonexistent != null)
              createifnonexistent(__superior.createifnonexistent);
            if (__superior.removeifzero != null)
              removeifzero(__superior.removeifzero);
            return this;
          }

          public Builder key(Key.Builder __builder) {
            key = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder key(java.util.function.Consumer<Key.Builder> __func) {
            Key.Builder __inner = new Key.Builder();
            __func.accept(__inner);
            key = __inner;
            return this;
          }

          public Builder createifnonexistent(boolean __value) {
            createifnonexistent = __value;
            return this;
          }

          private Builder createifnonexistent(String __value) {
            return createifnonexistent(Boolean.valueOf(__value));
          }

          public Builder removeifzero(boolean __value) {
            removeifzero = __value;
            return this;
          }

          private Builder removeifzero(String __value) {
            return removeifzero(Boolean.valueOf(__value));
          }

          public Wset build() {
            return new Wset(this);
          }

        }

        private final Key key;
        // Should an update to a nonexistent element cause it to be created
        private final BooleanNode createifnonexistent;
        // Should an element in a weighted set be removed if an update changes the weight to 0
        private final BooleanNode removeifzero;

        public Wset(Builder builder) {
          this(builder, true);
        }

        private Wset(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].datatype[].wset must be initialized: " + builder.__uninitialized);

          key = new Key(builder.key, throwIfUninitialized);
          createifnonexistent = (builder.createifnonexistent == null) ?
              new BooleanNode(false) : new BooleanNode(builder.createifnonexistent);
          removeifzero = (builder.removeifzero == null) ?
              new BooleanNode(false) : new BooleanNode(builder.removeifzero);
        }

        /**
         * @return documenttypes.documenttype[].datatype[].wset.key
         */
        public Key key() {
          return key;
        }

        /**
         * @return documenttypes.documenttype[].datatype[].wset.createifnonexistent
         */
        public boolean createifnonexistent() {
          return createifnonexistent.value();
        }

        /**
         * @return documenttypes.documenttype[].datatype[].wset.removeifzero
         */
        public boolean removeifzero() {
          return removeifzero.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Wset newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("wset");
          return changes;
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].wset.key
         */
        public final static class Key extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Integer id = null;

            public Builder() { }

            public Builder(Key config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Key build() {
              return new Key(this);
            }

          }

          // This is the id of the datatype of the key in the wset.
          private final IntegerNode id;

          public Key(Builder builder) {
            this(builder, true);
          }

          private Key(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].wset.key must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode(0) : new IntegerNode(builder.id);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].wset.key.id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Key newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("key");
            return changes;
          }
        }
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].annotationref
       */
      public final static class Annotationref extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public Annotation.Builder annotation = new Annotation.Builder();

          public Builder() { }

          public Builder(Annotationref config) {
            annotation(new Annotation.Builder(config.annotation()));
          }

          private Builder override(Builder __superior) {
            annotation(annotation.override(__superior.annotation));
            return this;
          }

          public Builder annotation(Annotation.Builder __builder) {
            annotation = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder annotation(java.util.function.Consumer<Annotation.Builder> __func) {
            Annotation.Builder __inner = new Annotation.Builder();
            __func.accept(__inner);
            annotation = __inner;
            return this;
          }

          public Annotationref build() {
            return new Annotationref(this);
          }

        }

        private final Annotation annotation;

        public Annotationref(Builder builder) {
          this(builder, true);
        }

        private Annotationref(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].datatype[].annotationref must be initialized: " + builder.__uninitialized);

          annotation = new Annotation(builder.annotation, throwIfUninitialized);
        }

        /**
         * @return documenttypes.documenttype[].datatype[].annotationref.annotation
         */
        public Annotation annotation() {
          return annotation;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Annotationref newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationref");
          return changes;
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].annotationref.annotation
         */
        public final static class Annotation extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Integer id = null;

            public Builder() { }

            public Builder(Annotation config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Annotation build() {
              return new Annotation(this);
            }

          }

          // This is the id of the referenced annotation.
          private final IntegerNode id;

          public Annotation(Builder builder) {
            this(builder, true);
          }

          private Annotation(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].annotationref.annotation must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode(0) : new IntegerNode(builder.id);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].annotationref.annotation.id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Annotation newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("annotation");
            return changes;
          }
        }
      }

      /**
       * This class represents documenttypes.documenttype[].datatype[].sstruct
       */
      public final static class Sstruct extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          private String name = null;
          private Integer version = null;
          public Compression.Builder compression = new Compression.Builder();
          public List<Field.Builder> field = new ArrayList<>();

          public Builder() { }

          public Builder(Sstruct config) {
            name(config.name());
            version(config.version());
            compression(new Compression.Builder(config.compression()));
            for (Field f : config.field()) {
              field(new Field.Builder(f));
            }
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.version != null)
              version(__superior.version);
            compression(compression.override(__superior.compression));
            if (!__superior.field.isEmpty())
              field.addAll(__superior.field);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            return this;
          }


          public Builder version(int __value) {
            version = __value;
            return this;
          }

          private Builder version(String __value) {
            return version(Integer.valueOf(__value));
          }

          public Builder compression(Compression.Builder __builder) {
            compression = __builder;
            return this;
          }
          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder compression(java.util.function.Consumer<Compression.Builder> __func) {
            Compression.Builder __inner = new Compression.Builder();
            __func.accept(__inner);
            compression = __inner;
            return this;
          }

          /**
           * Add the given builder to this builder's list of Field builders
           * @param __builder a builder
           * @return this builder
           */
          public Builder field(Field.Builder __builder) {
            field.add(__builder);
            return this;
          }

          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder field(java.util.function.Consumer<Field.Builder> __func) {
            Field.Builder __inner = new Field.Builder();
            __func.accept(__inner);
            field.add(__inner);
            return this;
          }

          /**
           * Set the given list as this builder's list of Field builders
           * @param __builders a list of builders
           * @return this builder
           */
          public Builder field(List<Field.Builder> __builders) {
            field = __builders;
            return this;
          }

          public Sstruct build() {
            return new Sstruct(this);
          }

        }

        // Specify the name of the struct type. Must be unique within documenttype.
        private final StringNode name;
        // Version is not used
        private final IntegerNode version;
        private final Compression compression;
        private final InnerNodeVector<Field> field;

        public Sstruct(Builder builder) {
          this(builder, true);
        }

        private Sstruct(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].datatype[].sstruct must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode("") : new StringNode(builder.name);
          version = (builder.version == null) ?
              new IntegerNode(0) : new IntegerNode(builder.version);
          compression = new Compression(builder.compression, throwIfUninitialized);
          field = Field.createVector(builder.field);
        }

        /**
         * @return documenttypes.documenttype[].datatype[].sstruct.name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documenttypes.documenttype[].datatype[].sstruct.version
         */
        public int version() {
          return version.value();
        }

        /**
         * @return documenttypes.documenttype[].datatype[].sstruct.compression
         */
        public Compression compression() {
          return compression;
        }

        /**
         * @return documenttypes.documenttype[].datatype[].sstruct.field[]
         */
        public List<Field> field() {
          return field;
        }

        /**
         * @param i the index of the value to return
         * @return documenttypes.documenttype[].datatype[].sstruct.field[]
         */
        public Field field(int i) {
          return field.get(i);
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Sstruct newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("sstruct");
          return changes;
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].sstruct.compression
         */
        public final static class Compression extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();

            private Type.Enum type = null;
            private Integer level = null;
            private Integer threshold = null;
            private Integer minsize = null;

            public Builder() { }

            public Builder(Compression config) {
              type(config.type());
              level(config.level());
              threshold(config.threshold());
              minsize(config.minsize());
            }

            private Builder override(Builder __superior) {
              if (__superior.type != null)
                type(__superior.type);
              if (__superior.level != null)
                level(__superior.level);
              if (__superior.threshold != null)
                threshold(__superior.threshold);
              if (__superior.minsize != null)
                minsize(__superior.minsize);
              return this;
            }

            public Builder type(Type.Enum __value) {
            if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
              type = __value;
              return this;
            }

            private Builder type(String __value) {
              return type(Type.Enum.valueOf(__value));
            }

            public Builder level(int __value) {
              level = __value;
              return this;
            }

            private Builder level(String __value) {
              return level(Integer.valueOf(__value));
            }

            public Builder threshold(int __value) {
              threshold = __value;
              return this;
            }

            private Builder threshold(String __value) {
              return threshold(Integer.valueOf(__value));
            }

            public Builder minsize(int __value) {
              minsize = __value;
              return this;
            }

            private Builder minsize(String __value) {
              return minsize(Integer.valueOf(__value));
            }

            public Compression build() {
              return new Compression(this);
            }

          }

          // Specify which compression to use if compression is enabled above (0 = NONE, 6 = LZ4)
          private final Type type;
          // Specify the compression level to use if compression is enabled
          private final IntegerNode level;
          // Specify the minimum reduction required from compression in order to keep the compressed version (maximum percentage of original size)
          private final IntegerNode threshold;
          // Specify the minimum size before trying compression.
          private final IntegerNode minsize;

          public Compression(Builder builder) {
            this(builder, true);
          }

          private Compression(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].sstruct.compression must be initialized: " + builder.__uninitialized);

            type = (builder.type == null) ?
                new Type(Type.NONE) : new Type(builder.type);
            level = (builder.level == null) ?
                new IntegerNode(0) : new IntegerNode(builder.level);
            threshold = (builder.threshold == null) ?
                new IntegerNode(95) : new IntegerNode(builder.threshold);
            minsize = (builder.minsize == null) ?
                new IntegerNode(200) : new IntegerNode(builder.minsize);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.compression.type
           */
          public Type.Enum type() {
            return type.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.compression.level
           */
          public int level() {
            return level.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.compression.threshold
           */
          public int threshold() {
            return threshold.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.compression.minsize
           */
          public int minsize() {
            return minsize.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
            return changes;
          }

          /**
           * This class represents documenttypes.documenttype[].datatype[].sstruct.compression.type
           * 
           * Specify which compression to use if compression is enabled above (0 = NONE, 6 = LZ4)
           */
          public final static class Type extends EnumNode<Type.Enum> {

            public Type(){
              this.value = null;
            }

            public Type(Enum enumValue) {
              super(enumValue != null);
              this.value = enumValue;
            }

            public enum Enum {NONE, LZ4}
            public final static Enum NONE = Enum.NONE;
            public final static Enum LZ4 = Enum.LZ4;

            @Override
            protected boolean doSetValue(String name) {
              try {
                value = Enum.valueOf(name);
                return true;
              } catch (IllegalArgumentException e) {
              }
              return false;
            }
          }
        }

        /**
         * This class represents documenttypes.documenttype[].datatype[].sstruct.field[]
         */
        public final static class Field extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of(
              "name",
              "id",
              "datatype"
              ));

            private String name = null;
            private Integer id = null;
            private Integer datatype = null;
            private String detailedtype = null;

            public Builder() { }

            public Builder(Field config) {
              name(config.name());
              id(config.id());
              datatype(config.datatype());
              detailedtype(config.detailedtype());
            }

            private Builder override(Builder __superior) {
              if (__superior.name != null)
                name(__superior.name);
              if (__superior.id != null)
                id(__superior.id);
              if (__superior.datatype != null)
                datatype(__superior.datatype);
              if (__superior.detailedtype != null)
                detailedtype(__superior.detailedtype);
              return this;
            }

            public Builder name(String __value) {
            if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
              name = __value;
              __uninitialized.remove("name");
              return this;
            }


            public Builder id(int __value) {
              id = __value;
              __uninitialized.remove("id");
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Builder datatype(int __value) {
              datatype = __value;
              __uninitialized.remove("datatype");
              return this;
            }

            private Builder datatype(String __value) {
              return datatype(Integer.valueOf(__value));
            }

            public Builder detailedtype(String __value) {
            if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
              detailedtype = __value;
              return this;
            }


            public Field build() {
              return new Field(this);
            }

          }

          // Specify a struct field name. Must be unique within the struct type.
          private final StringNode name;
          // Specify a document field id. If not specified, this is generated by a hash function
          private final IntegerNode id;
          // Specify the datatype of the field. Can only be a type defined in document
          // or one of its inherited document types.
          private final IntegerNode datatype;
          // Additional, optional type information which can be changed without
          // (necessarily) causing field incompatibility
          private final StringNode detailedtype;

          public Field(Builder builder) {
            this(builder, true);
          }

          private Field(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documenttypes.documenttype[].datatype[].sstruct.field[] must be initialized: " + builder.__uninitialized);

            name = (builder.name == null) ?
                new StringNode() : new StringNode(builder.name);
            id = (builder.id == null) ?
                new IntegerNode() : new IntegerNode(builder.id);
            datatype = (builder.datatype == null) ?
                new IntegerNode() : new IntegerNode(builder.datatype);
            detailedtype = (builder.detailedtype == null) ?
                new StringNode("") : new StringNode(builder.detailedtype);
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.field[].name
           */
          public String name() {
            return name.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.field[].id
           */
          public int id() {
            return id.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.field[].datatype
           */
          public int datatype() {
            return datatype.value();
          }

          /**
           * @return documenttypes.documenttype[].datatype[].sstruct.field[].detailedtype
           */
          public String detailedtype() {
            return detailedtype.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
            return changes;
          }

          private static InnerNodeVector<Field> createVector(List<Builder> builders) {
              List<Field> elems = new ArrayList<>();
              for (Builder b : builders) {
                  elems.add(new Field(b));
              }
              return new InnerNodeVector<Field>(elems);
          }
        }
      }
    }

    /**
     * This class represents documenttypes.documenttype[].annotationtype[]
     */
    public final static class Annotationtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id",
          "name"
          ));

        private Integer id = null;
        private String name = null;
        private Integer datatype = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();

        public Builder() { }

        public Builder(Annotationtype config) {
          id(config.id());
          name(config.name());
          datatype(config.datatype());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.datatype != null)
            datatype(__superior.datatype);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          return this;
        }

        public Builder id(int __value) {
          id = __value;
          __uninitialized.remove("id");
          return this;
        }

        private Builder id(String __value) {
          return id(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder datatype(int __value) {
          datatype = __value;
          return this;
        }

        private Builder datatype(String __value) {
          return datatype(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        public Annotationtype build() {
          return new Annotationtype(this);
        }

      }

      // The id of the annotation type.
      private final IntegerNode id;
      // The name of the annotation type.
      private final StringNode name;
      // The contained datatype of the annotation type.
      private final IntegerNode datatype;
      private final InnerNodeVector<Inherits> inherits;

      public Annotationtype(Builder builder) {
        this(builder, true);
      }

      private Annotationtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].annotationtype[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new IntegerNode() : new IntegerNode(builder.id);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        datatype = (builder.datatype == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.datatype);
        inherits = Inherits.createVector(builder.inherits);
      }

      /**
       * @return documenttypes.documenttype[].annotationtype[].id
       */
      public int id() {
        return id.value();
      }

      /**
       * @return documenttypes.documenttype[].annotationtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documenttypes.documenttype[].annotationtype[].datatype
       */
      public int datatype() {
        return datatype.value();
      }

      /**
       * @return documenttypes.documenttype[].annotationtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.documenttype[].annotationtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
        return changes;
      }

      private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
          List<Annotationtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationtype(b));
          }
          return new InnerNodeVector<Annotationtype>(elems);
      }

      /**
       * This class represents documenttypes.documenttype[].annotationtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "id"
            ));

          private Integer id = null;

          public Builder() { }

          public Builder(Inherits config) {
            id(config.id());
          }

          private Builder override(Builder __superior) {
            if (__superior.id != null)
              id(__superior.id);
            return this;
          }

          public Builder id(int __value) {
            id = __value;
            __uninitialized.remove("id");
            return this;
          }

          private Builder id(String __value) {
            return id(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // The annotation type that this type inherits. (0 or 1 type)
        private final IntegerNode id;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.documenttype[].annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);

          id = (builder.id == null) ?
              new IntegerNode() : new IntegerNode(builder.id);
        }

        /**
         * @return documenttypes.documenttype[].annotationtype[].inherits[].id
         */
        public int id() {
          return id.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }
    }

    /**
     * This class represents documenttypes.documenttype[].fieldsets{}
     */
    public final static class Fieldsets extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<String> fields = new ArrayList<>();

        public Builder() { }

        public Builder(Fieldsets config) {
          fields(config.fields());
        }

        private Builder override(Builder __superior) {
          if (!__superior.fields.isEmpty())
            fields.addAll(__superior.fields);
          return this;
        }

        public Builder fields(String __value) {
          fields.add(__value);
          return this;
        }

        public Builder fields(Collection<String> __values) {
          fields.addAll(__values);
          return this;
        }

        public Fieldsets build() {
          return new Fieldsets(this);
        }

      }

      // Field sets
      private final LeafNodeVector<String, StringNode> fields;

      public Fieldsets(Builder builder) {
        this(builder, true);
      }

      private Fieldsets(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].fieldsets{} must be initialized: " + builder.__uninitialized);

        fields = new LeafNodeVector<>(builder.fields, new StringNode());
      }

      /**
       * @return documenttypes.documenttype[].fieldsets{}.fields[]
       */
      public List<String> fields() {
        return fields.asList();
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.documenttype[].fieldsets{}.fields[]
       */
      public String fields(int i) {
        return fields.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
        return changes;
      }

      private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
        Map<String, Fieldsets> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new Fieldsets(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }
    }

    /**
     * This class represents documenttypes.documenttype[].referencetype[]
     */
    public final static class Referencetype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id",
          "target_type_id"
          ));

        private Integer id = null;
        private Integer target_type_id = null;

        public Builder() { }

        public Builder(Referencetype config) {
          id(config.id());
          target_type_id(config.target_type_id());
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          if (__superior.target_type_id != null)
            target_type_id(__superior.target_type_id);
          return this;
        }

        public Builder id(int __value) {
          id = __value;
          __uninitialized.remove("id");
          return this;
        }

        private Builder id(String __value) {
          return id(Integer.valueOf(__value));
        }

        public Builder target_type_id(int __value) {
          target_type_id = __value;
          __uninitialized.remove("target_type_id");
          return this;
        }

        private Builder target_type_id(String __value) {
          return target_type_id(Integer.valueOf(__value));
        }

        public Referencetype build() {
          return new Referencetype(this);
        }

      }

      // ID of reference type. This is a regular data type, but is kept in its own
      // array to avoid polluting the existing datatype array with a new default
      // field value.
      private final IntegerNode id;
      // Numeric ID of the document type instances of the reference point to.
      private final IntegerNode target_type_id;

      public Referencetype(Builder builder) {
        this(builder, true);
      }

      private Referencetype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].referencetype[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new IntegerNode() : new IntegerNode(builder.id);
        target_type_id = (builder.target_type_id == null) ?
            new IntegerNode() : new IntegerNode(builder.target_type_id);
      }

      /**
       * @return documenttypes.documenttype[].referencetype[].id
       */
      public int id() {
        return id.value();
      }

      /**
       * @return documenttypes.documenttype[].referencetype[].target_type_id
       */
      public int target_type_id() {
        return target_type_id.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Referencetype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("referencetype");
        return changes;
      }

      private static InnerNodeVector<Referencetype> createVector(List<Builder> builders) {
          List<Referencetype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Referencetype(b));
          }
          return new InnerNodeVector<Referencetype>(elems);
      }
    }

    /**
     * This class represents documenttypes.documenttype[].importedfield[]
     */
    public final static class Importedfield extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;

        public Builder() { }

        public Builder(Importedfield config) {
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Importedfield build() {
          return new Importedfield(this);
        }

      }

      // Imported fields (specified outside the document block in the schema)
      private final StringNode name;

      public Importedfield(Builder builder) {
        this(builder, true);
      }

      private Importedfield(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.documenttype[].importedfield[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return documenttypes.documenttype[].importedfield[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
        return changes;
      }

      private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
          List<Importedfield> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Importedfield(b));
          }
          return new InnerNodeVector<Importedfield>(elems);
      }
    }
  }

  /**
   * This class represents documenttypes.doctype[]
   */
  public final static class Doctype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "idx",
        "internalid",
        "contentstruct"
        ));

      private String name = null;
      private Integer idx = null;
      private Integer internalid = null;
      public List<Inherits.Builder> inherits = new ArrayList<>();
      private Integer contentstruct = null;
      public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<>();
      public List<Importedfield.Builder> importedfield = new ArrayList<>();
      public List<Primitivetype.Builder> primitivetype = new ArrayList<>();
      public List<Arraytype.Builder> arraytype = new ArrayList<>();
      public List<Maptype.Builder> maptype = new ArrayList<>();
      public List<Wsettype.Builder> wsettype = new ArrayList<>();
      public List<Tensortype.Builder> tensortype = new ArrayList<>();
      public List<Documentref.Builder> documentref = new ArrayList<>();
      public List<Annotationtype.Builder> annotationtype = new ArrayList<>();
      public List<Annotationref.Builder> annotationref = new ArrayList<>();
      public List<Structtype.Builder> structtype = new ArrayList<>();

      public Builder() { }

      public Builder(Doctype config) {
        name(config.name());
        idx(config.idx());
        internalid(config.internalid());
        for (Inherits i : config.inherits()) {
          inherits(new Inherits.Builder(i));
        }
        contentstruct(config.contentstruct());
        for (Map.Entry<String, Fieldsets> __entry : config.fieldsets().entrySet()) {
          fieldsets(__entry.getKey(), new Fieldsets.Builder(__entry.getValue()));
        }
        for (Importedfield i : config.importedfield()) {
          importedfield(new Importedfield.Builder(i));
        }
        for (Primitivetype p : config.primitivetype()) {
          primitivetype(new Primitivetype.Builder(p));
        }
        for (Arraytype a : config.arraytype()) {
          arraytype(new Arraytype.Builder(a));
        }
        for (Maptype m : config.maptype()) {
          maptype(new Maptype.Builder(m));
        }
        for (Wsettype w : config.wsettype()) {
          wsettype(new Wsettype.Builder(w));
        }
        for (Tensortype t : config.tensortype()) {
          tensortype(new Tensortype.Builder(t));
        }
        for (Documentref d : config.documentref()) {
          documentref(new Documentref.Builder(d));
        }
        for (Annotationtype a : config.annotationtype()) {
          annotationtype(new Annotationtype.Builder(a));
        }
        for (Annotationref a : config.annotationref()) {
          annotationref(new Annotationref.Builder(a));
        }
        for (Structtype s : config.structtype()) {
          structtype(new Structtype.Builder(s));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.idx != null)
          idx(__superior.idx);
        if (__superior.internalid != null)
          internalid(__superior.internalid);
        if (!__superior.inherits.isEmpty())
          inherits.addAll(__superior.inherits);
        if (__superior.contentstruct != null)
          contentstruct(__superior.contentstruct);
        fieldsets(__superior.fieldsets);
        if (!__superior.importedfield.isEmpty())
          importedfield.addAll(__superior.importedfield);
        if (!__superior.primitivetype.isEmpty())
          primitivetype.addAll(__superior.primitivetype);
        if (!__superior.arraytype.isEmpty())
          arraytype.addAll(__superior.arraytype);
        if (!__superior.maptype.isEmpty())
          maptype.addAll(__superior.maptype);
        if (!__superior.wsettype.isEmpty())
          wsettype.addAll(__superior.wsettype);
        if (!__superior.tensortype.isEmpty())
          tensortype.addAll(__superior.tensortype);
        if (!__superior.documentref.isEmpty())
          documentref.addAll(__superior.documentref);
        if (!__superior.annotationtype.isEmpty())
          annotationtype.addAll(__superior.annotationtype);
        if (!__superior.annotationref.isEmpty())
          annotationref.addAll(__superior.annotationref);
        if (!__superior.structtype.isEmpty())
          structtype.addAll(__superior.structtype);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder idx(int __value) {
        idx = __value;
        __uninitialized.remove("idx");
        return this;
      }

      private Builder idx(String __value) {
        return idx(Integer.valueOf(__value));
      }

      public Builder internalid(int __value) {
        internalid = __value;
        __uninitialized.remove("internalid");
        return this;
      }

      private Builder internalid(String __value) {
        return internalid(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Inherits builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder inherits(Inherits.Builder __builder) {
        inherits.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
        Inherits.Builder __inner = new Inherits.Builder();
        __func.accept(__inner);
        inherits.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Inherits builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder inherits(List<Inherits.Builder> __builders) {
        inherits = __builders;
        return this;
      }

      public Builder contentstruct(int __value) {
        contentstruct = __value;
        __uninitialized.remove("contentstruct");
        return this;
      }

      private Builder contentstruct(String __value) {
        return contentstruct(Integer.valueOf(__value));
      }

      public Builder fieldsets(String __key, Fieldsets.Builder __value) {
        fieldsets.put(__key, __value);
        return this;
      }

      public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
        fieldsets.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fieldsets(String __key, java.util.function.Consumer<Fieldsets.Builder> __func) {
        Fieldsets.Builder __inner = new Fieldsets.Builder();
        __func.accept(__inner);
        fieldsets.put(__key, __inner);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Importedfield builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder importedfield(Importedfield.Builder __builder) {
        importedfield.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder importedfield(java.util.function.Consumer<Importedfield.Builder> __func) {
        Importedfield.Builder __inner = new Importedfield.Builder();
        __func.accept(__inner);
        importedfield.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Importedfield builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder importedfield(List<Importedfield.Builder> __builders) {
        importedfield = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Primitivetype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder primitivetype(Primitivetype.Builder __builder) {
        primitivetype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder primitivetype(java.util.function.Consumer<Primitivetype.Builder> __func) {
        Primitivetype.Builder __inner = new Primitivetype.Builder();
        __func.accept(__inner);
        primitivetype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Primitivetype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder primitivetype(List<Primitivetype.Builder> __builders) {
        primitivetype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Arraytype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder arraytype(Arraytype.Builder __builder) {
        arraytype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder arraytype(java.util.function.Consumer<Arraytype.Builder> __func) {
        Arraytype.Builder __inner = new Arraytype.Builder();
        __func.accept(__inner);
        arraytype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Arraytype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder arraytype(List<Arraytype.Builder> __builders) {
        arraytype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Maptype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder maptype(Maptype.Builder __builder) {
        maptype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder maptype(java.util.function.Consumer<Maptype.Builder> __func) {
        Maptype.Builder __inner = new Maptype.Builder();
        __func.accept(__inner);
        maptype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Maptype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder maptype(List<Maptype.Builder> __builders) {
        maptype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Wsettype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder wsettype(Wsettype.Builder __builder) {
        wsettype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder wsettype(java.util.function.Consumer<Wsettype.Builder> __func) {
        Wsettype.Builder __inner = new Wsettype.Builder();
        __func.accept(__inner);
        wsettype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Wsettype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder wsettype(List<Wsettype.Builder> __builders) {
        wsettype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Tensortype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder tensortype(Tensortype.Builder __builder) {
        tensortype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tensortype(java.util.function.Consumer<Tensortype.Builder> __func) {
        Tensortype.Builder __inner = new Tensortype.Builder();
        __func.accept(__inner);
        tensortype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Tensortype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder tensortype(List<Tensortype.Builder> __builders) {
        tensortype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Documentref builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder documentref(Documentref.Builder __builder) {
        documentref.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder documentref(java.util.function.Consumer<Documentref.Builder> __func) {
        Documentref.Builder __inner = new Documentref.Builder();
        __func.accept(__inner);
        documentref.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Documentref builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder documentref(List<Documentref.Builder> __builders) {
        documentref = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationtype(Annotationtype.Builder __builder) {
        annotationtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationtype(java.util.function.Consumer<Annotationtype.Builder> __func) {
        Annotationtype.Builder __inner = new Annotationtype.Builder();
        __func.accept(__inner);
        annotationtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationtype(List<Annotationtype.Builder> __builders) {
        annotationtype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationref builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationref(Annotationref.Builder __builder) {
        annotationref.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationref(java.util.function.Consumer<Annotationref.Builder> __func) {
        Annotationref.Builder __inner = new Annotationref.Builder();
        __func.accept(__inner);
        annotationref.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationref builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationref(List<Annotationref.Builder> __builders) {
        annotationref = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Structtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder structtype(Structtype.Builder __builder) {
        structtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder structtype(java.util.function.Consumer<Structtype.Builder> __func) {
        Structtype.Builder __inner = new Structtype.Builder();
        __func.accept(__inner);
        structtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Structtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder structtype(List<Structtype.Builder> __builders) {
        structtype = __builders;
        return this;
      }

      public Doctype build() {
        return new Doctype(this);
      }

    }

    // Here starts a new model for how datatypes are configured, where
    // everything is per document-type, and each documenttype contains the
    // datatypes it defines.
    // Note: we will include the built-in "document" document
    // type that all other doctypes inherit from also, in order
    // to get all the primitive and built-in types declared
    // with an idx we can refer to.
    // Note: indexes are only meaningful as internal references in this
    // config; they will typically be sequential (1,2,3,...) in the order
    // that they are generated (but nothing should depend on that).
    // Name of the document type. Must be unique.
    private final StringNode name;
    // Index of this type (as a datatype which can be referred to).
    private final IntegerNode idx;
    // Internal ID of this datatype
    private final IntegerNode internalid;
    private final InnerNodeVector<Inherits> inherits;
    // Index of struct defining document fields
    private final IntegerNode contentstruct;
    private final Map<String, Fieldsets> fieldsets;
    private final InnerNodeVector<Importedfield> importedfield;
    private final InnerNodeVector<Primitivetype> primitivetype;
    private final InnerNodeVector<Arraytype> arraytype;
    private final InnerNodeVector<Maptype> maptype;
    private final InnerNodeVector<Wsettype> wsettype;
    private final InnerNodeVector<Tensortype> tensortype;
    private final InnerNodeVector<Documentref> documentref;
    private final InnerNodeVector<Annotationtype> annotationtype;
    private final InnerNodeVector<Annotationref> annotationref;
    private final InnerNodeVector<Structtype> structtype;

    public Doctype(Builder builder) {
      this(builder, true);
    }

    private Doctype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documenttypes.doctype[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      idx = (builder.idx == null) ?
          new IntegerNode() : new IntegerNode(builder.idx);
      internalid = (builder.internalid == null) ?
          new IntegerNode() : new IntegerNode(builder.internalid);
      inherits = Inherits.createVector(builder.inherits);
      contentstruct = (builder.contentstruct == null) ?
          new IntegerNode() : new IntegerNode(builder.contentstruct);
      fieldsets = Fieldsets.createMap(builder.fieldsets);
      importedfield = Importedfield.createVector(builder.importedfield);
      primitivetype = Primitivetype.createVector(builder.primitivetype);
      arraytype = Arraytype.createVector(builder.arraytype);
      maptype = Maptype.createVector(builder.maptype);
      wsettype = Wsettype.createVector(builder.wsettype);
      tensortype = Tensortype.createVector(builder.tensortype);
      documentref = Documentref.createVector(builder.documentref);
      annotationtype = Annotationtype.createVector(builder.annotationtype);
      annotationref = Annotationref.createVector(builder.annotationref);
      structtype = Structtype.createVector(builder.structtype);
    }

    /**
     * @return documenttypes.doctype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documenttypes.doctype[].idx
     */
    public int idx() {
      return idx.value();
    }

    /**
     * @return documenttypes.doctype[].internalid
     */
    public int internalid() {
      return internalid.value();
    }

    /**
     * @return documenttypes.doctype[].inherits[]
     */
    public List<Inherits> inherits() {
      return inherits;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].inherits[]
     */
    public Inherits inherits(int i) {
      return inherits.get(i);
    }

    /**
     * @return documenttypes.doctype[].contentstruct
     */
    public int contentstruct() {
      return contentstruct.value();
    }

    /**
     * @return documenttypes.doctype[].fieldsets{}
     */
    public Map<String, Fieldsets> fieldsets() {
      return Collections.unmodifiableMap(fieldsets);
    }

    /**
     * @param key the key of the value to return
     * @return documenttypes.doctype[].fieldsets{}
     */
    public Fieldsets fieldsets(String key) {
      return fieldsets.get(key);
    }

    /**
     * @return documenttypes.doctype[].importedfield[]
     */
    public List<Importedfield> importedfield() {
      return importedfield;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].importedfield[]
     */
    public Importedfield importedfield(int i) {
      return importedfield.get(i);
    }

    /**
     * @return documenttypes.doctype[].primitivetype[]
     */
    public List<Primitivetype> primitivetype() {
      return primitivetype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].primitivetype[]
     */
    public Primitivetype primitivetype(int i) {
      return primitivetype.get(i);
    }

    /**
     * @return documenttypes.doctype[].arraytype[]
     */
    public List<Arraytype> arraytype() {
      return arraytype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].arraytype[]
     */
    public Arraytype arraytype(int i) {
      return arraytype.get(i);
    }

    /**
     * @return documenttypes.doctype[].maptype[]
     */
    public List<Maptype> maptype() {
      return maptype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].maptype[]
     */
    public Maptype maptype(int i) {
      return maptype.get(i);
    }

    /**
     * @return documenttypes.doctype[].wsettype[]
     */
    public List<Wsettype> wsettype() {
      return wsettype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].wsettype[]
     */
    public Wsettype wsettype(int i) {
      return wsettype.get(i);
    }

    /**
     * @return documenttypes.doctype[].tensortype[]
     */
    public List<Tensortype> tensortype() {
      return tensortype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].tensortype[]
     */
    public Tensortype tensortype(int i) {
      return tensortype.get(i);
    }

    /**
     * @return documenttypes.doctype[].documentref[]
     */
    public List<Documentref> documentref() {
      return documentref;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].documentref[]
     */
    public Documentref documentref(int i) {
      return documentref.get(i);
    }

    /**
     * @return documenttypes.doctype[].annotationtype[]
     */
    public List<Annotationtype> annotationtype() {
      return annotationtype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].annotationtype[]
     */
    public Annotationtype annotationtype(int i) {
      return annotationtype.get(i);
    }

    /**
     * @return documenttypes.doctype[].annotationref[]
     */
    public List<Annotationref> annotationref() {
      return annotationref;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].annotationref[]
     */
    public Annotationref annotationref(int i) {
      return annotationref.get(i);
    }

    /**
     * @return documenttypes.doctype[].structtype[]
     */
    public List<Structtype> structtype() {
      return structtype;
    }

    /**
     * @param i the index of the value to return
     * @return documenttypes.doctype[].structtype[]
     */
    public Structtype structtype(int i) {
      return structtype.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Doctype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("doctype");
      return changes;
    }

    private static InnerNodeVector<Doctype> createVector(List<Builder> builders) {
        List<Doctype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Doctype(b));
        }
        return new InnerNodeVector<Doctype>(elems);
    }

    /**
     * This class represents documenttypes.doctype[].inherits[]
     */
    public final static class Inherits extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx"
          ));

        private Integer idx = null;

        public Builder() { }

        public Builder(Inherits config) {
          idx(config.idx());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Inherits build() {
          return new Inherits(this);
        }

      }

      // Specify document types to inherit
      private final IntegerNode idx;

      public Inherits(Builder builder) {
        this(builder, true);
      }

      private Inherits(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].inherits[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
      }

      /**
       * @return documenttypes.doctype[].inherits[].idx
       */
      public int idx() {
        return idx.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
        return changes;
      }

      private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
          List<Inherits> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Inherits(b));
          }
          return new InnerNodeVector<Inherits>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].fieldsets{}
     */
    public final static class Fieldsets extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<String> fields = new ArrayList<>();

        public Builder() { }

        public Builder(Fieldsets config) {
          fields(config.fields());
        }

        private Builder override(Builder __superior) {
          if (!__superior.fields.isEmpty())
            fields.addAll(__superior.fields);
          return this;
        }

        public Builder fields(String __value) {
          fields.add(__value);
          return this;
        }

        public Builder fields(Collection<String> __values) {
          fields.addAll(__values);
          return this;
        }

        public Fieldsets build() {
          return new Fieldsets(this);
        }

      }

      // Field sets available for this document type
      private final LeafNodeVector<String, StringNode> fields;

      public Fieldsets(Builder builder) {
        this(builder, true);
      }

      private Fieldsets(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].fieldsets{} must be initialized: " + builder.__uninitialized);

        fields = new LeafNodeVector<>(builder.fields, new StringNode());
      }

      /**
       * @return documenttypes.doctype[].fieldsets{}.fields[]
       */
      public List<String> fields() {
        return fields.asList();
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.doctype[].fieldsets{}.fields[]
       */
      public String fields(int i) {
        return fields.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
        return changes;
      }

      private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
        Map<String, Fieldsets> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new Fieldsets(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }
    }

    /**
     * This class represents documenttypes.doctype[].importedfield[]
     */
    public final static class Importedfield extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;

        public Builder() { }

        public Builder(Importedfield config) {
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Importedfield build() {
          return new Importedfield(this);
        }

      }

      // Imported fields (specified outside the document block in the schema)
      private final StringNode name;

      public Importedfield(Builder builder) {
        this(builder, true);
      }

      private Importedfield(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].importedfield[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return documenttypes.doctype[].importedfield[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
        return changes;
      }

      private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
          List<Importedfield> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Importedfield(b));
          }
          return new InnerNodeVector<Importedfield>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].primitivetype[]
     */
    public final static class Primitivetype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name"
          ));

        private Integer idx = null;
        private String name = null;

        public Builder() { }

        public Builder(Primitivetype config) {
          idx(config.idx());
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Primitivetype build() {
          return new Primitivetype(this);
        }

      }

      // Everything below here is configuration of data types defined by
      // this document type.
      // Primitive types must be present as built-in static members.
      // Index of primitive type
      private final IntegerNode idx;
      // The name of this primitive type
      private final StringNode name;

      public Primitivetype(Builder builder) {
        this(builder, true);
      }

      private Primitivetype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].primitivetype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return documenttypes.doctype[].primitivetype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].primitivetype[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Primitivetype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("primitivetype");
        return changes;
      }

      private static InnerNodeVector<Primitivetype> createVector(List<Builder> builders) {
          List<Primitivetype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Primitivetype(b));
          }
          return new InnerNodeVector<Primitivetype>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].arraytype[]
     */
    public final static class Arraytype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "elementtype",
          "internalid"
          ));

        private Integer idx = null;
        private Integer elementtype = null;
        private Integer internalid = null;

        public Builder() { }

        public Builder(Arraytype config) {
          idx(config.idx());
          elementtype(config.elementtype());
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.elementtype != null)
            elementtype(__superior.elementtype);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder elementtype(int __value) {
          elementtype = __value;
          __uninitialized.remove("elementtype");
          return this;
        }

        private Builder elementtype(String __value) {
          return elementtype(Integer.valueOf(__value));
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Arraytype build() {
          return new Arraytype(this);
        }

      }

      // Arrays are the simplest collection type:
      // Index of this array type
      private final IntegerNode idx;
      // Index of the element type this array type contains
      private final IntegerNode elementtype;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Arraytype(Builder builder) {
        this(builder, true);
      }

      private Arraytype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].arraytype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        elementtype = (builder.elementtype == null) ?
            new IntegerNode() : new IntegerNode(builder.elementtype);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].arraytype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].arraytype[].elementtype
       */
      public int elementtype() {
        return elementtype.value();
      }

      /**
       * @return documenttypes.doctype[].arraytype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
        return changes;
      }

      private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
          List<Arraytype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Arraytype(b));
          }
          return new InnerNodeVector<Arraytype>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].maptype[]
     */
    public final static class Maptype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "keytype",
          "valuetype",
          "internalid"
          ));

        private Integer idx = null;
        private Integer keytype = null;
        private Integer valuetype = null;
        private Integer internalid = null;

        public Builder() { }

        public Builder(Maptype config) {
          idx(config.idx());
          keytype(config.keytype());
          valuetype(config.valuetype());
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.keytype != null)
            keytype(__superior.keytype);
          if (__superior.valuetype != null)
            valuetype(__superior.valuetype);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder keytype(int __value) {
          keytype = __value;
          __uninitialized.remove("keytype");
          return this;
        }

        private Builder keytype(String __value) {
          return keytype(Integer.valueOf(__value));
        }

        public Builder valuetype(int __value) {
          valuetype = __value;
          __uninitialized.remove("valuetype");
          return this;
        }

        private Builder valuetype(String __value) {
          return valuetype(Integer.valueOf(__value));
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Maptype build() {
          return new Maptype(this);
        }

      }

      // Maps are another collection type:
      // Index of this map type
      private final IntegerNode idx;
      // Index of the key type used by this map type
      private final IntegerNode keytype;
      // Index of the key type used by this map type
      private final IntegerNode valuetype;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Maptype(Builder builder) {
        this(builder, true);
      }

      private Maptype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].maptype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        keytype = (builder.keytype == null) ?
            new IntegerNode() : new IntegerNode(builder.keytype);
        valuetype = (builder.valuetype == null) ?
            new IntegerNode() : new IntegerNode(builder.valuetype);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].maptype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].maptype[].keytype
       */
      public int keytype() {
        return keytype.value();
      }

      /**
       * @return documenttypes.doctype[].maptype[].valuetype
       */
      public int valuetype() {
        return valuetype.value();
      }

      /**
       * @return documenttypes.doctype[].maptype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
        return changes;
      }

      private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
          List<Maptype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Maptype(b));
          }
          return new InnerNodeVector<Maptype>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].wsettype[]
     */
    public final static class Wsettype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "elementtype",
          "internalid"
          ));

        private Integer idx = null;
        private Integer elementtype = null;
        private Boolean createifnonexistent = null;
        private Boolean removeifzero = null;
        private Integer internalid = null;

        public Builder() { }

        public Builder(Wsettype config) {
          idx(config.idx());
          elementtype(config.elementtype());
          createifnonexistent(config.createifnonexistent());
          removeifzero(config.removeifzero());
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.elementtype != null)
            elementtype(__superior.elementtype);
          if (__superior.createifnonexistent != null)
            createifnonexistent(__superior.createifnonexistent);
          if (__superior.removeifzero != null)
            removeifzero(__superior.removeifzero);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder elementtype(int __value) {
          elementtype = __value;
          __uninitialized.remove("elementtype");
          return this;
        }

        private Builder elementtype(String __value) {
          return elementtype(Integer.valueOf(__value));
        }

        public Builder createifnonexistent(boolean __value) {
          createifnonexistent = __value;
          return this;
        }

        private Builder createifnonexistent(String __value) {
          return createifnonexistent(Boolean.valueOf(__value));
        }

        public Builder removeifzero(boolean __value) {
          removeifzero = __value;
          return this;
        }

        private Builder removeifzero(String __value) {
          return removeifzero(Boolean.valueOf(__value));
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Wsettype build() {
          return new Wsettype(this);
        }

      }

      // Weighted sets are more complicated;
      // they can be considered as an collection
      // of unique elements where each element has
      // an associated weight:
      // Index of this weighted set type
      private final IntegerNode idx;
      // Index of the element types contained in this weighted set type
      private final IntegerNode elementtype;
      // Should an update to a nonexistent element cause it to be created
      private final BooleanNode createifnonexistent;
      // Should an element in a weighted set be removed if an update changes the weight to 0
      private final BooleanNode removeifzero;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Wsettype(Builder builder) {
        this(builder, true);
      }

      private Wsettype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].wsettype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        elementtype = (builder.elementtype == null) ?
            new IntegerNode() : new IntegerNode(builder.elementtype);
        createifnonexistent = (builder.createifnonexistent == null) ?
            new BooleanNode(false) : new BooleanNode(builder.createifnonexistent);
        removeifzero = (builder.removeifzero == null) ?
            new BooleanNode(false) : new BooleanNode(builder.removeifzero);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].wsettype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].wsettype[].elementtype
       */
      public int elementtype() {
        return elementtype.value();
      }

      /**
       * @return documenttypes.doctype[].wsettype[].createifnonexistent
       */
      public boolean createifnonexistent() {
        return createifnonexistent.value();
      }

      /**
       * @return documenttypes.doctype[].wsettype[].removeifzero
       */
      public boolean removeifzero() {
        return removeifzero.value();
      }

      /**
       * @return documenttypes.doctype[].wsettype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Wsettype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("wsettype");
        return changes;
      }

      private static InnerNodeVector<Wsettype> createVector(List<Builder> builders) {
          List<Wsettype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Wsettype(b));
          }
          return new InnerNodeVector<Wsettype>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].tensortype[]
     */
    public final static class Tensortype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "detailedtype"
          ));

        private Integer idx = null;
        private String detailedtype = null;

        public Builder() { }

        public Builder(Tensortype config) {
          idx(config.idx());
          detailedtype(config.detailedtype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.detailedtype != null)
            detailedtype(__superior.detailedtype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder detailedtype(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          detailedtype = __value;
          __uninitialized.remove("detailedtype");
          return this;
        }


        public Tensortype build() {
          return new Tensortype(this);
        }

      }

      // Tensors have their own type system
      // Index of this tensor type
      private final IntegerNode idx;
      // Description of the type of the actual tensors contained
      private final StringNode detailedtype;

      public Tensortype(Builder builder) {
        this(builder, true);
      }

      private Tensortype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].tensortype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        detailedtype = (builder.detailedtype == null) ?
            new StringNode() : new StringNode(builder.detailedtype);
      }

      /**
       * @return documenttypes.doctype[].tensortype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].tensortype[].detailedtype
       */
      public String detailedtype() {
        return detailedtype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Tensortype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tensortype");
        return changes;
      }

      private static InnerNodeVector<Tensortype> createVector(List<Builder> builders) {
          List<Tensortype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Tensortype(b));
          }
          return new InnerNodeVector<Tensortype>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].documentref[]
     */
    public final static class Documentref extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "targettype",
          "internalid"
          ));

        private Integer idx = null;
        private Integer targettype = null;
        private Integer internalid = null;

        public Builder() { }

        public Builder(Documentref config) {
          idx(config.idx());
          targettype(config.targettype());
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.targettype != null)
            targettype(__superior.targettype);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder targettype(int __value) {
          targettype = __value;
          __uninitialized.remove("targettype");
          return this;
        }

        private Builder targettype(String __value) {
          return targettype(Integer.valueOf(__value));
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Documentref build() {
          return new Documentref(this);
        }

      }

      // Document references refer to parent documents that a document can
      // import fields from:
      // Index of this reference data type:
      private final IntegerNode idx;
      // Index of the document type this reference type refers to:
      private final IntegerNode targettype;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Documentref(Builder builder) {
        this(builder, true);
      }

      private Documentref(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].documentref[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        targettype = (builder.targettype == null) ?
            new IntegerNode() : new IntegerNode(builder.targettype);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].documentref[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].documentref[].targettype
       */
      public int targettype() {
        return targettype.value();
      }

      /**
       * @return documenttypes.doctype[].documentref[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Documentref newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("documentref");
        return changes;
      }

      private static InnerNodeVector<Documentref> createVector(List<Builder> builders) {
          List<Documentref> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Documentref(b));
          }
          return new InnerNodeVector<Documentref>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].annotationtype[]
     */
    public final static class Annotationtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name",
          "internalid"
          ));

        private Integer idx = null;
        private String name = null;
        private Integer internalid = null;
        private Integer datatype = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();

        public Builder() { }

        public Builder(Annotationtype config) {
          idx(config.idx());
          name(config.name());
          internalid(config.internalid());
          datatype(config.datatype());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          if (__superior.datatype != null)
            datatype(__superior.datatype);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Builder datatype(int __value) {
          datatype = __value;
          return this;
        }

        private Builder datatype(String __value) {
          return datatype(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        public Annotationtype build() {
          return new Annotationtype(this);
        }

      }

      // Annotation types are another world, but are modeled here
      // as if they were also datatypes contained inside document types:
      // Index of an annotation type.
      private final IntegerNode idx;
      // Name of the annotation type.
      private final StringNode name;
      // Internal id of this annotation type
      private final IntegerNode internalid;
      // Index of contained datatype of the annotation type, if any
      private final IntegerNode datatype;
      private final InnerNodeVector<Inherits> inherits;

      public Annotationtype(Builder builder) {
        this(builder, true);
      }

      private Annotationtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].annotationtype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
        datatype = (builder.datatype == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.datatype);
        inherits = Inherits.createVector(builder.inherits);
      }

      /**
       * @return documenttypes.doctype[].annotationtype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].annotationtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documenttypes.doctype[].annotationtype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      /**
       * @return documenttypes.doctype[].annotationtype[].datatype
       */
      public int datatype() {
        return datatype.value();
      }

      /**
       * @return documenttypes.doctype[].annotationtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.doctype[].annotationtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
        return changes;
      }

      private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
          List<Annotationtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationtype(b));
          }
          return new InnerNodeVector<Annotationtype>(elems);
      }

      /**
       * This class represents documenttypes.doctype[].annotationtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "idx"
            ));

          private Integer idx = null;

          public Builder() { }

          public Builder(Inherits config) {
            idx(config.idx());
          }

          private Builder override(Builder __superior) {
            if (__superior.idx != null)
              idx(__superior.idx);
            return this;
          }

          public Builder idx(int __value) {
            idx = __value;
            __uninitialized.remove("idx");
            return this;
          }

          private Builder idx(String __value) {
            return idx(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Index of annotation type that this type inherits.
        private final IntegerNode idx;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.doctype[].annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);

          idx = (builder.idx == null) ?
              new IntegerNode() : new IntegerNode(builder.idx);
        }

        /**
         * @return documenttypes.doctype[].annotationtype[].inherits[].idx
         */
        public int idx() {
          return idx.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }
    }

    /**
     * This class represents documenttypes.doctype[].annotationref[]
     */
    public final static class Annotationref extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "annotationtype",
          "internalid"
          ));

        private Integer idx = null;
        private Integer annotationtype = null;
        private Integer internalid = null;

        public Builder() { }

        public Builder(Annotationref config) {
          idx(config.idx());
          annotationtype(config.annotationtype());
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.annotationtype != null)
            annotationtype(__superior.annotationtype);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder annotationtype(int __value) {
          annotationtype = __value;
          __uninitialized.remove("annotationtype");
          return this;
        }

        private Builder annotationtype(String __value) {
          return annotationtype(Integer.valueOf(__value));
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Annotationref build() {
          return new Annotationref(this);
        }

      }

      // Annotation references are field values referring to
      // an annotation of a certain annotation type.
      // Index of this annotation reference type
      private final IntegerNode idx;
      // Index of the annotation type this annotation reference type refers to
      private final IntegerNode annotationtype;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Annotationref(Builder builder) {
        this(builder, true);
      }

      private Annotationref(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].annotationref[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        annotationtype = (builder.annotationtype == null) ?
            new IntegerNode() : new IntegerNode(builder.annotationtype);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].annotationref[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].annotationref[].annotationtype
       */
      public int annotationtype() {
        return annotationtype.value();
      }

      /**
       * @return documenttypes.doctype[].annotationref[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationref newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationref");
        return changes;
      }

      private static InnerNodeVector<Annotationref> createVector(List<Builder> builders) {
          List<Annotationref> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationref(b));
          }
          return new InnerNodeVector<Annotationref>(elems);
      }
    }

    /**
     * This class represents documenttypes.doctype[].structtype[]
     */
    public final static class Structtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name",
          "internalid"
          ));

        private Integer idx = null;
        private String name = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();
        public List<Field.Builder> field = new ArrayList<>();
        private Integer internalid = null;

        public Builder() { }

        public Builder(Structtype config) {
          idx(config.idx());
          name(config.name());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
          for (Field f : config.field()) {
            field(new Field.Builder(f));
          }
          internalid(config.internalid());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          if (!__superior.field.isEmpty())
            field.addAll(__superior.field);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        /**
         * Add the given builder to this builder's list of Field builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder field(Field.Builder __builder) {
          field.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder field(java.util.function.Consumer<Field.Builder> __func) {
          Field.Builder __inner = new Field.Builder();
          __func.accept(__inner);
          field.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Field builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder field(List<Field.Builder> __builders) {
          field = __builders;
          return this;
        }

        public Builder internalid(int __value) {
          internalid = __value;
          __uninitialized.remove("internalid");
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Structtype build() {
          return new Structtype(this);
        }

      }

      // A struct is just a named collections of fields:
      // Index of this struct type
      private final IntegerNode idx;
      // Name of the struct type. Must be unique within documenttype.
      private final StringNode name;
      private final InnerNodeVector<Inherits> inherits;
      private final InnerNodeVector<Field> field;
      // Internal ID of this datatype
      private final IntegerNode internalid;

      public Structtype(Builder builder) {
        this(builder, true);
      }

      private Structtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documenttypes.doctype[].structtype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        inherits = Inherits.createVector(builder.inherits);
        field = Field.createVector(builder.field);
        internalid = (builder.internalid == null) ?
            new IntegerNode() : new IntegerNode(builder.internalid);
      }

      /**
       * @return documenttypes.doctype[].structtype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documenttypes.doctype[].structtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documenttypes.doctype[].structtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.doctype[].structtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      /**
       * @return documenttypes.doctype[].structtype[].field[]
       */
      public List<Field> field() {
        return field;
      }

      /**
       * @param i the index of the value to return
       * @return documenttypes.doctype[].structtype[].field[]
       */
      public Field field(int i) {
        return field.get(i);
      }

      /**
       * @return documenttypes.doctype[].structtype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
        return changes;
      }

      private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
          List<Structtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Structtype(b));
          }
          return new InnerNodeVector<Structtype>(elems);
      }

      /**
       * This class represents documenttypes.doctype[].structtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "type"
            ));

          private Integer type = null;

          public Builder() { }

          public Builder(Inherits config) {
            type(config.type());
          }

          private Builder override(Builder __superior) {
            if (__superior.type != null)
              type(__superior.type);
            return this;
          }

          public Builder type(int __value) {
            type = __value;
            __uninitialized.remove("type");
            return this;
          }

          private Builder type(String __value) {
            return type(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Index of another struct type to inherit
        private final IntegerNode type;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.doctype[].structtype[].inherits[] must be initialized: " + builder.__uninitialized);

          type = (builder.type == null) ?
              new IntegerNode() : new IntegerNode(builder.type);
        }

        /**
         * @return documenttypes.doctype[].structtype[].inherits[].type
         */
        public int type() {
          return type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }

      /**
       * This class represents documenttypes.doctype[].structtype[].field[]
       */
      public final static class Field extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "internalid",
            "type"
            ));

          private String name = null;
          private Integer internalid = null;
          private Integer type = null;

          public Builder() { }

          public Builder(Field config) {
            name(config.name());
            internalid(config.internalid());
            type(config.type());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.internalid != null)
              internalid(__superior.internalid);
            if (__superior.type != null)
              type(__superior.type);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder internalid(int __value) {
            internalid = __value;
            __uninitialized.remove("internalid");
            return this;
          }

          private Builder internalid(String __value) {
            return internalid(Integer.valueOf(__value));
          }

          public Builder type(int __value) {
            type = __value;
            __uninitialized.remove("type");
            return this;
          }

          private Builder type(String __value) {
            return type(Integer.valueOf(__value));
          }

          public Field build() {
            return new Field(this);
          }

        }

        // Name of a struct field. Must be unique within the struct type.
        private final StringNode name;
        // The "field id" - used in serialized format!
        private final IntegerNode internalid;
        // Index of the type of this field
        private final IntegerNode type;

        public Field(Builder builder) {
          this(builder, true);
        }

        private Field(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documenttypes.doctype[].structtype[].field[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          internalid = (builder.internalid == null) ?
              new IntegerNode() : new IntegerNode(builder.internalid);
          type = (builder.type == null) ?
              new IntegerNode() : new IntegerNode(builder.type);
        }

        /**
         * @return documenttypes.doctype[].structtype[].field[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documenttypes.doctype[].structtype[].field[].internalid
         */
        public int internalid() {
          return internalid.value();
        }

        /**
         * @return documenttypes.doctype[].structtype[].field[].type
         */
        public int type() {
          return type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
          return changes;
        }

        private static InnerNodeVector<Field> createVector(List<Builder> builders) {
            List<Field> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Field(b));
            }
            return new InnerNodeVector<Field>(elems);
        }
      }
    }
  }

}
