// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.document.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of documentmanager
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class DocumentmanagerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "e065e9f2a8264a0921e377cca24fe213";
  public final static String CONFIG_DEF_NAME = "documentmanager";
  public final static String CONFIG_DEF_NAMESPACE = "document.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=document.config",
    "ignoreundefinedfields bool default=false",
    "usev8geopositions bool default=false",
    "datatype[].id int",
    "datatype[].arraytype[].datatype int",
    "datatype[].maptype[].keytype int",
    "datatype[].maptype[].valtype int",
    "datatype[].weightedsettype[].datatype int",
    "datatype[].weightedsettype[].createifnonexistant bool default=false",
    "datatype[].weightedsettype[].removeifzero bool default=false",
    "datatype[].structtype[].name string",
    "datatype[].structtype[].version int default=0",
    "datatype[].structtype[].compresstype enum { NONE, UNCOMPRESSABLE, LZ4 } default=NONE",
    "datatype[].structtype[].compresslevel int default=0",
    "datatype[].structtype[].compressthreshold int default=95",
    "datatype[].structtype[].compressminsize int default=800",
    "datatype[].structtype[].field[].name string",
    "datatype[].structtype[].field[].id[].id int",
    "datatype[].structtype[].field[].datatype int",
    "datatype[].structtype[].field[].detailedtype string default=\"\"",
    "datatype[].structtype[].inherits[].name string",
    "datatype[].structtype[].inherits[].version int default=0",
    "datatype[].annotationreftype[].annotation string",
    "datatype[].documenttype[].name string",
    "datatype[].documenttype[].version int default=0",
    "datatype[].documenttype[].inherits[].name string",
    "datatype[].documenttype[].inherits[].version int default=0",
    "datatype[].documenttype[].headerstruct int",
    "datatype[].documenttype[].bodystruct int default=0",
    "datatype[].documenttype[].fieldsets{}.fields[] string",
    "datatype[].documenttype[].importedfield[].name string",
    "datatype[].referencetype[].target_type_id int",
    "annotationtype[].id int",
    "annotationtype[].name string",
    "annotationtype[].datatype int default=-1",
    "annotationtype[].inherits[].id int",
    "doctype[].name string",
    "doctype[].idx int",
    "doctype[].inherits[].idx int",
    "doctype[].contentstruct int",
    "doctype[].fieldsets{}.fields[] string",
    "doctype[].importedfield[].name string",
    "doctype[].primitivetype[].idx int",
    "doctype[].primitivetype[].name string",
    "doctype[].arraytype[].idx int",
    "doctype[].arraytype[].elementtype int",
    "doctype[].maptype[].idx int",
    "doctype[].maptype[].keytype int",
    "doctype[].maptype[].valuetype int",
    "doctype[].wsettype[].idx int",
    "doctype[].wsettype[].elementtype int",
    "doctype[].wsettype[].createifnonexistent bool default=false",
    "doctype[].wsettype[].removeifzero bool default=false",
    "doctype[].tensortype[].idx int",
    "doctype[].tensortype[].detailedtype string",
    "doctype[].documentref[].idx int",
    "doctype[].documentref[].targettype int",
    "doctype[].annotationtype[].idx int",
    "doctype[].annotationtype[].name string",
    "doctype[].annotationtype[].internalid int default=-1",
    "doctype[].annotationtype[].datatype int default=-1",
    "doctype[].annotationtype[].inherits[].idx int",
    "doctype[].annotationref[].idx int",
    "doctype[].annotationref[].annotationtype int",
    "doctype[].structtype[].idx int",
    "doctype[].structtype[].name string",
    "doctype[].structtype[].inherits[].type int",
    "doctype[].structtype[].field[].name string",
    "doctype[].structtype[].field[].internalid int",
    "doctype[].structtype[].field[].type int"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Boolean ignoreundefinedfields = null;
    private Boolean usev8geopositions = null;
    public List<Datatype.Builder> datatype = new ArrayList<>();
    public List<Annotationtype.Builder> annotationtype = new ArrayList<>();
    public List<Doctype.Builder> doctype = new ArrayList<>();

    public Builder() { }

    public Builder(DocumentmanagerConfig config) {
      ignoreundefinedfields(config.ignoreundefinedfields());
      usev8geopositions(config.usev8geopositions());
      for (Datatype d : config.datatype()) {
        datatype(new Datatype.Builder(d));
      }
      for (Annotationtype a : config.annotationtype()) {
        annotationtype(new Annotationtype.Builder(a));
      }
      for (Doctype d : config.doctype()) {
        doctype(new Doctype.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (__superior.ignoreundefinedfields != null)
        ignoreundefinedfields(__superior.ignoreundefinedfields);
      if (__superior.usev8geopositions != null)
        usev8geopositions(__superior.usev8geopositions);
      if (!__superior.datatype.isEmpty())
        datatype.addAll(__superior.datatype);
      if (!__superior.annotationtype.isEmpty())
        annotationtype.addAll(__superior.annotationtype);
      if (!__superior.doctype.isEmpty())
        doctype.addAll(__superior.doctype);
      return this;
    }

    public Builder ignoreundefinedfields(boolean __value) {
      ignoreundefinedfields = __value;
      return this;
    }

    private Builder ignoreundefinedfields(String __value) {
      return ignoreundefinedfields(Boolean.valueOf(__value));
    }

    public Builder usev8geopositions(boolean __value) {
      usev8geopositions = __value;
      return this;
    }

    private Builder usev8geopositions(String __value) {
      return usev8geopositions(Boolean.valueOf(__value));
    }

    /**
     * Add the given builder to this builder's list of Datatype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder datatype(Datatype.Builder __builder) {
      datatype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder datatype(java.util.function.Consumer<Datatype.Builder> __func) {
      Datatype.Builder __inner = new Datatype.Builder();
      __func.accept(__inner);
      datatype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Datatype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder datatype(List<Datatype.Builder> __builders) {
      datatype = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Annotationtype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder annotationtype(Annotationtype.Builder __builder) {
      annotationtype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder annotationtype(java.util.function.Consumer<Annotationtype.Builder> __func) {
      Annotationtype.Builder __inner = new Annotationtype.Builder();
      __func.accept(__inner);
      annotationtype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Annotationtype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder annotationtype(List<Annotationtype.Builder> __builders) {
      annotationtype = __builders;
      return this;
    }

    /**
     * Add the given builder to this builder's list of Doctype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder doctype(Doctype.Builder __builder) {
      doctype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder doctype(java.util.function.Consumer<Doctype.Builder> __func) {
      Doctype.Builder __inner = new Doctype.Builder();
      __func.accept(__inner);
      doctype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Doctype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder doctype(List<Doctype.Builder> __builders) {
      doctype = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public DocumentmanagerConfig build() {
      return new DocumentmanagerConfig(this);
    }

  }

  // Whether attempts to set an undefined field should be ignored rather than causing an error
  private final BooleanNode ignoreundefinedfields;
  // Prefer "Vespa 8" format for the "position" type
  private final BooleanNode usev8geopositions;
  private final InnerNodeVector<Datatype> datatype;
  private final InnerNodeVector<Annotationtype> annotationtype;
  private final InnerNodeVector<Doctype> doctype;

  public DocumentmanagerConfig(Builder builder) {
    this(builder, true);
  }

  private DocumentmanagerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "documentmanager must be initialized: " + builder.__uninitialized);

    ignoreundefinedfields = (builder.ignoreundefinedfields == null) ?
        new BooleanNode(false) : new BooleanNode(builder.ignoreundefinedfields);
    usev8geopositions = (builder.usev8geopositions == null) ?
        new BooleanNode(false) : new BooleanNode(builder.usev8geopositions);
    datatype = Datatype.createVector(builder.datatype);
    annotationtype = Annotationtype.createVector(builder.annotationtype);
    doctype = Doctype.createVector(builder.doctype);
  }

  /**
   * @return documentmanager.ignoreundefinedfields
   */
  public boolean ignoreundefinedfields() {
    return ignoreundefinedfields.value();
  }

  /**
   * @return documentmanager.usev8geopositions
   */
  public boolean usev8geopositions() {
    return usev8geopositions.value();
  }

  /**
   * @return documentmanager.datatype[]
   */
  public List<Datatype> datatype() {
    return datatype;
  }

  /**
   * @param i the index of the value to return
   * @return documentmanager.datatype[]
   */
  public Datatype datatype(int i) {
    return datatype.get(i);
  }

  /**
   * @return documentmanager.annotationtype[]
   */
  public List<Annotationtype> annotationtype() {
    return annotationtype;
  }

  /**
   * @param i the index of the value to return
   * @return documentmanager.annotationtype[]
   */
  public Annotationtype annotationtype(int i) {
    return annotationtype.get(i);
  }

  /**
   * @return documentmanager.doctype[]
   */
  public List<Doctype> doctype() {
    return doctype;
  }

  /**
   * @param i the index of the value to return
   * @return documentmanager.doctype[]
   */
  public Doctype doctype(int i) {
    return doctype.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(DocumentmanagerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("documentmanager");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents documentmanager.datatype[]
   */
  public final static class Datatype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id"
        ));

      private Integer id = null;
      public List<Arraytype.Builder> arraytype = new ArrayList<>();
      public List<Maptype.Builder> maptype = new ArrayList<>();
      public List<Weightedsettype.Builder> weightedsettype = new ArrayList<>();
      public List<Structtype.Builder> structtype = new ArrayList<>();
      public List<Annotationreftype.Builder> annotationreftype = new ArrayList<>();
      public List<Documenttype.Builder> documenttype = new ArrayList<>();
      public List<Referencetype.Builder> referencetype = new ArrayList<>();

      public Builder() { }

      public Builder(Datatype config) {
        id(config.id());
        for (Arraytype a : config.arraytype()) {
          arraytype(new Arraytype.Builder(a));
        }
        for (Maptype m : config.maptype()) {
          maptype(new Maptype.Builder(m));
        }
        for (Weightedsettype w : config.weightedsettype()) {
          weightedsettype(new Weightedsettype.Builder(w));
        }
        for (Structtype s : config.structtype()) {
          structtype(new Structtype.Builder(s));
        }
        for (Annotationreftype a : config.annotationreftype()) {
          annotationreftype(new Annotationreftype.Builder(a));
        }
        for (Documenttype d : config.documenttype()) {
          documenttype(new Documenttype.Builder(d));
        }
        for (Referencetype r : config.referencetype()) {
          referencetype(new Referencetype.Builder(r));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (!__superior.arraytype.isEmpty())
          arraytype.addAll(__superior.arraytype);
        if (!__superior.maptype.isEmpty())
          maptype.addAll(__superior.maptype);
        if (!__superior.weightedsettype.isEmpty())
          weightedsettype.addAll(__superior.weightedsettype);
        if (!__superior.structtype.isEmpty())
          structtype.addAll(__superior.structtype);
        if (!__superior.annotationreftype.isEmpty())
          annotationreftype.addAll(__superior.annotationreftype);
        if (!__superior.documenttype.isEmpty())
          documenttype.addAll(__superior.documenttype);
        if (!__superior.referencetype.isEmpty())
          referencetype.addAll(__superior.referencetype);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Arraytype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder arraytype(Arraytype.Builder __builder) {
        arraytype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder arraytype(java.util.function.Consumer<Arraytype.Builder> __func) {
        Arraytype.Builder __inner = new Arraytype.Builder();
        __func.accept(__inner);
        arraytype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Arraytype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder arraytype(List<Arraytype.Builder> __builders) {
        arraytype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Maptype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder maptype(Maptype.Builder __builder) {
        maptype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder maptype(java.util.function.Consumer<Maptype.Builder> __func) {
        Maptype.Builder __inner = new Maptype.Builder();
        __func.accept(__inner);
        maptype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Maptype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder maptype(List<Maptype.Builder> __builders) {
        maptype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Weightedsettype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder weightedsettype(Weightedsettype.Builder __builder) {
        weightedsettype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder weightedsettype(java.util.function.Consumer<Weightedsettype.Builder> __func) {
        Weightedsettype.Builder __inner = new Weightedsettype.Builder();
        __func.accept(__inner);
        weightedsettype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Weightedsettype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder weightedsettype(List<Weightedsettype.Builder> __builders) {
        weightedsettype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Structtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder structtype(Structtype.Builder __builder) {
        structtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder structtype(java.util.function.Consumer<Structtype.Builder> __func) {
        Structtype.Builder __inner = new Structtype.Builder();
        __func.accept(__inner);
        structtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Structtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder structtype(List<Structtype.Builder> __builders) {
        structtype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationreftype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationreftype(Annotationreftype.Builder __builder) {
        annotationreftype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationreftype(java.util.function.Consumer<Annotationreftype.Builder> __func) {
        Annotationreftype.Builder __inner = new Annotationreftype.Builder();
        __func.accept(__inner);
        annotationreftype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationreftype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationreftype(List<Annotationreftype.Builder> __builders) {
        annotationreftype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Documenttype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder documenttype(Documenttype.Builder __builder) {
        documenttype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder documenttype(java.util.function.Consumer<Documenttype.Builder> __func) {
        Documenttype.Builder __inner = new Documenttype.Builder();
        __func.accept(__inner);
        documenttype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Documenttype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder documenttype(List<Documenttype.Builder> __builders) {
        documenttype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Referencetype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder referencetype(Referencetype.Builder __builder) {
        referencetype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder referencetype(java.util.function.Consumer<Referencetype.Builder> __func) {
        Referencetype.Builder __inner = new Referencetype.Builder();
        __func.accept(__inner);
        referencetype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Referencetype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder referencetype(List<Referencetype.Builder> __builders) {
        referencetype = __builders;
        return this;
      }

      public Datatype build() {
        return new Datatype(this);
      }

    }

    // The Id of the datatype. Must be unique, including not
    // overlapping with the internal datatypes (defined in datatype.h)
    private final IntegerNode id;
    private final InnerNodeVector<Arraytype> arraytype;
    private final InnerNodeVector<Maptype> maptype;
    private final InnerNodeVector<Weightedsettype> weightedsettype;
    private final InnerNodeVector<Structtype> structtype;
    private final InnerNodeVector<Annotationreftype> annotationreftype;
    private final InnerNodeVector<Documenttype> documenttype;
    private final InnerNodeVector<Referencetype> referencetype;

    public Datatype(Builder builder) {
      this(builder, true);
    }

    private Datatype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documentmanager.datatype[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      arraytype = Arraytype.createVector(builder.arraytype);
      maptype = Maptype.createVector(builder.maptype);
      weightedsettype = Weightedsettype.createVector(builder.weightedsettype);
      structtype = Structtype.createVector(builder.structtype);
      annotationreftype = Annotationreftype.createVector(builder.annotationreftype);
      documenttype = Documenttype.createVector(builder.documenttype);
      referencetype = Referencetype.createVector(builder.referencetype);
    }

    /**
     * @return documentmanager.datatype[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return documentmanager.datatype[].arraytype[]
     */
    public List<Arraytype> arraytype() {
      return arraytype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].arraytype[]
     */
    public Arraytype arraytype(int i) {
      return arraytype.get(i);
    }

    /**
     * @return documentmanager.datatype[].maptype[]
     */
    public List<Maptype> maptype() {
      return maptype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].maptype[]
     */
    public Maptype maptype(int i) {
      return maptype.get(i);
    }

    /**
     * @return documentmanager.datatype[].weightedsettype[]
     */
    public List<Weightedsettype> weightedsettype() {
      return weightedsettype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].weightedsettype[]
     */
    public Weightedsettype weightedsettype(int i) {
      return weightedsettype.get(i);
    }

    /**
     * @return documentmanager.datatype[].structtype[]
     */
    public List<Structtype> structtype() {
      return structtype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].structtype[]
     */
    public Structtype structtype(int i) {
      return structtype.get(i);
    }

    /**
     * @return documentmanager.datatype[].annotationreftype[]
     */
    public List<Annotationreftype> annotationreftype() {
      return annotationreftype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].annotationreftype[]
     */
    public Annotationreftype annotationreftype(int i) {
      return annotationreftype.get(i);
    }

    /**
     * @return documentmanager.datatype[].documenttype[]
     */
    public List<Documenttype> documenttype() {
      return documenttype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].documenttype[]
     */
    public Documenttype documenttype(int i) {
      return documenttype.get(i);
    }

    /**
     * @return documentmanager.datatype[].referencetype[]
     */
    public List<Referencetype> referencetype() {
      return referencetype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.datatype[].referencetype[]
     */
    public Referencetype referencetype(int i) {
      return referencetype.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Datatype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("datatype");
      return changes;
    }

    private static InnerNodeVector<Datatype> createVector(List<Builder> builders) {
        List<Datatype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Datatype(b));
        }
        return new InnerNodeVector<Datatype>(elems);
    }

    /**
     * This class represents documentmanager.datatype[].arraytype[]
     */
    public final static class Arraytype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "datatype"
          ));

        private Integer datatype = null;

        public Builder() { }

        public Builder(Arraytype config) {
          datatype(config.datatype());
        }

        private Builder override(Builder __superior) {
          if (__superior.datatype != null)
            datatype(__superior.datatype);
          return this;
        }

        public Builder datatype(int __value) {
          datatype = __value;
          __uninitialized.remove("datatype");
          return this;
        }

        private Builder datatype(String __value) {
          return datatype(Integer.valueOf(__value));
        }

        public Arraytype build() {
          return new Arraytype(this);
        }

      }

      // Use if this datatype is an array type, for instance an int
      // or double array. Specifies the datatype we have an array of.
      // This can be a built-in datatype or a new one created here, meaning
      // that for instance arrays of arrays are allowed.
      private final IntegerNode datatype;

      public Arraytype(Builder builder) {
        this(builder, true);
      }

      private Arraytype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].arraytype[] must be initialized: " + builder.__uninitialized);

        datatype = (builder.datatype == null) ?
            new IntegerNode() : new IntegerNode(builder.datatype);
      }

      /**
       * @return documentmanager.datatype[].arraytype[].datatype
       */
      public int datatype() {
        return datatype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
        return changes;
      }

      private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
          List<Arraytype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Arraytype(b));
          }
          return new InnerNodeVector<Arraytype>(elems);
      }
    }

    /**
     * This class represents documentmanager.datatype[].maptype[]
     */
    public final static class Maptype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "keytype",
          "valtype"
          ));

        private Integer keytype = null;
        private Integer valtype = null;

        public Builder() { }

        public Builder(Maptype config) {
          keytype(config.keytype());
          valtype(config.valtype());
        }

        private Builder override(Builder __superior) {
          if (__superior.keytype != null)
            keytype(__superior.keytype);
          if (__superior.valtype != null)
            valtype(__superior.valtype);
          return this;
        }

        public Builder keytype(int __value) {
          keytype = __value;
          __uninitialized.remove("keytype");
          return this;
        }

        private Builder keytype(String __value) {
          return keytype(Integer.valueOf(__value));
        }

        public Builder valtype(int __value) {
          valtype = __value;
          __uninitialized.remove("valtype");
          return this;
        }

        private Builder valtype(String __value) {
          return valtype(Integer.valueOf(__value));
        }

        public Maptype build() {
          return new Maptype(this);
        }

      }

      // Map type. Keys and values can be built in types or types created here.
      private final IntegerNode keytype;
      private final IntegerNode valtype;

      public Maptype(Builder builder) {
        this(builder, true);
      }

      private Maptype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].maptype[] must be initialized: " + builder.__uninitialized);

        keytype = (builder.keytype == null) ?
            new IntegerNode() : new IntegerNode(builder.keytype);
        valtype = (builder.valtype == null) ?
            new IntegerNode() : new IntegerNode(builder.valtype);
      }

      /**
       * @return documentmanager.datatype[].maptype[].keytype
       */
      public int keytype() {
        return keytype.value();
      }

      /**
       * @return documentmanager.datatype[].maptype[].valtype
       */
      public int valtype() {
        return valtype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
        return changes;
      }

      private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
          List<Maptype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Maptype(b));
          }
          return new InnerNodeVector<Maptype>(elems);
      }
    }

    /**
     * This class represents documentmanager.datatype[].weightedsettype[]
     */
    public final static class Weightedsettype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "datatype"
          ));

        private Integer datatype = null;
        private Boolean createifnonexistant = null;
        private Boolean removeifzero = null;

        public Builder() { }

        public Builder(Weightedsettype config) {
          datatype(config.datatype());
          createifnonexistant(config.createifnonexistant());
          removeifzero(config.removeifzero());
        }

        private Builder override(Builder __superior) {
          if (__superior.datatype != null)
            datatype(__superior.datatype);
          if (__superior.createifnonexistant != null)
            createifnonexistant(__superior.createifnonexistant);
          if (__superior.removeifzero != null)
            removeifzero(__superior.removeifzero);
          return this;
        }

        public Builder datatype(int __value) {
          datatype = __value;
          __uninitialized.remove("datatype");
          return this;
        }

        private Builder datatype(String __value) {
          return datatype(Integer.valueOf(__value));
        }

        public Builder createifnonexistant(boolean __value) {
          createifnonexistant = __value;
          return this;
        }

        private Builder createifnonexistant(String __value) {
          return createifnonexistant(Boolean.valueOf(__value));
        }

        public Builder removeifzero(boolean __value) {
          removeifzero = __value;
          return this;
        }

        private Builder removeifzero(String __value) {
          return removeifzero(Boolean.valueOf(__value));
        }

        public Weightedsettype build() {
          return new Weightedsettype(this);
        }

      }

      // Use if this datatype is a weighted set type, for instance an int
      // or double weighted set. Specifies the datatype we have a weighted set of.
      // This can be a built-in datatype or a new one craeted here, meaning
      // that for instance weighted sets of weighted sets are allowed.
      private final IntegerNode datatype;
      // Should an update to a nonexistant element cause it to be created
      private final BooleanNode createifnonexistant;
      // Should an element in a weighted set be removed if an update changes the weight to 0
      private final BooleanNode removeifzero;

      public Weightedsettype(Builder builder) {
        this(builder, true);
      }

      private Weightedsettype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].weightedsettype[] must be initialized: " + builder.__uninitialized);

        datatype = (builder.datatype == null) ?
            new IntegerNode() : new IntegerNode(builder.datatype);
        createifnonexistant = (builder.createifnonexistant == null) ?
            new BooleanNode(false) : new BooleanNode(builder.createifnonexistant);
        removeifzero = (builder.removeifzero == null) ?
            new BooleanNode(false) : new BooleanNode(builder.removeifzero);
      }

      /**
       * @return documentmanager.datatype[].weightedsettype[].datatype
       */
      public int datatype() {
        return datatype.value();
      }

      /**
       * @return documentmanager.datatype[].weightedsettype[].createifnonexistant
       */
      public boolean createifnonexistant() {
        return createifnonexistant.value();
      }

      /**
       * @return documentmanager.datatype[].weightedsettype[].removeifzero
       */
      public boolean removeifzero() {
        return removeifzero.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Weightedsettype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("weightedsettype");
        return changes;
      }

      private static InnerNodeVector<Weightedsettype> createVector(List<Builder> builders) {
          List<Weightedsettype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Weightedsettype(b));
          }
          return new InnerNodeVector<Weightedsettype>(elems);
      }
    }

    /**
     * This class represents documentmanager.datatype[].structtype[]
     */
    public final static class Structtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;
        private Integer version = null;
        private Compresstype.Enum compresstype = null;
        private Integer compresslevel = null;
        private Integer compressthreshold = null;
        private Integer compressminsize = null;
        public List<Field.Builder> field = new ArrayList<>();
        public List<Inherits.Builder> inherits = new ArrayList<>();

        public Builder() { }

        public Builder(Structtype config) {
          name(config.name());
          version(config.version());
          compresstype(config.compresstype());
          compresslevel(config.compresslevel());
          compressthreshold(config.compressthreshold());
          compressminsize(config.compressminsize());
          for (Field f : config.field()) {
            field(new Field.Builder(f));
          }
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.version != null)
            version(__superior.version);
          if (__superior.compresstype != null)
            compresstype(__superior.compresstype);
          if (__superior.compresslevel != null)
            compresslevel(__superior.compresslevel);
          if (__superior.compressthreshold != null)
            compressthreshold(__superior.compressthreshold);
          if (__superior.compressminsize != null)
            compressminsize(__superior.compressminsize);
          if (!__superior.field.isEmpty())
            field.addAll(__superior.field);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder version(int __value) {
          version = __value;
          return this;
        }

        private Builder version(String __value) {
          return version(Integer.valueOf(__value));
        }

        public Builder compresstype(Compresstype.Enum __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          compresstype = __value;
          return this;
        }

        private Builder compresstype(String __value) {
          return compresstype(Compresstype.Enum.valueOf(__value));
        }

        public Builder compresslevel(int __value) {
          compresslevel = __value;
          return this;
        }

        private Builder compresslevel(String __value) {
          return compresslevel(Integer.valueOf(__value));
        }

        public Builder compressthreshold(int __value) {
          compressthreshold = __value;
          return this;
        }

        private Builder compressthreshold(String __value) {
          return compressthreshold(Integer.valueOf(__value));
        }

        public Builder compressminsize(int __value) {
          compressminsize = __value;
          return this;
        }

        private Builder compressminsize(String __value) {
          return compressminsize(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Field builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder field(Field.Builder __builder) {
          field.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder field(java.util.function.Consumer<Field.Builder> __func) {
          Field.Builder __inner = new Field.Builder();
          __func.accept(__inner);
          field.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Field builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder field(List<Field.Builder> __builders) {
          field = __builders;
          return this;
        }

        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        public Structtype build() {
          return new Structtype(this);
        }

      }

      // Specify the name of the document type. Must be unique.
      private final StringNode name;
      // Verison is not in use
      private final IntegerNode version;
      // Specify which compression to use if compression is enabled above
      private final Compresstype compresstype;
      // Specify the compression level to use if compression is enabled
      private final IntegerNode compresslevel;
      // Specify the minimum reduction required from compression in order to keep the compressed version (maximum percentage of original size)
      private final IntegerNode compressthreshold;
      // Specify the minimum size of the struct data before we even try to compress it
      private final IntegerNode compressminsize;
      private final InnerNodeVector<Field> field;
      private final InnerNodeVector<Inherits> inherits;

      public Structtype(Builder builder) {
        this(builder, true);
      }

      private Structtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].structtype[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        version = (builder.version == null) ?
            new IntegerNode(0) : new IntegerNode(builder.version);
        compresstype = (builder.compresstype == null) ?
            new Compresstype(Compresstype.NONE) : new Compresstype(builder.compresstype);
        compresslevel = (builder.compresslevel == null) ?
            new IntegerNode(0) : new IntegerNode(builder.compresslevel);
        compressthreshold = (builder.compressthreshold == null) ?
            new IntegerNode(95) : new IntegerNode(builder.compressthreshold);
        compressminsize = (builder.compressminsize == null) ?
            new IntegerNode(800) : new IntegerNode(builder.compressminsize);
        field = Field.createVector(builder.field);
        inherits = Inherits.createVector(builder.inherits);
      }

      /**
       * @return documentmanager.datatype[].structtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].version
       */
      public int version() {
        return version.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].compresstype
       */
      public Compresstype.Enum compresstype() {
        return compresstype.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].compresslevel
       */
      public int compresslevel() {
        return compresslevel.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].compressthreshold
       */
      public int compressthreshold() {
        return compressthreshold.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].compressminsize
       */
      public int compressminsize() {
        return compressminsize.value();
      }

      /**
       * @return documentmanager.datatype[].structtype[].field[]
       */
      public List<Field> field() {
        return field;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.datatype[].structtype[].field[]
       */
      public Field field(int i) {
        return field.get(i);
      }

      /**
       * @return documentmanager.datatype[].structtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.datatype[].structtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
        return changes;
      }

      private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
          List<Structtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Structtype(b));
          }
          return new InnerNodeVector<Structtype>(elems);
      }

      /**
       * This class represents documentmanager.datatype[].structtype[].compresstype
       * 
       * Specify which compression to use if compression is enabled above
       */
      public final static class Compresstype extends EnumNode<Compresstype.Enum> {

        public Compresstype(){
          this.value = null;
        }

        public Compresstype(Enum enumValue) {
          super(enumValue != null);
          this.value = enumValue;
        }

        public enum Enum {NONE, UNCOMPRESSABLE, LZ4}
        public final static Enum NONE = Enum.NONE;
        public final static Enum UNCOMPRESSABLE = Enum.UNCOMPRESSABLE;
        public final static Enum LZ4 = Enum.LZ4;

        @Override
        protected boolean doSetValue(String name) {
          try {
            value = Enum.valueOf(name);
            return true;
          } catch (IllegalArgumentException e) {
          }
          return false;
        }
      }

      /**
       * This class represents documentmanager.datatype[].structtype[].field[]
       */
      public final static class Field extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "datatype"
            ));

          private String name = null;
          public List<Id.Builder> id = new ArrayList<>();
          private Integer datatype = null;
          private String detailedtype = null;

          public Builder() { }

          public Builder(Field config) {
            name(config.name());
            for (Id i : config.id()) {
              id(new Id.Builder(i));
            }
            datatype(config.datatype());
            detailedtype(config.detailedtype());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (!__superior.id.isEmpty())
              id.addAll(__superior.id);
            if (__superior.datatype != null)
              datatype(__superior.datatype);
            if (__superior.detailedtype != null)
              detailedtype(__superior.detailedtype);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          /**
           * Add the given builder to this builder's list of Id builders
           * @param __builder a builder
           * @return this builder
           */
          public Builder id(Id.Builder __builder) {
            id.add(__builder);
            return this;
          }

          /**
           * Make a new builder and run the supplied function on it before adding it to the list
           * @param __func lambda that modifies the given builder
           * @return this builder
           */
          public Builder id(java.util.function.Consumer<Id.Builder> __func) {
            Id.Builder __inner = new Id.Builder();
            __func.accept(__inner);
            id.add(__inner);
            return this;
          }

          /**
           * Set the given list as this builder's list of Id builders
           * @param __builders a list of builders
           * @return this builder
           */
          public Builder id(List<Id.Builder> __builders) {
            id = __builders;
            return this;
          }

          public Builder datatype(int __value) {
            datatype = __value;
            __uninitialized.remove("datatype");
            return this;
          }

          private Builder datatype(String __value) {
            return datatype(Integer.valueOf(__value));
          }

          public Builder detailedtype(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            detailedtype = __value;
            return this;
          }


          public Field build() {
            return new Field(this);
          }

        }

        // Specify a document field name. Must be unique within the document type.
        private final StringNode name;
        private final InnerNodeVector<Id> id;
        // Specify the datatype of the field. Can be a built-in datatype or
        // one specified in config.
        private final IntegerNode datatype;
        // Additional, optional type information which can be changed without
        // (necessarily) causing field incompatibility
        private final StringNode detailedtype;

        public Field(Builder builder) {
          this(builder, true);
        }

        private Field(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.datatype[].structtype[].field[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          id = Id.createVector(builder.id);
          datatype = (builder.datatype == null) ?
              new IntegerNode() : new IntegerNode(builder.datatype);
          detailedtype = (builder.detailedtype == null) ?
              new StringNode("") : new StringNode(builder.detailedtype);
        }

        /**
         * @return documentmanager.datatype[].structtype[].field[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documentmanager.datatype[].structtype[].field[].id[]
         */
        public List<Id> id() {
          return id;
        }

        /**
         * @param i the index of the value to return
         * @return documentmanager.datatype[].structtype[].field[].id[]
         */
        public Id id(int i) {
          return id.get(i);
        }

        /**
         * @return documentmanager.datatype[].structtype[].field[].datatype
         */
        public int datatype() {
          return datatype.value();
        }

        /**
         * @return documentmanager.datatype[].structtype[].field[].detailedtype
         */
        public String detailedtype() {
          return detailedtype.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
          return changes;
        }

        private static InnerNodeVector<Field> createVector(List<Builder> builders) {
            List<Field> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Field(b));
            }
            return new InnerNodeVector<Field>(elems);
        }

        /**
         * This class represents documentmanager.datatype[].structtype[].field[].id[]
         */
        public final static class Id extends InnerNode { 

          public static final class Builder implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of(
              "id"
              ));

            private Integer id = null;

            public Builder() { }

            public Builder(Id config) {
              id(config.id());
            }

            private Builder override(Builder __superior) {
              if (__superior.id != null)
                id(__superior.id);
              return this;
            }

            public Builder id(int __value) {
              id = __value;
              __uninitialized.remove("id");
              return this;
            }

            private Builder id(String __value) {
              return id(Integer.valueOf(__value));
            }

            public Id build() {
              return new Id(this);
            }

          }

          // Specify a document field id. If not specified, this is generated by a hash function
          private final IntegerNode id;

          public Id(Builder builder) {
            this(builder, true);
          }

          private Id(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
              throw new IllegalArgumentException("The following builder parameters for " +
                  "documentmanager.datatype[].structtype[].field[].id[] must be initialized: " + builder.__uninitialized);

            id = (builder.id == null) ?
                new IntegerNode() : new IntegerNode(builder.id);
          }

          /**
           * @return documentmanager.datatype[].structtype[].field[].id[].id
           */
          public int id() {
            return id.value();
          }

          private ChangesRequiringRestart getChangesRequiringRestart(Id newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("id");
            return changes;
          }

          private static InnerNodeVector<Id> createVector(List<Builder> builders) {
              List<Id> elems = new ArrayList<>();
              for (Builder b : builders) {
                  elems.add(new Id(b));
              }
              return new InnerNodeVector<Id>(elems);
          }
        }
      }

      /**
       * This class represents documentmanager.datatype[].structtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name"
            ));

          private String name = null;
          private Integer version = null;

          public Builder() { }

          public Builder(Inherits config) {
            name(config.name());
            version(config.version());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.version != null)
              version(__superior.version);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder version(int __value) {
            version = __value;
            return this;
          }

          private Builder version(String __value) {
            return version(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Specify a struct type to inherit
        private final StringNode name;
        // Version is not in use
        private final IntegerNode version;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.datatype[].structtype[].inherits[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          version = (builder.version == null) ?
              new IntegerNode(0) : new IntegerNode(builder.version);
        }

        /**
         * @return documentmanager.datatype[].structtype[].inherits[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documentmanager.datatype[].structtype[].inherits[].version
         */
        public int version() {
          return version.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }
    }

    /**
     * This class represents documentmanager.datatype[].annotationreftype[]
     */
    public final static class Annotationreftype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "annotation"
          ));

        private String annotation = null;

        public Builder() { }

        public Builder(Annotationreftype config) {
          annotation(config.annotation());
        }

        private Builder override(Builder __superior) {
          if (__superior.annotation != null)
            annotation(__superior.annotation);
          return this;
        }

        public Builder annotation(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          annotation = __value;
          __uninitialized.remove("annotation");
          return this;
        }


        public Annotationreftype build() {
          return new Annotationreftype(this);
        }

      }

      // Specity an annotation reference type and the name of the annotation type it is referencing
      private final StringNode annotation;

      public Annotationreftype(Builder builder) {
        this(builder, true);
      }

      private Annotationreftype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].annotationreftype[] must be initialized: " + builder.__uninitialized);

        annotation = (builder.annotation == null) ?
            new StringNode() : new StringNode(builder.annotation);
      }

      /**
       * @return documentmanager.datatype[].annotationreftype[].annotation
       */
      public String annotation() {
        return annotation.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationreftype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationreftype");
        return changes;
      }

      private static InnerNodeVector<Annotationreftype> createVector(List<Builder> builders) {
          List<Annotationreftype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationreftype(b));
          }
          return new InnerNodeVector<Annotationreftype>(elems);
      }
    }

    /**
     * This class represents documentmanager.datatype[].documenttype[]
     */
    public final static class Documenttype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name",
          "headerstruct"
          ));

        private String name = null;
        private Integer version = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();
        private Integer headerstruct = null;
        private Integer bodystruct = null;
        public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<>();
        public List<Importedfield.Builder> importedfield = new ArrayList<>();

        public Builder() { }

        public Builder(Documenttype config) {
          name(config.name());
          version(config.version());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
          headerstruct(config.headerstruct());
          bodystruct(config.bodystruct());
          for (Map.Entry<String, Fieldsets> __entry : config.fieldsets().entrySet()) {
            fieldsets(__entry.getKey(), new Fieldsets.Builder(__entry.getValue()));
          }
          for (Importedfield i : config.importedfield()) {
            importedfield(new Importedfield.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.version != null)
            version(__superior.version);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          if (__superior.headerstruct != null)
            headerstruct(__superior.headerstruct);
          if (__superior.bodystruct != null)
            bodystruct(__superior.bodystruct);
          fieldsets(__superior.fieldsets);
          if (!__superior.importedfield.isEmpty())
            importedfield.addAll(__superior.importedfield);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder version(int __value) {
          version = __value;
          return this;
        }

        private Builder version(String __value) {
          return version(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        public Builder headerstruct(int __value) {
          headerstruct = __value;
          __uninitialized.remove("headerstruct");
          return this;
        }

        private Builder headerstruct(String __value) {
          return headerstruct(Integer.valueOf(__value));
        }

        public Builder bodystruct(int __value) {
          bodystruct = __value;
          return this;
        }

        private Builder bodystruct(String __value) {
          return bodystruct(Integer.valueOf(__value));
        }

        public Builder fieldsets(String __key, Fieldsets.Builder __value) {
          fieldsets.put(__key, __value);
          return this;
        }

        public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
          fieldsets.putAll(__values);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before using it as the value
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder fieldsets(String __key, java.util.function.Consumer<Fieldsets.Builder> __func) {
          Fieldsets.Builder __inner = new Fieldsets.Builder();
          __func.accept(__inner);
          fieldsets.put(__key, __inner);
          return this;
        }

        /**
         * Add the given builder to this builder's list of Importedfield builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder importedfield(Importedfield.Builder __builder) {
          importedfield.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder importedfield(java.util.function.Consumer<Importedfield.Builder> __func) {
          Importedfield.Builder __inner = new Importedfield.Builder();
          __func.accept(__inner);
          importedfield.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Importedfield builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder importedfield(List<Importedfield.Builder> __builders) {
          importedfield = __builders;
          return this;
        }

        public Documenttype build() {
          return new Documenttype(this);
        }

      }

      // Specify the name of the document type. Must be unique.
      private final StringNode name;
      // Version is not in use
      private final IntegerNode version;
      private final InnerNodeVector<Inherits> inherits;
      // Name of header struct defining document header.
      private final IntegerNode headerstruct;
      // Specify a document field id. Must be unique within the document type.
      private final IntegerNode bodystruct;
      private final Map<String, Fieldsets> fieldsets;
      private final InnerNodeVector<Importedfield> importedfield;

      public Documenttype(Builder builder) {
        this(builder, true);
      }

      private Documenttype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].documenttype[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        version = (builder.version == null) ?
            new IntegerNode(0) : new IntegerNode(builder.version);
        inherits = Inherits.createVector(builder.inherits);
        headerstruct = (builder.headerstruct == null) ?
            new IntegerNode() : new IntegerNode(builder.headerstruct);
        bodystruct = (builder.bodystruct == null) ?
            new IntegerNode(0) : new IntegerNode(builder.bodystruct);
        fieldsets = Fieldsets.createMap(builder.fieldsets);
        importedfield = Importedfield.createVector(builder.importedfield);
      }

      /**
       * @return documentmanager.datatype[].documenttype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documentmanager.datatype[].documenttype[].version
       */
      public int version() {
        return version.value();
      }

      /**
       * @return documentmanager.datatype[].documenttype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.datatype[].documenttype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      /**
       * @return documentmanager.datatype[].documenttype[].headerstruct
       */
      public int headerstruct() {
        return headerstruct.value();
      }

      /**
       * @return documentmanager.datatype[].documenttype[].bodystruct
       */
      public int bodystruct() {
        return bodystruct.value();
      }

      /**
       * @return documentmanager.datatype[].documenttype[].fieldsets{}
       */
      public Map<String, Fieldsets> fieldsets() {
        return Collections.unmodifiableMap(fieldsets);
      }

      /**
       * @param key the key of the value to return
       * @return documentmanager.datatype[].documenttype[].fieldsets{}
       */
      public Fieldsets fieldsets(String key) {
        return fieldsets.get(key);
      }

      /**
       * @return documentmanager.datatype[].documenttype[].importedfield[]
       */
      public List<Importedfield> importedfield() {
        return importedfield;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.datatype[].documenttype[].importedfield[]
       */
      public Importedfield importedfield(int i) {
        return importedfield.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Documenttype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("documenttype");
        return changes;
      }

      private static InnerNodeVector<Documenttype> createVector(List<Builder> builders) {
          List<Documenttype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Documenttype(b));
          }
          return new InnerNodeVector<Documenttype>(elems);
      }

      /**
       * This class represents documentmanager.datatype[].documenttype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name"
            ));

          private String name = null;
          private Integer version = null;

          public Builder() { }

          public Builder(Inherits config) {
            name(config.name());
            version(config.version());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.version != null)
              version(__superior.version);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder version(int __value) {
            version = __value;
            return this;
          }

          private Builder version(String __value) {
            return version(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Specify a document type to inherit
        private final StringNode name;
        // Version is not in use
        private final IntegerNode version;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.datatype[].documenttype[].inherits[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          version = (builder.version == null) ?
              new IntegerNode(0) : new IntegerNode(builder.version);
        }

        /**
         * @return documentmanager.datatype[].documenttype[].inherits[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documentmanager.datatype[].documenttype[].inherits[].version
         */
        public int version() {
          return version.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }

      /**
       * This class represents documentmanager.datatype[].documenttype[].fieldsets{}
       */
      public final static class Fieldsets extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>();

          public List<String> fields = new ArrayList<>();

          public Builder() { }

          public Builder(Fieldsets config) {
            fields(config.fields());
          }

          private Builder override(Builder __superior) {
            if (!__superior.fields.isEmpty())
              fields.addAll(__superior.fields);
            return this;
          }

          public Builder fields(String __value) {
            fields.add(__value);
            return this;
          }

          public Builder fields(Collection<String> __values) {
            fields.addAll(__values);
            return this;
          }

          public Fieldsets build() {
            return new Fieldsets(this);
          }

        }

        // Field sets
        private final LeafNodeVector<String, StringNode> fields;

        public Fieldsets(Builder builder) {
          this(builder, true);
        }

        private Fieldsets(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.datatype[].documenttype[].fieldsets{} must be initialized: " + builder.__uninitialized);

          fields = new LeafNodeVector<>(builder.fields, new StringNode());
        }

        /**
         * @return documentmanager.datatype[].documenttype[].fieldsets{}.fields[]
         */
        public List<String> fields() {
          return fields.asList();
        }

        /**
         * @param i the index of the value to return
         * @return documentmanager.datatype[].documenttype[].fieldsets{}.fields[]
         */
        public String fields(int i) {
          return fields.get(i).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
          return changes;
        }

        private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
          Map<String, Fieldsets> ret = new LinkedHashMap<>();
          for(String key : builders.keySet()) {
            ret.put(key, new Fieldsets(builders.get(key)));
          }
          return Collections.unmodifiableMap(ret);
        }
      }

      /**
       * This class represents documentmanager.datatype[].documenttype[].importedfield[]
       */
      public final static class Importedfield extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name"
            ));

          private String name = null;

          public Builder() { }

          public Builder(Importedfield config) {
            name(config.name());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Importedfield build() {
            return new Importedfield(this);
          }

        }

        // Imported fields (specified outside the document block in the schema)
        private final StringNode name;

        public Importedfield(Builder builder) {
          this(builder, true);
        }

        private Importedfield(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.datatype[].documenttype[].importedfield[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
        }

        /**
         * @return documentmanager.datatype[].documenttype[].importedfield[].name
         */
        public String name() {
          return name.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
          return changes;
        }

        private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
            List<Importedfield> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Importedfield(b));
            }
            return new InnerNodeVector<Importedfield>(elems);
        }
      }
    }

    /**
     * This class represents documentmanager.datatype[].referencetype[]
     */
    public final static class Referencetype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "target_type_id"
          ));

        private Integer target_type_id = null;

        public Builder() { }

        public Builder(Referencetype config) {
          target_type_id(config.target_type_id());
        }

        private Builder override(Builder __superior) {
          if (__superior.target_type_id != null)
            target_type_id(__superior.target_type_id);
          return this;
        }

        public Builder target_type_id(int __value) {
          target_type_id = __value;
          __uninitialized.remove("target_type_id");
          return this;
        }

        private Builder target_type_id(String __value) {
          return target_type_id(Integer.valueOf(__value));
        }

        public Referencetype build() {
          return new Referencetype(this);
        }

      }

      // Cross-document reference with ID of target document type
      private final IntegerNode target_type_id;

      public Referencetype(Builder builder) {
        this(builder, true);
      }

      private Referencetype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.datatype[].referencetype[] must be initialized: " + builder.__uninitialized);

        target_type_id = (builder.target_type_id == null) ?
            new IntegerNode() : new IntegerNode(builder.target_type_id);
      }

      /**
       * @return documentmanager.datatype[].referencetype[].target_type_id
       */
      public int target_type_id() {
        return target_type_id.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Referencetype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("referencetype");
        return changes;
      }

      private static InnerNodeVector<Referencetype> createVector(List<Builder> builders) {
          List<Referencetype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Referencetype(b));
          }
          return new InnerNodeVector<Referencetype>(elems);
      }
    }
  }

  /**
   * This class represents documentmanager.annotationtype[]
   */
  public final static class Annotationtype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "id",
        "name"
        ));

      private Integer id = null;
      private String name = null;
      private Integer datatype = null;
      public List<Inherits.Builder> inherits = new ArrayList<>();

      public Builder() { }

      public Builder(Annotationtype config) {
        id(config.id());
        name(config.name());
        datatype(config.datatype());
        for (Inherits i : config.inherits()) {
          inherits(new Inherits.Builder(i));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.id != null)
          id(__superior.id);
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.datatype != null)
          datatype(__superior.datatype);
        if (!__superior.inherits.isEmpty())
          inherits.addAll(__superior.inherits);
        return this;
      }

      public Builder id(int __value) {
        id = __value;
        __uninitialized.remove("id");
        return this;
      }

      private Builder id(String __value) {
        return id(Integer.valueOf(__value));
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder datatype(int __value) {
        datatype = __value;
        return this;
      }

      private Builder datatype(String __value) {
        return datatype(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Inherits builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder inherits(Inherits.Builder __builder) {
        inherits.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
        Inherits.Builder __inner = new Inherits.Builder();
        __func.accept(__inner);
        inherits.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Inherits builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder inherits(List<Inherits.Builder> __builders) {
        inherits = __builders;
        return this;
      }

      public Annotationtype build() {
        return new Annotationtype(this);
      }

    }

    // The Id of the annotation type. Must be unique.
    private final IntegerNode id;
    private final StringNode name;
    private final IntegerNode datatype;
    private final InnerNodeVector<Inherits> inherits;

    public Annotationtype(Builder builder) {
      this(builder, true);
    }

    private Annotationtype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documentmanager.annotationtype[] must be initialized: " + builder.__uninitialized);

      id = (builder.id == null) ?
          new IntegerNode() : new IntegerNode(builder.id);
      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      datatype = (builder.datatype == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.datatype);
      inherits = Inherits.createVector(builder.inherits);
    }

    /**
     * @return documentmanager.annotationtype[].id
     */
    public int id() {
      return id.value();
    }

    /**
     * @return documentmanager.annotationtype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documentmanager.annotationtype[].datatype
     */
    public int datatype() {
      return datatype.value();
    }

    /**
     * @return documentmanager.annotationtype[].inherits[]
     */
    public List<Inherits> inherits() {
      return inherits;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.annotationtype[].inherits[]
     */
    public Inherits inherits(int i) {
      return inherits.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
      return changes;
    }

    private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
        List<Annotationtype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Annotationtype(b));
        }
        return new InnerNodeVector<Annotationtype>(elems);
    }

    /**
     * This class represents documentmanager.annotationtype[].inherits[]
     */
    public final static class Inherits extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "id"
          ));

        private Integer id = null;

        public Builder() { }

        public Builder(Inherits config) {
          id(config.id());
        }

        private Builder override(Builder __superior) {
          if (__superior.id != null)
            id(__superior.id);
          return this;
        }

        public Builder id(int __value) {
          id = __value;
          __uninitialized.remove("id");
          return this;
        }

        private Builder id(String __value) {
          return id(Integer.valueOf(__value));
        }

        public Inherits build() {
          return new Inherits(this);
        }

      }

      private final IntegerNode id;

      public Inherits(Builder builder) {
        this(builder, true);
      }

      private Inherits(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);

        id = (builder.id == null) ?
            new IntegerNode() : new IntegerNode(builder.id);
      }

      /**
       * @return documentmanager.annotationtype[].inherits[].id
       */
      public int id() {
        return id.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
        return changes;
      }

      private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
          List<Inherits> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Inherits(b));
          }
          return new InnerNodeVector<Inherits>(elems);
      }
    }
  }

  /**
   * This class represents documentmanager.doctype[]
   */
  public final static class Doctype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "idx",
        "contentstruct"
        ));

      private String name = null;
      private Integer idx = null;
      public List<Inherits.Builder> inherits = new ArrayList<>();
      private Integer contentstruct = null;
      public Map<String, Fieldsets.Builder> fieldsets = new LinkedHashMap<>();
      public List<Importedfield.Builder> importedfield = new ArrayList<>();
      public List<Primitivetype.Builder> primitivetype = new ArrayList<>();
      public List<Arraytype.Builder> arraytype = new ArrayList<>();
      public List<Maptype.Builder> maptype = new ArrayList<>();
      public List<Wsettype.Builder> wsettype = new ArrayList<>();
      public List<Tensortype.Builder> tensortype = new ArrayList<>();
      public List<Documentref.Builder> documentref = new ArrayList<>();
      public List<Annotationtype.Builder> annotationtype = new ArrayList<>();
      public List<Annotationref.Builder> annotationref = new ArrayList<>();
      public List<Structtype.Builder> structtype = new ArrayList<>();

      public Builder() { }

      public Builder(Doctype config) {
        name(config.name());
        idx(config.idx());
        for (Inherits i : config.inherits()) {
          inherits(new Inherits.Builder(i));
        }
        contentstruct(config.contentstruct());
        for (Map.Entry<String, Fieldsets> __entry : config.fieldsets().entrySet()) {
          fieldsets(__entry.getKey(), new Fieldsets.Builder(__entry.getValue()));
        }
        for (Importedfield i : config.importedfield()) {
          importedfield(new Importedfield.Builder(i));
        }
        for (Primitivetype p : config.primitivetype()) {
          primitivetype(new Primitivetype.Builder(p));
        }
        for (Arraytype a : config.arraytype()) {
          arraytype(new Arraytype.Builder(a));
        }
        for (Maptype m : config.maptype()) {
          maptype(new Maptype.Builder(m));
        }
        for (Wsettype w : config.wsettype()) {
          wsettype(new Wsettype.Builder(w));
        }
        for (Tensortype t : config.tensortype()) {
          tensortype(new Tensortype.Builder(t));
        }
        for (Documentref d : config.documentref()) {
          documentref(new Documentref.Builder(d));
        }
        for (Annotationtype a : config.annotationtype()) {
          annotationtype(new Annotationtype.Builder(a));
        }
        for (Annotationref a : config.annotationref()) {
          annotationref(new Annotationref.Builder(a));
        }
        for (Structtype s : config.structtype()) {
          structtype(new Structtype.Builder(s));
        }
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.idx != null)
          idx(__superior.idx);
        if (!__superior.inherits.isEmpty())
          inherits.addAll(__superior.inherits);
        if (__superior.contentstruct != null)
          contentstruct(__superior.contentstruct);
        fieldsets(__superior.fieldsets);
        if (!__superior.importedfield.isEmpty())
          importedfield.addAll(__superior.importedfield);
        if (!__superior.primitivetype.isEmpty())
          primitivetype.addAll(__superior.primitivetype);
        if (!__superior.arraytype.isEmpty())
          arraytype.addAll(__superior.arraytype);
        if (!__superior.maptype.isEmpty())
          maptype.addAll(__superior.maptype);
        if (!__superior.wsettype.isEmpty())
          wsettype.addAll(__superior.wsettype);
        if (!__superior.tensortype.isEmpty())
          tensortype.addAll(__superior.tensortype);
        if (!__superior.documentref.isEmpty())
          documentref.addAll(__superior.documentref);
        if (!__superior.annotationtype.isEmpty())
          annotationtype.addAll(__superior.annotationtype);
        if (!__superior.annotationref.isEmpty())
          annotationref.addAll(__superior.annotationref);
        if (!__superior.structtype.isEmpty())
          structtype.addAll(__superior.structtype);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder idx(int __value) {
        idx = __value;
        __uninitialized.remove("idx");
        return this;
      }

      private Builder idx(String __value) {
        return idx(Integer.valueOf(__value));
      }

      /**
       * Add the given builder to this builder's list of Inherits builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder inherits(Inherits.Builder __builder) {
        inherits.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
        Inherits.Builder __inner = new Inherits.Builder();
        __func.accept(__inner);
        inherits.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Inherits builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder inherits(List<Inherits.Builder> __builders) {
        inherits = __builders;
        return this;
      }

      public Builder contentstruct(int __value) {
        contentstruct = __value;
        __uninitialized.remove("contentstruct");
        return this;
      }

      private Builder contentstruct(String __value) {
        return contentstruct(Integer.valueOf(__value));
      }

      public Builder fieldsets(String __key, Fieldsets.Builder __value) {
        fieldsets.put(__key, __value);
        return this;
      }

      public Builder fieldsets(Map<String, Fieldsets.Builder> __values) {
        fieldsets.putAll(__values);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before using it as the value
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder fieldsets(String __key, java.util.function.Consumer<Fieldsets.Builder> __func) {
        Fieldsets.Builder __inner = new Fieldsets.Builder();
        __func.accept(__inner);
        fieldsets.put(__key, __inner);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Importedfield builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder importedfield(Importedfield.Builder __builder) {
        importedfield.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder importedfield(java.util.function.Consumer<Importedfield.Builder> __func) {
        Importedfield.Builder __inner = new Importedfield.Builder();
        __func.accept(__inner);
        importedfield.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Importedfield builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder importedfield(List<Importedfield.Builder> __builders) {
        importedfield = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Primitivetype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder primitivetype(Primitivetype.Builder __builder) {
        primitivetype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder primitivetype(java.util.function.Consumer<Primitivetype.Builder> __func) {
        Primitivetype.Builder __inner = new Primitivetype.Builder();
        __func.accept(__inner);
        primitivetype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Primitivetype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder primitivetype(List<Primitivetype.Builder> __builders) {
        primitivetype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Arraytype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder arraytype(Arraytype.Builder __builder) {
        arraytype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder arraytype(java.util.function.Consumer<Arraytype.Builder> __func) {
        Arraytype.Builder __inner = new Arraytype.Builder();
        __func.accept(__inner);
        arraytype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Arraytype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder arraytype(List<Arraytype.Builder> __builders) {
        arraytype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Maptype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder maptype(Maptype.Builder __builder) {
        maptype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder maptype(java.util.function.Consumer<Maptype.Builder> __func) {
        Maptype.Builder __inner = new Maptype.Builder();
        __func.accept(__inner);
        maptype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Maptype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder maptype(List<Maptype.Builder> __builders) {
        maptype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Wsettype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder wsettype(Wsettype.Builder __builder) {
        wsettype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder wsettype(java.util.function.Consumer<Wsettype.Builder> __func) {
        Wsettype.Builder __inner = new Wsettype.Builder();
        __func.accept(__inner);
        wsettype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Wsettype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder wsettype(List<Wsettype.Builder> __builders) {
        wsettype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Tensortype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder tensortype(Tensortype.Builder __builder) {
        tensortype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder tensortype(java.util.function.Consumer<Tensortype.Builder> __func) {
        Tensortype.Builder __inner = new Tensortype.Builder();
        __func.accept(__inner);
        tensortype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Tensortype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder tensortype(List<Tensortype.Builder> __builders) {
        tensortype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Documentref builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder documentref(Documentref.Builder __builder) {
        documentref.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder documentref(java.util.function.Consumer<Documentref.Builder> __func) {
        Documentref.Builder __inner = new Documentref.Builder();
        __func.accept(__inner);
        documentref.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Documentref builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder documentref(List<Documentref.Builder> __builders) {
        documentref = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationtype(Annotationtype.Builder __builder) {
        annotationtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationtype(java.util.function.Consumer<Annotationtype.Builder> __func) {
        Annotationtype.Builder __inner = new Annotationtype.Builder();
        __func.accept(__inner);
        annotationtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationtype(List<Annotationtype.Builder> __builders) {
        annotationtype = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Annotationref builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder annotationref(Annotationref.Builder __builder) {
        annotationref.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder annotationref(java.util.function.Consumer<Annotationref.Builder> __func) {
        Annotationref.Builder __inner = new Annotationref.Builder();
        __func.accept(__inner);
        annotationref.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Annotationref builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder annotationref(List<Annotationref.Builder> __builders) {
        annotationref = __builders;
        return this;
      }

      /**
       * Add the given builder to this builder's list of Structtype builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder structtype(Structtype.Builder __builder) {
        structtype.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder structtype(java.util.function.Consumer<Structtype.Builder> __func) {
        Structtype.Builder __inner = new Structtype.Builder();
        __func.accept(__inner);
        structtype.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Structtype builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder structtype(List<Structtype.Builder> __builders) {
        structtype = __builders;
        return this;
      }

      public Doctype build() {
        return new Doctype(this);
      }

    }

    // Here starts a new model for how datatypes are configured, where
    // everything is per document-type, and each documenttype contains the
    // datatypes it defines. Will be used (only?) if the arrays above
    // (datatype[] and annotationtype[]) are empty.
    // Note: we will include the built-in "document" document
    // type that all other doctypes inherit from also, in order
    // to get all the primitive and built-in types declared
    // with an idx we can refer to.
    // Name of the document type. Must be unique.
    private final StringNode name;
    // Note: indexes are only meaningful as internal references in this
    // config; they will typically be sequential (1,2,3,...) in the order
    // that they are generated (but nothing should depend on that).
    // Index of this type (as a datatype which can be referred to).
    private final IntegerNode idx;
    private final InnerNodeVector<Inherits> inherits;
    // Index of struct defining document fields
    private final IntegerNode contentstruct;
    private final Map<String, Fieldsets> fieldsets;
    private final InnerNodeVector<Importedfield> importedfield;
    private final InnerNodeVector<Primitivetype> primitivetype;
    private final InnerNodeVector<Arraytype> arraytype;
    private final InnerNodeVector<Maptype> maptype;
    private final InnerNodeVector<Wsettype> wsettype;
    private final InnerNodeVector<Tensortype> tensortype;
    private final InnerNodeVector<Documentref> documentref;
    private final InnerNodeVector<Annotationtype> annotationtype;
    private final InnerNodeVector<Annotationref> annotationref;
    private final InnerNodeVector<Structtype> structtype;

    public Doctype(Builder builder) {
      this(builder, true);
    }

    private Doctype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "documentmanager.doctype[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      idx = (builder.idx == null) ?
          new IntegerNode() : new IntegerNode(builder.idx);
      inherits = Inherits.createVector(builder.inherits);
      contentstruct = (builder.contentstruct == null) ?
          new IntegerNode() : new IntegerNode(builder.contentstruct);
      fieldsets = Fieldsets.createMap(builder.fieldsets);
      importedfield = Importedfield.createVector(builder.importedfield);
      primitivetype = Primitivetype.createVector(builder.primitivetype);
      arraytype = Arraytype.createVector(builder.arraytype);
      maptype = Maptype.createVector(builder.maptype);
      wsettype = Wsettype.createVector(builder.wsettype);
      tensortype = Tensortype.createVector(builder.tensortype);
      documentref = Documentref.createVector(builder.documentref);
      annotationtype = Annotationtype.createVector(builder.annotationtype);
      annotationref = Annotationref.createVector(builder.annotationref);
      structtype = Structtype.createVector(builder.structtype);
    }

    /**
     * @return documentmanager.doctype[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return documentmanager.doctype[].idx
     */
    public int idx() {
      return idx.value();
    }

    /**
     * @return documentmanager.doctype[].inherits[]
     */
    public List<Inherits> inherits() {
      return inherits;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].inherits[]
     */
    public Inherits inherits(int i) {
      return inherits.get(i);
    }

    /**
     * @return documentmanager.doctype[].contentstruct
     */
    public int contentstruct() {
      return contentstruct.value();
    }

    /**
     * @return documentmanager.doctype[].fieldsets{}
     */
    public Map<String, Fieldsets> fieldsets() {
      return Collections.unmodifiableMap(fieldsets);
    }

    /**
     * @param key the key of the value to return
     * @return documentmanager.doctype[].fieldsets{}
     */
    public Fieldsets fieldsets(String key) {
      return fieldsets.get(key);
    }

    /**
     * @return documentmanager.doctype[].importedfield[]
     */
    public List<Importedfield> importedfield() {
      return importedfield;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].importedfield[]
     */
    public Importedfield importedfield(int i) {
      return importedfield.get(i);
    }

    /**
     * @return documentmanager.doctype[].primitivetype[]
     */
    public List<Primitivetype> primitivetype() {
      return primitivetype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].primitivetype[]
     */
    public Primitivetype primitivetype(int i) {
      return primitivetype.get(i);
    }

    /**
     * @return documentmanager.doctype[].arraytype[]
     */
    public List<Arraytype> arraytype() {
      return arraytype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].arraytype[]
     */
    public Arraytype arraytype(int i) {
      return arraytype.get(i);
    }

    /**
     * @return documentmanager.doctype[].maptype[]
     */
    public List<Maptype> maptype() {
      return maptype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].maptype[]
     */
    public Maptype maptype(int i) {
      return maptype.get(i);
    }

    /**
     * @return documentmanager.doctype[].wsettype[]
     */
    public List<Wsettype> wsettype() {
      return wsettype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].wsettype[]
     */
    public Wsettype wsettype(int i) {
      return wsettype.get(i);
    }

    /**
     * @return documentmanager.doctype[].tensortype[]
     */
    public List<Tensortype> tensortype() {
      return tensortype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].tensortype[]
     */
    public Tensortype tensortype(int i) {
      return tensortype.get(i);
    }

    /**
     * @return documentmanager.doctype[].documentref[]
     */
    public List<Documentref> documentref() {
      return documentref;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].documentref[]
     */
    public Documentref documentref(int i) {
      return documentref.get(i);
    }

    /**
     * @return documentmanager.doctype[].annotationtype[]
     */
    public List<Annotationtype> annotationtype() {
      return annotationtype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].annotationtype[]
     */
    public Annotationtype annotationtype(int i) {
      return annotationtype.get(i);
    }

    /**
     * @return documentmanager.doctype[].annotationref[]
     */
    public List<Annotationref> annotationref() {
      return annotationref;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].annotationref[]
     */
    public Annotationref annotationref(int i) {
      return annotationref.get(i);
    }

    /**
     * @return documentmanager.doctype[].structtype[]
     */
    public List<Structtype> structtype() {
      return structtype;
    }

    /**
     * @param i the index of the value to return
     * @return documentmanager.doctype[].structtype[]
     */
    public Structtype structtype(int i) {
      return structtype.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Doctype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("doctype");
      return changes;
    }

    private static InnerNodeVector<Doctype> createVector(List<Builder> builders) {
        List<Doctype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Doctype(b));
        }
        return new InnerNodeVector<Doctype>(elems);
    }

    /**
     * This class represents documentmanager.doctype[].inherits[]
     */
    public final static class Inherits extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx"
          ));

        private Integer idx = null;

        public Builder() { }

        public Builder(Inherits config) {
          idx(config.idx());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Inherits build() {
          return new Inherits(this);
        }

      }

      // Could also use name here?
      // Specify document types to inherit
      private final IntegerNode idx;

      public Inherits(Builder builder) {
        this(builder, true);
      }

      private Inherits(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].inherits[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
      }

      /**
       * @return documentmanager.doctype[].inherits[].idx
       */
      public int idx() {
        return idx.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
        return changes;
      }

      private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
          List<Inherits> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Inherits(b));
          }
          return new InnerNodeVector<Inherits>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].fieldsets{}
     */
    public final static class Fieldsets extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>();

        public List<String> fields = new ArrayList<>();

        public Builder() { }

        public Builder(Fieldsets config) {
          fields(config.fields());
        }

        private Builder override(Builder __superior) {
          if (!__superior.fields.isEmpty())
            fields.addAll(__superior.fields);
          return this;
        }

        public Builder fields(String __value) {
          fields.add(__value);
          return this;
        }

        public Builder fields(Collection<String> __values) {
          fields.addAll(__values);
          return this;
        }

        public Fieldsets build() {
          return new Fieldsets(this);
        }

      }

      // Field sets available for this document type
      private final LeafNodeVector<String, StringNode> fields;

      public Fieldsets(Builder builder) {
        this(builder, true);
      }

      private Fieldsets(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].fieldsets{} must be initialized: " + builder.__uninitialized);

        fields = new LeafNodeVector<>(builder.fields, new StringNode());
      }

      /**
       * @return documentmanager.doctype[].fieldsets{}.fields[]
       */
      public List<String> fields() {
        return fields.asList();
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.doctype[].fieldsets{}.fields[]
       */
      public String fields(int i) {
        return fields.get(i).value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Fieldsets newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("fieldsets");
        return changes;
      }

      private static Map<String, Fieldsets> createMap(Map<String, Builder> builders) {
        Map<String, Fieldsets> ret = new LinkedHashMap<>();
        for(String key : builders.keySet()) {
          ret.put(key, new Fieldsets(builders.get(key)));
        }
        return Collections.unmodifiableMap(ret);
      }
    }

    /**
     * This class represents documentmanager.doctype[].importedfield[]
     */
    public final static class Importedfield extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "name"
          ));

        private String name = null;

        public Builder() { }

        public Builder(Importedfield config) {
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Importedfield build() {
          return new Importedfield(this);
        }

      }

      // Imported fields (specified outside the document block in the schema)
      private final StringNode name;

      public Importedfield(Builder builder) {
        this(builder, true);
      }

      private Importedfield(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].importedfield[] must be initialized: " + builder.__uninitialized);

        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return documentmanager.doctype[].importedfield[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Importedfield newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("importedfield");
        return changes;
      }

      private static InnerNodeVector<Importedfield> createVector(List<Builder> builders) {
          List<Importedfield> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Importedfield(b));
          }
          return new InnerNodeVector<Importedfield>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].primitivetype[]
     */
    public final static class Primitivetype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name"
          ));

        private Integer idx = null;
        private String name = null;

        public Builder() { }

        public Builder(Primitivetype config) {
          idx(config.idx());
          name(config.name());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Primitivetype build() {
          return new Primitivetype(this);
        }

      }

      // Everything below here is configuration of data types defined by
      // this document type.
      // Primitive types must be present as built-in static members.
      // Index of primitive type
      private final IntegerNode idx;
      // The name of this primitive type
      private final StringNode name;

      public Primitivetype(Builder builder) {
        this(builder, true);
      }

      private Primitivetype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].primitivetype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
      }

      /**
       * @return documentmanager.doctype[].primitivetype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].primitivetype[].name
       */
      public String name() {
        return name.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Primitivetype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("primitivetype");
        return changes;
      }

      private static InnerNodeVector<Primitivetype> createVector(List<Builder> builders) {
          List<Primitivetype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Primitivetype(b));
          }
          return new InnerNodeVector<Primitivetype>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].arraytype[]
     */
    public final static class Arraytype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "elementtype"
          ));

        private Integer idx = null;
        private Integer elementtype = null;

        public Builder() { }

        public Builder(Arraytype config) {
          idx(config.idx());
          elementtype(config.elementtype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.elementtype != null)
            elementtype(__superior.elementtype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder elementtype(int __value) {
          elementtype = __value;
          __uninitialized.remove("elementtype");
          return this;
        }

        private Builder elementtype(String __value) {
          return elementtype(Integer.valueOf(__value));
        }

        public Arraytype build() {
          return new Arraytype(this);
        }

      }

      // Arrays are the simplest collection type:
      // Index of this array type
      private final IntegerNode idx;
      // Index of the element type this array type contains
      private final IntegerNode elementtype;

      public Arraytype(Builder builder) {
        this(builder, true);
      }

      private Arraytype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].arraytype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        elementtype = (builder.elementtype == null) ?
            new IntegerNode() : new IntegerNode(builder.elementtype);
      }

      /**
       * @return documentmanager.doctype[].arraytype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].arraytype[].elementtype
       */
      public int elementtype() {
        return elementtype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Arraytype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("arraytype");
        return changes;
      }

      private static InnerNodeVector<Arraytype> createVector(List<Builder> builders) {
          List<Arraytype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Arraytype(b));
          }
          return new InnerNodeVector<Arraytype>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].maptype[]
     */
    public final static class Maptype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "keytype",
          "valuetype"
          ));

        private Integer idx = null;
        private Integer keytype = null;
        private Integer valuetype = null;

        public Builder() { }

        public Builder(Maptype config) {
          idx(config.idx());
          keytype(config.keytype());
          valuetype(config.valuetype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.keytype != null)
            keytype(__superior.keytype);
          if (__superior.valuetype != null)
            valuetype(__superior.valuetype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder keytype(int __value) {
          keytype = __value;
          __uninitialized.remove("keytype");
          return this;
        }

        private Builder keytype(String __value) {
          return keytype(Integer.valueOf(__value));
        }

        public Builder valuetype(int __value) {
          valuetype = __value;
          __uninitialized.remove("valuetype");
          return this;
        }

        private Builder valuetype(String __value) {
          return valuetype(Integer.valueOf(__value));
        }

        public Maptype build() {
          return new Maptype(this);
        }

      }

      // Maps are another collection type:
      // Index of this map type
      private final IntegerNode idx;
      // Index of the key type used by this map type
      private final IntegerNode keytype;
      // Index of the key type used by this map type
      private final IntegerNode valuetype;

      public Maptype(Builder builder) {
        this(builder, true);
      }

      private Maptype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].maptype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        keytype = (builder.keytype == null) ?
            new IntegerNode() : new IntegerNode(builder.keytype);
        valuetype = (builder.valuetype == null) ?
            new IntegerNode() : new IntegerNode(builder.valuetype);
      }

      /**
       * @return documentmanager.doctype[].maptype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].maptype[].keytype
       */
      public int keytype() {
        return keytype.value();
      }

      /**
       * @return documentmanager.doctype[].maptype[].valuetype
       */
      public int valuetype() {
        return valuetype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Maptype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("maptype");
        return changes;
      }

      private static InnerNodeVector<Maptype> createVector(List<Builder> builders) {
          List<Maptype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Maptype(b));
          }
          return new InnerNodeVector<Maptype>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].wsettype[]
     */
    public final static class Wsettype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "elementtype"
          ));

        private Integer idx = null;
        private Integer elementtype = null;
        private Boolean createifnonexistent = null;
        private Boolean removeifzero = null;

        public Builder() { }

        public Builder(Wsettype config) {
          idx(config.idx());
          elementtype(config.elementtype());
          createifnonexistent(config.createifnonexistent());
          removeifzero(config.removeifzero());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.elementtype != null)
            elementtype(__superior.elementtype);
          if (__superior.createifnonexistent != null)
            createifnonexistent(__superior.createifnonexistent);
          if (__superior.removeifzero != null)
            removeifzero(__superior.removeifzero);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder elementtype(int __value) {
          elementtype = __value;
          __uninitialized.remove("elementtype");
          return this;
        }

        private Builder elementtype(String __value) {
          return elementtype(Integer.valueOf(__value));
        }

        public Builder createifnonexistent(boolean __value) {
          createifnonexistent = __value;
          return this;
        }

        private Builder createifnonexistent(String __value) {
          return createifnonexistent(Boolean.valueOf(__value));
        }

        public Builder removeifzero(boolean __value) {
          removeifzero = __value;
          return this;
        }

        private Builder removeifzero(String __value) {
          return removeifzero(Boolean.valueOf(__value));
        }

        public Wsettype build() {
          return new Wsettype(this);
        }

      }

      // Weighted sets are more complicated;
      // they can be considered as an collection
      // of unique elements where each element has
      // an associated weight:
      // Index of this weighted set type
      private final IntegerNode idx;
      // Index of the element types contained in this weighted set type
      private final IntegerNode elementtype;
      // Should an update to a nonexistent element cause it to be created
      private final BooleanNode createifnonexistent;
      // Should an element in a weighted set be removed if an update changes the weight to 0
      private final BooleanNode removeifzero;

      public Wsettype(Builder builder) {
        this(builder, true);
      }

      private Wsettype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].wsettype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        elementtype = (builder.elementtype == null) ?
            new IntegerNode() : new IntegerNode(builder.elementtype);
        createifnonexistent = (builder.createifnonexistent == null) ?
            new BooleanNode(false) : new BooleanNode(builder.createifnonexistent);
        removeifzero = (builder.removeifzero == null) ?
            new BooleanNode(false) : new BooleanNode(builder.removeifzero);
      }

      /**
       * @return documentmanager.doctype[].wsettype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].wsettype[].elementtype
       */
      public int elementtype() {
        return elementtype.value();
      }

      /**
       * @return documentmanager.doctype[].wsettype[].createifnonexistent
       */
      public boolean createifnonexistent() {
        return createifnonexistent.value();
      }

      /**
       * @return documentmanager.doctype[].wsettype[].removeifzero
       */
      public boolean removeifzero() {
        return removeifzero.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Wsettype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("wsettype");
        return changes;
      }

      private static InnerNodeVector<Wsettype> createVector(List<Builder> builders) {
          List<Wsettype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Wsettype(b));
          }
          return new InnerNodeVector<Wsettype>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].tensortype[]
     */
    public final static class Tensortype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "detailedtype"
          ));

        private Integer idx = null;
        private String detailedtype = null;

        public Builder() { }

        public Builder(Tensortype config) {
          idx(config.idx());
          detailedtype(config.detailedtype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.detailedtype != null)
            detailedtype(__superior.detailedtype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder detailedtype(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          detailedtype = __value;
          __uninitialized.remove("detailedtype");
          return this;
        }


        public Tensortype build() {
          return new Tensortype(this);
        }

      }

      // Tensors have their own type system
      // Index of this tensor type
      private final IntegerNode idx;
      // Description of the type of the actual tensors contained
      private final StringNode detailedtype;

      public Tensortype(Builder builder) {
        this(builder, true);
      }

      private Tensortype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].tensortype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        detailedtype = (builder.detailedtype == null) ?
            new StringNode() : new StringNode(builder.detailedtype);
      }

      /**
       * @return documentmanager.doctype[].tensortype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].tensortype[].detailedtype
       */
      public String detailedtype() {
        return detailedtype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Tensortype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("tensortype");
        return changes;
      }

      private static InnerNodeVector<Tensortype> createVector(List<Builder> builders) {
          List<Tensortype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Tensortype(b));
          }
          return new InnerNodeVector<Tensortype>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].documentref[]
     */
    public final static class Documentref extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "targettype"
          ));

        private Integer idx = null;
        private Integer targettype = null;

        public Builder() { }

        public Builder(Documentref config) {
          idx(config.idx());
          targettype(config.targettype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.targettype != null)
            targettype(__superior.targettype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder targettype(int __value) {
          targettype = __value;
          __uninitialized.remove("targettype");
          return this;
        }

        private Builder targettype(String __value) {
          return targettype(Integer.valueOf(__value));
        }

        public Documentref build() {
          return new Documentref(this);
        }

      }

      // Document references refer to parent documents that a document can
      // import fields from:
      // Index of this reference data type:
      private final IntegerNode idx;
      // Could also use name?
      // Index of the document type this reference type refers to:
      private final IntegerNode targettype;

      public Documentref(Builder builder) {
        this(builder, true);
      }

      private Documentref(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].documentref[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        targettype = (builder.targettype == null) ?
            new IntegerNode() : new IntegerNode(builder.targettype);
      }

      /**
       * @return documentmanager.doctype[].documentref[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].documentref[].targettype
       */
      public int targettype() {
        return targettype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Documentref newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("documentref");
        return changes;
      }

      private static InnerNodeVector<Documentref> createVector(List<Builder> builders) {
          List<Documentref> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Documentref(b));
          }
          return new InnerNodeVector<Documentref>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].annotationtype[]
     */
    public final static class Annotationtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name"
          ));

        private Integer idx = null;
        private String name = null;
        private Integer internalid = null;
        private Integer datatype = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();

        public Builder() { }

        public Builder(Annotationtype config) {
          idx(config.idx());
          name(config.name());
          internalid(config.internalid());
          datatype(config.datatype());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          if (__superior.internalid != null)
            internalid(__superior.internalid);
          if (__superior.datatype != null)
            datatype(__superior.datatype);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        public Builder internalid(int __value) {
          internalid = __value;
          return this;
        }

        private Builder internalid(String __value) {
          return internalid(Integer.valueOf(__value));
        }

        public Builder datatype(int __value) {
          datatype = __value;
          return this;
        }

        private Builder datatype(String __value) {
          return datatype(Integer.valueOf(__value));
        }

        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        public Annotationtype build() {
          return new Annotationtype(this);
        }

      }

      // Annotation types are another world, but are modeled here
      // as if they were also datatypes contained inside document types:
      // Index of an annotation type.
      private final IntegerNode idx;
      // Name of the annotation type.
      private final StringNode name;
      // Could we somehow avoid this?
      // Internal id of this annotation type
      private final IntegerNode internalid;
      // Index of contained datatype of the annotation type, if any
      private final IntegerNode datatype;
      private final InnerNodeVector<Inherits> inherits;

      public Annotationtype(Builder builder) {
        this(builder, true);
      }

      private Annotationtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].annotationtype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        internalid = (builder.internalid == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.internalid);
        datatype = (builder.datatype == null) ?
            new IntegerNode(-1) : new IntegerNode(builder.datatype);
        inherits = Inherits.createVector(builder.inherits);
      }

      /**
       * @return documentmanager.doctype[].annotationtype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].annotationtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documentmanager.doctype[].annotationtype[].internalid
       */
      public int internalid() {
        return internalid.value();
      }

      /**
       * @return documentmanager.doctype[].annotationtype[].datatype
       */
      public int datatype() {
        return datatype.value();
      }

      /**
       * @return documentmanager.doctype[].annotationtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.doctype[].annotationtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationtype");
        return changes;
      }

      private static InnerNodeVector<Annotationtype> createVector(List<Builder> builders) {
          List<Annotationtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationtype(b));
          }
          return new InnerNodeVector<Annotationtype>(elems);
      }

      /**
       * This class represents documentmanager.doctype[].annotationtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "idx"
            ));

          private Integer idx = null;

          public Builder() { }

          public Builder(Inherits config) {
            idx(config.idx());
          }

          private Builder override(Builder __superior) {
            if (__superior.idx != null)
              idx(__superior.idx);
            return this;
          }

          public Builder idx(int __value) {
            idx = __value;
            __uninitialized.remove("idx");
            return this;
          }

          private Builder idx(String __value) {
            return idx(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Index of annotation type that this type inherits.
        private final IntegerNode idx;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.doctype[].annotationtype[].inherits[] must be initialized: " + builder.__uninitialized);

          idx = (builder.idx == null) ?
              new IntegerNode() : new IntegerNode(builder.idx);
        }

        /**
         * @return documentmanager.doctype[].annotationtype[].inherits[].idx
         */
        public int idx() {
          return idx.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }
    }

    /**
     * This class represents documentmanager.doctype[].annotationref[]
     */
    public final static class Annotationref extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "annotationtype"
          ));

        private Integer idx = null;
        private Integer annotationtype = null;

        public Builder() { }

        public Builder(Annotationref config) {
          idx(config.idx());
          annotationtype(config.annotationtype());
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.annotationtype != null)
            annotationtype(__superior.annotationtype);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder annotationtype(int __value) {
          annotationtype = __value;
          __uninitialized.remove("annotationtype");
          return this;
        }

        private Builder annotationtype(String __value) {
          return annotationtype(Integer.valueOf(__value));
        }

        public Annotationref build() {
          return new Annotationref(this);
        }

      }

      // Annotation references are field values referring to
      // an annotation of a certain annotation type.
      // Index of this annotation reference type
      private final IntegerNode idx;
      // Index of the annotation type this annotation reference type refers to
      private final IntegerNode annotationtype;

      public Annotationref(Builder builder) {
        this(builder, true);
      }

      private Annotationref(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].annotationref[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        annotationtype = (builder.annotationtype == null) ?
            new IntegerNode() : new IntegerNode(builder.annotationtype);
      }

      /**
       * @return documentmanager.doctype[].annotationref[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].annotationref[].annotationtype
       */
      public int annotationtype() {
        return annotationtype.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Annotationref newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("annotationref");
        return changes;
      }

      private static InnerNodeVector<Annotationref> createVector(List<Builder> builders) {
          List<Annotationref> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Annotationref(b));
          }
          return new InnerNodeVector<Annotationref>(elems);
      }
    }

    /**
     * This class represents documentmanager.doctype[].structtype[]
     */
    public final static class Structtype extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "idx",
          "name"
          ));

        private Integer idx = null;
        private String name = null;
        public List<Inherits.Builder> inherits = new ArrayList<>();
        public List<Field.Builder> field = new ArrayList<>();

        public Builder() { }

        public Builder(Structtype config) {
          idx(config.idx());
          name(config.name());
          for (Inherits i : config.inherits()) {
            inherits(new Inherits.Builder(i));
          }
          for (Field f : config.field()) {
            field(new Field.Builder(f));
          }
        }

        private Builder override(Builder __superior) {
          if (__superior.idx != null)
            idx(__superior.idx);
          if (__superior.name != null)
            name(__superior.name);
          if (!__superior.inherits.isEmpty())
            inherits.addAll(__superior.inherits);
          if (!__superior.field.isEmpty())
            field.addAll(__superior.field);
          return this;
        }

        public Builder idx(int __value) {
          idx = __value;
          __uninitialized.remove("idx");
          return this;
        }

        private Builder idx(String __value) {
          return idx(Integer.valueOf(__value));
        }

        public Builder name(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          name = __value;
          __uninitialized.remove("name");
          return this;
        }


        /**
         * Add the given builder to this builder's list of Inherits builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder inherits(Inherits.Builder __builder) {
          inherits.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder inherits(java.util.function.Consumer<Inherits.Builder> __func) {
          Inherits.Builder __inner = new Inherits.Builder();
          __func.accept(__inner);
          inherits.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Inherits builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder inherits(List<Inherits.Builder> __builders) {
          inherits = __builders;
          return this;
        }

        /**
         * Add the given builder to this builder's list of Field builders
         * @param __builder a builder
         * @return this builder
         */
        public Builder field(Field.Builder __builder) {
          field.add(__builder);
          return this;
        }

        /**
         * Make a new builder and run the supplied function on it before adding it to the list
         * @param __func lambda that modifies the given builder
         * @return this builder
         */
        public Builder field(java.util.function.Consumer<Field.Builder> __func) {
          Field.Builder __inner = new Field.Builder();
          __func.accept(__inner);
          field.add(__inner);
          return this;
        }

        /**
         * Set the given list as this builder's list of Field builders
         * @param __builders a list of builders
         * @return this builder
         */
        public Builder field(List<Field.Builder> __builders) {
          field = __builders;
          return this;
        }

        public Structtype build() {
          return new Structtype(this);
        }

      }

      // A struct is just a named collections of fields:
      // Index of this struct type
      private final IntegerNode idx;
      // Name of the struct type. Must be unique within documenttype.
      private final StringNode name;
      private final InnerNodeVector<Inherits> inherits;
      private final InnerNodeVector<Field> field;

      public Structtype(Builder builder) {
        this(builder, true);
      }

      private Structtype(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "documentmanager.doctype[].structtype[] must be initialized: " + builder.__uninitialized);

        idx = (builder.idx == null) ?
            new IntegerNode() : new IntegerNode(builder.idx);
        name = (builder.name == null) ?
            new StringNode() : new StringNode(builder.name);
        inherits = Inherits.createVector(builder.inherits);
        field = Field.createVector(builder.field);
      }

      /**
       * @return documentmanager.doctype[].structtype[].idx
       */
      public int idx() {
        return idx.value();
      }

      /**
       * @return documentmanager.doctype[].structtype[].name
       */
      public String name() {
        return name.value();
      }

      /**
       * @return documentmanager.doctype[].structtype[].inherits[]
       */
      public List<Inherits> inherits() {
        return inherits;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.doctype[].structtype[].inherits[]
       */
      public Inherits inherits(int i) {
        return inherits.get(i);
      }

      /**
       * @return documentmanager.doctype[].structtype[].field[]
       */
      public List<Field> field() {
        return field;
      }

      /**
       * @param i the index of the value to return
       * @return documentmanager.doctype[].structtype[].field[]
       */
      public Field field(int i) {
        return field.get(i);
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Structtype newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("structtype");
        return changes;
      }

      private static InnerNodeVector<Structtype> createVector(List<Builder> builders) {
          List<Structtype> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Structtype(b));
          }
          return new InnerNodeVector<Structtype>(elems);
      }

      /**
       * This class represents documentmanager.doctype[].structtype[].inherits[]
       */
      public final static class Inherits extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "type"
            ));

          private Integer type = null;

          public Builder() { }

          public Builder(Inherits config) {
            type(config.type());
          }

          private Builder override(Builder __superior) {
            if (__superior.type != null)
              type(__superior.type);
            return this;
          }

          public Builder type(int __value) {
            type = __value;
            __uninitialized.remove("type");
            return this;
          }

          private Builder type(String __value) {
            return type(Integer.valueOf(__value));
          }

          public Inherits build() {
            return new Inherits(this);
          }

        }

        // Index of another struct type to inherit
        private final IntegerNode type;

        public Inherits(Builder builder) {
          this(builder, true);
        }

        private Inherits(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.doctype[].structtype[].inherits[] must be initialized: " + builder.__uninitialized);

          type = (builder.type == null) ?
              new IntegerNode() : new IntegerNode(builder.type);
        }

        /**
         * @return documentmanager.doctype[].structtype[].inherits[].type
         */
        public int type() {
          return type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Inherits newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("inherits");
          return changes;
        }

        private static InnerNodeVector<Inherits> createVector(List<Builder> builders) {
            List<Inherits> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Inherits(b));
            }
            return new InnerNodeVector<Inherits>(elems);
        }
      }

      /**
       * This class represents documentmanager.doctype[].structtype[].field[]
       */
      public final static class Field extends InnerNode { 

        public static final class Builder implements ConfigBuilder {
          private Set<String> __uninitialized = new HashSet<String>(List.of(
            "name",
            "internalid",
            "type"
            ));

          private String name = null;
          private Integer internalid = null;
          private Integer type = null;

          public Builder() { }

          public Builder(Field config) {
            name(config.name());
            internalid(config.internalid());
            type(config.type());
          }

          private Builder override(Builder __superior) {
            if (__superior.name != null)
              name(__superior.name);
            if (__superior.internalid != null)
              internalid(__superior.internalid);
            if (__superior.type != null)
              type(__superior.type);
            return this;
          }

          public Builder name(String __value) {
          if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
            name = __value;
            __uninitialized.remove("name");
            return this;
          }


          public Builder internalid(int __value) {
            internalid = __value;
            __uninitialized.remove("internalid");
            return this;
          }

          private Builder internalid(String __value) {
            return internalid(Integer.valueOf(__value));
          }

          public Builder type(int __value) {
            type = __value;
            __uninitialized.remove("type");
            return this;
          }

          private Builder type(String __value) {
            return type(Integer.valueOf(__value));
          }

          public Field build() {
            return new Field(this);
          }

        }

        // Name of a struct field. Must be unique within the struct type.
        private final StringNode name;
        // The "field id" - used in serialized format!
        private final IntegerNode internalid;
        // Index of the type of this field
        private final IntegerNode type;

        public Field(Builder builder) {
          this(builder, true);
        }

        private Field(Builder builder, boolean throwIfUninitialized) {
          if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
            throw new IllegalArgumentException("The following builder parameters for " +
                "documentmanager.doctype[].structtype[].field[] must be initialized: " + builder.__uninitialized);

          name = (builder.name == null) ?
              new StringNode() : new StringNode(builder.name);
          internalid = (builder.internalid == null) ?
              new IntegerNode() : new IntegerNode(builder.internalid);
          type = (builder.type == null) ?
              new IntegerNode() : new IntegerNode(builder.type);
        }

        /**
         * @return documentmanager.doctype[].structtype[].field[].name
         */
        public String name() {
          return name.value();
        }

        /**
         * @return documentmanager.doctype[].structtype[].field[].internalid
         */
        public int internalid() {
          return internalid.value();
        }

        /**
         * @return documentmanager.doctype[].structtype[].field[].type
         */
        public int type() {
          return type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Field newConfig) {
          ChangesRequiringRestart changes = new ChangesRequiringRestart("field");
          return changes;
        }

        private static InnerNodeVector<Field> createVector(List<Builder> builders) {
            List<Field> elems = new ArrayList<>();
            for (Builder b : builders) {
                elems.add(new Field(b));
            }
            return new InnerNodeVector<Field>(elems);
        }
      }
    }
  }

}
