/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.select.rule;

import com.yahoo.document.BucketIdFactory;
import com.yahoo.document.DocumentId;
import com.yahoo.document.select.BucketSet;
import com.yahoo.document.select.Context;
import com.yahoo.document.select.Visitor;
import com.yahoo.document.select.rule.ExpressionNode;

public class IdNode
implements ExpressionNode {
    private String field;
    private short widthBits = (short)-1;
    private short divisionBits = (short)-1;

    public String getField() {
        return this.field;
    }

    public IdNode setField(String field) {
        this.field = field;
        return this;
    }

    public IdNode setWidthBits(short widthBits) {
        this.widthBits = widthBits;
        return this;
    }

    public IdNode setDivisionBits(short divisionBits) {
        this.divisionBits = divisionBits;
        return this;
    }

    @Override
    public BucketSet getBucketSet(BucketIdFactory factory) {
        return null;
    }

    @Override
    public Object evaluate(Context context) {
        DocumentId id = context.getDocumentOperation().getId();
        if (id == null) {
            throw new IllegalStateException("Document has no identifier.");
        }
        if (this.field == null) {
            return id.toString();
        }
        if (this.field.equalsIgnoreCase("scheme")) {
            return id.getScheme().getType().toString();
        }
        if (this.field.equalsIgnoreCase("namespace")) {
            return id.getScheme().getNamespace();
        }
        if (this.field.equalsIgnoreCase("specific")) {
            return id.getScheme().getNamespaceSpecific();
        }
        if (this.field.equalsIgnoreCase("group")) {
            if (id.getScheme().hasGroup()) {
                return id.getScheme().getGroup();
            }
            throw new IllegalStateException("Group identifier is null.");
        }
        if (this.field.equalsIgnoreCase("user")) {
            if (id.getScheme().hasNumber()) {
                return id.getScheme().getNumber();
            }
            throw new IllegalStateException("User identifier is null.");
        }
        if (this.field.equalsIgnoreCase("type")) {
            if (id.getScheme().hasDocType()) {
                return id.getScheme().getDocType();
            }
            throw new IllegalStateException("Document id doesn't have doc type.");
        }
        throw new IllegalStateException("Identifier field '" + this.field + "' is not supported.");
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "id" + (String)(this.field != null ? "." + this.field : "") + (String)(this.widthBits != -1 ? "(" + this.widthBits + "," + this.divisionBits + ")" : "");
    }
}

