/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document.serialization;

import com.yahoo.compress.Compressor;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Document;
import com.yahoo.document.DocumentId;
import com.yahoo.document.DocumentType;
import com.yahoo.document.DocumentUpdate;
import com.yahoo.document.Field;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.document.annotation.AlternateSpanList;
import com.yahoo.document.annotation.Annotation;
import com.yahoo.document.annotation.AnnotationReference;
import com.yahoo.document.annotation.Span;
import com.yahoo.document.annotation.SpanList;
import com.yahoo.document.annotation.SpanNode;
import com.yahoo.document.annotation.SpanTree;
import com.yahoo.document.datatypes.Array;
import com.yahoo.document.datatypes.ByteFieldValue;
import com.yahoo.document.datatypes.CollectionFieldValue;
import com.yahoo.document.datatypes.DoubleFieldValue;
import com.yahoo.document.datatypes.FieldValue;
import com.yahoo.document.datatypes.FloatFieldValue;
import com.yahoo.document.datatypes.IntegerFieldValue;
import com.yahoo.document.datatypes.LongFieldValue;
import com.yahoo.document.datatypes.MapFieldValue;
import com.yahoo.document.datatypes.PredicateFieldValue;
import com.yahoo.document.datatypes.Raw;
import com.yahoo.document.datatypes.ReferenceFieldValue;
import com.yahoo.document.datatypes.StringFieldValue;
import com.yahoo.document.datatypes.Struct;
import com.yahoo.document.datatypes.StructuredFieldValue;
import com.yahoo.document.datatypes.TensorFieldValue;
import com.yahoo.document.datatypes.WeightedSet;
import com.yahoo.document.predicate.BinaryFormat;
import com.yahoo.document.predicate.Predicate;
import com.yahoo.document.serialization.DocumentSerializer;
import com.yahoo.document.serialization.SerializationException;
import com.yahoo.document.serialization.VespaDocumentSerializerHead;
import com.yahoo.document.update.AddValueUpdate;
import com.yahoo.document.update.ArithmeticValueUpdate;
import com.yahoo.document.update.AssignValueUpdate;
import com.yahoo.document.update.ClearValueUpdate;
import com.yahoo.document.update.FieldUpdate;
import com.yahoo.document.update.MapValueUpdate;
import com.yahoo.document.update.RemoveValueUpdate;
import com.yahoo.document.update.ValueUpdate;
import com.yahoo.io.GrowableByteBuffer;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.objects.BufferSerializer;
import com.yahoo.vespa.objects.FieldBase;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;

@Deprecated
public class VespaDocumentSerializer42
extends BufferSerializer
implements DocumentSerializer {
    private final Compressor compressor = new Compressor();
    private static final Logger log = Logger.getLogger(VespaDocumentSerializer42.class.getName());
    private boolean headerOnly;
    private int spanNodeCounter = -1;
    private int[] bytePositions;

    VespaDocumentSerializer42(GrowableByteBuffer buf) {
        super(buf);
    }

    VespaDocumentSerializer42(ByteBuffer buf) {
        super(buf);
    }

    VespaDocumentSerializer42(byte[] buf) {
        super(buf);
    }

    VespaDocumentSerializer42() {
    }

    VespaDocumentSerializer42(GrowableByteBuffer buf, boolean headerOnly) {
        this(buf);
        this.headerOnly = headerOnly;
    }

    public void setHeaderOnly(boolean headerOnly) {
        this.headerOnly = headerOnly;
    }

    @Override
    public void write(Document doc) {
        this.write((FieldBase)new Field(doc.getDataType().getName(), 0, doc.getDataType(), true), doc);
    }

    @Override
    public void write(FieldBase field, Document doc) {
        int startPos = this.buf.position();
        this.buf.putShort((short)8);
        this.buf.putInt(0);
        doc.getId().serialize(this);
        byte contents = 1;
        if (doc.getHeader().getFieldCount() > 0) {
            contents = (byte)(contents | 2);
        }
        if (!this.headerOnly && doc.getBody().getFieldCount() > 0) {
            contents = (byte)(contents | 4);
        }
        this.buf.put(contents);
        doc.getDataType().serialize(this);
        if (doc.getHeader().getFieldCount() > 0) {
            doc.getHeader().serialize(doc.getDataType().getField("header"), this);
        }
        if (!this.headerOnly && doc.getBody().getFieldCount() > 0) {
            doc.getBody().serialize(doc.getDataType().getField("body"), this);
        }
        int finalPos = this.buf.position();
        this.buf.position(startPos + 2);
        this.buf.putInt(finalPos - startPos - 2 - 4);
        this.buf.position(finalPos);
    }

    @Override
    public void write(FieldBase field, FieldValue value) {
        throw new IllegalArgumentException("Not Implemented");
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, Array<T> array) {
        this.buf.putInt1_2_4Bytes(array.size());
        List<T> lst = array.getValues();
        for (FieldValue value : lst) {
            value.serialize(this);
        }
    }

    @Override
    public <K extends FieldValue, V extends FieldValue> void write(FieldBase field, MapFieldValue<K, V> map) {
        this.buf.putInt1_2_4Bytes(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            ((FieldValue)e.getKey()).serialize(this);
            ((FieldValue)e.getValue()).serialize(this);
        }
    }

    @Override
    public void write(FieldBase field, ByteFieldValue value) {
        this.buf.put(value.getByte());
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, CollectionFieldValue<T> value) {
        throw new IllegalArgumentException("Not Implemented");
    }

    @Override
    public void write(FieldBase field, DoubleFieldValue value) {
        this.buf.putDouble(value.getDouble());
    }

    @Override
    public void write(FieldBase field, FloatFieldValue value) {
        this.buf.putFloat(value.getFloat());
    }

    @Override
    public void write(FieldBase field, IntegerFieldValue value) {
        this.buf.putInt(value.getInteger());
    }

    @Override
    public void write(FieldBase field, LongFieldValue value) {
        this.buf.putLong(value.getLong());
    }

    @Override
    public void write(FieldBase field, Raw value) {
        ByteBuffer rawBuf = value.getByteBuffer();
        int origPos = rawBuf.position();
        this.buf.putInt(rawBuf.remaining());
        this.buf.put(rawBuf);
        rawBuf.position(origPos);
    }

    @Override
    public void write(FieldBase field, PredicateFieldValue value) {
        byte[] buf = BinaryFormat.encode((Predicate)value.getPredicate());
        this.buf.putInt(buf.length);
        this.buf.put(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(FieldBase field, StringFieldValue value) {
        byte[] stringBytes = VespaDocumentSerializer42.createUTF8CharArray((String)value.getString());
        byte coding = 0;
        if (!value.getSpanTrees().isEmpty()) {
            coding = (byte)(coding | 0x40);
        }
        this.buf.put(coding);
        this.buf.putInt1_4Bytes(stringBytes.length + 1);
        this.buf.put(stringBytes);
        this.buf.put((byte)0);
        Map<String, SpanTree> trees = value.getSpanTreeMap();
        if (trees != null && !trees.isEmpty()) {
            try {
                this.bytePositions = Utf8.calculateBytePositions((CharSequence)value.getString());
                int posBeforeSize = this.buf.position();
                this.buf.putInt(0);
                this.buf.putInt1_2_4Bytes(trees.size());
                for (SpanTree tree : trees.values()) {
                    try {
                        this.write(tree);
                    }
                    catch (SerializationException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw new SerializationException("Exception thrown while serializing span tree '" + tree.getName() + "'; string='" + value.getString() + "'", e);
                    }
                }
                int endPos = this.buf.position();
                this.buf.position(posBeforeSize);
                this.buf.putInt(endPos - posBeforeSize - 4);
                this.buf.position(endPos);
            }
            finally {
                this.bytePositions = null;
            }
        }
    }

    @Override
    public void write(FieldBase field, TensorFieldValue value) {
        if (value.getTensor().isPresent()) {
            byte[] encodedTensor = TypedBinaryFormat.encode((Tensor)value.getTensor().get());
            this.buf.putInt1_4Bytes(encodedTensor.length);
            this.buf.put(encodedTensor);
        } else {
            this.buf.putInt1_4Bytes(0);
        }
    }

    @Override
    public void write(FieldBase field, ReferenceFieldValue value) {
        if (value.getDocumentId().isPresent()) {
            this.buf.put((byte)1);
            this.write(value.getDocumentId().get());
        } else {
            this.buf.put((byte)0);
        }
    }

    @Override
    public void write(FieldBase field, Struct s) {
        GrowableByteBuffer buffer;
        GrowableByteBuffer bigBuffer = this.buf;
        this.buf = buffer = new GrowableByteBuffer(4096, 2.0f);
        LinkedList<Integer> fieldIds = new LinkedList<Integer>();
        LinkedList<Integer> fieldLengths = new LinkedList<Integer>();
        for (Map.Entry<Field, FieldValue> value : s.getFields()) {
            int startPos = buffer.position();
            value.getValue().serialize(value.getKey(), this);
            fieldLengths.add(buffer.position() - startPos);
            fieldIds.add(value.getKey().getId(s.getVersion()));
        }
        buffer.flip();
        this.buf = bigBuffer;
        int uncompressedSize = buffer.remaining();
        Compressor.Compression compression = s.getDataType().getCompressor().compress(buffer.getByteBuffer().array(), buffer.remaining());
        int lenPos = this.buf.position();
        this.putInt(null, 0);
        this.buf.put(compression.type().getCode());
        if (compression.data() != null && compression.type().isCompressed()) {
            this.buf.putInt2_4_8Bytes((long)uncompressedSize);
        }
        this.buf.putInt1_4Bytes(s.getFieldCount());
        for (int i = 0; i < s.getFieldCount(); ++i) {
            this.putInt1_4Bytes(null, (Integer)fieldIds.get(i));
            this.putInt2_4_8Bytes(null, ((Integer)fieldLengths.get(i)).intValue());
        }
        int pos = this.buf.position();
        if (compression.data() != null && compression.type().isCompressed()) {
            this.put(null, compression.data());
        } else {
            this.put(null, buffer.getByteBuffer());
        }
        int dataLength = this.buf.position() - pos;
        int posNow = this.buf.position();
        this.buf.position(lenPos);
        this.putInt(null, dataLength);
        this.buf.position(posNow);
    }

    @Override
    public void write(FieldBase field, StructuredFieldValue value) {
        throw new IllegalArgumentException("Not Implemented");
    }

    @Override
    public <T extends FieldValue> void write(FieldBase field, WeightedSet<T> ws) {
        WeightedSetDataType type = ws.getDataType();
        this.putInt(null, type.getNestedType().getId());
        this.putInt(null, ws.size());
        Iterator<T> it = ws.fieldValueIterator();
        while (it.hasNext()) {
            FieldValue key = (FieldValue)it.next();
            Integer value = ws.get(key);
            int sizePos = this.buf.position();
            this.putInt(null, 0);
            int startPos = this.buf.position();
            key.serialize(this);
            this.putInt(null, value);
            int finalPos = this.buf.position();
            int size = finalPos - startPos;
            this.buf.position(sizePos);
            this.putInt(null, size);
            this.buf.position(finalPos);
        }
    }

    @Override
    public void write(FieldBase field, AnnotationReference value) {
        int annotationId = value.getReference().getScratchId();
        if (annotationId < 0) {
            throw new SerializationException("Could not serialize AnnotationReference value, reference not found (" + value + ")");
        }
        this.buf.putInt1_2_4Bytes(annotationId);
    }

    @Override
    public void write(DocumentId id) {
        this.put(null, id.getScheme().toUtf8().getBytes());
        this.putByte(null, (byte)0);
    }

    @Override
    public void write(DocumentType type) {
        byte[] docType = VespaDocumentSerializer42.createUTF8CharArray((String)type.getName());
        this.put(null, docType);
        this.putByte(null, (byte)0);
        this.putShort(null, (short)0);
    }

    private static void serializeAttributeString(GrowableByteBuffer data, String input) {
        byte[] inputBytes = VespaDocumentSerializer42.createUTF8CharArray((String)input);
        data.put((byte)inputBytes.length);
        data.put(inputBytes);
        data.put((byte)0);
    }

    @Override
    public void write(Annotation annotation) {
        this.buf.putInt(annotation.getType().getId());
        byte features = 0;
        if (annotation.isSpanNodeValid()) {
            features = (byte)(features | 1);
        }
        if (annotation.hasFieldValue()) {
            features = (byte)(features | 2);
        }
        this.buf.put(features);
        int posBeforeSize = this.buf.position();
        this.buf.putInt1_2_4BytesAs4(0);
        if (annotation.isSpanNodeValid()) {
            int spanNodeId = annotation.getSpanNode().getScratchId();
            if (spanNodeId >= 0) {
                this.buf.putInt1_2_4Bytes(spanNodeId);
            } else {
                throw new SerializationException("Could not serialize annotation, associated SpanNode not found (" + annotation + ")");
            }
        }
        if (annotation.hasFieldValue()) {
            this.buf.putInt(annotation.getType().getDataType().getId());
            annotation.getFieldValue().serialize(this);
        }
        int end = this.buf.position();
        this.buf.position(posBeforeSize);
        this.buf.putInt1_2_4BytesAs4(end - posBeforeSize - 4);
        this.buf.position(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(SpanTree tree) {
        if (this.spanNodeCounter >= 0) {
            throw new SerializationException("Serialization of nested SpanTrees is not supported.");
        }
        this.spanNodeCounter = 0;
        tree.cleanup();
        try {
            new StringFieldValue(tree.getName()).serialize(this);
            this.write(tree.getRoot());
            ArrayList<Annotation> tmpAnnotationList = new ArrayList<Annotation>(tree.numAnnotations());
            for (Annotation annotation : tree) {
                tmpAnnotationList.add(annotation);
            }
            Collections.sort(tmpAnnotationList);
            int annotationCounter = 0;
            for (Annotation annotation : tmpAnnotationList) {
                annotation.setScratchId(annotationCounter++);
            }
            this.buf.putInt1_2_4Bytes(tmpAnnotationList.size());
            for (Annotation annotation : tmpAnnotationList) {
                this.write(annotation);
            }
        }
        finally {
            this.spanNodeCounter = -1;
        }
    }

    @Override
    public void write(SpanNode spanNode) {
        if (this.spanNodeCounter >= 0) {
            spanNode.setScratchId(this.spanNodeCounter++);
        }
        if (spanNode instanceof Span) {
            this.write((Span)spanNode);
        } else if (spanNode instanceof AlternateSpanList) {
            this.write((AlternateSpanList)spanNode);
        } else if (spanNode instanceof SpanList) {
            this.write((SpanList)spanNode);
        } else {
            throw new IllegalStateException("BUG!! Unable to serialize " + spanNode);
        }
    }

    @Override
    public void write(Span span) {
        this.buf.put((byte)1);
        if (this.bytePositions == null) {
            throw new SerializationException("Cannot serialize Span " + span + ", no access to parent StringFieldValue.");
        }
        int byteFrom = this.bytePositions[span.getFrom()];
        int byteLength = this.bytePositions[span.getFrom() + span.getLength()] - byteFrom;
        this.buf.putInt1_2_4Bytes(byteFrom);
        this.buf.putInt1_2_4Bytes(byteLength);
    }

    @Override
    public void write(SpanList spanList) {
        this.buf.put((byte)2);
        this.buf.putInt1_2_4Bytes(spanList.numChildren());
        ListIterator<SpanNode> children = spanList.childIterator();
        while (children.hasNext()) {
            this.write((SpanNode)children.next());
        }
    }

    @Override
    public void write(AlternateSpanList altSpanList) {
        this.buf.put((byte)4);
        this.buf.putInt1_2_4Bytes(altSpanList.getNumSubTrees());
        for (int i = 0; i < altSpanList.getNumSubTrees(); ++i) {
            this.buf.putDouble(altSpanList.getProbability(i));
            this.buf.putInt1_2_4Bytes(altSpanList.numChildren(i));
            ListIterator<SpanNode> children = altSpanList.childIterator(i);
            while (children.hasNext()) {
                this.write((SpanNode)children.next());
            }
        }
    }

    @Override
    public void write(DocumentUpdate update) {
        this.putShort(null, (short)8);
        update.getId().serialize(this);
        byte contents = 1;
        this.putByte(null, contents);
        update.getDocumentType().serialize(this);
        this.putInt(null, update.getFieldUpdates().size());
        for (FieldUpdate up : update.getFieldUpdates()) {
            up.serialize(this);
        }
    }

    @Override
    public void write(FieldUpdate update) {
        this.putInt(null, update.getField().getId(8));
        this.putInt(null, update.getValueUpdates().size());
        for (ValueUpdate vupd : update.getValueUpdates()) {
            this.putInt(null, vupd.getValueUpdateClassID().id);
            vupd.serialize(this, update.getField().getDataType());
        }
    }

    @Override
    public void write(AddValueUpdate update, DataType superType) {
        VespaDocumentSerializer42.writeValue(this, ((CollectionDataType)superType).getNestedType(), update.getValue());
        this.putInt(null, update.getWeight());
    }

    @Override
    public void write(MapValueUpdate update, DataType superType) {
        if (superType instanceof ArrayDataType) {
            CollectionDataType type = (CollectionDataType)superType;
            IntegerFieldValue index = (IntegerFieldValue)update.getValue();
            index.serialize(this);
            this.putInt(null, update.getUpdate().getValueUpdateClassID().id);
            update.getUpdate().serialize(this, type.getNestedType());
        } else if (superType instanceof WeightedSetDataType) {
            VespaDocumentSerializer42.writeValue(this, ((CollectionDataType)superType).getNestedType(), update.getValue());
            this.putInt(null, update.getUpdate().getValueUpdateClassID().id);
            update.getUpdate().serialize(this, DataType.INT);
        } else {
            throw new SerializationException("MapValueUpdate only works for arrays and weighted sets");
        }
    }

    @Override
    public void write(ArithmeticValueUpdate update) {
        this.putInt(null, update.getOperator().id);
        this.putDouble(null, update.getOperand().doubleValue());
    }

    @Override
    public void write(AssignValueUpdate update, DataType superType) {
        if (update.getValue() == null) {
            this.putByte(null, (byte)0);
        } else {
            this.putByte(null, (byte)1);
            VespaDocumentSerializer42.writeValue(this, superType, update.getValue());
        }
    }

    @Override
    public void write(RemoveValueUpdate update, DataType superType) {
        VespaDocumentSerializer42.writeValue(this, ((CollectionDataType)superType).getNestedType(), update.getValue());
    }

    @Override
    public void write(ClearValueUpdate clearValueUpdate, DataType superType) {
    }

    public static long getSerializedSize(Document doc) {
        VespaDocumentSerializerHead serializer = new VespaDocumentSerializerHead(new GrowableByteBuffer());
        serializer.write(doc);
        return serializer.getBuf().position();
    }

    private static void writeValue(VespaDocumentSerializer42 serializer, DataType dataType, Object value) {
        FieldValue fieldValue = value instanceof FieldValue ? (FieldValue)value : dataType.createFieldValue(value);
        fieldValue.serialize(serializer);
    }
}

