/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.document;

import com.yahoo.collections.MD5;
import com.yahoo.document.BucketId;
import com.yahoo.document.idstring.IdString;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.security.MessageDigest;
import java.util.Arrays;

public class GlobalId
implements Comparable {
    public static final int LENGTH = 12;
    private final byte[] raw;

    public GlobalId(byte[] raw) {
        this.raw = new byte[12];
        int len = Math.min(12, raw.length);
        System.arraycopy(raw, 0, this.raw, 0, len);
    }

    public GlobalId(IdString id) {
        int i;
        byte[] raw = ((MessageDigest)MD5.md5.get()).digest(id.toUtf8().wrap().array());
        long location = id.getLocation();
        this.raw = new byte[12];
        for (i = 0; i < 4; ++i) {
            this.raw[i] = (byte)(location >> 8 * i & 0xFFL);
        }
        for (i = 4; i < 12; ++i) {
            this.raw[i] = raw[i];
        }
    }

    public GlobalId(Deserializer buf) {
        this.raw = buf.getBytes(null, 12);
    }

    public void serialize(Serializer buf) {
        buf.put(null, this.raw);
    }

    public byte[] getRawId() {
        return this.raw;
    }

    public int hashCode() {
        return Arrays.hashCode(this.raw);
    }

    public BucketId toBucketId() {
        long location = (long)this.raw[0] & 0xFFL | ((long)this.raw[1] & 0xFFL) << 8 | ((long)this.raw[2] & 0xFFL) << 16 | ((long)this.raw[3] & 0xFFL) << 24;
        long md5 = 0L;
        int i = 4;
        int j = 0;
        while (i < 12) {
            md5 |= ((long)this.raw[i] & 0xFFL) << j;
            ++i;
            j += 8;
        }
        long rawBucketId = md5 & 0xFFFFFFFF00000000L | location;
        return new BucketId(58, rawBucketId);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GlobalId)) {
            return false;
        }
        GlobalId rhs = (GlobalId)obj;
        return Arrays.equals(this.raw, rhs.raw);
    }

    public int compareTo(Object o) {
        GlobalId other = (GlobalId)o;
        for (int i = 0; i < 12; ++i) {
            int thisByte = 0xF & this.raw[i];
            int otherByte = 0xF & other.raw[i];
            if (thisByte < otherByte) {
                return -1;
            }
            if (thisByte <= otherByte) continue;
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder(50);
        for (byte b : this.raw) {
            strb.append(" ").append(0xFF & b);
        }
        return strb.toString().trim();
    }
}

