/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.text.interpretation;

import com.yahoo.text.interpretation.AnnotationClass;
import com.yahoo.text.interpretation.Annotations;
import com.yahoo.text.interpretation.Modification;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Span {
    private final Modification modification;
    private List<Span> subSpans = null;
    private final Map<AnnotationClass, Annotations> annotations = new HashMap<AnnotationClass, Annotations>();
    private Span parent;
    private final int from;
    private final int to;

    Span(Modification modification) {
        this.modification = modification;
        this.parent = null;
        this.from = 0;
        this.to = modification.getText().length();
    }

    private Span(int from, int to, Span parent) {
        this.parent = parent;
        this.modification = parent.modification;
        this.from = from;
        this.to = to;
    }

    public String getText() {
        return this.modification.getText().substring(this.from, this.to);
    }

    public String toString() {
        return "SPAN: " + this.getText();
    }

    public Annotations annotate(AnnotationClass clazz) {
        Annotations annotations = this.annotations.get(clazz);
        if (!this.annotations.containsKey(clazz)) {
            annotations = new Annotations(this);
            this.annotations.put(clazz, annotations);
        }
        return annotations;
    }

    public Annotations annotate(int from, int to, AnnotationClass clazz) {
        return this.addAnnotation(from, to, clazz);
    }

    public Map<AnnotationClass, List<Annotations>> getAllAnnotations() {
        HashMap<AnnotationClass, List<Annotations>> result = new HashMap<AnnotationClass, List<Annotations>>();
        this.getAllAnnotations(result);
        return result;
    }

    public List<Span> getTermSpans(String term) {
        ArrayList<Span> spans = new ArrayList<Span>();
        this.getTermSpans(term, spans);
        return spans;
    }

    public Annotations getAnnotation(AnnotationClass clazz) {
        return this.getAnnotation(this.from, this.to, clazz);
    }

    public Annotations getAnnotation(int from, int to, AnnotationClass clazz) {
        if (from < this.from || to > this.to) {
            throw new RuntimeException("Trying to get a range that is outside this span");
        }
        if (this.parent != null) {
            return this.parent.getAnnotation(from, to, clazz);
        }
        return this.getBestAnnotation(from, to, clazz);
    }

    public Set<AnnotationClass> getClasses() {
        return this.getClasses(this.from, this.to);
    }

    public Set<AnnotationClass> getClasses(int from, int to) {
        if (from < this.from || to > this.to) {
            throw new RuntimeException("Trying to get a range that is outside this span");
        }
        if (this.parent != null) {
            return this.parent.getClasses(from, to);
        }
        HashSet<AnnotationClass> classes = new HashSet<AnnotationClass>();
        this.getAnnotationClasses(from, to, classes);
        return classes;
    }

    public List<Span> getTokens() {
        ArrayList<Span> spans = new ArrayList<Span>();
        this.getTokens(spans);
        return Collections.unmodifiableList(spans);
    }

    public boolean hasClass(AnnotationClass clazz) {
        return this.getClasses().contains(clazz);
    }

    public List<Span> getSubSpans() {
        return this.subSpans == null ? Collections.emptyList() : Collections.unmodifiableList(this.subSpans);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    private List<Span> getRemovableSubSpan() {
        return this.subSpans == null ? Collections.emptyList() : this.subSpans;
    }

    private void addSubSpan(Span span) {
        if (this.subSpans == null) {
            this.subSpans = new ArrayList<Span>();
        }
        this.subSpans.add(span);
    }

    private Annotations addAnnotation(int from, int to, AnnotationClass clazz) {
        if (this.equalsRange(from, to)) {
            if (this.annotations.containsKey(clazz)) {
                return this.annotations.get(clazz);
            }
            Annotations nAnnotations = new Annotations(this);
            this.annotations.put(clazz, nAnnotations);
            return nAnnotations;
        }
        for (Span subSpan : this.getSubSpans()) {
            if (subSpan.intersects(from, to)) {
                throw new RuntimeException("Trying to add span that intersects already excisting span");
            }
            if (!subSpan.contains(from, to)) continue;
            return subSpan.addAnnotation(from, to, clazz);
        }
        Span span = new Span(from, to, this);
        Annotations nAnnotations = new Annotations(span);
        span.annotations.put(clazz, nAnnotations);
        this.addSubSpan(span);
        Iterator<Span> subIterator = this.getRemovableSubSpan().iterator();
        while (subIterator.hasNext()) {
            Span subSpan = subIterator.next();
            if (subSpan.contains(from, to)) {
                return subSpan.addAnnotation(from, to, clazz);
            }
            if (!subSpan.isInside(from, to)) continue;
            subSpan.parent = span;
            span.addSubSpan(subSpan);
            subIterator.remove();
        }
        return nAnnotations;
    }

    private boolean contains(int from, int to) {
        return this.from <= from && this.to >= to;
    }

    private boolean isInside(int from, int to) {
        return this.from >= from && this.to <= to;
    }

    private boolean intersects(int from, int to) {
        return this.from < from && this.to > from && this.to < to || this.from < to && this.to > to && this.from > from;
    }

    private boolean equalsRange(int from, int to) {
        return this.from == from && this.to == to;
    }

    private void getAllAnnotations(Map<AnnotationClass, List<Annotations>> results) {
        for (Map.Entry<AnnotationClass, Annotations> entry : this.annotations.entrySet()) {
            List<Annotations> anList = results.get(entry.getKey());
            if (anList == null) {
                anList = new ArrayList<Annotations>();
                results.put(entry.getKey(), anList);
            }
            anList.add(entry.getValue());
        }
        for (Span subSpan : this.getSubSpans()) {
            subSpan.getAllAnnotations(results);
        }
    }

    private void getTermSpans(String term, List<Span> spans) {
        if (term.equalsIgnoreCase(this.getText())) {
            spans.add(this);
        }
        for (Span subSpan : this.getSubSpans()) {
            subSpan.getTermSpans(term, spans);
        }
    }

    private void getAnnotationClasses(int from, int to, Set<AnnotationClass> classes) {
        if (!this.contains(from, to)) {
            return;
        }
        classes.addAll(this.annotations.keySet());
        for (Span subSpan : this.getSubSpans()) {
            subSpan.getAnnotationClasses(from, to, classes);
        }
    }

    private void getTokens(List<Span> spans) {
        if (this.getSubSpans().size() == 0) {
            spans.add(this);
        } else {
            for (Span subSpan : this.getSubSpans()) {
                subSpan.getTokens(spans);
            }
        }
    }

    private Annotations getBestAnnotation(int from, int to, AnnotationClass clazz) {
        if (!this.contains(from, to)) {
            return null;
        }
        Annotations annotations = this.annotations.get(clazz);
        for (Span subSpan : this.getSubSpans()) {
            Annotations subAnnotations = subSpan.getBestAnnotation(from, to, clazz);
            if (subAnnotations == null) continue;
            annotations = subAnnotations;
        }
        return annotations;
    }
}

