/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.item;

import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.search.query.textserialize.item.ItemArguments;
import com.yahoo.search.query.textserialize.item.ItemContext;
import com.yahoo.search.query.textserialize.item.ItemFormConverter;
import com.yahoo.search.query.textserialize.item.ItemInitializer;
import com.yahoo.search.query.textserialize.serializer.DispatchForm;
import com.yahoo.search.query.textserialize.serializer.ItemIdMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.ListIterator;

public class CompositeConverter<T extends CompositeItem>
implements ItemFormConverter {
    private final Class<T> itemClass;

    public CompositeConverter(Class<T> itemClass) {
        this.itemClass = itemClass;
    }

    @Override
    public Object formToItem(String name, ItemArguments arguments, ItemContext itemContext) {
        T item = this.newInstance();
        this.addChildren(item, arguments, itemContext);
        return item;
    }

    protected void addChildren(T item, ItemArguments arguments, ItemContext itemContext) {
        for (Object child : arguments.children) {
            ((CompositeItem)item).addItem(CompositeConverter.asItem(child));
        }
        ItemInitializer.initialize(item, arguments, itemContext);
    }

    private static Item asItem(Object child) {
        if (!(child instanceof Item) && child != null) {
            throw new RuntimeException("Expected query item, but got '" + child.toString() + "' [" + child.getClass().getName() + "]");
        }
        return (Item)child;
    }

    private T newInstance() {
        try {
            return (T)((CompositeItem)this.itemClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DispatchForm itemToForm(Item item, ItemIdMapper itemIdMapper) {
        CompositeItem compositeItem = (CompositeItem)item;
        DispatchForm form = new DispatchForm(this.getFormName(item));
        ListIterator<Item> i = compositeItem.getItemIterator();
        while (i.hasNext()) {
            form.addChild(i.next());
        }
        ItemInitializer.initializeForm(form, item, itemIdMapper);
        return form;
    }

    protected String getFormName(Item item) {
        return item.getItemType().name();
    }
}

