/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.model;

import com.yahoo.search.pagetemplates.model.AbstractChoice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MapChoice
extends AbstractChoice {
    private List<String> placeholderIds = new ArrayList<String>();
    private List<List<PageElement>> values = new ArrayList<List<PageElement>>();

    @Override
    public boolean isChoiceBetween(Class pageTemplateModelElementClass) {
        List<PageElement> firstNonEmpty = null;
        for (List<PageElement> value : this.values) {
            if (value.size() <= 0) continue;
            firstNonEmpty = value;
        }
        if (firstNonEmpty == null) {
            return false;
        }
        return pageTemplateModelElementClass.isAssignableFrom(((PageElement)firstNonEmpty.get(0)).getClass());
    }

    public List<String> placeholderIds() {
        return this.placeholderIds;
    }

    public List<List<PageElement>> values() {
        return this.values;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        this.placeholderIds = Collections.unmodifiableList(this.placeholderIds);
        this.values = Collections.unmodifiableList(this.values);
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
        for (List<PageElement> valueEntry : this.values) {
            for (PageElement value : valueEntry) {
                value.accept(visitor);
            }
        }
    }

    public String toString() {
        return "mapping to placeholders " + String.valueOf(this.placeholderIds);
    }
}

