/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import com.yahoo.api.annotations.Beta;
import com.yahoo.search.grouping.request.AggregatorNode;
import com.yahoo.search.grouping.request.BucketValue;
import com.yahoo.search.grouping.request.FilterExpression;
import com.yahoo.search.grouping.request.FixedWidthFunction;
import com.yahoo.search.grouping.request.GroupingExpression;
import com.yahoo.search.grouping.request.PredefinedFunction;

@Beta
public class RegexPredicate
extends FilterExpression {
    private final String pattern;
    private final GroupingExpression expression;

    public RegexPredicate(String pattern, GroupingExpression expression) {
        RegexPredicate.validateRegex(pattern);
        RegexPredicate.validateExpression(expression);
        this.pattern = pattern;
        this.expression = expression;
    }

    private static void validateRegex(String pattern) {
        try {
            Pattern.compile((String)pattern);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regex pattern: %s (%s)".formatted(pattern, e.getMessage()), e);
        }
    }

    private static void validateExpression(GroupingExpression exp) {
        if (exp instanceof BucketValue) {
            throw new IllegalArgumentException("Regex predicate cannot be used with a bucket value");
        }
        if (exp instanceof AggregatorNode) {
            throw new IllegalArgumentException("Regex predicate cannot be used with an aggregator");
        }
        if (exp instanceof PredefinedFunction) {
            throw new IllegalArgumentException("Regex predicate cannot be used with a predefined function");
        }
        if (exp instanceof FixedWidthFunction) {
            throw new IllegalArgumentException("Regex predicate cannot be used with a fixed width function");
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public GroupingExpression getExpression() {
        return this.expression;
    }

    @Override
    public String toString() {
        return "regex(\"%s\", %s)".formatted(this.pattern, this.expression);
    }

    @Override
    public FilterExpression copy() {
        return new RegexPredicate(this.pattern, this.expression.copy());
    }
}

