/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Production;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProductionList {
    private final List<Production> productions = new ArrayList<Production>();
    private boolean replacing = true;

    public void addProduction(Production term) {
        term.setReplacing(this.replacing);
        term.setPosition(this.productions.size());
        this.productions.add(term);
    }

    void setReplacing(boolean replacing) {
        for (Production production : this.productions) {
            production.setReplacing(replacing);
        }
        this.replacing = replacing;
    }

    public List<Production> productionList() {
        return Collections.unmodifiableList(this.productions);
    }

    public int getTermCount() {
        return this.productions.size();
    }

    void addMatchReferences(Set<String> matchReferences) {
        for (Production term : this.productions) {
            term.addMatchReferences(matchReferences);
        }
    }

    public void produce(RuleEvaluation e) {
        for (int i = 0; i < this.productions.size(); ++i) {
            this.productions.get(i).produce(e, i);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<Production> i = this.productions.iterator();
        while (i.hasNext()) {
            buffer.append(i.next());
            if (!i.hasNext()) continue;
            buffer.append(" ");
        }
        return buffer.toString();
    }
}

