/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.List;

@After(value={"rawQuery"})
@Before(value={"transformedQuery"})
@Provides(value={"PhraseReplacement"})
public class PhrasingSearcher
extends Searcher {
    private static final CompoundName suggestonly = CompoundName.from((String)"suggestonly");
    public static final String PHRASE_REPLACEMENT = "PhraseReplacement";
    private PhraseMatcher phraseMatcher;

    @Inject
    public PhrasingSearcher(ComponentId id, QrSearchersConfig config) {
        super(id);
        this.setupAutomatonFile(config.com().yahoo().prelude().querytransform().PhrasingSearcher().automatonfile());
    }

    public PhrasingSearcher(String phraseAutomatonFile) {
        this.setupAutomatonFile(phraseAutomatonFile);
    }

    private void setupAutomatonFile(String phraseAutomatonFile) {
        this.phraseMatcher = phraseAutomatonFile == null || phraseAutomatonFile.trim().equals("") ? PhraseMatcher.getNullMatcher() : new PhraseMatcher(phraseAutomatonFile, true);
    }

    @Override
    public Result search(Query query, Execution execution) {
        if (this.phraseMatcher.isEmpty()) {
            return execution.search(query);
        }
        List<PhraseMatcher.Phrase> replacePhrases = this.phraseMatcher.matchPhrases(query.getModel().getQueryTree().getRoot());
        if (replacePhrases != null && !query.properties().getBoolean(suggestonly, false)) {
            this.replace(replacePhrases);
            query.trace("Replacing phrases", true, 2);
        }
        return execution.search(query);
    }

    private void replace(List<PhraseMatcher.Phrase> phrases) {
        for (int i = phrases.size() - 1; i >= 0; --i) {
            PhraseMatcher.Phrase phrase = phrases.get(i);
            if (phrase.getLength() <= 1) continue;
            phrase.replace();
        }
    }
}

