/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TrueItem;
import java.util.List;
import java.util.Objects;

public class NotItem
extends CompositeItem {
    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NOT;
    }

    @Override
    public String getName() {
        return "NOT";
    }

    @Override
    public void addItem(Item item) {
        super.addItem(item);
    }

    public void addNegativeItem(Item negative) {
        if (this.getItemCount() == 0) {
            this.insertTrueFirstItem();
        }
        this.addItem(negative);
    }

    public List<Item> negativeItems() {
        return this.items().subList(1, this.getItemCount());
    }

    public Item getPositiveItem() {
        if (this.getItemCount() == 0) {
            return new TrueItem();
        }
        return this.getItem(0);
    }

    public Item setPositiveItem(Item item) {
        Objects.requireNonNull(item, () -> "Positive item of " + String.valueOf(this));
        if (this.getItemCount() == 0) {
            this.addItem(item);
            return null;
        }
        return this.setItem(0, item);
    }

    public void addPositiveItem(Item item) {
        if (this.getPositiveItem() instanceof TrueItem) {
            this.setPositiveItem(item);
        } else if (this.getPositiveItem() instanceof AndItem) {
            ((AndItem)this.getPositiveItem()).addItem(item);
        } else {
            AndItem positives = new AndItem();
            positives.addItem(this.getPositiveItem());
            positives.addItem(item);
            this.setPositiveItem(positives);
        }
    }

    @Override
    public boolean removeItem(Item item) {
        int removedIndex = this.getItemIndex(item);
        boolean removed = super.removeItem(item);
        if (removed && removedIndex == 0) {
            this.insertTrueFirstItem();
        }
        return removed;
    }

    @Override
    public Item removeItem(int index) {
        Item removed = super.removeItem(index);
        if (index == 0) {
            this.insertTrueFirstItem();
        }
        return removed;
    }

    private void insertTrueFirstItem() {
        this.addItem(0, new TrueItem());
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        if (this.items().isEmpty()) {
            return;
        }
        if (this.items().size() == 1) {
            buffer.append(this.items().get(0));
            return;
        }
        for (int i = 0; i < this.items().size(); ++i) {
            if (i == 0 && this.items().get(i) instanceof TrueItem) continue;
            buffer.append(i == 0 ? "+" : "-").append(this.items().get(i));
            if (i >= this.items().size() - 1) continue;
            buffer.append(" ");
        }
    }

    @Override
    public int getTermCount() {
        Item positive = this.getPositiveItem();
        return positive == null ? 0 : positive.getTermCount();
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemAndNot.Builder builder = SearchProtocol.ItemAndNot.newBuilder();
        for (Item child : this.items()) {
            builder.addChildren(child.toProtobuf());
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemAndNot(builder.build()).build();
    }
}

