/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.ToProtobuf;
import java.nio.ByteBuffer;
import java.util.Objects;

public class FuzzyItem
extends TermItem {
    private String term;
    private int maxEditDistance;
    private int prefixLength;
    private boolean prefixMatch;
    public static int DEFAULT_MAX_EDIT_DISTANCE = 2;
    public static int DEFAULT_PREFIX_LENGTH = 0;

    public FuzzyItem(String indexName, boolean isFromQuery, String term, int maxEditDistance, int prefixLength, boolean prefixMatch) {
        super(indexName, isFromQuery, null);
        this.setValue(term);
        this.setMaxEditDistance(maxEditDistance);
        this.setPrefixLength(prefixLength);
        this.setPrefixMatch(prefixMatch);
    }

    public FuzzyItem(String indexName, boolean isFromQuery, String term, int maxEditDistance, int prefixLength) {
        this(indexName, isFromQuery, term, maxEditDistance, prefixLength, false);
    }

    public void setMaxEditDistance(int maxEditDistance) {
        this.maxEditDistance = maxEditDistance;
    }

    public void setPrefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
    }

    public int getPrefixLength() {
        return this.prefixLength;
    }

    public int getMaxEditDistance() {
        return this.maxEditDistance;
    }

    public boolean isPrefixMatch() {
        return this.prefixMatch;
    }

    public void setPrefixMatch(boolean prefixMatch) {
        this.prefixMatch = prefixMatch;
    }

    @Override
    protected boolean hasPrefixMatchSemantics() {
        return this.prefixMatch;
    }

    @Override
    public void setValue(String value) {
        this.term = value;
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public boolean isWords() {
        return false;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.FUZZY;
    }

    @Override
    public String getName() {
        return "FUZZY";
    }

    @Override
    public String stringValue() {
        return this.term;
    }

    @Override
    public boolean isStemmed() {
        return false;
    }

    @Override
    public String getIndexedString() {
        return this.stringValue();
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FuzzyItem fuzzyItem = (FuzzyItem)o;
        return this.maxEditDistance == fuzzyItem.maxEditDistance && this.prefixLength == fuzzyItem.prefixLength && this.prefixMatch == fuzzyItem.prefixMatch && Objects.equals(this.term, fuzzyItem.term);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term, this.maxEditDistance, this.prefixLength, this.prefixMatch);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append('(');
        buffer.append(this.term);
        buffer.append(',');
        buffer.append(this.maxEditDistance);
        buffer.append(',');
        buffer.append(this.prefixLength);
        buffer.append(',');
        buffer.append(this.prefixMatch);
        buffer.append(") ");
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        FuzzyItem.putString(this.getIndexedString(), buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.maxEditDistance, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.prefixLength, (ByteBuffer)buffer);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemFuzzy.Builder builder = SearchProtocol.ItemFuzzy.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setWord(this.term);
        builder.setMaxEditDistance(this.maxEditDistance);
        builder.setPrefixLockLength(this.prefixLength);
        builder.setPrefixMatch(this.prefixMatch);
        return SearchProtocol.QueryTreeItem.newBuilder().setItemFuzzy(builder.build()).build();
    }
}

