/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude;

import com.yahoo.text.Lowercase;
import java.util.Calendar;

public class Freshness {
    private long refSecondsSinceEpoch = 0L;

    private void parse(String dateTime) {
        if (dateTime.startsWith("now")) {
            this.refSecondsSinceEpoch = this.getSystemTimeInSecondsSinceEpoch();
            if (dateTime.startsWith("now-")) {
                String offsetStr = dateTime.substring(4);
                long timeOffset = offsetStr.length() > 0 ? Long.parseLong(offsetStr) : 1L;
                this.refSecondsSinceEpoch -= timeOffset;
            }
        } else {
            this.refSecondsSinceEpoch = Long.parseLong(dateTime);
        }
    }

    public Freshness(String dateTime) {
        this.parse(Lowercase.toLowerCase((String)dateTime));
    }

    public long getSystemTimeInSecondsSinceEpoch() {
        long msSinceEpochNow = Calendar.getInstance().getTimeInMillis();
        return msSinceEpochNow / 1000L;
    }

    public long getRefTime() {
        return this.refSecondsSinceEpoch;
    }

    public String toString() {
        StringBuilder ser = new StringBuilder();
        String dateTime = Long.toString(this.refSecondsSinceEpoch);
        ser.append(dateTime);
        return ser.toString().trim();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Freshness)) {
            return false;
        }
        return ((Freshness)other).refSecondsSinceEpoch == this.refSecondsSinceEpoch;
    }

    public int hashCode() {
        return (int)this.refSecondsSinceEpoch;
    }
}

