// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.logging;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of local-disk-logger
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LocalDiskLoggerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "8de8da4d31644a0e80a81745a1edf2ea";
  public final static String CONFIG_DEF_NAME = "local-disk-logger";
  public final static String CONFIG_DEF_NAMESPACE = "search.logging";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.logging",
    "path string default=/dev/null"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String path = null;

    public Builder() { }

    public Builder(LocalDiskLoggerConfig config) {
      path(config.path());
    }

    private Builder override(Builder __superior) {
      if (__superior.path != null)
        path(__superior.path);
      return this;
    }

    public Builder path(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      path = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LocalDiskLoggerConfig build() {
      return new LocalDiskLoggerConfig(this);
    }

  }

  // Path where logs should be put
  private final StringNode path;

  public LocalDiskLoggerConfig(Builder builder) {
    this(builder, true);
  }

  private LocalDiskLoggerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "local-disk-logger must be initialized: " + builder.__uninitialized);

    path = (builder.path == null) ?
        new StringNode("/dev/null") : new StringNode(builder.path);
  }

  /**
   * @return local-disk-logger.path
   */
  public String path() {
    return path.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LocalDiskLoggerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("local-disk-logger");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
