/* GroupingParser.java */
/* Generated by: ParserGeneratorCC: Do not edit this line. GroupingParser.java */
package com.yahoo.search.grouping.request.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.LinkedList;
import com.yahoo.javacc.UnicodeUtilities;
import com.yahoo.search.grouping.request.*;

@SuppressWarnings({ "ConstantIfStatement", "UnnecessarySemicolon", "Convert2Diamond", "FinalPrivateMethod" })
public class GroupingParser implements GroupingParserConstants {

    private static Number resolveNumber(String str) {
        if (str.indexOf('.') >= 0) {
            return Double.valueOf(str);
        }
        if (str.equals(Long.toString(Long.MIN_VALUE).substring(1))) return Double.NaN;
        return Long.valueOf(str);
    }

    private static GroupingExpression resolveNegation(GroupingExpression exp) {
        if (exp instanceof DoubleValue && ((DoubleValue)exp).getValue().isNaN()) return new LongValue(Long.MIN_VALUE);
        return new NegFunction(exp);
    }

// --------------------------------------------------------------------------------
//
// Production rules.
//
// --------------------------------------------------------------------------------
  final public 
List<GroupingOperation> requestList() throws ParseException {List<GroupingOperation> lst = new LinkedList<GroupingOperation>();
    GroupingOperation val;
    space();
    val = root();
lst.add(val);
    label_1:
    while (true) {
      switch (jj_nt.kind) {
      case SCOLON:{
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      scolon();
      val = root();
lst.add(val);
    }
    jj_consume_token(0);
{if ("" != null) return lst;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingOperation request() throws ParseException {GroupingOperation val;
    space();
    val = root();
    jj_consume_token(0);
{if ("" != null) return val;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingOperation root() throws ParseException {String str;
    GroupingOperation ret;
    ret = operation(null);
    switch (jj_nt.kind) {
    case WHERE:{
      jj_consume_token(WHERE);
      lbrace();
      str = where();
      rbrace();
GroupingOperation grp = new AllOperation();
                                                  grp.setWhere(str);
                                                  grp.addChild(ret);
                                                  ret = grp;
      break;
      }
    default:
      jj_la1[1] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingOperation operation(GroupingOperation parent) throws ParseException {GroupingOperation ret;
    switch (jj_nt.kind) {
    case ALL:{
      ret = allOperation(parent);
      break;
      }
    case EACH:{
      ret = eachOperation(parent);
      break;
      }
    default:
      jj_la1[2] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingOperation allOperation(GroupingOperation parent) throws ParseException {GroupingOperation ret;
    jj_consume_token(ALL);
ret = new AllOperation(); if (parent != null) { parent.addChild(ret); }
    lbrace();
    operationBody(ret);
    rbrace();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingOperation eachOperation(GroupingOperation parent) throws ParseException {String str;
    GroupingOperation ret;
    jj_consume_token(EACH);
ret = new EachOperation(); if (parent != null) { parent.addChild(ret); }
    lbrace();
    operationBody(ret);
    rbrace();
    switch (jj_nt.kind) {
    case AS:{
      jj_consume_token(AS);
      lbrace();
      str = string();
      rbrace();
ret.setLabel(str);
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void operationBody(GroupingOperation parent) throws ParseException {FilterExpression filterExp = null;
    ConstantValue<?> maxOperand = null;
    String str;
    Number num;
    GroupingExpression exp;
    List<GroupingExpression> lst;
    switch (jj_nt.kind) {
    case GROUP:{
      jj_consume_token(GROUP);
      lbrace();
      exp = exp(parent);
      rbrace();
parent.setGroupBy(exp);
      break;
      }
    default:
      jj_la1[4] = jj_gen;
      ;
    }
    label_2:
    while (true) {
      switch (jj_nt.kind) {
      case ACCURACY:
      case ALIAS:
      case FILTER:
      case HINT:
      case KEEP:
      case MAX:
      case ORDER:
      case OUTPUT:
      case PRECISION:
      case WHERE:{
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        break label_2;
      }
      switch (jj_nt.kind) {
      case ACCURACY:{
        jj_consume_token(ACCURACY);
        lbrace();
        num = number();
        rbrace();
parent.setAccuracy(num.doubleValue());
        break;
        }
      case ALIAS:{
        jj_consume_token(ALIAS);
        lbrace();
        str = identifier();
        comma();
        exp = exp(parent);
        rbrace();
parent.putAlias(str, exp);
        break;
        }
      case HINT:{
        jj_consume_token(HINT);
        lbrace();
        str = identifier();
        rbrace();
parent.addHint(str);
        break;
        }
      case FILTER:{
        jj_consume_token(FILTER);
        lbrace();
        filterExp = filterExp(parent);
        rbrace();
parent.setFilterBy(filterExp);
        break;
        }
      case KEEP:{
        jj_consume_token(KEEP);
        lbrace();
        filterExp = filterExp(parent);
        rbrace();
parent.setFilterBy(filterExp);
        break;
        }
      case MAX:{
        jj_consume_token(MAX);
        lbrace();
        switch (jj_nt.kind) {
        case INF:{
          maxOperand = infinitePositiveValue();
          break;
          }
        case INTEGER:
        case FLOAT:{
          maxOperand = constantValue();
          break;
          }
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        rbrace();
if (maxOperand instanceof InfiniteValue) {
                parent.setMax(GroupingOperation.UNLIMITED_MAX);
            } else {
                parent.setMax(((Number)maxOperand.getValue()).intValue());
            }
        break;
        }
      case ORDER:{
        jj_consume_token(ORDER);
        lbrace();
        lst = expList(parent);
        rbrace();
parent.addOrderBy(lst);
        break;
        }
      case OUTPUT:{
        jj_consume_token(OUTPUT);
        lbrace();
        lst = expList(parent);
        rbrace();
parent.addOutputs(lst);
        break;
        }
      case PRECISION:{
        jj_consume_token(PRECISION);
        lbrace();
        num = number();
        rbrace();
parent.setPrecision(num.intValue());
        break;
        }
      case WHERE:{
        jj_consume_token(WHERE);
        lbrace();
        str = where();
        rbrace();
parent.setWhere(str);
        break;
        }
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_3:
    while (true) {
      switch (jj_nt.kind) {
      case ALL:
      case EACH:{
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        break label_3;
      }
      operation(parent);
    }
}

  final public String where() throws ParseException {StringBuilder ret = new StringBuilder();
    String str;
    switch (jj_nt.kind) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
ret.append(token.image);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      ;
    }
    str = identifier();
ret.append(str);
{if ("" != null) return ret.toString();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public List<GroupingExpression> expList(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    List<GroupingExpression> ret = new LinkedList<GroupingExpression>();
    exp = exp(grp);
ret.add(exp);
    label_4:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        break label_4;
      }
      comma();
      exp = exp(grp);
ret.add(exp);
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression exp(GroupingOperation grp) throws ParseException {String str;
    boolean neg = false;
    GroupingExpression exp;
    switch (jj_nt.kind) {
    case INFIX_ADD:
    case INFIX_SUB:{
      switch (jj_nt.kind) {
      case INFIX_ADD:{
        add();
        break;
        }
      case INFIX_SUB:{
        sub();
neg = true;
        break;
        }
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      ;
    }
    exp = expAlias(grp);
if (neg) { exp = resolveNegation(exp); }
    switch (jj_nt.kind) {
    case AS:{
      jj_consume_token(AS);
      lbrace();
      str = string();
      rbrace();
exp.setLabel(str);
      break;
      }
    default:
      jj_la1[13] = jj_gen;
      ;
    }
{if ("" != null) return exp;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FilterExpression filterExp(GroupingOperation grp) throws ParseException {FilterExpression exp;
    exp = orPredicate(grp);
{if ("" != null) return exp;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression expAlias(GroupingOperation grp) throws ParseException {String str;
    GroupingExpression exp;
    switch (jj_nt.kind) {
    case DOLLAR:{
      jj_consume_token(DOLLAR);
      str = identifier();
      switch (jj_nt.kind) {
      case EQ:{
        eq();
        exp = expMath(grp);
grp.putAlias(str, exp);
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        ;
      }
exp = grp.getAlias(str);
      break;
      }
    case INTEGER:
    case FLOAT:
    case LBRACE:
    case STRING:
    case ACOS:
    case ACOSH:
    case ACCURACY:
    case ADD:
    case ALIAS:
    case ALL:
    case AND:
    case ARRAY:
    case AS:
    case AT:
    case ASIN:
    case ASINH:
    case ATAN:
    case ATANH:
    case ATTRIBUTE:
    case AVG:
    case BUCKET:
    case CAT:
    case CBRT:
    case COS:
    case COSH:
    case COUNT:
    case DEBUGWAIT:
    case DIV:
    case DOCIDNSSPECIFIC:
    case EACH:
    case EXP:
    case FILTER:
    case FIXEDWIDTH:
    case FLOOR:
    case GROUP:
    case HINT:
    case HYPOT:
    case KEEP:
    case LOG:
    case LOG1P:
    case LOG10:
    case MATH:
    case MAX:
    case MD5:
    case MIN:
    case MOD:
    case MUL:
    case NEG:
    case NOT:
    case NORMALIZESUBJECT:
    case NOW:
    case OR:
    case ORDER:
    case OUTPUT:
    case POW:
    case PRECISION:
    case PREDEFINED:
    case QUANTILES:
    case RANGE:
    case REGEX:
    case RELEVANCE:
    case REVERSE:
    case SIN:
    case SINH:
    case SIZE:
    case SORT:
    case INTERPOLATEDLOOKUP:
    case SQRT:
    case STDDEV:
    case STRCAT:
    case STRLEN:
    case SUB:
    case SUM:
    case SUMMARY:
    case TAN:
    case TANH:
    case TIME:
    case TIME_DATE:
    case TIME_DAYOFMONTH:
    case TIME_DAYOFWEEK:
    case TIME_DAYOFYEAR:
    case TIME_HOUROFDAY:
    case TIME_MINUTEOFHOUR:
    case TIME_MONTHOFYEAR:
    case TIME_SECONDOFMINUTE:
    case TIME_YEAR:
    case TODOUBLE:
    case TOLONG:
    case TORAW:
    case TOSTRING:
    case TRUE:
    case FALSE:
    case UCA:
    case WHERE:
    case X:
    case XOR:
    case XORBIT:
    case Y:
    case ZCURVE:
    case IDENTIFIER:{
      exp = expMath(grp);
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return exp;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression expMath(GroupingOperation grp) throws ParseException {MathResolver.Type type = MathResolver.Type.ADD;
    MathResolver math = new MathResolver();
    GroupingExpression exp;
    exp = value(grp);
math.push(type, exp);
    label_5:
    while (true) {
      switch (jj_nt.kind) {
      case INFIX_ADD:
      case INFIX_DIV:
      case INFIX_MOD:
      case INFIX_MUL:
      case INFIX_SUB:{
        break;
        }
      default:
        jj_la1[16] = jj_gen;
        break label_5;
      }
      switch (jj_nt.kind) {
      case INFIX_ADD:{
        add();
type = MathResolver.Type.ADD;
        break;
        }
      case INFIX_DIV:{
        div();
type = MathResolver.Type.DIV;
        break;
        }
      case INFIX_MOD:{
        mod();
type = MathResolver.Type.MOD;
        break;
        }
      case INFIX_MUL:{
        mul();
type = MathResolver.Type.MUL;
        break;
        }
      case INFIX_SUB:{
        sub();
type = MathResolver.Type.SUB;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      exp = value(grp);
math.push(type, exp);
    }
{if ("" != null) return math.resolve();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression value(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    if (jj_2_1(2)) {
      switch (jj_nt.kind) {
      case LBRACE:{
        lbrace();
        exp = exp(grp);
        rbrace();
        break;
        }
      case ADD:{
        exp = addFunction(grp);
        break;
        }
      case AND:{
        exp = andFunction(grp);
        break;
        }
      case ATTRIBUTE:{
        exp = attributeFunction();
        break;
        }
      case AVG:{
        exp = avgExpression(grp);
        break;
        }
      case CAT:{
        exp = catFunction(grp);
        break;
        }
      case INTEGER:
      case FLOAT:{
        exp = constantValue();
        break;
        }
      case COUNT:{
        exp = countAggregator();
        break;
        }
      case DEBUGWAIT:{
        exp = debugWaitFunction(grp);
        break;
        }
      case DIV:{
        exp = divFunction(grp);
        break;
        }
      case DOCIDNSSPECIFIC:{
        exp = docIdNsSpecificValue();
        break;
        }
      case FIXEDWIDTH:{
        exp = fixedWidthFunction(grp);
        break;
        }
      case MATH:{
        exp = mathFunction(grp);
        break;
        }
      case MAX:{
        exp = maxExpression(grp);
        break;
        }
      case MD5:{
        exp = md5Function(grp);
        break;
        }
      case MIN:{
        exp = minExpression(grp);
        break;
        }
      case MOD:{
        exp = modFunction(grp);
        break;
        }
      case MUL:{
        exp = mulFunction(grp);
        break;
        }
      case NEG:{
        exp = negFunction(grp);
        break;
        }
      case NORMALIZESUBJECT:{
        exp = normalizeSubjectFunction(grp);
        break;
        }
      case NOW:{
        exp = nowFunction();
        break;
        }
      case OR:{
        exp = orFunction(grp);
        break;
        }
      case PREDEFINED:{
        exp = predefinedFunction(grp);
        break;
        }
      case RELEVANCE:{
        exp = relevanceValue();
        break;
        }
      case REVERSE:{
        exp = reverseFunction(grp);
        break;
        }
      case SIZE:{
        exp = sizeFunction(grp);
        break;
        }
      case SORT:{
        exp = sortFunction(grp);
        break;
        }
      case ARRAY:{
        exp = arrayAtLookup(grp);
        break;
        }
      case INTERPOLATEDLOOKUP:{
        exp = interpolatedLookup(grp);
        break;
        }
      case QUANTILES:{
        exp = quantilesExpression(grp);
        break;
        }
      case STDDEV:{
        exp = stddevAggregator(grp);
        break;
        }
      case STRING:{
        exp = stringValue();
        break;
        }
      case STRCAT:{
        exp = strCatFunction(grp);
        break;
        }
      case STRLEN:{
        exp = strLenFunction(grp);
        break;
        }
      case SUB:{
        exp = subFunction(grp);
        break;
        }
      case SUM:{
        exp = sumAggregator(grp);
        break;
        }
      case SUMMARY:{
        exp = summaryValue();
        break;
        }
      case TIME:{
        exp = timeFunction(grp);
        break;
        }
      case TODOUBLE:{
        exp = toDoubleFunction(grp);
        break;
        }
      case TOLONG:{
        exp = toLongFunction(grp);
        break;
        }
      case TORAW:{
        exp = toRawFunction(grp);
        break;
        }
      case TOSTRING:{
        exp = toStringFunction(grp);
        break;
        }
      case UCA:{
        exp = ucaFunction(grp);
        break;
        }
      case XOR:{
        exp = xorExpression(grp);
        break;
        }
      case XORBIT:{
        exp = xorBitFunction(grp);
        break;
        }
      case ZCURVE:{
        exp = zcurveFunction(grp);
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch (jj_nt.kind) {
      case ACOS:
      case ACOSH:
      case ACCURACY:
      case ADD:
      case ALIAS:
      case ALL:
      case AND:
      case ARRAY:
      case AS:
      case AT:
      case ASIN:
      case ASINH:
      case ATAN:
      case ATANH:
      case ATTRIBUTE:
      case AVG:
      case BUCKET:
      case CAT:
      case CBRT:
      case COS:
      case COSH:
      case COUNT:
      case DEBUGWAIT:
      case DIV:
      case DOCIDNSSPECIFIC:
      case EACH:
      case EXP:
      case FILTER:
      case FIXEDWIDTH:
      case FLOOR:
      case GROUP:
      case HINT:
      case HYPOT:
      case KEEP:
      case LOG:
      case LOG1P:
      case LOG10:
      case MATH:
      case MAX:
      case MD5:
      case MIN:
      case MOD:
      case MUL:
      case NEG:
      case NOT:
      case NORMALIZESUBJECT:
      case NOW:
      case OR:
      case ORDER:
      case OUTPUT:
      case POW:
      case PRECISION:
      case PREDEFINED:
      case QUANTILES:
      case RANGE:
      case REGEX:
      case RELEVANCE:
      case REVERSE:
      case SIN:
      case SINH:
      case SIZE:
      case SORT:
      case INTERPOLATEDLOOKUP:
      case SQRT:
      case STDDEV:
      case STRCAT:
      case STRLEN:
      case SUB:
      case SUM:
      case SUMMARY:
      case TAN:
      case TANH:
      case TIME:
      case TIME_DATE:
      case TIME_DAYOFMONTH:
      case TIME_DAYOFWEEK:
      case TIME_DAYOFYEAR:
      case TIME_HOUROFDAY:
      case TIME_MINUTEOFHOUR:
      case TIME_MONTHOFYEAR:
      case TIME_SECONDOFMINUTE:
      case TIME_YEAR:
      case TODOUBLE:
      case TOLONG:
      case TORAW:
      case TOSTRING:
      case TRUE:
      case FALSE:
      case UCA:
      case WHERE:
      case X:
      case XOR:
      case XORBIT:
      case Y:
      case ZCURVE:
      case IDENTIFIER:{
        exp = attributeValue();
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return exp;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AddFunction addFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(ADD);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new AddFunction(arg1, arg2);}
      {if ("" != null) return new AddFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AndFunction andFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(AND);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new AndFunction(arg1, arg2);}
      {if ("" != null) return new AndFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AttributeValue attributeValue() throws ParseException {StringBuilder prefix = new StringBuilder();
    StringBuilder suffix = new StringBuilder();
    String str;
    String key = null;
    AttributeFunction keySourceAttr = null;
    str = identifier();
prefix.append(str);
    label_6:
    while (true) {
      if (jj_2_2(2)) {
      } else {
        break label_6;
      }
      jj_consume_token(DOT);
prefix.append(token.image);
      str = identifier();
prefix.append(str);
    }
    switch (jj_nt.kind) {
    case LCURLY:{
      if (jj_2_3(3)) {
        lcurly();
        key = string();
        rcurly();
      } else {
        switch (jj_nt.kind) {
        case LCURLY:{
          lcurly();
          keySourceAttr = attributeFunction();
          rcurly();
          break;
          }
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      break;
      }
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    label_7:
    while (true) {
      switch (jj_nt.kind) {
      case DOT:{
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        break label_7;
      }
      jj_consume_token(DOT);
suffix.append(token.image);
      str = identifier();
suffix.append(str);
    }
if (key != null) {
            {if ("" != null) return AttributeMapLookupValue.fromKey(prefix.toString(), key, suffix.toString());}
        } else if (keySourceAttr != null) {
            {if ("" != null) return AttributeMapLookupValue.fromKeySourceAttribute(prefix.toString(), keySourceAttr.getAttributeName(), suffix.toString());}
        } else {
            prefix.append(suffix.toString());
            {if ("" != null) return new AttributeValue(prefix.toString());}
        }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public AttributeFunction attributeFunction() throws ParseException {AttributeValue val;
    jj_consume_token(ATTRIBUTE);
    lbrace();
    val = attributeValue();
    rbrace();
{if ("" != null) return new AttributeFunction(val.getAttributeName());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ArrayAtLookup arrayAtLookup(GroupingOperation parent) throws ParseException {AttributeValue val = null;
    GroupingExpression arg2 = null;
    jj_consume_token(ARRAY);
    jj_consume_token(DOT);
    jj_consume_token(AT);
    lbrace();
    val = attributeValue();
    comma();
    arg2 = exp(parent);
    rbrace();
{if ("" != null) return new ArrayAtLookup(val.getAttributeName(), arg2);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public InterpolatedLookup interpolatedLookup(GroupingOperation parent) throws ParseException {AttributeValue val = null;
    GroupingExpression arg2 = null;
    jj_consume_token(INTERPOLATEDLOOKUP);
    lbrace();
    val = attributeValue();
    comma();
    arg2 = exp(parent);
    rbrace();
{if ("" != null) return new InterpolatedLookup(val.getAttributeName(), arg2);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression avgExpression(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2 = null;
    jj_consume_token(AVG);
    lbrace();
    arg1 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      arg2 = exp(grp);
      switch (jj_nt.kind) {
      case COMMA:{
        comma();
        argN = expList(grp);
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    rbrace();
if (arg2 == null) {if ("" != null) return new AvgAggregator(arg1);}
      if (argN == null) {if ("" != null) return new AvgFunction(arg1, arg2);}
      {if ("" != null) return new AvgFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CatFunction catFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(CAT);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new CatFunction(arg1, arg2);}
      {if ("" != null) return new CatFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ConstantValue constantValue() throws ParseException {Number num;
    num = number();
{if ("" != null) return num instanceof Double ? new DoubleValue((Double)num) : new LongValue((Long)num);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ConstantValue constantValueSigned() throws ParseException {Number num;
    num = signedNumber();
{if ("" != null) return num instanceof Double ? new DoubleValue((Double)num) : new LongValue((Long)num);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public InfiniteValue infiniteNegativeValue() throws ParseException {
    neginf();
{if ("" != null) return new InfiniteValue(new Infinite(true));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public InfiniteValue infinitePositiveValue() throws ParseException {
    inf();
{if ("" != null) return new InfiniteValue(new Infinite(false));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public CountAggregator countAggregator() throws ParseException {
    jj_consume_token(COUNT);
    lbrace();
    rbrace();
{if ("" != null) return new CountAggregator();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DebugWaitFunction debugWaitFunction(GroupingOperation grp) throws ParseException {GroupingExpression arg;
 Number waitTime;
 BooleanValue busy;
    jj_consume_token(DEBUGWAIT);
    lbrace();
    arg = exp(grp);
    comma();
    waitTime = number();
    comma();
    busy = booleanValue();
    rbrace();
{if ("" != null) return new DebugWaitFunction(arg, new DoubleValue(waitTime.doubleValue()), busy);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DivFunction divFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(DIV);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new DivFunction(arg1, arg2);}
      {if ("" != null) return new DivFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public DocIdNsSpecificValue docIdNsSpecificValue() throws ParseException {
    jj_consume_token(DOCIDNSSPECIFIC);
    lbrace();
    rbrace();
{if ("" != null) return new DocIdNsSpecificValue();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FixedWidthFunction fixedWidthFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    Number num;
    jj_consume_token(FIXEDWIDTH);
    lbrace();
    exp = exp(grp);
    comma();
    num = number();
    rbrace();
{if ("" != null) return new FixedWidthFunction(exp, num);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression maxExpression(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2 = null;
    jj_consume_token(MAX);
    lbrace();
    arg1 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      arg2 = exp(grp);
      switch (jj_nt.kind) {
      case COMMA:{
        comma();
        argN = expList(grp);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    rbrace();
if (arg2 == null) {if ("" != null) return new MaxAggregator(arg1);}
      if (argN == null) {if ("" != null) return new MaxFunction(arg1, arg2);}
      {if ("" != null) return new MaxFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression md5Function(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    Number num;
    jj_consume_token(MD5);
    lbrace();
    exp = exp(grp);
    comma();
    num = number();
    rbrace();
{if ("" != null) return new Md5Function(exp, num.intValue());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression quantilesExpression(GroupingOperation grp) throws ParseException {GroupingExpression input;
    List<Number> qs = new ArrayList<Number>();
    Number q;
    jj_consume_token(QUANTILES);
    lbrace();
    lbracket();
    q = number();
qs.add(q);
    label_8:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        break label_8;
      }
      comma();
      q = number();
qs.add(q);
    }
    rbracket();
    comma();
    input = exp(grp);
    rbrace();
{if ("" != null) return new QuantileAggregator(qs, input);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression minExpression(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2 = null;
    jj_consume_token(MIN);
    lbrace();
    arg1 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      arg2 = exp(grp);
      switch (jj_nt.kind) {
      case COMMA:{
        comma();
        argN = expList(grp);
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    rbrace();
if (arg2 == null) {if ("" != null) return new MinAggregator(arg1);}
      if (argN == null) {if ("" != null) return new MinFunction(arg1, arg2);}
      {if ("" != null) return new MinFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ModFunction modFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(MOD);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new ModFunction(arg1, arg2);}
      {if ("" != null) return new ModFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public MulFunction mulFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(MUL);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new MulFunction(arg1, arg2);}
      {if ("" != null) return new MulFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression negFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(NEG);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return resolveNegation(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NormalizeSubjectFunction normalizeSubjectFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(NORMALIZESUBJECT);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new NormalizeSubjectFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public NowFunction nowFunction() throws ParseException {
    jj_consume_token(NOW);
    lbrace();
    rbrace();
{if ("" != null) return new NowFunction();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public OrFunction orFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(OR);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[36] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new OrFunction(arg1, arg2);}
      {if ("" != null) return new OrFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public PredefinedFunction predefinedFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    BucketResolver resolver = new BucketResolver();
    jj_consume_token(PREDEFINED);
    lbrace();
    exp = exp(grp);
    comma();
    bucket(grp, resolver);
    label_9:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        break label_9;
      }
      comma();
      bucket(grp, resolver);
    }
    rbrace();
{if ("" != null) return resolver.resolve(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RelevanceValue relevanceValue() throws ParseException {
    jj_consume_token(RELEVANCE);
    lbrace();
    rbrace();
{if ("" != null) return new RelevanceValue();}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ReverseFunction reverseFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(REVERSE);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new ReverseFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SizeFunction sizeFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(SIZE);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new SizeFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SortFunction sortFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(SORT);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new SortFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StringValue stringValue() throws ParseException {String str;
    jj_consume_token(STRING);
str = UnicodeUtilities.unquote(token.image);
    space();
{if ("" != null) return new StringValue(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RawValue rawValue(GroupingOperation grp) throws ParseException {RawBuffer buffer = new RawBuffer();
    lcurly();
    byteValue(buffer);
    label_10:
    while (true) {
      switch (jj_nt.kind) {
      case COMMA:{
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        break label_10;
      }
      comma();
      byteValue(buffer);
    }
    rcurly();
{if ("" != null) return new RawValue(buffer);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StandardDeviationAggregator stddevAggregator(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(STDDEV);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new StandardDeviationAggregator(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StringValue stringValueUnquoted() throws ParseException {String str;
    str = string();
{if ("" != null) return new StringValue(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StrCatFunction strCatFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(STRCAT);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new StrCatFunction(arg1, arg2);}
      {if ("" != null) return new StrCatFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public StrLenFunction strLenFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(STRLEN);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new StrLenFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SubFunction subFunction(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2;
    jj_consume_token(SUB);
    lbrace();
    arg1 = exp(grp);
    comma();
    arg2 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      argN = expList(grp);
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    rbrace();
if (argN == null) {if ("" != null) return new SubFunction(arg1, arg2);}
      {if ("" != null) return new SubFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SumAggregator sumAggregator(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(SUM);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new SumAggregator(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public SummaryValue summaryValue() throws ParseException {String str = null;
    jj_consume_token(SUMMARY);
    lbrace();
    switch (jj_nt.kind) {
    case STRING:
    case ACOS:
    case ACOSH:
    case ACCURACY:
    case ADD:
    case ALIAS:
    case ALL:
    case AND:
    case ARRAY:
    case AS:
    case AT:
    case ASIN:
    case ASINH:
    case ATAN:
    case ATANH:
    case ATTRIBUTE:
    case AVG:
    case BUCKET:
    case CAT:
    case CBRT:
    case COS:
    case COSH:
    case COUNT:
    case DEBUGWAIT:
    case DIV:
    case DOCIDNSSPECIFIC:
    case EACH:
    case EXP:
    case FILTER:
    case FIXEDWIDTH:
    case FLOOR:
    case GROUP:
    case HINT:
    case HYPOT:
    case KEEP:
    case LOG:
    case LOG1P:
    case LOG10:
    case MATH:
    case MAX:
    case MD5:
    case MIN:
    case MOD:
    case MUL:
    case NEG:
    case NOT:
    case NORMALIZESUBJECT:
    case NOW:
    case OR:
    case ORDER:
    case OUTPUT:
    case POW:
    case PRECISION:
    case PREDEFINED:
    case QUANTILES:
    case RANGE:
    case REGEX:
    case RELEVANCE:
    case REVERSE:
    case SIN:
    case SINH:
    case SIZE:
    case SORT:
    case INTERPOLATEDLOOKUP:
    case SQRT:
    case STDDEV:
    case STRCAT:
    case STRLEN:
    case SUB:
    case SUM:
    case SUMMARY:
    case TAN:
    case TANH:
    case TIME:
    case TIME_DATE:
    case TIME_DAYOFMONTH:
    case TIME_DAYOFWEEK:
    case TIME_DAYOFYEAR:
    case TIME_HOUROFDAY:
    case TIME_MINUTEOFHOUR:
    case TIME_MONTHOFYEAR:
    case TIME_SECONDOFMINUTE:
    case TIME_YEAR:
    case TODOUBLE:
    case TOLONG:
    case TORAW:
    case TOSTRING:
    case TRUE:
    case FALSE:
    case UCA:
    case WHERE:
    case X:
    case XOR:
    case XORBIT:
    case Y:
    case ZCURVE:
    case IDENTIFIER:{
      str = string();
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    rbrace();
{if ("" != null) return str == null ? new SummaryValue() : new SummaryValue(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FunctionNode timeFunction(GroupingOperation grp) throws ParseException {TimeFunctions.Type type;
    GroupingExpression exp;
    jj_consume_token(TIME);
    jj_consume_token(DOT);
    switch (jj_nt.kind) {
    case TIME_DATE:{
      jj_consume_token(TIME_DATE);
type = TimeFunctions.Type.DATE;
      break;
      }
    case TIME_DAYOFMONTH:{
      jj_consume_token(TIME_DAYOFMONTH);
type = TimeFunctions.Type.DAY_OF_MONTH;
      break;
      }
    case TIME_DAYOFWEEK:{
      jj_consume_token(TIME_DAYOFWEEK);
type = TimeFunctions.Type.DAY_OF_WEEK;
      break;
      }
    case TIME_DAYOFYEAR:{
      jj_consume_token(TIME_DAYOFYEAR);
type = TimeFunctions.Type.DAY_OF_YEAR;
      break;
      }
    case TIME_HOUROFDAY:{
      jj_consume_token(TIME_HOUROFDAY);
type = TimeFunctions.Type.HOUR_OF_DAY;
      break;
      }
    case TIME_MINUTEOFHOUR:{
      jj_consume_token(TIME_MINUTEOFHOUR);
type = TimeFunctions.Type.MINUTE_OF_HOUR;
      break;
      }
    case TIME_MONTHOFYEAR:{
      jj_consume_token(TIME_MONTHOFYEAR);
type = TimeFunctions.Type.MONTH_OF_YEAR;
      break;
      }
    case TIME_SECONDOFMINUTE:{
      jj_consume_token(TIME_SECONDOFMINUTE);
type = TimeFunctions.Type.SECOND_OF_MINUTE;
      break;
      }
    case TIME_YEAR:{
      jj_consume_token(TIME_YEAR);
type = TimeFunctions.Type.YEAR;
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return TimeFunctions.newInstance(type, exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FunctionNode mathFunction(GroupingOperation grp) throws ParseException {GroupingExpression arg1, arg2 = null;
    MathFunctions.Function func;
    jj_consume_token(MATH);
    jj_consume_token(DOT);
    switch (jj_nt.kind) {
    case HYPOT:
    case POW:{
      switch (jj_nt.kind) {
      case POW:{
        jj_consume_token(POW);
func = MathFunctions.Function.POW;
        break;
        }
      case HYPOT:{
        jj_consume_token(HYPOT);
func = MathFunctions.Function.HYPOT;
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      lbrace();
      arg1 = exp(grp);
      jj_consume_token(COMMA);
      arg2 = exp(grp);
      rbrace();
      break;
      }
    case ACOS:
    case ACOSH:
    case ASIN:
    case ASINH:
    case ATAN:
    case ATANH:
    case CBRT:
    case COS:
    case COSH:
    case EXP:
    case FLOOR:
    case LOG:
    case LOG1P:
    case LOG10:
    case SIN:
    case SINH:
    case SQRT:
    case TAN:
    case TANH:{
      switch (jj_nt.kind) {
      case EXP:{
        jj_consume_token(EXP);
func = MathFunctions.Function.EXP;
        break;
        }
      case LOG:{
        jj_consume_token(LOG);
func = MathFunctions.Function.LOG;
        break;
        }
      case LOG1P:{
        jj_consume_token(LOG1P);
func = MathFunctions.Function.LOG1P;
        break;
        }
      case LOG10:{
        jj_consume_token(LOG10);
func = MathFunctions.Function.LOG10;
        break;
        }
      case SIN:{
        jj_consume_token(SIN);
func = MathFunctions.Function.SIN;
        break;
        }
      case ASIN:{
        jj_consume_token(ASIN);
func = MathFunctions.Function.ASIN;
        break;
        }
      case COS:{
        jj_consume_token(COS);
func = MathFunctions.Function.COS;
        break;
        }
      case ACOS:{
        jj_consume_token(ACOS);
func = MathFunctions.Function.ACOS;
        break;
        }
      case TAN:{
        jj_consume_token(TAN);
func = MathFunctions.Function.TAN;
        break;
        }
      case ATAN:{
        jj_consume_token(ATAN);
func = MathFunctions.Function.ATAN;
        break;
        }
      case SQRT:{
        jj_consume_token(SQRT);
func = MathFunctions.Function.SQRT;
        break;
        }
      case SINH:{
        jj_consume_token(SINH);
func = MathFunctions.Function.SINH;
        break;
        }
      case ASINH:{
        jj_consume_token(ASINH);
func = MathFunctions.Function.ASINH;
        break;
        }
      case COSH:{
        jj_consume_token(COSH);
func = MathFunctions.Function.COSH;
        break;
        }
      case ACOSH:{
        jj_consume_token(ACOSH);
func = MathFunctions.Function.ACOSH;
        break;
        }
      case TANH:{
        jj_consume_token(TANH);
func = MathFunctions.Function.TANH;
        break;
        }
      case ATANH:{
        jj_consume_token(ATANH);
func = MathFunctions.Function.ATANH;
        break;
        }
      case FLOOR:{
        jj_consume_token(FLOOR);
func = MathFunctions.Function.FLOOR;
        break;
        }
      case CBRT:{
        jj_consume_token(CBRT);
func = MathFunctions.Function.CBRT;
        break;
        }
      default:
        jj_la1[44] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      lbrace();
      arg1 = exp(grp);
      rbrace();
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return MathFunctions.newInstance(func, arg1, arg2);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FunctionNode ucaFunction(GroupingOperation grp) throws ParseException {GroupingExpression arg;
    String locale;
    String strength = null;
    jj_consume_token(UCA);
    lbrace();
    arg = exp(grp);
    comma();
    locale = string();
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      strength = string();
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    rbrace();
{if ("" != null) return (strength == null ? new UcaFunction(arg, locale)
                               : new UcaFunction(arg, locale, strength));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FunctionNode zcurveFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    int dim;
    jj_consume_token(ZCURVE);
    jj_consume_token(DOT);
    switch (jj_nt.kind) {
    case X:{
      jj_consume_token(X);
dim = 0;
      break;
      }
    case Y:{
      jj_consume_token(Y);
dim = 1;
      break;
      }
    default:
      jj_la1[47] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return dim == 0 ? new ZCurveXFunction(exp) : new ZCurveYFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ToDoubleFunction toDoubleFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(TODOUBLE);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new ToDoubleFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ToLongFunction toLongFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(TOLONG);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new ToLongFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ToRawFunction toRawFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(TORAW);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new ToRawFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public ToStringFunction toStringFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    jj_consume_token(TOSTRING);
    lbrace();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new ToStringFunction(exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public GroupingExpression xorExpression(GroupingOperation grp) throws ParseException {List<GroupingExpression> argN = null;
    GroupingExpression arg1, arg2 = null;
    jj_consume_token(XOR);
    lbrace();
    arg1 = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      arg2 = exp(grp);
      switch (jj_nt.kind) {
      case COMMA:{
        comma();
        argN = expList(grp);
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    rbrace();
if (arg2 == null) {if ("" != null) return new XorAggregator(arg1);}
      if (argN == null) {if ("" != null) return new XorFunction(arg1, arg2);}
      {if ("" != null) return new XorFunction(arg1, arg2, argN.toArray(new GroupingExpression[argN.size()]));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public XorBitFunction xorBitFunction(GroupingOperation grp) throws ParseException {GroupingExpression exp;
    Number num;
    jj_consume_token(XORBIT);
    lbrace();
    exp = exp(grp);
    comma();
    num = number();
    rbrace();
{if ("" != null) return new XorBitFunction(exp, num.intValue());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FilterExpression filterPrimary(GroupingOperation grp) throws ParseException {FilterExpression f;
    switch (jj_nt.kind) {
    case LBRACE:{
      lbrace();
      f = filterExp(grp);
      rbrace();
      break;
      }
    case REGEX:{
      f = regexPredicate(grp);
      break;
      }
    case RANGE:{
      f = rangePredicate(grp);
      break;
      }
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return f;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RegexPredicate regexPredicate(GroupingOperation grp) throws ParseException {String pattern;
    GroupingExpression exp;
    jj_consume_token(REGEX);
    lbrace();
    pattern = string();
    comma();
    exp = exp(grp);
    rbrace();
{if ("" != null) return new RegexPredicate(pattern, exp);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public RangePredicate rangePredicate(GroupingOperation grp) throws ParseException {Number lower;
    Number upper;
    GroupingExpression exp;
    BooleanValue lowerInclusive = new BooleanValue(true);
    BooleanValue upperInclusive = new BooleanValue(false);
    jj_consume_token(RANGE);
    lbrace();
    lower = number();
    comma();
    upper = number();
    comma();
    exp = exp(grp);
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      lowerInclusive = booleanValue();
      comma();
      upperInclusive = booleanValue();
      break;
      }
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    rbrace();
{if ("" != null) return new RangePredicate(lower, upper, exp, lowerInclusive.getValue(), upperInclusive.getValue());}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FilterExpression orPredicate(GroupingOperation grp) throws ParseException {FilterExpression left, right;
    java.util.List<FilterExpression> args = new java.util.ArrayList<FilterExpression>();
    left = andPredicate(grp);
    label_11:
    while (true) {
      switch (jj_nt.kind) {
      case OR:{
        break;
        }
      default:
        jj_la1[52] = jj_gen;
        break label_11;
      }
      jj_consume_token(OR);
      space();
      right = andPredicate(grp);
args.add(right);
    }
if (args.isEmpty()) {if ("" != null) return left;}
        args.add(0, left);
        {if ("" != null) return new OrPredicate(args);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FilterExpression andPredicate(GroupingOperation grp) throws ParseException {FilterExpression left, right;
    java.util.List<FilterExpression> args = new java.util.ArrayList<FilterExpression>();
    left = notPredicate(grp);
    label_12:
    while (true) {
      switch (jj_nt.kind) {
      case AND:{
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        break label_12;
      }
      jj_consume_token(AND);
      space();
      right = notPredicate(grp);
args.add(right);
    }
if (args.isEmpty()) {if ("" != null) return left;}
        args.add(0, left);
        {if ("" != null) return new AndPredicate(args);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public FilterExpression notPredicate(GroupingOperation grp) throws ParseException {FilterExpression inner;
    switch (jj_nt.kind) {
    case NOT:{
      jj_consume_token(NOT);
      space();
      inner = notPredicate(grp);
{if ("" != null) return new NotPredicate(inner);}
      break;
      }
    case LBRACE:
    case RANGE:
    case REGEX:{
      inner = filterPrimary(grp);
{if ("" != null) return inner;}
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void bucket(GroupingOperation grp, BucketResolver resolver) throws ParseException {ConstantValue from, to = null;
    boolean inclusiveFrom, inclusiveTo;
    jj_consume_token(BUCKET);
    switch (jj_nt.kind) {
    case LBRACE:
    case LBRACKET:{
      switch (jj_nt.kind) {
      case LBRACE:{
        lbrace();
        break;
        }
      case LBRACKET:{
        lbracket();
        break;
        }
      default:
        jj_la1[55] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
inclusiveFrom = true;
      break;
      }
    case LT:{
      lt();
inclusiveFrom = false;
      break;
      }
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case NEGINF:{
      from = infiniteNegativeValue();
      break;
      }
    case LCURLY:{
      from = rawValue(grp);
      break;
      }
    case INTEGER:
    case FLOAT:
    case INFIX_SUB:{
      from = constantValueSigned();
      break;
      }
    case STRING:
    case ACOS:
    case ACOSH:
    case ACCURACY:
    case ADD:
    case ALIAS:
    case ALL:
    case AND:
    case ARRAY:
    case AS:
    case AT:
    case ASIN:
    case ASINH:
    case ATAN:
    case ATANH:
    case ATTRIBUTE:
    case AVG:
    case BUCKET:
    case CAT:
    case CBRT:
    case COS:
    case COSH:
    case COUNT:
    case DEBUGWAIT:
    case DIV:
    case DOCIDNSSPECIFIC:
    case EACH:
    case EXP:
    case FILTER:
    case FIXEDWIDTH:
    case FLOOR:
    case GROUP:
    case HINT:
    case HYPOT:
    case KEEP:
    case LOG:
    case LOG1P:
    case LOG10:
    case MATH:
    case MAX:
    case MD5:
    case MIN:
    case MOD:
    case MUL:
    case NEG:
    case NOT:
    case NORMALIZESUBJECT:
    case NOW:
    case OR:
    case ORDER:
    case OUTPUT:
    case POW:
    case PRECISION:
    case PREDEFINED:
    case QUANTILES:
    case RANGE:
    case REGEX:
    case RELEVANCE:
    case REVERSE:
    case SIN:
    case SINH:
    case SIZE:
    case SORT:
    case INTERPOLATEDLOOKUP:
    case SQRT:
    case STDDEV:
    case STRCAT:
    case STRLEN:
    case SUB:
    case SUM:
    case SUMMARY:
    case TAN:
    case TANH:
    case TIME:
    case TIME_DATE:
    case TIME_DAYOFMONTH:
    case TIME_DAYOFWEEK:
    case TIME_DAYOFYEAR:
    case TIME_HOUROFDAY:
    case TIME_MINUTEOFHOUR:
    case TIME_MONTHOFYEAR:
    case TIME_SECONDOFMINUTE:
    case TIME_YEAR:
    case TODOUBLE:
    case TOLONG:
    case TORAW:
    case TOSTRING:
    case TRUE:
    case FALSE:
    case UCA:
    case WHERE:
    case X:
    case XOR:
    case XORBIT:
    case Y:
    case ZCURVE:
    case IDENTIFIER:{
      from = stringValueUnquoted();
      break;
      }
    default:
      jj_la1[57] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch (jj_nt.kind) {
    case COMMA:{
      comma();
      switch (jj_nt.kind) {
      case INF:{
        to = infinitePositiveValue();
        break;
        }
      case LCURLY:{
        to = rawValue(grp);
        break;
        }
      case INTEGER:
      case FLOAT:
      case INFIX_SUB:{
        to = constantValueSigned();
        break;
        }
      case STRING:
      case ACOS:
      case ACOSH:
      case ACCURACY:
      case ADD:
      case ALIAS:
      case ALL:
      case AND:
      case ARRAY:
      case AS:
      case AT:
      case ASIN:
      case ASINH:
      case ATAN:
      case ATANH:
      case ATTRIBUTE:
      case AVG:
      case BUCKET:
      case CAT:
      case CBRT:
      case COS:
      case COSH:
      case COUNT:
      case DEBUGWAIT:
      case DIV:
      case DOCIDNSSPECIFIC:
      case EACH:
      case EXP:
      case FILTER:
      case FIXEDWIDTH:
      case FLOOR:
      case GROUP:
      case HINT:
      case HYPOT:
      case KEEP:
      case LOG:
      case LOG1P:
      case LOG10:
      case MATH:
      case MAX:
      case MD5:
      case MIN:
      case MOD:
      case MUL:
      case NEG:
      case NOT:
      case NORMALIZESUBJECT:
      case NOW:
      case OR:
      case ORDER:
      case OUTPUT:
      case POW:
      case PRECISION:
      case PREDEFINED:
      case QUANTILES:
      case RANGE:
      case REGEX:
      case RELEVANCE:
      case REVERSE:
      case SIN:
      case SINH:
      case SIZE:
      case SORT:
      case INTERPOLATEDLOOKUP:
      case SQRT:
      case STDDEV:
      case STRCAT:
      case STRLEN:
      case SUB:
      case SUM:
      case SUMMARY:
      case TAN:
      case TANH:
      case TIME:
      case TIME_DATE:
      case TIME_DAYOFMONTH:
      case TIME_DAYOFWEEK:
      case TIME_DAYOFYEAR:
      case TIME_HOUROFDAY:
      case TIME_MINUTEOFHOUR:
      case TIME_MONTHOFYEAR:
      case TIME_SECONDOFMINUTE:
      case TIME_YEAR:
      case TODOUBLE:
      case TOLONG:
      case TORAW:
      case TOSTRING:
      case TRUE:
      case FALSE:
      case UCA:
      case WHERE:
      case X:
      case XOR:
      case XORBIT:
      case Y:
      case ZCURVE:
      case IDENTIFIER:{
        to = stringValueUnquoted();
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case RBRACE:
    case GT:{
      switch (jj_nt.kind) {
      case GT:{
        gt();
        break;
        }
      case RBRACE:{
        rbrace();
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
inclusiveTo = false;
      break;
      }
    case RBRACKET:{
      rbracket();
inclusiveTo = true;
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
resolver.push(from, inclusiveFrom); resolver.push((to == null) ? from : to, inclusiveTo || to == null);
}

  final public Number signedNumber() throws ParseException {String str;
    boolean neg = false;
    switch (jj_nt.kind) {
    case INFIX_SUB:{
      jj_consume_token(INFIX_SUB);
neg = true;
      break;
      }
    default:
      jj_la1[62] = jj_gen;
      ;
    }
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    default:
      jj_la1[63] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
str = neg ? "-" + token.image : token.image;
    space();
{if ("" != null) return resolveNumber(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public Number number() throws ParseException {String str;
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
str = token.image;
    space();
{if ("" != null) return resolveNumber(str);}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public BooleanValue booleanValue() throws ParseException {String str;
    switch (jj_nt.kind) {
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
str = token.image;
    space();
{if ("" != null) return new BooleanValue(Boolean.parseBoolean(str));}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void byteValue(RawBuffer buffer) throws ParseException {
    switch (jj_nt.kind) {
    case INTEGER:{
      jj_consume_token(INTEGER);
buffer.put(Byte.parseByte(token.image));
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
buffer.put(token.image.getBytes());
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public String string() throws ParseException {String ret;
    switch (jj_nt.kind) {
    case ACOS:
    case ACOSH:
    case ACCURACY:
    case ADD:
    case ALIAS:
    case ALL:
    case AND:
    case ARRAY:
    case AS:
    case AT:
    case ASIN:
    case ASINH:
    case ATAN:
    case ATANH:
    case ATTRIBUTE:
    case AVG:
    case BUCKET:
    case CAT:
    case CBRT:
    case COS:
    case COSH:
    case COUNT:
    case DEBUGWAIT:
    case DIV:
    case DOCIDNSSPECIFIC:
    case EACH:
    case EXP:
    case FILTER:
    case FIXEDWIDTH:
    case FLOOR:
    case GROUP:
    case HINT:
    case HYPOT:
    case KEEP:
    case LOG:
    case LOG1P:
    case LOG10:
    case MATH:
    case MAX:
    case MD5:
    case MIN:
    case MOD:
    case MUL:
    case NEG:
    case NOT:
    case NORMALIZESUBJECT:
    case NOW:
    case OR:
    case ORDER:
    case OUTPUT:
    case POW:
    case PRECISION:
    case PREDEFINED:
    case QUANTILES:
    case RANGE:
    case REGEX:
    case RELEVANCE:
    case REVERSE:
    case SIN:
    case SINH:
    case SIZE:
    case SORT:
    case INTERPOLATEDLOOKUP:
    case SQRT:
    case STDDEV:
    case STRCAT:
    case STRLEN:
    case SUB:
    case SUM:
    case SUMMARY:
    case TAN:
    case TANH:
    case TIME:
    case TIME_DATE:
    case TIME_DAYOFMONTH:
    case TIME_DAYOFWEEK:
    case TIME_DAYOFYEAR:
    case TIME_HOUROFDAY:
    case TIME_MINUTEOFHOUR:
    case TIME_MONTHOFYEAR:
    case TIME_SECONDOFMINUTE:
    case TIME_YEAR:
    case TODOUBLE:
    case TOLONG:
    case TORAW:
    case TOSTRING:
    case TRUE:
    case FALSE:
    case UCA:
    case WHERE:
    case X:
    case XOR:
    case XORBIT:
    case Y:
    case ZCURVE:
    case IDENTIFIER:{
      ret = identifier();
      break;
      }
    case STRING:{
      jj_consume_token(STRING);
ret = UnicodeUtilities.unquote(token.image);
      space();
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public String identifier() throws ParseException {String ret;
    switch (jj_nt.kind) {
    case ACOS:{
      jj_consume_token(ACOS);
      break;
      }
    case ACOSH:{
      jj_consume_token(ACOSH);
      break;
      }
    case ACCURACY:{
      jj_consume_token(ACCURACY);
      break;
      }
    case ADD:{
      jj_consume_token(ADD);
      break;
      }
    case ALIAS:{
      jj_consume_token(ALIAS);
      break;
      }
    case ALL:{
      jj_consume_token(ALL);
      break;
      }
    case AND:{
      jj_consume_token(AND);
      break;
      }
    case ARRAY:{
      jj_consume_token(ARRAY);
      break;
      }
    case AS:{
      jj_consume_token(AS);
      break;
      }
    case AT:{
      jj_consume_token(AT);
      break;
      }
    case ASIN:{
      jj_consume_token(ASIN);
      break;
      }
    case ASINH:{
      jj_consume_token(ASINH);
      break;
      }
    case ATAN:{
      jj_consume_token(ATAN);
      break;
      }
    case ATANH:{
      jj_consume_token(ATANH);
      break;
      }
    case ATTRIBUTE:{
      jj_consume_token(ATTRIBUTE);
      break;
      }
    case AVG:{
      jj_consume_token(AVG);
      break;
      }
    case BUCKET:{
      jj_consume_token(BUCKET);
      break;
      }
    case CAT:{
      jj_consume_token(CAT);
      break;
      }
    case CBRT:{
      jj_consume_token(CBRT);
      break;
      }
    case COS:{
      jj_consume_token(COS);
      break;
      }
    case COSH:{
      jj_consume_token(COSH);
      break;
      }
    case COUNT:{
      jj_consume_token(COUNT);
      break;
      }
    case DEBUGWAIT:{
      jj_consume_token(DEBUGWAIT);
      break;
      }
    case DIV:{
      jj_consume_token(DIV);
      break;
      }
    case DOCIDNSSPECIFIC:{
      jj_consume_token(DOCIDNSSPECIFIC);
      break;
      }
    case EACH:{
      jj_consume_token(EACH);
      break;
      }
    case EXP:{
      jj_consume_token(EXP);
      break;
      }
    case FILTER:{
      jj_consume_token(FILTER);
      break;
      }
    case FIXEDWIDTH:{
      jj_consume_token(FIXEDWIDTH);
      break;
      }
    case FLOOR:{
      jj_consume_token(FLOOR);
      break;
      }
    case GROUP:{
      jj_consume_token(GROUP);
      break;
      }
    case HINT:{
      jj_consume_token(HINT);
      break;
      }
    case HYPOT:{
      jj_consume_token(HYPOT);
      break;
      }
    case IDENTIFIER:{
      jj_consume_token(IDENTIFIER);
      break;
      }
    case KEEP:{
      jj_consume_token(KEEP);
      break;
      }
    case LOG:{
      jj_consume_token(LOG);
      break;
      }
    case LOG1P:{
      jj_consume_token(LOG1P);
      break;
      }
    case LOG10:{
      jj_consume_token(LOG10);
      break;
      }
    case MATH:{
      jj_consume_token(MATH);
      break;
      }
    case MAX:{
      jj_consume_token(MAX);
      break;
      }
    case MD5:{
      jj_consume_token(MD5);
      break;
      }
    case MIN:{
      jj_consume_token(MIN);
      break;
      }
    case MOD:{
      jj_consume_token(MOD);
      break;
      }
    case MUL:{
      jj_consume_token(MUL);
      break;
      }
    case NEG:{
      jj_consume_token(NEG);
      break;
      }
    case NOT:{
      jj_consume_token(NOT);
      break;
      }
    case NORMALIZESUBJECT:{
      jj_consume_token(NORMALIZESUBJECT);
      break;
      }
    case NOW:{
      jj_consume_token(NOW);
      break;
      }
    case OR:{
      jj_consume_token(OR);
      break;
      }
    case ORDER:{
      jj_consume_token(ORDER);
      break;
      }
    case OUTPUT:{
      jj_consume_token(OUTPUT);
      break;
      }
    case POW:{
      jj_consume_token(POW);
      break;
      }
    case PRECISION:{
      jj_consume_token(PRECISION);
      break;
      }
    case PREDEFINED:{
      jj_consume_token(PREDEFINED);
      break;
      }
    case QUANTILES:{
      jj_consume_token(QUANTILES);
      break;
      }
    case RANGE:{
      jj_consume_token(RANGE);
      break;
      }
    case REGEX:{
      jj_consume_token(REGEX);
      break;
      }
    case RELEVANCE:{
      jj_consume_token(RELEVANCE);
      break;
      }
    case REVERSE:{
      jj_consume_token(REVERSE);
      break;
      }
    case SIN:{
      jj_consume_token(SIN);
      break;
      }
    case SINH:{
      jj_consume_token(SINH);
      break;
      }
    case SIZE:{
      jj_consume_token(SIZE);
      break;
      }
    case SORT:{
      jj_consume_token(SORT);
      break;
      }
    case INTERPOLATEDLOOKUP:{
      jj_consume_token(INTERPOLATEDLOOKUP);
      break;
      }
    case SQRT:{
      jj_consume_token(SQRT);
      break;
      }
    case STDDEV:{
      jj_consume_token(STDDEV);
      break;
      }
    case STRCAT:{
      jj_consume_token(STRCAT);
      break;
      }
    case STRLEN:{
      jj_consume_token(STRLEN);
      break;
      }
    case SUB:{
      jj_consume_token(SUB);
      break;
      }
    case SUM:{
      jj_consume_token(SUM);
      break;
      }
    case SUMMARY:{
      jj_consume_token(SUMMARY);
      break;
      }
    case TAN:{
      jj_consume_token(TAN);
      break;
      }
    case TANH:{
      jj_consume_token(TANH);
      break;
      }
    case TIME:{
      jj_consume_token(TIME);
      break;
      }
    case TIME_DATE:{
      jj_consume_token(TIME_DATE);
      break;
      }
    case TIME_DAYOFMONTH:{
      jj_consume_token(TIME_DAYOFMONTH);
      break;
      }
    case TIME_DAYOFWEEK:{
      jj_consume_token(TIME_DAYOFWEEK);
      break;
      }
    case TIME_DAYOFYEAR:{
      jj_consume_token(TIME_DAYOFYEAR);
      break;
      }
    case TIME_HOUROFDAY:{
      jj_consume_token(TIME_HOUROFDAY);
      break;
      }
    case TIME_MINUTEOFHOUR:{
      jj_consume_token(TIME_MINUTEOFHOUR);
      break;
      }
    case TIME_MONTHOFYEAR:{
      jj_consume_token(TIME_MONTHOFYEAR);
      break;
      }
    case TIME_SECONDOFMINUTE:{
      jj_consume_token(TIME_SECONDOFMINUTE);
      break;
      }
    case TIME_YEAR:{
      jj_consume_token(TIME_YEAR);
      break;
      }
    case TODOUBLE:{
      jj_consume_token(TODOUBLE);
      break;
      }
    case TOLONG:{
      jj_consume_token(TOLONG);
      break;
      }
    case TORAW:{
      jj_consume_token(TORAW);
      break;
      }
    case TOSTRING:{
      jj_consume_token(TOSTRING);
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
      break;
      }
    case UCA:{
      jj_consume_token(UCA);
      break;
      }
    case WHERE:{
      jj_consume_token(WHERE);
      break;
      }
    case X:{
      jj_consume_token(X);
      break;
      }
    case XOR:{
      jj_consume_token(XOR);
      break;
      }
    case XORBIT:{
      jj_consume_token(XORBIT);
      break;
      }
    case Y:{
      jj_consume_token(Y);
      break;
      }
    case ZCURVE:{
      jj_consume_token(ZCURVE);
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ret = token.image;
    space();
{if ("" != null) return ret;}
    throw new IllegalStateException ("Missing return statement in function");
}

  final public void add() throws ParseException {
    jj_consume_token(INFIX_ADD);
    space();
}

  final public void comma() throws ParseException {
    jj_consume_token(COMMA);
    space();
}

  final public void div() throws ParseException {
    jj_consume_token(INFIX_DIV);
    space();
}

  final public void eq() throws ParseException {
    jj_consume_token(EQ);
    space();
}

  final public void lt() throws ParseException {
    jj_consume_token(LT);
    space();
}

  final public void gt() throws ParseException {
    jj_consume_token(GT);
    space();
}

  final public void inf() throws ParseException {
    jj_consume_token(INF);
    space();
}

  final public void neginf() throws ParseException {
    jj_consume_token(NEGINF);
    space();
}

  final public void lbracket() throws ParseException {
    jj_consume_token(LBRACKET);
    space();
}

  final public void rbracket() throws ParseException {
    jj_consume_token(RBRACKET);
    space();
}

  final public void lbrace() throws ParseException {
    jj_consume_token(LBRACE);
    space();
}

  final public void lcurly() throws ParseException {
    jj_consume_token(LCURLY);
    space();
}

  final public void mod() throws ParseException {
    jj_consume_token(INFIX_MOD);
    space();
}

  final public void mul() throws ParseException {
    jj_consume_token(INFIX_MUL);
    space();
}

  final public void rbrace() throws ParseException {
    jj_consume_token(RBRACE);
    space();
}

  final public void rcurly() throws ParseException {
    jj_consume_token(RCURLY);
    space();
}

  final public void sub() throws ParseException {
    jj_consume_token(INFIX_SUB);
    space();
}

  final public void scolon() throws ParseException {
    jj_consume_token(SCOLON);
    space();
}

  final public void space() throws ParseException {
    label_13:
    while (true) {
      switch (jj_nt.kind) {
      case SPACE:{
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        break label_13;
      }
      jj_consume_token(SPACE);
    }
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla;
    jj_scanpos = token;
    jj_lastpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_3R_69()
 {
    if (jj_scan_token(AVG)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_70()
 {
    if (jj_scan_token(CAT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_71()
 {
    if (jj_3R_116()) return true;
    return false;
  }

  private boolean jj_3R_72()
 {
    if (jj_scan_token(COUNT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_116()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(1)) {
    jj_scanpos = xsp;
    if (jj_scan_token(5)) return true;
    }
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_73()
 {
    if (jj_scan_token(DEBUGWAIT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_74()
 {
    if (jj_scan_token(DIV)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_75()
 {
    if (jj_scan_token(DOCIDNSSPECIFIC)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_62()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    }
    return false;
  }

  private boolean jj_3R_112()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_76()
 {
    if (jj_scan_token(FIXEDWIDTH)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_60()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(29)) {
    jj_scanpos = xsp;
    if (jj_scan_token(30)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_scan_token(33)) {
    jj_scanpos = xsp;
    if (jj_scan_token(34)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) {
    jj_scanpos = xsp;
    if (jj_scan_token(36)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(39)) {
    jj_scanpos = xsp;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) {
    jj_scanpos = xsp;
    if (jj_scan_token(42)) {
    jj_scanpos = xsp;
    if (jj_scan_token(43)) {
    jj_scanpos = xsp;
    if (jj_scan_token(44)) {
    jj_scanpos = xsp;
    if (jj_scan_token(45)) {
    jj_scanpos = xsp;
    if (jj_scan_token(46)) {
    jj_scanpos = xsp;
    if (jj_scan_token(47)) {
    jj_scanpos = xsp;
    if (jj_scan_token(48)) {
    jj_scanpos = xsp;
    if (jj_scan_token(49)) {
    jj_scanpos = xsp;
    if (jj_scan_token(50)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(56)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(58)) {
    jj_scanpos = xsp;
    if (jj_scan_token(59)) {
    jj_scanpos = xsp;
    if (jj_scan_token(60)) {
    jj_scanpos = xsp;
    if (jj_scan_token(61)) {
    jj_scanpos = xsp;
    if (jj_scan_token(124)) {
    jj_scanpos = xsp;
    if (jj_scan_token(62)) {
    jj_scanpos = xsp;
    if (jj_scan_token(63)) {
    jj_scanpos = xsp;
    if (jj_scan_token(64)) {
    jj_scanpos = xsp;
    if (jj_scan_token(65)) {
    jj_scanpos = xsp;
    if (jj_scan_token(66)) {
    jj_scanpos = xsp;
    if (jj_scan_token(67)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(70)) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(72)) {
    jj_scanpos = xsp;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(74)) {
    jj_scanpos = xsp;
    if (jj_scan_token(75)) {
    jj_scanpos = xsp;
    if (jj_scan_token(76)) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_scan_token(79)) {
    jj_scanpos = xsp;
    if (jj_scan_token(80)) {
    jj_scanpos = xsp;
    if (jj_scan_token(81)) {
    jj_scanpos = xsp;
    if (jj_scan_token(82)) {
    jj_scanpos = xsp;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) {
    jj_scanpos = xsp;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) {
    jj_scanpos = xsp;
    if (jj_scan_token(90)) {
    jj_scanpos = xsp;
    if (jj_scan_token(91)) {
    jj_scanpos = xsp;
    if (jj_scan_token(92)) {
    jj_scanpos = xsp;
    if (jj_scan_token(93)) {
    jj_scanpos = xsp;
    if (jj_scan_token(94)) {
    jj_scanpos = xsp;
    if (jj_scan_token(95)) {
    jj_scanpos = xsp;
    if (jj_scan_token(96)) {
    jj_scanpos = xsp;
    if (jj_scan_token(97)) {
    jj_scanpos = xsp;
    if (jj_scan_token(98)) {
    jj_scanpos = xsp;
    if (jj_scan_token(99)) {
    jj_scanpos = xsp;
    if (jj_scan_token(100)) {
    jj_scanpos = xsp;
    if (jj_scan_token(101)) {
    jj_scanpos = xsp;
    if (jj_scan_token(102)) {
    jj_scanpos = xsp;
    if (jj_scan_token(103)) {
    jj_scanpos = xsp;
    if (jj_scan_token(104)) {
    jj_scanpos = xsp;
    if (jj_scan_token(105)) {
    jj_scanpos = xsp;
    if (jj_scan_token(106)) {
    jj_scanpos = xsp;
    if (jj_scan_token(107)) {
    jj_scanpos = xsp;
    if (jj_scan_token(108)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(110)) {
    jj_scanpos = xsp;
    if (jj_scan_token(111)) {
    jj_scanpos = xsp;
    if (jj_scan_token(112)) {
    jj_scanpos = xsp;
    if (jj_scan_token(113)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(117)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(120)) {
    jj_scanpos = xsp;
    if (jj_scan_token(121)) {
    jj_scanpos = xsp;
    if (jj_scan_token(122)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_78()
 {
    if (jj_scan_token(MAX)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_113()
 {
    if (jj_scan_token(STRING)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_79()
 {
    if (jj_scan_token(MD5)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_94()
 {
    if (jj_scan_token(QUANTILES)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_80()
 {
    if (jj_scan_token(MIN)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_81()
 {
    if (jj_scan_token(MOD)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_82()
 {
    if (jj_scan_token(MUL)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_83()
 {
    if (jj_scan_token(NEG)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_84()
 {
    if (jj_scan_token(NORMALIZESUBJECT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_85()
 {
    if (jj_scan_token(NOW)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_121()
 {
    if (jj_scan_token(INFIX_ADD)) return true;
    return false;
  }

  private boolean jj_3R_86()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_87()
 {
    if (jj_scan_token(PREDEFINED)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_88()
 {
    if (jj_scan_token(RELEVANCE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_89()
 {
    if (jj_scan_token(REVERSE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_90()
 {
    if (jj_scan_token(SIZE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_64()
 {
    if (jj_scan_token(LBRACE)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_91()
 {
    if (jj_scan_token(SORT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_61()
 {
    if (jj_scan_token(LCURLY)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_96()
 {
    if (jj_scan_token(STRING)) return true;
    if (jj_3R_111()) return true;
    return false;
  }

  private boolean jj_3R_63()
 {
    if (jj_scan_token(RCURLY)) return true;
    return false;
  }

  private boolean jj_3R_95()
 {
    if (jj_scan_token(STDDEV)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_122()
 {
    if (jj_scan_token(INFIX_SUB)) return true;
    return false;
  }

  private boolean jj_3R_111()
 {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(7)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_97()
 {
    if (jj_scan_token(STRCAT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_98()
 {
    if (jj_scan_token(STRLEN)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_99()
 {
    if (jj_scan_token(SUB)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_100()
 {
    if (jj_scan_token(SUM)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_65()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) jj_scanpos = xsp;
    if (jj_3R_115()) return true;
    return false;
  }

  private boolean jj_3R_101()
 {
    if (jj_scan_token(SUMMARY)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_114()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_117()) {
    jj_scanpos = xsp;
    if (jj_3R_118()) return true;
    }
    return false;
  }

  private boolean jj_3R_117()
 {
    if (jj_3R_121()) return true;
    return false;
  }

  private boolean jj_3R_118()
 {
    if (jj_3R_122()) return true;
    return false;
  }

  private boolean jj_3R_102()
 {
    if (jj_scan_token(TIME)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) {
    jj_scanpos = xsp;
    if (jj_3R_120()) return true;
    }
    return false;
  }

  private boolean jj_3R_119()
 {
    if (jj_scan_token(DOLLAR)) return true;
    return false;
  }

  private boolean jj_3R_120()
 {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_77()
 {
    if (jj_scan_token(MATH)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_123()
 {
    if (jj_3R_124()) return true;
    return false;
  }

  private boolean jj_3R_124()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_125()) return true;
    }
    return false;
  }

  private boolean jj_3_1()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_14()) {
    jj_scanpos = xsp;
    if (jj_3R_15()) {
    jj_scanpos = xsp;
    if (jj_3R_16()) {
    jj_scanpos = xsp;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_14()
 {
    if (jj_3R_64()) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  private boolean jj_3R_15()
 {
    if (jj_3R_66()) return true;
    return false;
  }

  private boolean jj_3R_107()
 {
    if (jj_scan_token(UCA)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_16()
 {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_17()
 {
    if (jj_3R_68()) return true;
    return false;
  }

  private boolean jj_3R_18()
 {
    if (jj_3R_69()) return true;
    return false;
  }

  private boolean jj_3R_19()
 {
    if (jj_3R_70()) return true;
    return false;
  }

  private boolean jj_3R_20()
 {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_21()
 {
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_22()
 {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_23()
 {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3R_24()
 {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_25()
 {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_26()
 {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_110()
 {
    if (jj_scan_token(ZCURVE)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_27()
 {
    if (jj_3R_78()) return true;
    return false;
  }

  private boolean jj_3R_28()
 {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_29()
 {
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_30()
 {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_31()
 {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3R_32()
 {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3R_33()
 {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_34()
 {
    if (jj_3R_85()) return true;
    return false;
  }

  private boolean jj_3R_35()
 {
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_103()
 {
    if (jj_scan_token(TODOUBLE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_36()
 {
    if (jj_3R_87()) return true;
    return false;
  }

  private boolean jj_3R_37()
 {
    if (jj_3R_88()) return true;
    return false;
  }

  private boolean jj_3R_38()
 {
    if (jj_3R_89()) return true;
    return false;
  }

  private boolean jj_3R_39()
 {
    if (jj_3R_90()) return true;
    return false;
  }

  private boolean jj_3R_40()
 {
    if (jj_3R_91()) return true;
    return false;
  }

  private boolean jj_3R_41()
 {
    if (jj_3R_92()) return true;
    return false;
  }

  private boolean jj_3R_42()
 {
    if (jj_3R_93()) return true;
    return false;
  }

  private boolean jj_3R_43()
 {
    if (jj_3R_94()) return true;
    return false;
  }

  private boolean jj_3R_44()
 {
    if (jj_3R_95()) return true;
    return false;
  }

  private boolean jj_3R_104()
 {
    if (jj_scan_token(TOLONG)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_45()
 {
    if (jj_3R_96()) return true;
    return false;
  }

  private boolean jj_3R_46()
 {
    if (jj_3R_97()) return true;
    return false;
  }

  private boolean jj_3R_47()
 {
    if (jj_3R_98()) return true;
    return false;
  }

  private boolean jj_3R_125()
 {
    if (jj_3R_126()) return true;
    return false;
  }

  private boolean jj_3R_48()
 {
    if (jj_3R_99()) return true;
    return false;
  }

  private boolean jj_3R_49()
 {
    if (jj_3R_100()) return true;
    return false;
  }

  private boolean jj_3R_50()
 {
    if (jj_3R_101()) return true;
    return false;
  }

  private boolean jj_3R_51()
 {
    if (jj_3R_102()) return true;
    return false;
  }

  private boolean jj_3R_52()
 {
    if (jj_3R_103()) return true;
    return false;
  }

  private boolean jj_3R_53()
 {
    if (jj_3R_104()) return true;
    return false;
  }

  private boolean jj_3R_105()
 {
    if (jj_scan_token(TORAW)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_54()
 {
    if (jj_3R_105()) return true;
    return false;
  }

  private boolean jj_3R_55()
 {
    if (jj_3R_106()) return true;
    return false;
  }

  private boolean jj_3R_66()
 {
    if (jj_scan_token(ADD)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_56()
 {
    if (jj_3R_107()) return true;
    return false;
  }

  private boolean jj_3R_57()
 {
    if (jj_3R_108()) return true;
    return false;
  }

  private boolean jj_3R_58()
 {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_59()
 {
    if (jj_3R_110()) return true;
    return false;
  }

  private boolean jj_3R_106()
 {
    if (jj_scan_token(TOSTRING)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_67()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_108()
 {
    if (jj_scan_token(XOR)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_126()
 {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(DOT)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_109()
 {
    if (jj_scan_token(XORBIT)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_3R_61()) return true;
    if (jj_3R_62()) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_68()
 {
    if (jj_scan_token(ATTRIBUTE)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_92()
 {
    if (jj_scan_token(ARRAY)) return true;
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3R_93()
 {
    if (jj_scan_token(INTERPOLATEDLOOKUP)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public GroupingParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[70];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0x100,0x0,0x0,0x0,0x0,0x80000000,0x4000022,0x80000000,0x0,0x400,0x200,0x22000,0x22000,0x0,0x1000,0xf0040422,0x3e000,0x3e000,0x10040022,0xe0000000,0x200,0x200,0x100000,0x100000,0x800,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0x200,0xf0000000,0x0,0x0,0x60000000,0x60000000,0x200,0x0,0x200,0x200,0x40000,0x200,0x0,0x0,0x40000,0x1040000,0x1440000,0xf8120022,0xf4120022,0x200,0x880000,0x2880000,0x20000,0x22,0x22,0x0,0x10000002,0xf0000000,0xe0000000,0x80,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0x0,0x0,0x400004,0x20,0x8000000,0x51000002,0x0,0x51000002,0x400004,0x0,0x0,0x0,0x0,0x20,0x0,0xffffffff,0x0,0x0,0x23c5819,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x20000000,0x84838780,0xa4838780,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x0,0x16008,0x0,0x16008,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x0,0xee661dfc,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0x0,0x8000,0x11800003,0x11808003,0x0,0x0,0x0,0x0,0x180000,0x0,0x1000,0x0,0x180200,0x0,0x0,0xffffffff,0xffffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xffffffff,0xffffffff,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x0,0x400000,0x0,0x0,0x0,0x400000,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fffffff,0x0,0x0,0xb278027,0x1fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fffffff,0x7fc0,0x0,0x18,0x18,0x0,0x4800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1fffffff,0x1fffffff,0x0,0x0,0x0,0x0,0x0,0x0,0x180000,0x0,0x1fffffff,0x1fffffff,0x0,};
	}
  private final JJCalls[] jj_2_rtns = new JJCalls[3];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /**
   * Constructor with user supplied CharStream.
   * @param stream stream to init with
   */
  public GroupingParser(final CharStream stream) {
	 token_source = new GroupingParserTokenManager(stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
	 for (int i = 0; i < 70; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise.
   * @param stream stream to init with
   */
  public void ReInit(final CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
   jj_nt = token_source.getNextToken();
   token.next = jj_nt;
	 jj_gen = 0;
   for (int i = 0; i < 70; i++)
     jj_la1[i] = -1;
   for (int i = 0; i < jj_2_rtns.length; i++)
     jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Constructor with generated Token Manager.
   * @param tm Token manager to use
   */
  public GroupingParser(final GroupingParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 70; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /**
   * Reinitialise
   * @param tm Token manager to use
   */
  public void ReInit(final GroupingParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 token.next = jj_nt = token_source.getNextToken();
	 jj_gen = 0;
	 for (int i = 0; i < 70; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(final int kind) throws ParseException {
    final Token oldToken = token;
    token = jj_nt;
    if (token.next != null)
      jj_nt = jj_nt.next;
    else {
      jj_nt.next = token_source.getNextToken();
      jj_nt = jj_nt.next;
    }
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen)
              c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  private static final class LookaheadSuccess extends IllegalStateException {}
  private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		   jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		   jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


  /**
   * @return the next Token.
   */
  public final Token getNextToken() {
   token = jj_nt;
   if (token.next != null)
     jj_nt = jj_nt.next;
   else
     jj_nt = jj_nt.next = token_source.getNextToken();
	 jj_gen++;
	 return token;
  }

  /**
   * @param index index to be retrieved
   * @return the specific Token.
   */
  public final Token getToken(final int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next == null)
        t.next = token_source.getNextToken();
      t = t.next;
    }
    return t;
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
  if (pos >= 100) {
    return;
  }

  if (pos == jj_endpos + 1) {
    jj_lasttokens[jj_endpos++] = kind;
  } else if (jj_endpos != 0) {
    jj_expentry = new int[jj_endpos];

    for (int i = 0; i < jj_endpos; i++) {
      jj_expentry[i] = jj_lasttokens[i];
    }

    for (final int[] oldentry : jj_expentries) {
      if (oldentry.length == jj_expentry.length) {
        boolean isMatched = true;
        for (int i = 0; i < jj_expentry.length; i++) {
          if (oldentry[i] != jj_expentry[i]) {
            isMatched = false;
            break;
          }
        }
        if (isMatched) {
          jj_expentries.add(jj_expentry);
          break;
        }
      }
    }

    if (pos != 0) {
      jj_endpos = pos;
      jj_lasttokens[jj_endpos - 1] = kind;
    }
  }
}

  /**
   * Generate ParseException.
   * @return new Exception object. Never <code>null</code>
   */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[127];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 70; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 127; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /**
   * @return Always <code>false</code>.
   */
  public final boolean trace_enabled() {
    return false;
  }

  /** Enable tracing. */
  public final void enable_tracing() {}

  /** Disable tracing. */
  public final void disable_tracing() {}

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 3; i++) {
      try {
        JJCalls p = jj_2_rtns[i];
        do {
          if (p.gen > jj_gen) {
            jj_la = p.arg;
            jj_scanpos = p.first;
            jj_lastpos = p.first;
            switch (i) {
              case 0: jj_3_1(); break;
              case 1: jj_3_2(); break;
              case 2: jj_3_3(); break;
            }
          }
          p = p.next;
        } while (p != null);
      } catch(LookaheadSuccess ls) { /* ignore */ }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) {
        p.next = new JJCalls();
        p = p.next;
        break;
      }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; 
    p.first = token;
    p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
