// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of rate-limiting
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 * Configuration of the rate limiting algorithm
 */
public final class RateLimitingConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "6d50886971d1e8d4a244f21e5e3acb37";
  public final static String CONFIG_DEF_NAME = "rate-limiting";
  public final static String CONFIG_DEF_NAMESPACE = "search.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.config",
    "capacityIncrement double default=1000",
    "maxAvailableCapacity double default=10000",
    "recheckForCapacityProbability double default=0.001",
    "localRate bool default=false"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Double capacityIncrement = null;
    private Double maxAvailableCapacity = null;
    private Double recheckForCapacityProbability = null;
    private Boolean localRate = null;

    public Builder() { }

    public Builder(RateLimitingConfig config) {
      capacityIncrement(config.capacityIncrement());
      maxAvailableCapacity(config.maxAvailableCapacity());
      recheckForCapacityProbability(config.recheckForCapacityProbability());
      localRate(config.localRate());
    }

    private Builder override(Builder __superior) {
      if (__superior.capacityIncrement != null)
        capacityIncrement(__superior.capacityIncrement);
      if (__superior.maxAvailableCapacity != null)
        maxAvailableCapacity(__superior.maxAvailableCapacity);
      if (__superior.recheckForCapacityProbability != null)
        recheckForCapacityProbability(__superior.recheckForCapacityProbability);
      if (__superior.localRate != null)
        localRate(__superior.localRate);
      return this;
    }

    public Builder capacityIncrement(double __value) {
      capacityIncrement = __value;
      return this;
    }

    private Builder capacityIncrement(String __value) {
      return capacityIncrement(Double.valueOf(__value));
    }

    public Builder maxAvailableCapacity(double __value) {
      maxAvailableCapacity = __value;
      return this;
    }

    private Builder maxAvailableCapacity(String __value) {
      return maxAvailableCapacity(Double.valueOf(__value));
    }

    public Builder recheckForCapacityProbability(double __value) {
      recheckForCapacityProbability = __value;
      return this;
    }

    private Builder recheckForCapacityProbability(String __value) {
      return recheckForCapacityProbability(Double.valueOf(__value));
    }

    public Builder localRate(boolean __value) {
      localRate = __value;
      return this;
    }

    private Builder localRate(String __value) {
      return localRate(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public RateLimitingConfig build() {
      return new RateLimitingConfig(this);
    }

  }

  // How much additional capacity to assign to a thread each time it has run out.
  // A higher number means less thread contention and less accuracy
  private final DoubleNode capacityIncrement;
  // The max capacity which will ever (and initially) be available to requesting threads on one node
  // A higher number means we'll be less sensitive to intermittent overlap
  // A good number may be capacityIncrement * 10
  private final DoubleNode maxAvailableCapacity;
  // The probability per request that we check for more quota when we have run out.
  // A higher number means less probability of rejecting a request unnecessarily
  // but also more thread contention.
  // A good number may be 1 / (maxAvailableCapacity * average-cost)
  private final DoubleNode recheckForCapacityProbability;
  // Set to true to interpret the rate.quota given in the query as a node-local value
  // instead of a cluster-wide value.
  private final BooleanNode localRate;

  public RateLimitingConfig(Builder builder) {
    this(builder, true);
  }

  private RateLimitingConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "rate-limiting must be initialized: " + builder.__uninitialized);

    capacityIncrement = (builder.capacityIncrement == null) ?
        new DoubleNode(1000D) : new DoubleNode(builder.capacityIncrement);
    maxAvailableCapacity = (builder.maxAvailableCapacity == null) ?
        new DoubleNode(10000D) : new DoubleNode(builder.maxAvailableCapacity);
    recheckForCapacityProbability = (builder.recheckForCapacityProbability == null) ?
        new DoubleNode(0.001D) : new DoubleNode(builder.recheckForCapacityProbability);
    localRate = (builder.localRate == null) ?
        new BooleanNode(false) : new BooleanNode(builder.localRate);
  }

  /**
   * @return rate-limiting.capacityIncrement
   */
  public double capacityIncrement() {
    return capacityIncrement.value();
  }

  /**
   * @return rate-limiting.maxAvailableCapacity
   */
  public double maxAvailableCapacity() {
    return maxAvailableCapacity.value();
  }

  /**
   * @return rate-limiting.recheckForCapacityProbability
   */
  public double recheckForCapacityProbability() {
    return recheckForCapacityProbability.value();
  }

  /**
   * @return rate-limiting.localRate
   */
  public boolean localRate() {
    return localRate.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(RateLimitingConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("rate-limiting");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
