// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.search.config;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of cluster
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ClusterConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "79bbef68dd4ead98136666457eb9e678";
  public final static String CONFIG_DEF_NAME = "cluster";
  public final static String CONFIG_DEF_NAMESPACE = "search.config";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=search.config",
    "cacheTimeout double default=0",
    "clusterName string",
    "maxQueryTimeout double default=600",
    "maxQueryCacheTimeout double default=10",
    "configid string default=\"\"",
    "storageRoute string default=\"\"",
    "indexMode enum {INDEX, STREAMING, STORE_ONLY} default = INDEX"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "clusterName"
      ));

    private Double cacheTimeout = null;
    private String clusterName = null;
    private Double maxQueryTimeout = null;
    private Double maxQueryCacheTimeout = null;
    private String configid = null;
    private String storageRoute = null;
    private IndexMode.Enum indexMode = null;

    public Builder() { }

    public Builder(ClusterConfig config) {
      cacheTimeout(config.cacheTimeout());
      clusterName(config.clusterName());
      maxQueryTimeout(config.maxQueryTimeout());
      maxQueryCacheTimeout(config.maxQueryCacheTimeout());
      configid(config.configid());
      storageRoute(config.storageRoute());
      indexMode(config.indexMode());
    }

    private Builder override(Builder __superior) {
      if (__superior.cacheTimeout != null)
        cacheTimeout(__superior.cacheTimeout);
      if (__superior.clusterName != null)
        clusterName(__superior.clusterName);
      if (__superior.maxQueryTimeout != null)
        maxQueryTimeout(__superior.maxQueryTimeout);
      if (__superior.maxQueryCacheTimeout != null)
        maxQueryCacheTimeout(__superior.maxQueryCacheTimeout);
      if (__superior.configid != null)
        configid(__superior.configid);
      if (__superior.storageRoute != null)
        storageRoute(__superior.storageRoute);
      if (__superior.indexMode != null)
        indexMode(__superior.indexMode);
      return this;
    }

    public Builder cacheTimeout(double __value) {
      cacheTimeout = __value;
      return this;
    }

    private Builder cacheTimeout(String __value) {
      return cacheTimeout(Double.valueOf(__value));
    }

    public Builder clusterName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      clusterName = __value;
      __uninitialized.remove("clusterName");
      return this;
    }


    public Builder maxQueryTimeout(double __value) {
      maxQueryTimeout = __value;
      return this;
    }

    private Builder maxQueryTimeout(String __value) {
      return maxQueryTimeout(Double.valueOf(__value));
    }

    public Builder maxQueryCacheTimeout(double __value) {
      maxQueryCacheTimeout = __value;
      return this;
    }

    private Builder maxQueryCacheTimeout(String __value) {
      return maxQueryCacheTimeout(Double.valueOf(__value));
    }

    public Builder configid(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      configid = __value;
      return this;
    }


    public Builder storageRoute(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      storageRoute = __value;
      return this;
    }


    public Builder indexMode(IndexMode.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      indexMode = __value;
      return this;
    }

    private Builder indexMode(String __value) {
      return indexMode(IndexMode.Enum.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ClusterConfig build() {
      return new ClusterConfig(this);
    }

  }

  // Timeout for internal searcher cache. Entries older than this number
  // of seconds will be removed from cache. 0 or less means the cache is disabled.
  private final DoubleNode cacheTimeout;
  // The name of the cluster (as specified in qr-searchers)
  private final StringNode clusterName;
  // The maximum query timeout for this cluster in seconds (default 10 minutes)
  private final DoubleNode maxQueryTimeout;
  // The maximum query timeout allowed before disabling the backend query cache for the given query (default 10 seconds).
  // Note that the query timeout is used as the query cache timeout in the backend if enabled.
  private final DoubleNode maxQueryCacheTimeout;
  // The configid to use to get other clusterspecific configs.
  private final StringNode configid;
  // The mbus route to the backing content cluster
  private final StringNode storageRoute;
  // Indexing mode for this cluster. This is a temporary workaround until this is correctly resolved per schema all over.
  private final IndexMode indexMode;

  public ClusterConfig(Builder builder) {
    this(builder, true);
  }

  private ClusterConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "cluster must be initialized: " + builder.__uninitialized);

    cacheTimeout = (builder.cacheTimeout == null) ?
        new DoubleNode(0D) : new DoubleNode(builder.cacheTimeout);
    clusterName = (builder.clusterName == null) ?
        new StringNode() : new StringNode(builder.clusterName);
    maxQueryTimeout = (builder.maxQueryTimeout == null) ?
        new DoubleNode(600D) : new DoubleNode(builder.maxQueryTimeout);
    maxQueryCacheTimeout = (builder.maxQueryCacheTimeout == null) ?
        new DoubleNode(10D) : new DoubleNode(builder.maxQueryCacheTimeout);
    configid = (builder.configid == null) ?
        new StringNode("") : new StringNode(builder.configid);
    storageRoute = (builder.storageRoute == null) ?
        new StringNode("") : new StringNode(builder.storageRoute);
    indexMode = (builder.indexMode == null) ?
        new IndexMode(IndexMode.INDEX) : new IndexMode(builder.indexMode);
  }

  /**
   * @return cluster.cacheTimeout
   */
  public double cacheTimeout() {
    return cacheTimeout.value();
  }

  /**
   * @return cluster.clusterName
   */
  public String clusterName() {
    return clusterName.value();
  }

  /**
   * @return cluster.maxQueryTimeout
   */
  public double maxQueryTimeout() {
    return maxQueryTimeout.value();
  }

  /**
   * @return cluster.maxQueryCacheTimeout
   */
  public double maxQueryCacheTimeout() {
    return maxQueryCacheTimeout.value();
  }

  /**
   * @return cluster.configid
   */
  public String configid() {
    return configid.value();
  }

  /**
   * @return cluster.storageRoute
   */
  public String storageRoute() {
    return storageRoute.value();
  }

  /**
   * @return cluster.indexMode
   */
  public IndexMode.Enum indexMode() {
    return indexMode.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ClusterConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("cluster");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents cluster.indexMode
   * 
   * Indexing mode for this cluster. This is a temporary workaround until this is correctly resolved per schema all over.
   */
  public final static class IndexMode extends EnumNode<IndexMode.Enum> {

    public IndexMode(){
      this.value = null;
    }

    public IndexMode(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {INDEX, STREAMING, STORE_ONLY}
    public final static Enum INDEX = Enum.INDEX;
    public final static Enum STREAMING = Enum.STREAMING;
    public final static Enum STORE_ONLY = Enum.STORE_ONLY;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
