// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.prelude.searcher;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of keyvalue
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class KeyvalueConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "bb44ee26962990615b606e91a2b4d913";
  public final static String CONFIG_DEF_NAME = "keyvalue";
  public final static String CONFIG_DEF_NAMESPACE = "prelude.searcher";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=prelude.searcher",
    "docIdScheme enum { DOC_SCHEME, ID_SCHEME } default=ID_SCHEME",
    "numparts int",
    "numrows int default=1",
    "summaryName string",
    "docIdNameSpace string",
    "docIdType string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "numparts",
      "summaryName",
      "docIdNameSpace"
      ));

    private DocIdScheme.Enum docIdScheme = null;
    private Integer numparts = null;
    private Integer numrows = null;
    private String summaryName = null;
    private String docIdNameSpace = null;
    private String docIdType = null;

    public Builder() { }

    public Builder(KeyvalueConfig config) {
      docIdScheme(config.docIdScheme());
      numparts(config.numparts());
      numrows(config.numrows());
      summaryName(config.summaryName());
      docIdNameSpace(config.docIdNameSpace());
      docIdType(config.docIdType());
    }

    private Builder override(Builder __superior) {
      if (__superior.docIdScheme != null)
        docIdScheme(__superior.docIdScheme);
      if (__superior.numparts != null)
        numparts(__superior.numparts);
      if (__superior.numrows != null)
        numrows(__superior.numrows);
      if (__superior.summaryName != null)
        summaryName(__superior.summaryName);
      if (__superior.docIdNameSpace != null)
        docIdNameSpace(__superior.docIdNameSpace);
      if (__superior.docIdType != null)
        docIdType(__superior.docIdType);
      return this;
    }

    public Builder docIdScheme(DocIdScheme.Enum __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      docIdScheme = __value;
      return this;
    }

    private Builder docIdScheme(String __value) {
      return docIdScheme(DocIdScheme.Enum.valueOf(__value));
    }

    public Builder numparts(int __value) {
      numparts = __value;
      __uninitialized.remove("numparts");
      return this;
    }

    private Builder numparts(String __value) {
      return numparts(Integer.valueOf(__value));
    }

    public Builder numrows(int __value) {
      numrows = __value;
      return this;
    }

    private Builder numrows(String __value) {
      return numrows(Integer.valueOf(__value));
    }

    public Builder summaryName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      summaryName = __value;
      __uninitialized.remove("summaryName");
      return this;
    }


    public Builder docIdNameSpace(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      docIdNameSpace = __value;
      __uninitialized.remove("docIdNameSpace");
      return this;
    }


    public Builder docIdType(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      docIdType = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public KeyvalueConfig build() {
      return new KeyvalueConfig(this);
    }

  }

  // The doc id scheme to use.
  private final DocIdScheme docIdScheme;
  // Number of partitions in search cluster
  private final IntegerNode numparts;
  // Number of rows in search cluster
  private final IntegerNode numrows;
  // Which summary to request for each key
  private final StringNode summaryName;
  // Document ID namespace
  private final StringNode docIdNameSpace;
  // Document id type (only necessary if
  private final StringNode docIdType;

  public KeyvalueConfig(Builder builder) {
    this(builder, true);
  }

  private KeyvalueConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "keyvalue must be initialized: " + builder.__uninitialized);

    docIdScheme = (builder.docIdScheme == null) ?
        new DocIdScheme(DocIdScheme.ID_SCHEME) : new DocIdScheme(builder.docIdScheme);
    numparts = (builder.numparts == null) ?
        new IntegerNode() : new IntegerNode(builder.numparts);
    numrows = (builder.numrows == null) ?
        new IntegerNode(1) : new IntegerNode(builder.numrows);
    summaryName = (builder.summaryName == null) ?
        new StringNode() : new StringNode(builder.summaryName);
    docIdNameSpace = (builder.docIdNameSpace == null) ?
        new StringNode() : new StringNode(builder.docIdNameSpace);
    docIdType = (builder.docIdType == null) ?
        new StringNode("") : new StringNode(builder.docIdType);
  }

  /**
   * @return keyvalue.docIdScheme
   */
  public DocIdScheme.Enum docIdScheme() {
    return docIdScheme.value();
  }

  /**
   * @return keyvalue.numparts
   */
  public int numparts() {
    return numparts.value();
  }

  /**
   * @return keyvalue.numrows
   */
  public int numrows() {
    return numrows.value();
  }

  /**
   * @return keyvalue.summaryName
   */
  public String summaryName() {
    return summaryName.value();
  }

  /**
   * @return keyvalue.docIdNameSpace
   */
  public String docIdNameSpace() {
    return docIdNameSpace.value();
  }

  /**
   * @return keyvalue.docIdType
   */
  public String docIdType() {
    return docIdType.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(KeyvalueConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("keyvalue");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents keyvalue.docIdScheme
   * 
   * The doc id scheme to use.
   */
  public final static class DocIdScheme extends EnumNode<DocIdScheme.Enum> {

    public DocIdScheme(){
      this.value = null;
    }

    public DocIdScheme(Enum enumValue) {
      super(enumValue != null);
      this.value = enumValue;
    }

    public enum Enum {DOC_SCHEME, ID_SCHEME}
    public final static Enum DOC_SCHEME = Enum.DOC_SCHEME;
    public final static Enum ID_SCHEME = Enum.ID_SCHEME;

    @Override
    protected boolean doSetValue(String name) {
      try {
        value = Enum.valueOf(name);
        return true;
      } catch (IllegalArgumentException e) {
      }
      return false;
    }
  }

}
