// Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
package com.yahoo.prelude.fastsearch;

import com.yahoo.prelude.hitfield.RawData;
import com.yahoo.data.access.simple.Value;
import com.yahoo.data.access.Inspector;

/**
 * Class representing a data field in the result set.  a data field
 * is basically the same thing as a string field, only that we
 * treat it like a raw buffer.  Well we SHOULD.  we don't actually
 * do so.  yet.  we should probably do some defensive copying and
 * return a ByteBuffer...hmm...
 *
 * @author Bjørn Borud
 */
public class DataField extends DocsumField {

    public DataField(String name) {
        super(name);
    }

    private RawData convert(byte[] value) {
        return new RawData(value);
    }

    @Override
    public String toString() {
        return "field " + getName() + " type data";
    }

    @Override
    public Object convert(Inspector value) {
        return convert(value.asData(Value.empty().asData()));
    }

}
