// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package ai.vespa.search.llm;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of llm-searcher
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class LlmSearcherConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "104a672574a9dbdc37322dbff0003b92";
  public final static String CONFIG_DEF_NAME = "llm-searcher";
  public final static String CONFIG_DEF_NAMESPACE = "ai.vespa.search.llm";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "package=ai.vespa.search.llm",
    "propertyPrefix string default=\"llm\"",
    "stream bool default=true",
    "providerId string default=\"\"",
    "prompt string default=\"\"",
    "promptTemplate path optional"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private String propertyPrefix = null;
    private Boolean stream = null;
    private String providerId = null;
    private String prompt = null;
    private Optional<FileReference> promptTemplate = Optional.empty();

    public Builder() { }

    public Builder(LlmSearcherConfig config) {
      propertyPrefix(config.propertyPrefix());
      stream(config.stream());
      providerId(config.providerId());
      prompt(config.prompt());
      promptTemplate(config.promptTemplate.getFileReference());
    }

    private Builder override(Builder __superior) {
      if (__superior.propertyPrefix != null)
        propertyPrefix(__superior.propertyPrefix);
      if (__superior.stream != null)
        stream(__superior.stream);
      if (__superior.providerId != null)
        providerId(__superior.providerId);
      if (__superior.prompt != null)
        prompt(__superior.prompt);
      if (__superior.promptTemplate != null)
        promptTemplate(__superior.promptTemplate);
      return this;
    }

    public Builder propertyPrefix(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      propertyPrefix = __value;
      return this;
    }


    public Builder stream(boolean __value) {
      stream = __value;
      return this;
    }

    private Builder stream(String __value) {
      return stream(Boolean.valueOf(__value));
    }

    public Builder providerId(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      providerId = __value;
      return this;
    }


    public Builder prompt(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      prompt = __value;
      return this;
    }


    public Builder promptTemplate(Optional<FileReference> __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      promptTemplate = __value;
      __uninitialized.remove("promptTemplate");
      return this;
    }

    private Builder promptTemplate(FileReference __value) {
      return promptTemplate(Optional.of(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public LlmSearcherConfig build() {
      return new LlmSearcherConfig(this);
    }

  }

  // Query propertry prefix for options
  private final StringNode propertyPrefix;
  // Should the searcher stream tokens or wait for the entire thing?
  private final BooleanNode stream;
  // The external LLM provider - the id of a LanguageModel component
  private final StringNode providerId;
  // The default prompt to use if not overridden in query
  private final StringNode prompt;
  // The default prompt template file to use if not overridden in query. Above prompt has precedence if it is set.
  private final OptionalPathNode promptTemplate;

  public LlmSearcherConfig(Builder builder) {
    this(builder, true);
  }

  private LlmSearcherConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "llm-searcher must be initialized: " + builder.__uninitialized);

    propertyPrefix = (builder.propertyPrefix == null) ?
        new StringNode("llm") : new StringNode(builder.propertyPrefix);
    stream = (builder.stream == null) ?
        new BooleanNode(true) : new BooleanNode(builder.stream);
    providerId = (builder.providerId == null) ?
        new StringNode("") : new StringNode(builder.providerId);
    prompt = (builder.prompt == null) ?
        new StringNode("") : new StringNode(builder.prompt);
    promptTemplate = (builder.promptTemplate == null) ?
        new OptionalPathNode() : new OptionalPathNode(builder.promptTemplate);
  }

  /**
   * @return llm-searcher.propertyPrefix
   */
  public String propertyPrefix() {
    return propertyPrefix.value();
  }

  /**
   * @return llm-searcher.stream
   */
  public boolean stream() {
    return stream.value();
  }

  /**
   * @return llm-searcher.providerId
   */
  public String providerId() {
    return providerId.value();
  }

  /**
   * @return llm-searcher.prompt
   */
  public String prompt() {
    return prompt.value();
  }

  /**
   * @return llm-searcher.promptTemplate
   */
  public Optional<Path> promptTemplate() {
    return promptTemplate.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(LlmSearcherConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("llm-searcher");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
