/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.searchchain;

import com.yahoo.concurrent.ThreadFactoryFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class RenderingExecutorFactory {
    private final int maxQueuedRenderingTasksPerProcessor;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();

    public RenderingExecutorFactory() {
        this.maxQueuedRenderingTasksPerProcessor = 500;
    }

    ThreadPoolExecutor createExecutor() {
        int maxOutstandingTasks = this.maxQueuedRenderingTasksPerProcessor * this.availableProcessors;
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.availableProcessors, this.availableProcessors, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxOutstandingTasks), ThreadFactoryFactory.getThreadFactory((String)"common-rendering"), (task, exec) -> this.renderingRejected(maxOutstandingTasks));
        executor.prestartAllCoreThreads();
        return executor;
    }

    private void renderingRejected(int maxOutstandingTasks) {
        throw new RejectedExecutionException("More than " + maxOutstandingTasks + " rendering tasks queued, rejecting this");
    }
}

