/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query;

import com.yahoo.prelude.query.AndItem;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.IndexedItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.RootItem;
import com.yahoo.prelude.query.TermItem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class QueryTree
extends RootItem {
    public QueryTree() {
    }

    public QueryTree(Item root) {
        super(root);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof QueryTree)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public QueryTree clone() {
        QueryTree clone = (QueryTree)super.clone();
        this.fixClonedConnectivityReferences(clone);
        return clone;
    }

    private void fixClonedConnectivityReferences(QueryTree clone) {
    }

    public Item withRank(Item item) {
        RankItem result = new RankItem();
        result.addItem(this.getRoot());
        result.addItem(item);
        this.setRoot(result);
        return result;
    }

    public Item and(Item item) {
        Item result = this.and(this.getRoot(), item);
        this.setRoot(result);
        return result;
    }

    private Item and(Item a, Item b) {
        if (a == null || a instanceof NullItem) {
            return b;
        }
        if (b == null || b instanceof NullItem) {
            return a;
        }
        if (a instanceof NotItem) {
            NotItem notItemA = (NotItem)a;
            if (b instanceof NotItem) {
                NotItem notItemB = (NotItem)b;
                NotItem combined = new NotItem();
                combined.addPositiveItem(this.and(notItemA.getPositiveItem(), notItemB.getPositiveItem()));
                notItemA.negativeItems().forEach(item -> combined.addNegativeItem((Item)item));
                notItemB.negativeItems().forEach(item -> combined.addNegativeItem((Item)item));
                return combined;
            }
        }
        if (a instanceof NotItem) {
            NotItem notItem = (NotItem)a;
            notItem.addPositiveItem(b);
            return a;
        }
        if (b instanceof NotItem) {
            NotItem notItem = (NotItem)b;
            notItem.addPositiveItem(a);
            return notItem;
        }
        if (a instanceof AndItem) {
            ((AndItem)a).addItem(b);
            return a;
        }
        AndItem andItem = new AndItem();
        andItem.addItem(a);
        andItem.addItem(b);
        return andItem;
    }

    public static List<IndexedItem> getPositiveTerms(Item item) {
        ArrayList<IndexedItem> items = new ArrayList<IndexedItem>();
        QueryTree.getPositiveTerms(item, items);
        return items;
    }

    private static void getPositiveTerms(Item item, List<IndexedItem> terms) {
        if (item instanceof NotItem) {
            NotItem notItem = (NotItem)item;
            QueryTree.getPositiveTerms(notItem.getPositiveItem(), terms);
        } else if (item instanceof PhraseItem) {
            PhraseItem phraseItem = (PhraseItem)item;
            terms.add(phraseItem);
        } else if (item instanceof CompositeItem) {
            CompositeItem compositeItem = (CompositeItem)item;
            ListIterator<Item> i = compositeItem.getItemIterator();
            while (i.hasNext()) {
                QueryTree.getPositiveTerms((Item)i.next(), terms);
            }
        } else if (item instanceof TermItem) {
            TermItem termItem = (TermItem)item;
            terms.add(termItem);
        }
    }

    public int treeSize() {
        if (this.isEmpty()) {
            return 0;
        }
        return this.countItemsRecursively(this.getItemIterator().next());
    }

    private int countItemsRecursively(Item item) {
        int children = 0;
        if (item instanceof CompositeItem) {
            CompositeItem composite = (CompositeItem)item;
            ListIterator<Item> i = composite.getItemIterator();
            while (i.hasNext()) {
                children += this.countItemsRecursively(i.next());
            }
        }
        return children + 1;
    }
}

