/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.model;

import com.yahoo.component.provider.FreezableClass;
import com.yahoo.protect.Validator;
import com.yahoo.search.pagetemplates.model.Choice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import com.yahoo.search.pagetemplates.model.Renderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Source
extends FreezableClass
implements PageElement {
    public static final Source any = new Source("*", true);
    private String name;
    private List<PageElement> renderers = new ArrayList<PageElement>();
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String url;
    private int hashCode = 0;

    public Source(String name) {
        this(name, false);
    }

    private Source(String name, boolean freeze) {
        this.setName(name);
        if (freeze) {
            this.freeze();
        }
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.ensureNotFrozen();
        Validator.ensureNotNull((String)"Source name", (Object)name);
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.ensureNotFrozen();
        this.url = url;
    }

    public List<PageElement> renderers() {
        return this.renderers;
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        for (PageElement element : this.renderers) {
            if (element instanceof Renderer) {
                this.assignRendererForIfNotSet((Renderer)element);
            } else if (element instanceof Choice) {
                for (List<PageElement> renderersAlternative : ((Choice)element).alternatives()) {
                    for (PageElement rendererElement : renderersAlternative) {
                        Renderer renderer = (Renderer)rendererElement;
                        if (renderer.getRendererFor() != null) continue;
                        renderer.setRendererFor(this.name);
                    }
                }
            }
            element.freeze();
        }
        this.parameters = Collections.unmodifiableMap(this.parameters);
        this.hashCode = this.hashCode();
        super.freeze();
    }

    private void assignRendererForIfNotSet(Renderer renderer) {
        if (renderer.getRendererFor() == null) {
            renderer.setRendererFor(this.name);
        }
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
        for (PageElement renderer : this.renderers) {
            renderer.accept(visitor);
        }
    }

    public int hashCode() {
        if (this.isFrozen()) {
            return this.hashCode;
        }
        int hashCode = this.name.hashCode();
        int i = 0;
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            hashCode += i * 17 * parameter.getKey().hashCode() + i * 31 * parameter.getValue().hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Source)) {
            return false;
        }
        Source otherSource = (Source)other;
        if (!this.name.equals(otherSource.name)) {
            return false;
        }
        if (this.parameters.size() != otherSource.parameters.size()) {
            return false;
        }
        for (Map.Entry<String, String> thisParameter : this.parameters.entrySet()) {
            if (thisParameter.getValue().equals(otherSource.parameters.get(thisParameter.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "source '" + this.name + "'";
    }
}

