/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.model;

import com.yahoo.search.pagetemplates.model.AbstractChoice;
import com.yahoo.search.pagetemplates.model.PageElement;
import com.yahoo.search.pagetemplates.model.PageTemplateVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public final class Choice
extends AbstractChoice {
    private List<List<PageElement>> alternatives = new ArrayList<List<PageElement>>(3);

    public Choice() {
    }

    public static Choice createSingleton(PageElement singletonAlternative) {
        Choice choice = new Choice();
        choice.alternatives().add(Choice.createSingletonList(singletonAlternative));
        return choice;
    }

    public static Choice createSingletons(List<PageElement> alternatives) {
        Choice choice = new Choice();
        for (PageElement alternative : alternatives) {
            choice.alternatives().add(Choice.createSingletonList(alternative));
        }
        return choice;
    }

    private static List<PageElement> createSingletonList(PageElement member) {
        ArrayList<PageElement> list = new ArrayList<PageElement>();
        list.add(member);
        return list;
    }

    public Choice(List<List<PageElement>> alternatives) {
        for (List<PageElement> alternative : alternatives) {
            this.alternatives.add(new ArrayList<PageElement>(alternative));
        }
    }

    public List<List<PageElement>> alternatives() {
        return this.alternatives;
    }

    public List<PageElement> get(int index) {
        return this.alternatives.get(index);
    }

    public void add(List<PageElement> alternative) {
        if (alternative != null) {
            this.alternatives.add(new ArrayList<PageElement>(alternative));
        }
    }

    public boolean isEmpty() {
        return this.alternatives.size() == 0;
    }

    @Override
    public boolean isChoiceBetween(Class pageTemplateModelElementClass) {
        List<PageElement> firstNonEmpty = null;
        for (List<PageElement> value : this.alternatives) {
            List<PageElement> listValue;
            if (pageTemplateModelElementClass.isAssignableFrom(value.getClass())) {
                return true;
            }
            if (!(value instanceof List) || (listValue = value).size() <= 0) continue;
            firstNonEmpty = listValue;
        }
        if (firstNonEmpty == null) {
            return false;
        }
        return pageTemplateModelElementClass.isAssignableFrom(firstNonEmpty.get(0).getClass());
    }

    public void freeze() {
        if (this.isFrozen()) {
            return;
        }
        super.freeze();
        ListIterator<List<PageElement>> i = this.alternatives.listIterator();
        while (i.hasNext()) {
            List<PageElement> alternative = i.next();
            for (PageElement alternativeElement : alternative) {
                alternativeElement.freeze();
            }
            i.set(Collections.unmodifiableList(alternative));
        }
        this.alternatives = Collections.unmodifiableList(this.alternatives);
    }

    @Override
    public void accept(PageTemplateVisitor visitor) {
        visitor.visit(this);
        for (List<PageElement> alternative : this.alternatives) {
            for (PageElement alternativeElement : alternative) {
                alternativeElement.accept(visitor);
            }
        }
    }

    public String toString() {
        if (this.alternatives.isEmpty()) {
            return "(empty choice)";
        }
        if (this.alternatives.size() == 1) {
            return this.alternatives.get(0).toString();
        }
        return "a choice between " + String.valueOf(this.alternatives);
    }
}

