/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine.resolvers;

import com.yahoo.component.ComponentId;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.search.pagetemplates.engine.Resolver;
import com.yahoo.search.pagetemplates.engine.resolvers.DeterministicResolver;
import com.yahoo.search.pagetemplates.engine.resolvers.RandomResolver;
import java.util.List;

public class ResolverRegistry
extends ComponentRegistry<Resolver> {
    private final Resolver defaultResolver;

    public ResolverRegistry(List<Resolver> resolvers) {
        this.addBuiltInResolvers();
        for (Resolver component : resolvers) {
            this.registerResolver(component);
        }
        this.defaultResolver = this.decideDefaultResolver();
        this.freeze();
    }

    private void addBuiltInResolvers() {
        this.registerResolver(this.createNativeDeterministicResolver());
        this.registerResolver(this.createNativeRandomResolver());
    }

    private Resolver decideDefaultResolver() {
        Resolver defaultResolver = (Resolver)((Object)this.getComponent("default"));
        if (defaultResolver != null) {
            return defaultResolver;
        }
        return (Resolver)((Object)this.getComponent("native.random"));
    }

    private Resolver createNativeRandomResolver() {
        RandomResolver resolver = new RandomResolver();
        resolver.initId(ComponentId.fromString((String)"native.random"));
        return resolver;
    }

    private DeterministicResolver createNativeDeterministicResolver() {
        DeterministicResolver resolver = new DeterministicResolver();
        resolver.initId(ComponentId.fromString((String)"native.deterministic"));
        return resolver;
    }

    private void registerResolver(Resolver resolver) {
        super.register(resolver.getId(), (Object)resolver);
    }

    public Resolver defaultResolver() {
        return this.defaultResolver;
    }
}

