/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.intent.model;

import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.intent.model.InterpretationNode;
import com.yahoo.search.intent.model.ParentNode;
import com.yahoo.search.intent.model.Source;
import com.yahoo.search.intent.model.SourceNode;
import com.yahoo.text.interpretation.Interpretation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class IntentModel
extends ParentNode<InterpretationNode> {
    public static final CompoundName intentModelStringName = CompoundName.from((String)"intentModel");
    public static final CompoundName intentModelObjectName = CompoundName.from((String)"IntentModel");
    private static final InterpretationNodeComparator inodeComp = new InterpretationNodeComparator();

    public IntentModel() {
    }

    public IntentModel(List<Interpretation> interpretations) {
        for (Interpretation interpretation : interpretations) {
            this.children().add(new InterpretationNode(interpretation));
        }
        this.sortChildren();
    }

    public IntentModel(Interpretation ... interpretations) {
        for (Interpretation interpretation : interpretations) {
            this.children().add(new InterpretationNode(interpretation));
        }
        this.sortChildren();
    }

    public void sortChildren() {
        this.children().sort(inodeComp);
    }

    public List<SourceNode> getSources() {
        HashMap<Source, SourceNode> sources = new HashMap<Source, SourceNode>();
        this.addSources(1.0, sources);
        ArrayList<SourceNode> sourceList = new ArrayList<SourceNode>(sources.values());
        Collections.sort(sourceList);
        return sourceList;
    }

    public List<String> getSourceNames() {
        ArrayList<String> sourceNames = new ArrayList<String>();
        for (SourceNode sourceNode : this.getSources()) {
            sourceNames.add(sourceNode.getSource().getId());
        }
        return sourceNames;
    }

    public static IntentModel getFrom(Query query) {
        return (IntentModel)query.properties().get(intentModelObjectName);
    }

    public void setTo(Query query) {
        query.properties().set(intentModelObjectName, this);
    }

    static class InterpretationNodeComparator
    implements Comparator<InterpretationNode> {
        InterpretationNodeComparator() {
        }

        @Override
        public int compare(InterpretationNode o1, InterpretationNode o2) {
            double diff = o2.getScore() - o1.getScore();
            return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
        }
    }
}

