/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping;

import com.yahoo.api.annotations.Beta;
import com.yahoo.net.URI;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.GroupingQueryParser;
import com.yahoo.search.grouping.request.GroupingOperation;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.result.RootId;
import com.yahoo.search.query.Select;
import com.yahoo.search.result.Hit;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;

public class GroupingRequest {
    private final Select parent;
    private final List<Continuation> continuations = new ArrayList<Continuation>();
    private GroupingOperation root;
    private TimeZone timeZone;
    private Integer defaultMaxHits;
    private Integer defaultMaxGroups;
    private Long globalMaxGroups;
    private Double defaultPrecisionFactor;

    private GroupingRequest(Select parent) {
        this.parent = parent;
    }

    private GroupingRequest(Select parent, List<Continuation> continuations, GroupingOperation root, TimeZone timeZone, Integer defaultMaxHits, Integer defaultMaxGroups, Long globalMaxGroups, Double defaultPrecisionFactor) {
        this.parent = parent;
        continuations.forEach(item -> this.continuations.add(item.copy()));
        this.root = root != null ? root.copy(null) : null;
        this.timeZone = timeZone;
        this.defaultMaxHits = defaultMaxHits;
        this.defaultMaxGroups = defaultMaxGroups;
        this.globalMaxGroups = globalMaxGroups;
        this.defaultPrecisionFactor = defaultPrecisionFactor;
    }

    public GroupingRequest copy(Select parentOfCopy) {
        return new GroupingRequest(parentOfCopy, this.continuations, this.root, this.timeZone, this.defaultMaxHits, this.defaultMaxGroups, this.globalMaxGroups, this.defaultPrecisionFactor);
    }

    public int getRequestId() {
        return this.parent.getGrouping().indexOf(this);
    }

    public GroupingOperation getRootOperation() {
        return this.root;
    }

    public GroupingRequest setRootOperation(GroupingOperation root) {
        this.root = root;
        return this;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public GroupingRequest setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public RootGroup getResultGroup(Result result) {
        Hit root = result.hits().get(new URI(new RootId(this.getRequestId()).toString()), -1);
        if (!(root instanceof RootGroup)) {
            return null;
        }
        return (RootGroup)root;
    }

    public List<Continuation> continuations() {
        return this.continuations;
    }

    @Beta
    public OptionalInt defaultMaxHits() {
        return this.defaultMaxHits != null ? OptionalInt.of(this.defaultMaxHits) : OptionalInt.empty();
    }

    @Beta
    public void setDefaultMaxHits(int v) {
        this.defaultMaxHits = v;
    }

    @Beta
    public OptionalInt defaultMaxGroups() {
        return this.defaultMaxGroups != null ? OptionalInt.of(this.defaultMaxGroups) : OptionalInt.empty();
    }

    @Beta
    public void setDefaultMaxGroups(int v) {
        this.defaultMaxGroups = v;
    }

    @Beta
    public OptionalLong globalMaxGroups() {
        return this.globalMaxGroups != null ? OptionalLong.of(this.globalMaxGroups) : OptionalLong.empty();
    }

    @Beta
    public void setGlobalMaxGroups(long v) {
        this.globalMaxGroups = v;
    }

    @Beta
    public OptionalDouble defaultPrecisionFactor() {
        return this.defaultPrecisionFactor != null ? OptionalDouble.of(this.defaultPrecisionFactor) : OptionalDouble.empty();
    }

    @Beta
    void setDefaultPrecisionFactor(double v) {
        this.defaultPrecisionFactor = v;
    }

    public static GroupingRequest newInstance(Query query) {
        GroupingRequest newRequest = new GroupingRequest(query.getSelect());
        GroupingRequest.intProperty(query, GroupingQueryParser.PARAM_DEFAULT_MAX_GROUPS).ifPresent(newRequest::setDefaultMaxGroups);
        GroupingRequest.intProperty(query, GroupingQueryParser.PARAM_DEFAULT_MAX_HITS).ifPresent(newRequest::setDefaultMaxHits);
        GroupingRequest.longProperty(query, GroupingQueryParser.GROUPING_GLOBAL_MAX_GROUPS).ifPresent(newRequest::setGlobalMaxGroups);
        GroupingRequest.doubleProperty(query, GroupingQueryParser.PARAM_DEFAULT_PRECISION_FACTOR).ifPresent(newRequest::setDefaultPrecisionFactor);
        query.getSelect().getGrouping().add(newRequest);
        return newRequest;
    }

    private static OptionalInt intProperty(Query q, CompoundName name) {
        Integer val = q.properties().getInteger(name);
        return val != null ? OptionalInt.of(val) : OptionalInt.empty();
    }

    private static OptionalLong longProperty(Query q, CompoundName name) {
        Long val = q.properties().getLong(name);
        return val != null ? OptionalLong.of(val) : OptionalLong.empty();
    }

    private static OptionalDouble doubleProperty(Query q, CompoundName name) {
        Double val = q.properties().getDouble(name);
        return val != null ? OptionalDouble.of(val) : OptionalDouble.empty();
    }

    public String toString() {
        return this.root == null ? "(empty)" : this.root.toString();
    }
}

