/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import ai.vespa.cloud.SystemInfo;
import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.container.QrSearchersConfig;
import com.yahoo.container.handler.VipStatus;
import com.yahoo.search.dispatch.Dispatcher;
import com.yahoo.vespa.config.search.DispatchConfig;
import com.yahoo.vespa.config.search.DispatchNodesConfig;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ReconfigurableDispatcher
extends Dispatcher {
    private final ConfigSubscriber subscriber = new ConfigSubscriber();

    @Inject
    public ReconfigurableDispatcher(ComponentId clusterId, DispatchConfig dispatchConfig, QrSearchersConfig qrSearchersConfig, SystemInfo systemInfo, VipStatus vipStatus) {
        super(clusterId, dispatchConfig, qrSearchersConfig, new DispatchNodesConfig.Builder().build(), vipStatus);
        CountDownLatch configured = new CountDownLatch(1);
        this.subscriber.subscribe(nodesConfig -> {
            this.updateWithNewConfig((DispatchNodesConfig)nodesConfig);
            configured.countDown();
        }, DispatchNodesConfig.class, ReconfigurableDispatcher.configId(clusterId, systemInfo));
        try {
            if (!configured.await(1L, TimeUnit.MINUTES)) {
                throw new IllegalStateException("timed out waiting for initial dispatch nodes config for " + clusterId.getName());
            }
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException("interrupted waiting for initial dispatch nodes config for " + clusterId.getName(), e);
        }
    }

    @Override
    public void deconstruct() {
        this.subscriber.close();
        super.deconstruct();
    }

    private static String configId(ComponentId clusterId, SystemInfo systemInfo) {
        return systemInfo.clusterName() + "/component/" + clusterId.getName();
    }
}

