/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.search.dispatch.TimeoutHandler;
import com.yahoo.search.result.Coverage;

public class CoverageAggregator {
    private final int askedNodes;
    private int answeredNodes = 0;
    private int answeredNodesParticipated = 0;
    private int failedNodes = 0;
    private long answeredDocs = 0L;
    private long answeredActiveDocs = 0L;
    private long answeredTargetActiveDocs = 0L;
    private int degradedReason = 0;

    CoverageAggregator(int askedNodes) {
        this.askedNodes = askedNodes;
    }

    CoverageAggregator(CoverageAggregator rhs) {
        this.askedNodes = rhs.askedNodes;
        this.answeredNodes = rhs.answeredNodes;
        this.answeredNodesParticipated = rhs.answeredNodesParticipated;
        this.failedNodes = rhs.failedNodes;
        this.answeredDocs = rhs.answeredDocs;
        this.answeredActiveDocs = rhs.answeredActiveDocs;
        this.answeredTargetActiveDocs = rhs.answeredTargetActiveDocs;
        this.degradedReason = rhs.degradedReason;
    }

    void add(Coverage source) {
        this.answeredDocs += source.getDocs();
        this.answeredActiveDocs += source.getActive();
        this.answeredTargetActiveDocs += source.getTargetActive();
        this.answeredNodesParticipated += source.getNodes();
        ++this.answeredNodes;
        this.degradedReason |= source.getDegradedReason();
    }

    public int getAskedNodes() {
        return this.askedNodes;
    }

    public int getAnsweredNodes() {
        return this.answeredNodes;
    }

    public boolean hasNoAnswers() {
        return this.answeredNodes == 0;
    }

    public void setFailedNodes(int failedNodes) {
        this.failedNodes = failedNodes;
    }

    public Coverage createCoverage(TimeoutHandler timeoutHandler) {
        Coverage coverage = new Coverage(this.answeredDocs, this.answeredActiveDocs, this.answeredNodesParticipated, 1);
        coverage.setNodesTried(this.askedNodes);
        coverage.setTargetActive(this.answeredTargetActiveDocs);
        coverage.setDegradedReason(this.degradedReason | timeoutHandler.reason());
        return coverage;
    }

    public CoverageAggregator adjustedDegradedCoverage(int redundancy, TimeoutHandler timeoutHandler) {
        int askedAndFailed = this.askedNodes + this.failedNodes;
        if (askedAndFailed == this.answeredNodesParticipated) {
            return this;
        }
        int notAnswered = askedAndFailed - this.answeredNodesParticipated;
        if (timeoutHandler.reason() == 4) {
            CoverageAggregator clone = new CoverageAggregator(this);
            return clone.adjustActiveDocs(notAnswered);
        }
        if (askedAndFailed > this.answeredNodesParticipated) {
            CoverageAggregator clone = new CoverageAggregator(this);
            int missingNodes = notAnswered - (redundancy - 1);
            if (missingNodes > 0) {
                clone.adjustActiveDocs(missingNodes);
            }
            clone.degradedReason |= timeoutHandler.reason();
            return clone;
        }
        return this;
    }

    private CoverageAggregator adjustActiveDocs(int numMissingNodes) {
        if (this.answeredNodesParticipated > 0) {
            this.answeredActiveDocs += (long)numMissingNodes * this.answeredActiveDocs / (long)this.answeredNodesParticipated;
            this.answeredTargetActiveDocs += (long)numMissingNodes * this.answeredTargetActiveDocs / (long)this.answeredNodesParticipated;
        }
        return this;
    }
}

