/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.searcher;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.config.ClusterConfig;
import com.yahoo.search.query.Sorting;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.searchchain.Execution;
import com.yahoo.vespa.config.search.AttributesConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Before(value={"backend"})
@After(value={"AccentRemoval"})
public class ValidateSortingSearcher
extends Searcher {
    private final boolean isStreaming;
    private Map<String, AttributesConfig.Attribute> attributeNames = null;
    private String clusterName = "";

    public ValidateSortingSearcher(ClusterConfig clusterConfig, AttributesConfig attributesConfig) {
        this.initAttributeNames(attributesConfig);
        this.setClusterName(clusterConfig.clusterName());
        this.isStreaming = clusterConfig.indexMode() == ClusterConfig.IndexMode.Enum.STREAMING;
    }

    @Override
    public Result search(Query query, Execution execution) {
        ErrorMessage error = this.validate(query);
        if (!this.isStreaming && error != null) {
            return new Result(query, error);
        }
        return execution.search(query);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    private Map<String, AttributesConfig.Attribute> getAttributeNames() {
        return this.attributeNames;
    }

    public void setAttributeNames(Map<String, AttributesConfig.Attribute> attributeNames) {
        this.attributeNames = attributeNames;
    }

    public void initAttributeNames(AttributesConfig config) {
        HashMap<String, AttributesConfig.Attribute> attributes = new HashMap<String, AttributesConfig.Attribute>(config.attribute().size());
        for (AttributesConfig.Attribute attr : config.attribute()) {
            attributes.put(attr.name(), attr);
        }
        this.setAttributeNames(attributes);
    }

    private ErrorMessage validate(Query query) {
        List<Sorting.FieldOrder> l;
        Sorting sorting = query.getRanking().getSorting();
        List<Sorting.FieldOrder> list = l = sorting != null ? sorting.fieldOrders() : null;
        if (l == null) {
            return null;
        }
        Map<String, AttributesConfig.Attribute> names = this.getAttributeNames();
        if (names == null) {
            return null;
        }
        String queryLocale = null;
        if (query.getModel().getLocale() != null) {
            queryLocale = query.getModel().getLocale().toString();
        }
        for (Sorting.FieldOrder f : l) {
            String name = f.getFieldName();
            if ("[rank]".equals(name) || "[docid]".equals(name)) continue;
            if ("[relevance]".equals(name) || "[relevancy]".equals(name)) {
                f.getSorter().setName("[rank]");
                continue;
            }
            if (names.containsKey(name)) {
                Sorting.AttributeSorter attributeSorter;
                AttributesConfig.Attribute attrConfig = names.get(name);
                if (attrConfig == null) {
                    return ErrorMessage.createInvalidQueryParameter("Cluster '" + this.getClusterName() + "' has no attribute config for field '" + name + "'");
                }
                if (f.getSortOrder() == Sorting.Order.UNDEFINED) {
                    f.setAscending(attrConfig.sortascending());
                }
                if (f.getSorter().getClass().equals(Sorting.AttributeSorter.class)) {
                    if (attrConfig.datatype() == AttributesConfig.Attribute.Datatype.STRING) {
                        if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.UCA) {
                            String locale = attrConfig.sortlocale();
                            if (locale == null || locale.isEmpty()) {
                                locale = queryLocale;
                            }
                            if (locale != null) {
                                f.setSorter(new Sorting.UcaSorter(name, locale, Sorting.UcaSorter.Strength.UNDEFINED));
                            } else {
                                f.setSorter(new Sorting.LowerCaseSorter(name));
                            }
                        } else if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.LOWERCASE) {
                            f.setSorter(new Sorting.LowerCaseSorter(name));
                        } else if (attrConfig.sortfunction() == AttributesConfig.Attribute.Sortfunction.RAW) {
                            f.setSorter(new Sorting.RawSorter(name));
                        } else {
                            f.setSorter(new Sorting.LowerCaseSorter(name));
                        }
                    } else if (attrConfig.datatype() == AttributesConfig.Attribute.Datatype.TENSOR) {
                        throw new IllegalArgumentException("Cannot sort on field '" + attrConfig.name() + "' because it is a tensor");
                    }
                }
                if (!((attributeSorter = f.getSorter()) instanceof Sorting.UcaSorter)) continue;
                Sorting.UcaSorter sorter = (Sorting.UcaSorter)attributeSorter;
                String locale = sorter.getLocale();
                if (locale == null || locale.isEmpty()) {
                    locale = attrConfig.sortlocale();
                }
                if (locale == null || locale.isEmpty()) {
                    locale = queryLocale;
                }
                if (locale == null || locale.isEmpty()) {
                    locale = "en_US";
                }
                Sorting.UcaSorter.Strength strength = sorter.getStrength();
                if (sorter.getStrength() == Sorting.UcaSorter.Strength.UNDEFINED) {
                    strength = ValidateSortingSearcher.config2Strength(attrConfig.sortstrength());
                }
                if (sorter.getStrength() != Sorting.UcaSorter.Strength.UNDEFINED && sorter.getLocale() != null && !sorter.getLocale().isEmpty()) continue;
                sorter.setLocale(locale, strength);
                continue;
            }
            return ErrorMessage.createInvalidQueryParameter("Cluster '" + this.getClusterName() + "' has no sortable attribute named '" + name + "'");
        }
        return null;
    }

    private static Sorting.UcaSorter.Strength config2Strength(AttributesConfig.Attribute.Sortstrength.Enum s) {
        if (s == AttributesConfig.Attribute.Sortstrength.PRIMARY) {
            return Sorting.UcaSorter.Strength.PRIMARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.SECONDARY) {
            return Sorting.UcaSorter.Strength.SECONDARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.TERTIARY) {
            return Sorting.UcaSorter.Strength.TERTIARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.QUATERNARY) {
            return Sorting.UcaSorter.Strength.QUATERNARY;
        }
        if (s == AttributesConfig.Attribute.Sortstrength.IDENTICAL) {
            return Sorting.UcaSorter.Strength.IDENTICAL;
        }
        return Sorting.UcaSorter.Strength.PRIMARY;
    }
}

