/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.WeightedSetItem;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class WandItem
extends WeightedSetItem {
    private final int targetNumHits;
    private double scoreThreshold = 0.0;
    private double thresholdBoostFactor = 1.0;

    public WandItem(String fieldName, int targetNumHits) {
        super(fieldName);
        this.targetNumHits = targetNumHits;
    }

    public WandItem(String fieldName, int targetNumHits, Map<Object, Integer> tokens) {
        super(fieldName, tokens);
        this.targetNumHits = targetNumHits;
    }

    public void setScoreThreshold(double scoreThreshold) {
        this.scoreThreshold = scoreThreshold;
    }

    public void setThresholdBoostFactor(double thresholdBoostFactor) {
        this.thresholdBoostFactor = thresholdBoostFactor;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public double getScoreThreshold() {
        return this.scoreThreshold;
    }

    public double getThresholdBoostFactor() {
        return this.thresholdBoostFactor;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WAND;
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        buffer.putDouble(this.scoreThreshold);
        buffer.putDouble(this.thresholdBoostFactor);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.targetNumHits).append(",");
        buffer.append(this.scoreThreshold).append(",");
        buffer.append(this.thresholdBoostFactor);
        buffer.append(") ");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("targetNumHits", this.targetNumHits);
        discloser.addProperty("scoreThreshold", this.scoreThreshold);
        discloser.addProperty("thresholdBoostFactor", this.thresholdBoostFactor);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        WandItem other = (WandItem)o;
        if (this.targetNumHits != other.targetNumHits) {
            return false;
        }
        if (this.scoreThreshold != other.scoreThreshold) {
            return false;
        }
        if (this.thresholdBoostFactor != other.thresholdBoostFactor) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetNumHits, this.scoreThreshold, this.thresholdBoostFactor);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        if (this.hasOnlyLongs()) {
            SearchProtocol.ItemLongWand.Builder builder = SearchProtocol.ItemLongWand.newBuilder();
            builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
            builder.setTargetNumHits(this.targetNumHits);
            builder.setScoreThreshold(this.scoreThreshold);
            builder.setThresholdBoostFactor(this.thresholdBoostFactor);
            Iterator<Map.Entry<Object, Integer>> it = this.getTokens();
            while (it.hasNext()) {
                Map.Entry<Object, Integer> entry = it.next();
                SearchProtocol.PureWeightedLong weightedLong = SearchProtocol.PureWeightedLong.newBuilder().setWeight(entry.getValue().intValue()).setValue(((Long)entry.getKey()).longValue()).build();
                builder.addWeightedLongs(weightedLong);
            }
            return SearchProtocol.QueryTreeItem.newBuilder().setItemLongWand(builder.build()).build();
        }
        SearchProtocol.ItemStringWand.Builder builder = SearchProtocol.ItemStringWand.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setTargetNumHits(this.targetNumHits);
        builder.setScoreThreshold(this.scoreThreshold);
        builder.setThresholdBoostFactor(this.thresholdBoostFactor);
        Iterator<Map.Entry<Object, Integer>> it = this.getTokens();
        while (it.hasNext()) {
            Map.Entry<Object, Integer> entry = it.next();
            SearchProtocol.PureWeightedString weightedString = SearchProtocol.PureWeightedString.newBuilder().setWeight(entry.getValue().intValue()).setValue(entry.getKey().toString()).build();
            builder.addWeightedStrings(weightedString);
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemStringWand(builder.build()).build();
    }
}

