/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.ToProtobuf;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.regex.Pattern;

public class RegExpItem
extends TermItem {
    private String expression;
    private Pattern regexp;

    public RegExpItem(String indexName, boolean isFromQuery, String expression) {
        super(indexName, isFromQuery, null);
        this.setValue(expression);
    }

    @Override
    public String stringValue() {
        return this.expression;
    }

    @Override
    public boolean isStemmed() {
        return true;
    }

    @Override
    public int getNumWords() {
        return 1;
    }

    @Override
    public void setValue(String expression) {
        this.regexp = Pattern.compile(expression);
        this.expression = expression;
    }

    @Override
    public String getRawWord() {
        return this.stringValue();
    }

    @Override
    public boolean isWords() {
        return false;
    }

    @Override
    public String getIndexedString() {
        return this.stringValue();
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.REGEXP;
    }

    @Override
    public String getName() {
        return Item.ItemType.REGEXP.name();
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        RegExpItem.putString(this.getIndexedString(), buffer);
    }

    public Pattern getRegexp() {
        return this.regexp;
    }

    @Override
    public String toString() {
        return "RegExpItem [expression=" + this.expression + "]";
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        RegExpItem other = (RegExpItem)o;
        return Objects.equals(this.expression, other.expression);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemRegexp.Builder builder = SearchProtocol.ItemRegexp.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setRegexp(this.expression);
        return SearchProtocol.QueryTreeItem.newBuilder().setItemRegexp(builder.build()).build();
    }
}

