/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import com.yahoo.data.access.Inspector;
import com.yahoo.data.access.Type;
import com.yahoo.text.XML;
import java.util.Map;

public class XmlRenderer {
    public static StringBuilder render(StringBuilder target, Inspector value) {
        new InspectorRenderer(target).renderInspector(value, 2);
        return target;
    }

    private static class InspectorRenderer {
        private final StringBuilder renderTarget;

        InspectorRenderer(StringBuilder target) {
            this.renderTarget = target;
        }

        void renderInspector(Inspector value, int nestingLevel) {
            if (value.type() == Type.ARRAY) {
                this.renderMapOrArray(value, nestingLevel);
            } else if (value.type() == Type.OBJECT) {
                this.renderStruct(value, nestingLevel);
            } else if (value.type() == Type.STRING) {
                this.renderTarget.append(XML.xmlEscape((String)value.asString(), (boolean)false));
            } else if (value.type() == Type.LONG) {
                long l = value.asLong();
                this.renderTarget.append(String.valueOf(l));
            } else if (value.type() == Type.DOUBLE) {
                double d = value.asDouble();
                this.renderTarget.append(String.valueOf(d));
            } else if (value.type() == Type.BOOL) {
                boolean b = value.asBool();
                this.renderTarget.append(b ? "true" : "false");
            } else if (value.type() == Type.DATA) {
                byte[] data = value.asData();
                this.renderTarget.append("<data length=\"").append(data.length);
                this.renderTarget.append("\" encoding=\"hex\">");
                for (int i = 0; i < data.length; ++i) {
                    for (int sh = 4; sh >= 0; sh -= 4) {
                        int val = data[i] >> sh & 0xF;
                        char hexdigit = val < 10 ? (char)(48 + val) : (char)(65 + val - 10);
                        this.renderTarget.append(hexdigit);
                    }
                }
                this.renderTarget.append("</data>");
            }
        }

        private void renderMapItem(Inspector object, int nestingLevel) {
            this.renderTarget.append('\n');
            this.indent(nestingLevel);
            this.renderTarget.append("<item><key>");
            this.renderInspector(object.field("key"), nestingLevel);
            this.renderTarget.append("</key><value>");
            this.renderInspector(object.field("value"), nestingLevel);
            this.renderTarget.append("</value></item>");
        }

        private void renderStructure(Inspector structure, int nestingLevel) {
            for (Map.Entry entry : structure.fields()) {
                String key = (String)entry.getKey();
                Inspector value = (Inspector)entry.getValue();
                this.renderTarget.append('\n');
                this.indent(nestingLevel);
                this.renderTarget.append("<struct-field name=\"").append(key).append("\">");
                this.renderInspector(value, nestingLevel);
                this.renderTarget.append("</struct-field>");
            }
            this.renderTarget.append('\n');
        }

        private void renderStruct(Inspector object, int nestingLevel) {
            this.renderStructure(object, nestingLevel + 1);
            this.indent(nestingLevel);
        }

        private void indent(int nestingLevel) {
            for (int i = 0; i < nestingLevel; ++i) {
                this.renderTarget.append("  ");
            }
        }

        private void renderMap(Inspector sequence, int nestingLevel) {
            int limit = sequence.entryCount();
            if (limit == 0) {
                return;
            }
            for (int i = 0; i < limit; ++i) {
                this.renderMapItem(sequence.entry(i), nestingLevel);
            }
            this.renderTarget.append("\n");
        }

        private boolean isMap(Inspector array) {
            Inspector firstObject = array.entry(0);
            if (firstObject.type() != Type.OBJECT) {
                return false;
            }
            if (firstObject.fieldCount() != 2) {
                return false;
            }
            if (!firstObject.field("key").valid()) {
                return false;
            }
            return firstObject.field("value").valid();
        }

        private boolean isWeightedSetObjects(Inspector array) {
            Inspector firstObject = array.entry(0);
            if (firstObject.type() != Type.OBJECT) {
                return false;
            }
            if (firstObject.fieldCount() != 2) {
                return false;
            }
            if (!firstObject.field("item").valid()) {
                return false;
            }
            return firstObject.field("weight").valid();
        }

        private boolean isWeightedSetArrays(Inspector array) {
            Inspector firstObject = array.entry(0);
            if (firstObject.type() != Type.ARRAY) {
                return false;
            }
            return firstObject.entryCount() == 2;
        }

        private void renderMapOrArray(Inspector sequence, int nestingLevel) {
            if (sequence.entryCount() == 0) {
                return;
            }
            if (this.isMap(sequence)) {
                this.renderMap(sequence, nestingLevel + 1);
            } else if (this.isWeightedSetArrays(sequence)) {
                this.renderWeightedSet(sequence, nestingLevel + 1, true);
            } else if (this.isWeightedSetObjects(sequence)) {
                this.renderWeightedSet(sequence, nestingLevel + 1, false);
            } else {
                this.renderArray(sequence, nestingLevel + 1);
            }
            this.indent(nestingLevel);
        }

        private void renderWeightedSet(Inspector seq, int nestingLevel, boolean nestedarray) {
            int limit = seq.entryCount();
            this.renderTarget.append('\n');
            for (int i = 0; i < limit; ++i) {
                Inspector value = nestedarray ? seq.entry(i).entry(0) : seq.entry(i).field("item");
                Inspector weight = nestedarray ? seq.entry(i).entry(1) : seq.entry(i).field("weight");
                long lw = 0L;
                double dw = 0.0;
                if (weight.type() == Type.LONG) {
                    lw = weight.asLong();
                    dw = lw;
                }
                if (weight.type() == Type.DOUBLE) {
                    dw = weight.asDouble();
                    lw = (long)dw;
                }
                this.indent(nestingLevel);
                this.renderTarget.append("<item weight=\"");
                if (dw == (double)lw || weight.type() == Type.LONG) {
                    this.renderTarget.append(lw);
                } else {
                    this.renderTarget.append(dw);
                }
                this.renderTarget.append("\">");
                this.renderInspector(value, nestingLevel);
                this.renderTarget.append("</item>\n");
            }
        }

        private void renderArray(Inspector seq, int nestingLevel) {
            int limit = seq.entryCount();
            if (limit == 0) {
                return;
            }
            this.renderTarget.append('\n');
            for (int i = 0; i < limit; ++i) {
                Inspector value = seq.entry(i);
                this.indent(nestingLevel);
                this.renderTarget.append("<item>");
                this.renderInspector(value, nestingLevel);
                this.renderTarget.append("</item>\n");
            }
        }
    }
}

