/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.pagetemplates.engine;

import com.yahoo.search.result.ChainableComparator;
import com.yahoo.search.result.Hit;
import java.util.Comparator;
import java.util.List;

class SourceOrderComparator
extends ChainableComparator {
    private final List<String> sourceOrder;

    public SourceOrderComparator(List<String> sourceOrder) {
        this(sourceOrder, null);
    }

    public SourceOrderComparator(List<String> sourceOrder, Comparator<Hit> secondaryComparator) {
        super(secondaryComparator);
        this.sourceOrder = sourceOrder;
    }

    @Override
    public int compare(Hit h1, Hit h2) {
        int primaryOrder = this.sourceOrderCompare(h1, h2);
        if (primaryOrder != 0) {
            return primaryOrder;
        }
        return super.compare(h1, h2);
    }

    private int sourceOrderCompare(Hit h1, Hit h2) {
        String h1Source = h1.getSource();
        String h2Source = h2.getSource();
        if (h1Source == null && h2Source == null) {
            return 0;
        }
        if (h1Source == null) {
            return 1;
        }
        if (h2Source == null) {
            return -1;
        }
        if (h1Source.equals(h2Source)) {
            return 0;
        }
        return this.sourceOrder.indexOf(h1Source) - this.sourceOrder.indexOf(h2Source);
    }
}

