/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.vespa;

import com.yahoo.prelude.hitfield.RawBase64;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.grouping.Continuation;
import com.yahoo.search.grouping.result.BoolId;
import com.yahoo.search.grouping.result.DoubleBucketId;
import com.yahoo.search.grouping.result.DoubleId;
import com.yahoo.search.grouping.result.Group;
import com.yahoo.search.grouping.result.GroupId;
import com.yahoo.search.grouping.result.GroupList;
import com.yahoo.search.grouping.result.HitList;
import com.yahoo.search.grouping.result.LongBucketId;
import com.yahoo.search.grouping.result.LongId;
import com.yahoo.search.grouping.result.NullId;
import com.yahoo.search.grouping.result.RawBucketId;
import com.yahoo.search.grouping.result.RawId;
import com.yahoo.search.grouping.result.RootGroup;
import com.yahoo.search.grouping.result.StringBucketId;
import com.yahoo.search.grouping.result.StringId;
import com.yahoo.search.grouping.vespa.CompositeContinuation;
import com.yahoo.search.grouping.vespa.GroupingTransform;
import com.yahoo.search.grouping.vespa.OffsetContinuation;
import com.yahoo.search.grouping.vespa.ResultId;
import com.yahoo.search.result.Relevance;
import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.AverageAggregationResult;
import com.yahoo.searchlib.aggregation.CountAggregationResult;
import com.yahoo.searchlib.aggregation.ExpressionCountAggregationResult;
import com.yahoo.searchlib.aggregation.Grouping;
import com.yahoo.searchlib.aggregation.Hit;
import com.yahoo.searchlib.aggregation.HitsAggregationResult;
import com.yahoo.searchlib.aggregation.MaxAggregationResult;
import com.yahoo.searchlib.aggregation.MinAggregationResult;
import com.yahoo.searchlib.aggregation.QuantileAggregationResult;
import com.yahoo.searchlib.aggregation.RawData;
import com.yahoo.searchlib.aggregation.StandardDeviationAggregationResult;
import com.yahoo.searchlib.aggregation.SumAggregationResult;
import com.yahoo.searchlib.aggregation.XorAggregationResult;
import com.yahoo.searchlib.expression.BoolResultNode;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FloatBucketResultNode;
import com.yahoo.searchlib.expression.FloatResultNode;
import com.yahoo.searchlib.expression.IntegerBucketResultNode;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.NullResultNode;
import com.yahoo.searchlib.expression.RawBucketResultNode;
import com.yahoo.searchlib.expression.RawResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.StringBucketResultNode;
import com.yahoo.searchlib.expression.StringResultNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResultBuilder {
    private final CompositeContinuation continuation = new CompositeContinuation();
    private RootGroup root;
    private GroupListBuilder rootBuilder;
    private HitConverter hitConverter;
    private GroupingTransform transform;

    ResultBuilder() {
    }

    public ResultBuilder setRequestId(int requestId) {
        this.root = new RootGroup(requestId, this.continuation);
        this.rootBuilder = new GroupListBuilder(ResultId.valueOf(requestId), 0, true, true);
        return this;
    }

    public ResultBuilder setTransform(GroupingTransform transform) {
        this.transform = transform;
        return this;
    }

    public ResultBuilder setHitConverter(HitConverter hitConverter) {
        this.hitConverter = hitConverter;
        return this;
    }

    public void addGroupingResult(Grouping executionResult) {
        executionResult.unifyNull();
        this.rootBuilder.addGroup(executionResult.getRoot());
    }

    public RootGroup getRoot() {
        return this.root;
    }

    public Continuation getContinuation() {
        return this.continuation;
    }

    public void build() {
        int numChildren = this.rootBuilder.childGroups.size();
        if (numChildren != 1) {
            throw new IllegalInputException("Expected 1 group, got " + numChildren + ".");
        }
        this.rootBuilder.childGroups.get(0).fill(this.root);
    }

    private class GroupListBuilder {
        final Map<ResultNode, GroupBuilder> childResultGroups = new HashMap<ResultNode, GroupBuilder>();
        final List<GroupBuilder> childGroups = new ArrayList<GroupBuilder>();
        final ResultId resultId;
        final int tag;
        final boolean stable;
        final boolean stableChildren;
        final boolean ranked;

        GroupListBuilder(ResultId resultId, int tag, boolean stable, boolean ranked) {
            this.resultId = resultId;
            this.tag = tag;
            this.stable = stable;
            this.stableChildren = stable && ResultBuilder.this.transform.isStable(resultId);
            this.ranked = ranked;
        }

        GroupList build() {
            PageInfo page = new PageInfo(this.resultId, this.tag, this.stable, this.childGroups.size());
            GroupList groupList = new GroupList(ResultBuilder.this.transform.getLabel(this.tag));
            for (int i = page.firstEntry; i < page.lastEntry; ++i) {
                GroupBuilder child = this.childGroups.get(i);
                groupList.add(child.build(this.ranked ? child.group.getRank() : (double)(page.lastEntry - i) / (double)(page.lastEntry - page.firstEntry)));
            }
            page.putContinuations(groupList.continuations());
            return groupList;
        }

        void addGroup(com.yahoo.searchlib.aggregation.Group execGroup) {
            GroupBuilder groupBuilder = this.getOrCreateGroup(execGroup);
            if (execGroup.getNumChildren() > 0) {
                execGroup.sortChildrenByRank();
                List children = execGroup.getChildren();
                boolean ranked = ((com.yahoo.searchlib.aggregation.Group)children.get(0)).isRankedByRelevance();
                for (com.yahoo.searchlib.aggregation.Group childGroup : children) {
                    GroupListBuilder childList = groupBuilder.getOrCreateChildList(childGroup.getTag(), ranked);
                    childList.addGroup(childGroup);
                }
            }
        }

        GroupBuilder getOrCreateGroup(com.yahoo.searchlib.aggregation.Group execGroup) {
            ResultNode result = execGroup.getId();
            GroupBuilder ret = this.childResultGroups.get(result);
            if (ret != null) {
                ret.merge(execGroup);
            } else {
                ret = new GroupBuilder(this.resultId.newChildId(this.childResultGroups.size()), execGroup, this.stableChildren);
                this.childResultGroups.put(result, ret);
                this.childGroups.add(ret);
            }
            return ret;
        }
    }

    public static interface HitConverter {
        public com.yahoo.search.result.Hit toSearchHit(String var1, Hit var2);
    }

    private class GroupBuilder {
        private static final int CHILDLIST_SIZE_INCREMENTS = 4;
        boolean[] results = new boolean[8];
        GroupListBuilder[] childLists;
        int childCount = 0;
        final ResultId resultId;
        final com.yahoo.searchlib.aggregation.Group group;
        final boolean stable;

        GroupBuilder(ResultId resultId, com.yahoo.searchlib.aggregation.Group group, boolean stable) {
            this.resultId = resultId;
            this.group = group;
            this.stable = stable;
        }

        Group build(double relevance) {
            return this.fill(new Group(this.newGroupId(this.group), new Relevance(relevance)));
        }

        Group fill(Group group) {
            for (AggregationResult result : this.group.getAggregationResults()) {
                int tag = result.getTag();
                if (result instanceof HitsAggregationResult) {
                    group.add(this.newHitList(group.size(), tag, (HitsAggregationResult)result));
                    continue;
                }
                String label = ResultBuilder.this.transform.getLabel(result.getTag());
                if (label == null) continue;
                group.setField(label, this.convertResult(this.newResult((ExpressionNode)result, tag)));
            }
            if (this.childLists != null) {
                for (GroupListBuilder child : this.childLists) {
                    if (child == null) continue;
                    group.add(child.build());
                }
            }
            return group;
        }

        GroupListBuilder getOrCreateChildList(int tag, boolean ranked) {
            GroupListBuilder ret;
            int index = tag + 1;
            if (this.childLists == null || index >= this.childLists.length) {
                int minSize = index + 1;
                int reservedSize = (minSize + 3) / 4 * 4;
                GroupListBuilder[] groupListBuilderArray = this.childLists = this.childLists == null ? new GroupListBuilder[reservedSize] : Arrays.copyOf(this.childLists, reservedSize);
            }
            if ((ret = this.childLists[index]) == null) {
                this.childLists[index] = ret = new GroupListBuilder(this.resultId.newChildId(this.childCount), tag, this.stable, ranked);
                ++this.childCount;
            }
            return ret;
        }

        void merge(com.yahoo.searchlib.aggregation.Group group) {
            for (AggregationResult res : group.getAggregationResults()) {
                int tag = res.getTag() + 1;
                if (tag >= this.results.length) {
                    this.results = Arrays.copyOf(this.results, tag + 8);
                }
                if (this.results[tag]) continue;
                this.group.addAggregationResult(res);
                this.results[tag] = true;
            }
        }

        GroupId newGroupId(com.yahoo.searchlib.aggregation.Group execGroup) {
            ResultNode res = execGroup.getId();
            if (res instanceof FloatResultNode) {
                return new DoubleId(res.getFloat());
            }
            if (res instanceof IntegerResultNode) {
                return new LongId(res.getInteger());
            }
            if (res instanceof BoolResultNode) {
                return new BoolId(((BoolResultNode)res).getValue());
            }
            if (res instanceof NullResultNode) {
                return new NullId();
            }
            if (res instanceof RawResultNode) {
                return new RawId(res.getRaw());
            }
            if (res instanceof StringResultNode) {
                return new StringId(res.getString());
            }
            if (res instanceof FloatBucketResultNode) {
                FloatBucketResultNode bucketId = (FloatBucketResultNode)res;
                return new DoubleBucketId(bucketId.getFrom(), bucketId.getTo());
            }
            if (res instanceof IntegerBucketResultNode) {
                IntegerBucketResultNode bucketId = (IntegerBucketResultNode)res;
                return new LongBucketId(bucketId.getFrom(), bucketId.getTo());
            }
            if (res instanceof StringBucketResultNode) {
                StringBucketResultNode bucketId = (StringBucketResultNode)res;
                return new StringBucketId(bucketId.getFrom(), bucketId.getTo());
            }
            if (res instanceof RawBucketResultNode) {
                RawBucketResultNode bucketId = (RawBucketResultNode)res;
                return new RawBucketId(bucketId.getFrom(), bucketId.getTo());
            }
            throw new UnsupportedOperationException(res.getClass().getName());
        }

        private Object convertResult(Object value) {
            if (value instanceof RawData) {
                RawData raw = (RawData)value;
                return new RawBase64(raw.getData());
            }
            return value;
        }

        private Object newResult(ExpressionNode execResult, int tag) {
            if (execResult instanceof AverageAggregationResult) {
                return ((AverageAggregationResult)execResult).getAverage().getNumber();
            }
            if (execResult instanceof CountAggregationResult) {
                return ((CountAggregationResult)execResult).getCount();
            }
            if (execResult instanceof QuantileAggregationResult) {
                QuantileAggregationResult quantiles = (QuantileAggregationResult)execResult;
                return quantiles.getQuantileResults();
            }
            if (execResult instanceof ExpressionCountAggregationResult) {
                long count = ((ExpressionCountAggregationResult)execResult).getEstimatedUniqueCount();
                return this.correctExpressionCountEstimate(count, tag);
            }
            if (execResult instanceof MaxAggregationResult) {
                return ((MaxAggregationResult)execResult).getMax().getValue();
            }
            if (execResult instanceof MinAggregationResult) {
                return ((MinAggregationResult)execResult).getMin().getValue();
            }
            if (execResult instanceof SumAggregationResult) {
                return ((SumAggregationResult)execResult).getSum().getValue();
            }
            if (execResult instanceof StandardDeviationAggregationResult) {
                return ((StandardDeviationAggregationResult)execResult).getStandardDeviation();
            }
            if (execResult instanceof XorAggregationResult) {
                return ((XorAggregationResult)execResult).getXor();
            }
            throw new UnsupportedOperationException(execResult.getClass().getName());
        }

        private long correctExpressionCountEstimate(long count, int tag) {
            int actualGroupCount = this.group.getNumChildren();
            if (actualGroupCount > 0 && count != (long)actualGroupCount && (ResultBuilder.this.transform.getMax(tag + 1) == 0 || ResultBuilder.this.transform.getMax(tag + 1) > actualGroupCount)) {
                return actualGroupCount;
            }
            return count;
        }

        HitList newHitList(int listIdx, int tag, HitsAggregationResult execResult) {
            HitList hitList = new HitList(ResultBuilder.this.transform.getLabel(tag));
            List hits = execResult.getHits();
            PageInfo page = new PageInfo(this.resultId.newChildId(listIdx), tag, this.stable, hits.size());
            for (int i = page.firstEntry; i < page.lastEntry; ++i) {
                hitList.add(ResultBuilder.this.hitConverter.toSearchHit(execResult.getSummaryClass(), (Hit)hits.get(i)));
            }
            page.putContinuations(hitList.continuations());
            return hitList;
        }
    }

    private class PageInfo {
        final ResultId resultId;
        final int tag;
        final int max;
        final int numEntries;
        final int firstEntry;
        final int lastEntry;

        PageInfo(ResultId resultId, int tag, boolean stable, int numEntries) {
            this.resultId = resultId;
            this.tag = tag;
            this.numEntries = numEntries;
            this.max = ResultBuilder.this.transform.getMax(tag);
            if (this.max > 0) {
                this.firstEntry = stable ? ResultBuilder.this.transform.getOffset(resultId) : 0;
                this.lastEntry = Math.min(numEntries, this.firstEntry + this.max);
            } else {
                this.firstEntry = 0;
                this.lastEntry = numEntries;
            }
        }

        void putContinuations(Map<String, Continuation> out) {
            if (this.max > 0) {
                if (this.firstEntry > 0) {
                    ResultBuilder.this.continuation.add(new OffsetContinuation(this.resultId, this.tag, this.firstEntry, 0));
                    int prevPage = Math.max(0, Math.min(this.firstEntry, this.lastEntry) - this.max);
                    out.put("prev", new OffsetContinuation(this.resultId, this.tag, prevPage, 1));
                }
                if (this.lastEntry < this.numEntries) {
                    out.put("next", new OffsetContinuation(this.resultId, this.tag, this.lastEntry, 1));
                }
            }
        }
    }
}

