/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.collections.CopyOnWriteHashMap;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.PureWeightedInteger;
import com.yahoo.prelude.query.PureWeightedItem;
import com.yahoo.prelude.query.PureWeightedString;
import com.yahoo.prelude.query.SimpleTaggableItem;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class WeightedSetItem
extends SimpleTaggableItem {
    private String indexName;
    private CopyOnWriteHashMap<Object, Integer> set;

    public WeightedSetItem(String indexName) {
        this.indexName = Objects.requireNonNullElse(indexName, "");
        this.set = new CopyOnWriteHashMap(1000);
    }

    public WeightedSetItem(String indexName, Map<Object, Integer> map) {
        this.indexName = Objects.requireNonNullElse(indexName, "");
        this.set = new CopyOnWriteHashMap(map);
    }

    public Integer addToken(long value, int weight) {
        return this.addInternal(value, weight);
    }

    public Integer addToken(String token, int weight) {
        if (token == null) {
            throw new IllegalArgumentException("token must be a string");
        }
        return this.addInternal(token, weight);
    }

    private Integer addInternal(Object token, int weight) {
        Integer newWeight = weight;
        Integer oldWeight = (Integer)this.set.put(token, (Object)newWeight);
        if (oldWeight != null && oldWeight > newWeight) {
            this.set.put(token, (Object)oldWeight);
            return oldWeight;
        }
        return newWeight;
    }

    public Integer addToken(String token) {
        return this.addToken(token, 1);
    }

    public Integer getTokenWeight(Object token) {
        return (Integer)this.set.get(token);
    }

    public Integer removeToken(String token) {
        return (Integer)this.set.remove((Object)token);
    }

    public int getNumTokens() {
        return this.set.size();
    }

    public Iterator<Map.Entry<Object, Integer>> getTokens() {
        return this.set.entrySet().iterator();
    }

    @Override
    public void setIndexName(String index) {
        this.indexName = Objects.requireNonNullElse(index, "");
    }

    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.WEIGHTEDSET;
    }

    @Override
    public String getName() {
        return this.getItemType().name();
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append(this.indexName);
        buffer.append("{");
        for (Map.Entry entry : this.set.entrySet()) {
            buffer.append("[");
            buffer.append(entry.getValue());
            buffer.append("]:\"");
            buffer.append(entry.getKey());
            buffer.append("\",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append("}");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("index", this.indexName);
        for (Map.Entry entry : this.set.entrySet()) {
            discloser.addChild(this.asItem(entry));
        }
    }

    @Override
    public int encode(ByteBuffer buffer) {
        this.encodeThis(buffer);
        int itemCount = 1;
        for (Map.Entry entry : this.set.entrySet()) {
            this.asItem(entry).encode(buffer);
            ++itemCount;
        }
        return itemCount;
    }

    private PureWeightedItem asItem(Map.Entry<Object, Integer> entry) {
        Object key = entry.getKey();
        if (key instanceof Long) {
            return new PureWeightedInteger((Long)key, entry.getValue());
        }
        return new PureWeightedString(key.toString(), entry.getValue());
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.set.size(), (ByteBuffer)buffer);
        WeightedSetItem.putString(this.indexName, buffer);
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public WeightedSetItem clone() {
        WeightedSetItem clone = (WeightedSetItem)super.clone();
        clone.set = this.set.clone();
        return clone;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        WeightedSetItem other = (WeightedSetItem)o;
        if (!Objects.equals(this.indexName, other.indexName)) {
            return false;
        }
        return Objects.equals(this.set, other.set);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexName, this.set);
    }

    protected boolean hasOnlyLongs() {
        boolean hasLongs = false;
        boolean hasStrings = false;
        for (Object key : this.set.keySet()) {
            if (key instanceof Long) {
                hasLongs = true;
                continue;
            }
            hasStrings = true;
        }
        return hasLongs && !hasStrings;
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        if (this.hasOnlyLongs()) {
            SearchProtocol.ItemWeightedSetOfLong.Builder builder = SearchProtocol.ItemWeightedSetOfLong.newBuilder();
            builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
            for (Map.Entry entry : this.set.entrySet()) {
                SearchProtocol.PureWeightedLong weightedLong = SearchProtocol.PureWeightedLong.newBuilder().setWeight(((Integer)entry.getValue()).intValue()).setValue(((Long)entry.getKey()).longValue()).build();
                builder.addWeightedLongs(weightedLong);
            }
            return SearchProtocol.QueryTreeItem.newBuilder().setItemWeightedSetOfLong(builder.build()).build();
        }
        SearchProtocol.ItemWeightedSetOfString.Builder builder = SearchProtocol.ItemWeightedSetOfString.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        for (Map.Entry entry : this.set.entrySet()) {
            SearchProtocol.PureWeightedString weightedString = SearchProtocol.PureWeightedString.newBuilder().setWeight(((Integer)entry.getValue()).intValue()).setValue(entry.getKey().toString()).build();
            builder.addWeightedStrings(weightedString);
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemWeightedSetOfString(builder.build()).build();
    }
}

