/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import com.yahoo.search.dispatch.rpc.ProtobufSerialization;
import java.nio.ByteBuffer;
import java.util.Objects;

public class NearItem
extends CompositeItem {
    protected int distance;
    protected int numNegativeItems;
    protected int exclusionDistance;
    public static final int defaultDistance = 2;

    public NearItem() {
        this.setDistance(2);
    }

    public NearItem(int distance) {
        this.setDistance(distance);
    }

    public void setDistance(int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException("Can not use negative distance " + distance);
        }
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setNumNegativeItems(int numNegativeItems) {
        this.numNegativeItems = numNegativeItems;
    }

    public int getNumNegativeItems() {
        return this.numNegativeItems;
    }

    public void setExclusionDistance(int exclusionDistance) {
        this.exclusionDistance = exclusionDistance;
    }

    public int getExclusionDistance() {
        return this.exclusionDistance;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAR;
    }

    @Override
    public String getName() {
        return "NEAR";
    }

    @Override
    protected void encodeThis(ByteBuffer buffer) {
        super.encodeThis(buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.distance, (ByteBuffer)buffer);
        if (this.numNegativeItems != 0 && !ProtobufSerialization.isProtobufAlsoSerialized()) {
            throw new IllegalArgumentException("cannot serialize negative items in old protocol");
        }
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("limit", this.distance);
    }

    @Override
    protected void appendHeadingString(StringBuilder buffer) {
        buffer.append(this.getName());
        buffer.append("(");
        buffer.append(this.distance);
        if (this.numNegativeItems != 0 || this.exclusionDistance != 0) {
            buffer.append(",");
            buffer.append(this.numNegativeItems);
            buffer.append(",");
            buffer.append(this.exclusionDistance);
        }
        buffer.append(")");
        buffer.append(" ");
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        NearItem other = (NearItem)object;
        return this.distance == other.distance;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.distance);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemNear.Builder builder = SearchProtocol.ItemNear.newBuilder();
        builder.setDistance(this.distance);
        builder.setNumNegativeTerms(this.numNegativeItems);
        builder.setExclusionDistance(this.exclusionDistance);
        for (Item child : this.items()) {
            builder.addChildren(child.toProtobuf());
        }
        return SearchProtocol.QueryTreeItem.newBuilder().setItemNear(builder.build()).build();
    }
}

