/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics;

import com.yahoo.language.Linguistics;
import com.yahoo.prelude.querytransform.PhraseMatcher;
import com.yahoo.prelude.semantics.RuleImporter;
import com.yahoo.prelude.semantics.engine.RuleEngine;
import com.yahoo.prelude.semantics.parser.ParseException;
import com.yahoo.prelude.semantics.rule.CompositeCondition;
import com.yahoo.prelude.semantics.rule.Condition;
import com.yahoo.prelude.semantics.rule.NamedCondition;
import com.yahoo.prelude.semantics.rule.ProductionRule;
import com.yahoo.prelude.semantics.rule.SuperCondition;
import com.yahoo.protect.Validator;
import com.yahoo.search.Query;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class RuleBase {
    private String name;
    private String source;
    private String automataFileName = null;
    private boolean isDefault = false;
    private final List<ProductionRule> productionRules = new ArrayList<ProductionRule>();
    private Map<String, NamedCondition> namedConditions = new LinkedHashMap<String, NamedCondition>();
    private final RuleEngine analyzer = new RuleEngine(this);
    private static final PhraseMatcher nullPhraseMatcher = PhraseMatcher.getNullMatcher();
    private PhraseMatcher phraseMatcher = nullPhraseMatcher;
    private final Set<String> includedNames = new LinkedHashSet<String>();
    private boolean usesAutomata = false;

    public RuleBase(String name) {
        this.name = name;
    }

    public static RuleBase createFromFile(String ruleFile, String automataFile, Linguistics linguistics) throws IOException, ParseException {
        return new RuleImporter(linguistics).importFile(ruleFile, automataFile);
    }

    public static RuleBase createFromString(String name, String ruleString, String automataFile, Linguistics linguistics) throws IOException, ParseException {
        RuleBase base = new RuleImporter(linguistics).importString(ruleString, automataFile);
        base.setName(name);
        return base;
    }

    public void include(RuleBase include) {
        this.productionRules.add(new IncludeDirective(include));
        this.includedNames.addAll(include.includedNames);
        this.includedNames.add(include.getName());
    }

    private void inlineIncluded() {
        Map<String, NamedCondition> thisConditions = this.namedConditions;
        this.namedConditions = new LinkedHashMap<String, NamedCondition>();
        HashSet<RuleBase> included = new HashSet<RuleBase>();
        included.add(this);
        ListIterator<ProductionRule> i = this.productionRules.listIterator();
        while (i.hasNext()) {
            ProductionRule rule = i.next();
            if (!(rule instanceof IncludeDirective)) continue;
            i.remove();
            RuleBase toInclude = ((IncludeDirective)rule).getIncludedBase();
            if (included.contains(toInclude)) continue;
            toInclude.inlineIn(this, i, included);
        }
        this.namedConditions.putAll(thisConditions);
    }

    private void inlineIn(RuleBase receiver, ListIterator<ProductionRule> receiverRules, Set<RuleBase> included) {
        if (included.contains(this)) {
            return;
        }
        included.add(this);
        for (ProductionRule rule : this.productionRules) {
            if (rule instanceof IncludeDirective) {
                ((IncludeDirective)rule).getIncludedBase().inlineIn(receiver, receiverRules, included);
                continue;
            }
            receiverRules.add(rule);
        }
        receiver.namedConditions.putAll(this.namedConditions);
    }

    public void addCondition(NamedCondition namedCondition) {
        this.namedConditions.put(namedCondition.getName(), namedCondition);
        Condition condition = namedCondition.getCondition();
        Condition superCondition = this.findIncludedCondition(namedCondition.getName());
        this.resolveSuper(condition, superCondition);
    }

    private void resolveSuper(Condition condition, Condition superCondition) {
        if (condition instanceof SuperCondition) {
            ((SuperCondition)condition).setCondition(superCondition);
        } else if (condition instanceof CompositeCondition) {
            Iterator<Condition> i = ((CompositeCondition)condition).conditionIterator();
            while (i.hasNext()) {
                Condition subCondition = i.next();
                this.resolveSuper(subCondition, superCondition);
            }
        }
    }

    private Condition findIncludedCondition(String name) {
        for (ProductionRule rule : this.productionRules) {
            if (!(rule instanceof IncludeDirective)) continue;
            RuleBase included = ((IncludeDirective)rule).getIncludedBase();
            NamedCondition condition = included.getCondition(name);
            if (condition != null) {
                return condition.getCondition();
            }
            included.findIncludedCondition(name);
        }
        return null;
    }

    public boolean includes(String ruleBaseName) {
        return this.includedNames.contains(ruleBaseName);
    }

    public void setName(String name) {
        Validator.ensureNotNull((String)"Rule base name", (Object)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAutomataFile(String automataFile) {
        if (!new File(automataFile).exists()) {
            throw new IllegalArgumentException("Automata file '" + automataFile + "' included in " + String.valueOf(this) + " not found");
        }
        this.phraseMatcher = new PhraseMatcher(automataFile);
        this.phraseMatcher.setIgnorePluralForm(true);
        this.phraseMatcher.setMatchAll(true);
        this.phraseMatcher.setMatchPhraseItems(true);
        this.phraseMatcher.setMatchSingleItems(true);
        this.setPhraseMatcher(this.phraseMatcher);
        this.automataFileName = automataFile;
    }

    public String getAutomataFile() {
        return this.automataFileName;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public synchronized void setPhraseMatcher(PhraseMatcher matcher) {
        this.phraseMatcher = matcher == null ? nullPhraseMatcher : matcher;
    }

    public synchronized PhraseMatcher getPhraseMatcher() {
        return this.phraseMatcher;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean usesAutomata() {
        return this.usesAutomata || this.phraseMatcher != nullPhraseMatcher;
    }

    void setUsesAutomata(boolean usesAutomata) {
        this.usesAutomata = usesAutomata;
    }

    public void addRule(ProductionRule productionRule) {
        this.productionRules.add(productionRule);
    }

    public NamedCondition getCondition(String name) {
        return this.namedConditions.get(name);
    }

    public void initialize() {
        this.inlineIncluded();
        this.makeReferences();
    }

    public String analyze(Query query, int traceLevel) {
        int queryTraceLevel = query.getTrace().getLevel();
        if (traceLevel > 0 && queryTraceLevel == 0) {
            query.getTrace().setLevel(1);
        }
        this.matchAutomata(query, traceLevel);
        String error = this.analyzer.evaluate(query, traceLevel);
        query.getTrace().setLevel(queryTraceLevel);
        return error;
    }

    protected void matchAutomata(Query query, int traceLevel) {
        List<PhraseMatcher.Phrase> matches = this.getPhraseMatcher().matchPhrases(query.getModel().getQueryTree().getRoot());
        if (matches == null || matches.size() == 0) {
            return;
        }
        for (PhraseMatcher.Phrase phrase : matches) {
            if (traceLevel >= 3) {
                query.trace("Semantic searcher automata matched " + String.valueOf(phrase), false, 1);
            }
            this.annotatePhrase(phrase, query, traceLevel);
        }
    }

    protected void annotatePhrase(PhraseMatcher.Phrase phrase, Query query, int traceLevel) {
        StringTokenizer tokens = new StringTokenizer(phrase.getData(), "|", false);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int semicolonIndex = token.indexOf(";");
            String annotation = token;
            String value = "";
            if (semicolonIndex > 0) {
                annotation = token.substring(0, semicolonIndex);
                value = token.substring(semicolonIndex + 1);
            }
            phrase.getItem(0).addAnnotation(annotation, phrase);
            if (traceLevel < 4) continue;
            query.trace("   Annotating '" + String.valueOf(phrase) + "' as " + annotation + (String)(value.equals("") ? "" : "=" + value), false, 1);
        }
    }

    private void makeReferences() {
        Iterator<Object> i = this.ruleIterator();
        while (i.hasNext()) {
            ProductionRule rule = (ProductionRule)i.next();
            rule.makeReferences(this);
        }
        i = this.conditionIterator();
        while (i.hasNext()) {
            NamedCondition namedCondition = (NamedCondition)i.next();
            namedCondition.getCondition().makeReferences(this);
        }
    }

    public ListIterator<ProductionRule> ruleIterator() {
        return this.productionRules.listIterator();
    }

    public List<ProductionRule> rules() {
        return Collections.unmodifiableList(this.productionRules);
    }

    public Iterator<NamedCondition> conditionIterator() {
        return this.namedConditions.values().iterator();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RuleBase)) {
            return false;
        }
        return ((RuleBase)object).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return "rule base '" + this.getName() + "'";
    }

    public String toContentString() {
        StringBuilder b = new StringBuilder();
        Iterator<Object> i = this.productionRules.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            b.append("\n");
        }
        b.append("\n");
        b.append("\n");
        i = this.namedConditions.values().iterator();
        while (i.hasNext()) {
            b.append(i.next());
            b.append("\n");
        }
        return b.toString();
    }

    private static class IncludeDirective
    extends ProductionRule {
        private final RuleBase includedBase;

        public IncludeDirective(RuleBase ruleBase) {
            this.includedBase = ruleBase;
        }

        public RuleBase getIncludedBase() {
            return this.includedBase;
        }

        @Override
        public String getSymbol() {
            return "";
        }
    }
}

