/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NullItem;
import com.yahoo.search.query.QueryTree;
import java.nio.ByteBuffer;

public class RootItem
extends CompositeItem {
    public RootItem() {
        this.setRoot(new NullItem());
    }

    public RootItem(Item root) {
        this.setRoot(root);
    }

    @Override
    public void setIndexName(String index) {
        if (this.getRoot() != null) {
            this.getRoot().setIndexName(index);
        }
    }

    @Override
    public Item.ItemType getItemType() {
        throw new RuntimeException("Packet type access attempted. A root item has no packet code. This is probably a misbehaving searcher.");
    }

    @Override
    public String getName() {
        return "ROOT";
    }

    @Override
    public int encode(ByteBuffer buffer) {
        if (this.getRoot() == null) {
            return 0;
        }
        return this.getRoot().encode(buffer);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        throw new UnsupportedOperationException("QueryTree itself should not be serialized, serialize its root");
    }

    public SearchProtocol.QueryTree toProtobufQueryTree() {
        SearchProtocol.QueryTree.Builder builder = SearchProtocol.QueryTree.newBuilder();
        if (this.getRoot() != null && !(this.getRoot() instanceof NullItem)) {
            builder.setRoot(this.getRoot().toProtobuf());
        }
        return builder.build();
    }

    @Override
    protected void appendHeadingString(StringBuilder sb) {
    }

    public Item getRoot() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return this.getItem(0);
    }

    public final void setRoot(Item root) {
        if (root == this) {
            throw new IllegalArgumentException("Cannot make a root point at itself");
        }
        if (root == null) {
            throw new IllegalArgumentException("Root must not be null, use NullItem instead.");
        }
        if (root instanceof RootItem) {
            throw new IllegalArgumentException("Do not use a new RootItem instance as a root.");
        }
        if (root instanceof QueryTree) {
            throw new IllegalArgumentException("Do not use a new QueryTree instance as a root.");
        }
        if (this.getItemCount() == 0) {
            super.addItem(root);
        } else {
            this.setItem(0, root);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RootItem)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public RootItem clone() {
        return (RootItem)super.clone();
    }

    @Override
    public void addItem(Item item) {
        if (this.getItemCount() != 0) {
            throw new RuntimeException("Programming error: Cannot add multiple roots");
        }
        super.addItem(item);
    }

    @Override
    public void addItem(int index, Item item) {
        if (this.getItemCount() != 0 || index != 0) {
            throw new RuntimeException("Programming error: Cannot add multiple roots, have '" + String.valueOf(this.getRoot()) + "'");
        }
        super.addItem(index, item);
    }

    public boolean isEmpty() {
        return this.getRoot() == null || this.getRoot() instanceof NullItem || this.getItemCount() == 0;
    }
}

