/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.fastsearch;

import com.yahoo.prelude.fastsearch.DocsumDefinition;
import com.yahoo.prelude.fastsearch.DocsumDefinitionSet;
import com.yahoo.prelude.fastsearch.DocumentDatabase;
import com.yahoo.processing.IllegalInputException;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.query.Presentation;
import com.yahoo.search.result.Hit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class PartialSummaryHandler {
    public static final String DEFAULT_CLASS = "default";
    public static final String ALL_FIELDS_CLASS = "default";
    public static final String PRESENTATION = "[presentation]";
    private static final Logger log = Logger.getLogger(PartialSummaryHandler.class.getName());
    private final DocsumDefinitionSet docsumDefinitions;
    private DocsumDefinition effectiveDocsumDef = null;
    private final Map<String, Set<String>> knownSummaryClasses = new HashMap<String, Set<String>>();
    private String summaryFromQuery = null;
    private String summaryRequestedInFill = null;
    private String askForSummary = null;
    private Set<String> fillMarkers = new HashSet<String>();
    private Set<String> fieldsFromQuery = null;
    private Set<String> resultHasFilled = null;
    private Set<String> askForFields = null;

    public static String resolveSummaryClass(Result result) {
        return PRESENTATION;
    }

    public PartialSummaryHandler(DocumentDatabase docDb) {
        this(docDb.getDocsumDefinitionSet());
    }

    public PartialSummaryHandler(DocsumDefinitionSet docsumDefinitionSet) {
        this.docsumDefinitions = docsumDefinitionSet;
    }

    public PartialSummaryHandler(Map<String, Set<String>> knownSummaryClasses) {
        this.docsumDefinitions = null;
        this.knownSummaryClasses.putAll(knownSummaryClasses);
    }

    public void wantToFill(Result result, String summaryClass) {
        this.summaryRequestedInFill = summaryClass;
        this.analyzeResult(result);
        this.analyzeQuery(result.getQuery());
        this.computeAskForFields();
        this.computeAskForSum(result.getQuery());
        this.computeFillMarker();
        this.computeEffectiveDocsumDef();
    }

    public void wantToFill(Query query) {
        this.summaryRequestedInFill = PRESENTATION;
        this.resultHasFilled = Set.of();
        this.analyzeQuery(query);
        this.computeAskForFields();
        this.computeAskForSum(query);
        this.computeFillMarker();
        this.computeEffectiveDocsumDef();
    }

    public String askForSummary() {
        return this.askForSummary;
    }

    public Set<String> askForFields() {
        return this.askForFields;
    }

    public boolean needFill(Hit hit) {
        return this.needsMoreFill(hit.getFilled());
    }

    public boolean resultAlreadyFilled() {
        return !this.needsMoreFill(this.resultHasFilled);
    }

    public DocsumDefinition effectiveDocsumDef() {
        if (this.effectiveDocsumDef == null) {
            if (this.docsumDefinitions == null) {
                throw new IllegalStateException("missing docsumDefinitions");
            }
            throw new IllegalStateException("docsumDefinition missing for summary=" + this.askForSummary);
        }
        return this.effectiveDocsumDef;
    }

    public void markFilled(Hit hit) {
        for (String marker : this.fillMarkers) {
            hit.setFilled(marker);
        }
    }

    private void analyzeResult(Result result) {
        this.resultHasFilled = result.hits().getFilled();
    }

    private void analyzeQuery(Query query) {
        Presentation presentation = query.getPresentation();
        this.summaryFromQuery = presentation.getSummary();
        this.fieldsFromQuery = presentation.getSummaryFields();
    }

    private static boolean isFieldListRequest(String summaryClass) {
        return summaryClass != null && summaryClass.startsWith("[f:");
    }

    private static boolean isDefaultRequest(String summaryClass) {
        return summaryClass == null || summaryClass.equals("default") || summaryClass.equals(PRESENTATION);
    }

    private static boolean isPresentationRequest(String summaryClass) {
        return summaryClass != null && summaryClass.equals(PRESENTATION);
    }

    private void computeAskForSum(Query query) {
        this.askForSummary = this.summaryRequestedInFill;
        if (this.askForSummary == null || this.askForSummary.equals(PRESENTATION)) {
            this.askForSummary = this.summaryFromQuery;
        }
        if (this.askForSummary == null) {
            this.askForSummary = "default";
        }
        if (this.askForFields != null) {
            Set<String> fieldsFromClass = this.getFieldsForClass(this.askForSummary);
            Set<String> available = this.fieldsAlreadyFilled(this.resultHasFilled);
            available.addAll(fieldsFromClass);
            if (!available.containsAll(this.askForFields)) {
                this.askForFields.addAll(fieldsFromClass);
                query.trace("requested summary=" + this.askForSummary + " does not contain all fields " + String.valueOf(this.fieldsFromQuery) + " from query; trying fields=" + String.valueOf(this.askForFields) + " and summary=default", 1);
                this.askForSummary = "default";
            }
        }
    }

    private void computeAskForFields() {
        this.askForFields = null;
        if (PartialSummaryHandler.isFieldListRequest(this.summaryRequestedInFill)) {
            Set<String> fieldSet = this.parseFieldList(this.summaryRequestedInFill);
            if (!fieldSet.isEmpty()) {
                this.askForFields = fieldSet;
            }
        } else if (PartialSummaryHandler.isPresentationRequest(this.summaryRequestedInFill) || PartialSummaryHandler.isDefaultRequest(this.summaryRequestedInFill)) {
            if (!this.fieldsFromQuery.isEmpty()) {
                this.askForFields = new TreeSet<String>(this.fieldsFromQuery);
            }
        } else if (this.summaryRequestedInFill != null && this.summaryRequestedInFill.startsWith("[")) {
            throw new IllegalArgumentException("fill(" + this.summaryRequestedInFill + ") is not valid");
        }
    }

    private void computeFillMarker() {
        if (PartialSummaryHandler.isPresentationRequest(this.summaryRequestedInFill)) {
            this.fillMarkers.add(this.summaryRequestedInFill);
            if (this.askForFields != null) {
                this.fillMarkers.add(PartialSummaryHandler.syntheticName(this.askForFields));
            } else {
                this.fillMarkers.add(this.summaryFromQuery);
            }
        } else if (this.askForFields != null) {
            this.fillMarkers.add(PartialSummaryHandler.syntheticName(this.askForFields));
        } else {
            this.fillMarkers.add(this.summaryRequestedInFill);
            this.fillMarkers.add(this.askForSummary);
        }
    }

    private static String syntheticName(Set<String> summaryFields) {
        TreeSet<String> sorted = new TreeSet<String>(summaryFields);
        StringBuilder buf = new StringBuilder();
        buf.append("[f:");
        for (String field : sorted) {
            buf.append(buf.length() == 3 ? "" : ",");
            buf.append(field);
        }
        buf.append(']');
        return buf.toString();
    }

    public static String quotedSummaryClassName(String summaryClass, Set<String> summaryFields) {
        if (PartialSummaryHandler.isDefaultRequest(summaryClass) && !summaryFields.isEmpty()) {
            return PartialSummaryHandler.syntheticName(summaryFields);
        }
        if (summaryClass == null) {
            return "[null]";
        }
        return "'" + summaryClass + "'";
    }

    public static String enoughFields(String summaryClass, Result result) {
        Set<String> summaryFields = result.getQuery().getPresentation().getSummaryFields();
        if (PartialSummaryHandler.isDefaultRequest(summaryClass) && !summaryFields.isEmpty()) {
            return PartialSummaryHandler.syntheticName(summaryFields);
        }
        return "default";
    }

    public void validateSummaryClass(String summaryClass, Query query) {
        if (PartialSummaryHandler.isFieldListRequest(summaryClass)) {
            Set<String> fieldSet = this.parseFieldList(summaryClass);
            if (fieldSet.isEmpty()) {
                throw new IllegalArgumentException("invalid fill() with empty fieldset=" + summaryClass);
            }
        } else if (PartialSummaryHandler.isPresentationRequest(summaryClass)) {
            String wantClass = query.getPresentation().getSummary();
            if (!this.ensureKnownClass(wantClass)) {
                throw new IllegalInputException("invalid presentation.summary=" + wantClass);
            }
        } else if (summaryClass != null && !this.ensureKnownClass(summaryClass)) {
            throw new IllegalArgumentException("invalid fill() with summaryClass=" + summaryClass);
        }
    }

    private void computeEffectiveDocsumDef() {
        if (this.docsumDefinitions != null && this.docsumDefinitions.hasDocsum(this.askForSummary)) {
            this.effectiveDocsumDef = this.docsumDefinitions.getDocsum(this.askForSummary);
            if (this.askForFields != null) {
                this.effectiveDocsumDef = new DocsumDefinition("<unnamed>", this.effectiveDocsumDef, this.askForFields);
            }
        }
    }

    private Set<String> parseFieldList(String fieldList) {
        if (fieldList.startsWith("[f:") && fieldList.endsWith("]")) {
            String content = fieldList.substring(3, fieldList.length() - 1);
            String[] parts = content.split(",");
            return new TreeSet<String>(Arrays.asList(parts));
        }
        return Set.of();
    }

    private Set<String> getFieldsForClass(String wantClass) {
        if (!this.ensureKnownClass(wantClass)) {
            throw new IllegalArgumentException("unknown summary class: " + wantClass);
        }
        return this.knownSummaryClasses.get(wantClass);
    }

    private boolean ensureKnownClass(String wantClass) {
        if (this.knownSummaryClasses.containsKey(wantClass)) {
            return true;
        }
        if (PartialSummaryHandler.isFieldListRequest(wantClass)) {
            Set<String> fieldSet = this.parseFieldList(wantClass);
            if (fieldSet.isEmpty()) {
                return false;
            }
            this.knownSummaryClasses.put(wantClass, fieldSet);
            return true;
        }
        if (this.docsumDefinitions != null && this.docsumDefinitions.hasDocsum(wantClass)) {
            DocsumDefinition docsumDef = this.docsumDefinitions.getDocsum(wantClass);
            Set<String> fields = docsumDef.fields().keySet();
            Set<String> fieldSet = Set.copyOf(fields);
            this.knownSummaryClasses.put(wantClass, fieldSet);
            return true;
        }
        return false;
    }

    private Set<String> fieldsAlreadyFilled(Set<String> alreadyFilled) {
        HashSet<String> gotFields = new HashSet<String>();
        for (String hasSummary : alreadyFilled) {
            if (hasSummary == PRESENTATION) continue;
            Set<String> hasSome = this.getFieldsForClass(hasSummary);
            for (String field : hasSome) {
                gotFields.add(field);
            }
        }
        return gotFields;
    }

    private boolean needsMoreFill(Set<String> alreadyFilled) {
        if (alreadyFilled == null) {
            return false;
        }
        if (alreadyFilled.contains(this.askForSummary)) {
            return false;
        }
        for (String marker : this.fillMarkers) {
            if (!alreadyFilled.contains(marker)) continue;
            return false;
        }
        Set<String> gotFields = this.fieldsAlreadyFilled(alreadyFilled);
        Set<String> wantFields = this.askForFields == null ? this.getFieldsForClass(this.askForSummary) : this.askForFields;
        for (String field : wantFields) {
            if (gotFields.contains(field)) continue;
            return true;
        }
        return false;
    }
}

