/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.statistics;

import com.yahoo.component.chain.Chain;
import com.yahoo.prelude.Pong;
import com.yahoo.processing.Processor;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.statistics.ElapsedTime;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class TimeTracker {
    private State state = null;
    private final List<Tag> tags = new ArrayList<Tag>();
    private SearcherTimer[] searcherTracking = null;
    private final Chain<? extends Processor> searchChain;
    private boolean invoking = true;
    private long last = 0L;
    private final int entryIndex;
    TimeSource timeSource = new TimeSource();

    public TimeTracker(Chain<? extends Searcher> searchChain) {
        this(searchChain, 0);
    }

    public TimeTracker(Chain<? extends Processor> searchChain, int entryIndex) {
        this.searchChain = searchChain;
        this.entryIndex = entryIndex;
    }

    private void concludeState(long now) {
        if (this.state == null) {
            return;
        }
        this.tags.add(new Tag(this.state.start, now, this.state.activity));
        this.state = null;
    }

    private void concludeStateOnExit(long now) {
        if (now != 0L) {
            this.concludeState(now);
        } else {
            this.concludeState(this.getNow());
        }
    }

    private long detailedMeasurements(int searcherIndex, boolean calledAsInvoking) {
        long now = this.getNow();
        if (this.searcherTracking == null) {
            this.initBreakdown();
        }
        SearcherTimer timeSpentIn = this.getPreviouslyRunSearcher(searcherIndex, calledAsInvoking);
        long spent = now - this.last;
        if (timeSpentIn != null && this.last != 0L) {
            if (this.invoking) {
                timeSpentIn.addInvoking(this.getActivity(), spent);
            } else {
                timeSpentIn.addReturning(this.getActivity(), spent);
            }
        }
        this.last = now;
        this.invoking = searcherIndex >= this.searcherTracking.length ? false : calledAsInvoking;
        return now;
    }

    private void enteringState(int searcherIndex, boolean detailed, Activity activity) {
        long now = 0L;
        if (detailed) {
            now = this.detailedMeasurements(searcherIndex, true);
        }
        if (this.isNewState(activity)) {
            if (now == 0L) {
                now = this.getNow();
            }
            this.concludeState(now);
            this.initNewState(now, activity);
        }
    }

    private long fetchTime(Activity filter, Tag container) {
        if (filter == container.activity) {
            return container.end - container.start;
        }
        return 0L;
    }

    public long fillTime() {
        return this.typedSum(Activity.FILL);
    }

    public long first() {
        if (this.tags.isEmpty()) {
            return 0L;
        }
        return this.tags.get((int)0).start;
    }

    public long firstFill() {
        for (Tag t : this.tags) {
            if (t.activity != Activity.FILL) continue;
            return t.start;
        }
        return 0L;
    }

    private Activity getActivity() {
        if (this.state == null) {
            throw new IllegalStateException("Trying to measure an interval having only one point.");
        }
        return this.state.activity;
    }

    private long getNow() {
        return this.timeSource.now();
    }

    private SearcherTimer getPreviouslyRunSearcher(int searcherIndex, boolean calledAsInvoking) {
        if (calledAsInvoking) {
            if (--searcherIndex < this.entryIndex) {
                return null;
            }
            return this.searcherTracking[searcherIndex];
        }
        return this.searcherTracking[searcherIndex];
    }

    private void initBreakdown() {
        if (this.searcherTracking != null) {
            throw new IllegalStateException("initBreakdown invoked when measurement structures are already initialized.");
        }
        List searchers = this.searchChain.components();
        this.searcherTracking = new SearcherTimer[searchers.size()];
        for (int i = 0; i < this.searcherTracking.length; ++i) {
            this.searcherTracking[i] = new SearcherTimer(((Processor)searchers.get(i)).getId().stringValue());
        }
    }

    private void initNewState(long now, Activity activity) {
        this.state = new State(now, activity);
    }

    void injectTimeSource(TimeSource source) {
        this.timeSource = source;
    }

    private boolean isNewState(Activity callPath) {
        if (this.state == null) {
            return true;
        }
        return callPath != this.state.activity;
    }

    public long last() {
        if (this.tags.isEmpty()) {
            return 0L;
        }
        return this.tags.get((int)(this.tags.size() - 1)).end;
    }

    public long pingTime() {
        return this.typedSum(Activity.PING);
    }

    private long returnFromState(int searcherIndex, boolean detailed) {
        if (detailed) {
            return this.detailedMeasurements(searcherIndex, false);
        }
        return 0L;
    }

    public void sampleFill(int searcherIndex, boolean detailed) {
        this.enteringState(searcherIndex, detailed, Activity.FILL);
    }

    public void sampleFillReturn(int searcherIndex, boolean detailed, Result annotationReference) {
        ElapsedTime elapsed = this.getElapsedTime(annotationReference);
        this.sampleReturn(searcherIndex, detailed, elapsed);
    }

    public void samplePing(int searcherIndex, boolean detailed) {
        this.enteringState(searcherIndex, detailed, Activity.PING);
    }

    public void samplePingReturn(int searcherIndex, boolean detailed, Pong annotationReference) {
        ElapsedTime elapsed = this.getElapsedTime(annotationReference);
        this.sampleReturn(searcherIndex, detailed, elapsed);
    }

    public void sampleSearch(int searcherIndex, boolean detailed) {
        this.enteringState(searcherIndex, detailed, Activity.SEARCH);
    }

    public void sampleSearchReturn(int searcherIndex, boolean detailed, Result annotationReference) {
        ElapsedTime elapsed = this.getElapsedTime(annotationReference);
        this.sampleReturn(searcherIndex, detailed, elapsed);
    }

    private void sampleReturn(int searcherIndex, boolean detailed, ElapsedTime elapsed) {
        long now = this.returnFromState(searcherIndex, detailed);
        if (searcherIndex == this.entryIndex) {
            this.concludeStateOnExit(now);
            if (elapsed != null) {
                elapsed.add(this);
            }
        }
    }

    private ElapsedTime getElapsedTime(Result r) {
        return r == null ? null : r.getElapsedTime();
    }

    private ElapsedTime getElapsedTime(Pong p) {
        return p == null ? null : p.getElapsedTime();
    }

    SearcherTimer[] searcherTracking() {
        return this.searcherTracking;
    }

    public long searchTime() {
        return this.typedSum(Activity.SEARCH);
    }

    public long totalTime() {
        return this.last() - this.first();
    }

    private long typedSum(Activity activity) {
        long sum = 0L;
        for (Tag tag : this.tags) {
            sum += this.fetchTime(activity, tag);
        }
        return sum;
    }

    static class State {
        public final long start;
        public final Activity activity;

        State(long start, Activity activity) {
            this.start = start;
            this.activity = activity;
        }
    }

    static class SearcherTimer {
        private final String name;
        private final EnumMap<Activity, Long> invoking = new EnumMap(Activity.class);
        private final EnumMap<Activity, Long> returning = new EnumMap(Activity.class);

        SearcherTimer(String name) {
            this.name = name;
        }

        private void activityRepr(StringBuilder buffer, int preLen, Map.Entry<Activity, Long> m) {
            if (buffer.length() != preLen) {
                buffer.append(", ");
            }
            buffer.append((Object)m.getKey()).append(": ").append(m.getValue()).append(" ms");
        }

        void addInvoking(Activity activity, long time) {
            Long storedTillNow = this.invoking.get((Object)activity);
            long tillNow = this.getTime(storedTillNow);
            this.invoking.put(activity, tillNow + time);
        }

        void addReturning(Activity activity, long time) {
            Long storedTillNow = this.returning.get((Object)activity);
            long tillNow = this.getTime(storedTillNow);
            this.returning.put(activity, tillNow + time);
        }

        Long getInvoking(Activity activity) {
            return this.invoking.get((Object)activity);
        }

        String getName() {
            return this.name;
        }

        Long getReturning(Activity activity) {
            return this.returning.get((Object)activity);
        }

        private long getTime(Long storedTillNow) {
            long tillNow = storedTillNow == null ? 0L : storedTillNow;
            return tillNow;
        }

        public void merge(SearcherTimer other) {
            for (Map.Entry<Activity, Long> invokingEntry : other.invoking.entrySet()) {
                this.addInvoking(invokingEntry.getKey(), invokingEntry.getValue());
            }
            for (Map.Entry<Activity, Long> returningEntry : other.returning.entrySet()) {
                this.addReturning(returningEntry.getKey(), returningEntry.getValue());
            }
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.name).append("(").append("QueryProcessing(");
            int preLen = buffer.length();
            for (Map.Entry<Activity, Long> m : this.invoking.entrySet()) {
                this.activityRepr(buffer, preLen, m);
            }
            buffer.append("), ResultProcessing(");
            preLen = buffer.length();
            for (Map.Entry<Activity, Long> m : this.returning.entrySet()) {
                this.activityRepr(buffer, preLen, m);
            }
            buffer.append("))");
            return buffer.toString();
        }
    }

    static class TimeSource {
        TimeSource() {
        }

        long now() {
            return System.currentTimeMillis();
        }
    }

    static class Tag {
        public final long start;
        public final long end;
        public final Activity activity;

        Tag(long start, long end, Activity activity) {
            this.start = start;
            this.end = end;
            this.activity = activity;
        }
    }

    public static enum Activity {
        PING,
        SEARCH,
        FILL;

    }
}

