/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.rewrite.rewriters;

import com.yahoo.component.ComponentId;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.dependencies.Provides;
import com.yahoo.filedistribution.fileacquirer.FileAcquirer;
import com.yahoo.search.Query;
import com.yahoo.search.query.rewrite.QueryRewriteSearcher;
import com.yahoo.search.query.rewrite.RewriterFeatures;
import com.yahoo.search.query.rewrite.RewriterUtils;
import com.yahoo.search.query.rewrite.RewritesConfig;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;

@Provides(value={"NameRewriter"})
public class NameRewriter
extends QueryRewriteSearcher {
    private final boolean SKIP_REWRITER_IF_REWRITTEN = false;
    public static final String REWRITER_NAME = "NameRewriter";
    public static final String NAME_ENTITY_EXPAND_DICT = "NameEntityExpansion";
    public static final String NAME_ENTITY_EXPAND_DICT_FILENAME = "NameRewriter.fsa";
    private Logger logger;

    @Inject
    public NameRewriter(ComponentId id, FileAcquirer fileAcquirer, RewritesConfig config) {
        super(id, fileAcquirer, config);
    }

    public NameRewriter(RewritesConfig config, HashMap<String, File> fileList) {
        super(config, fileList);
    }

    @Override
    public boolean configure(FileAcquirer fileAcquirer, RewritesConfig config, HashMap<String, File> fileList) {
        this.logger = Logger.getLogger(NameRewriter.class.getName());
        return true;
    }

    @Override
    public HashMap<String, Object> rewrite(Query query, String dictKey) throws RuntimeException {
        Boolean rewritten = false;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Rewritten", rewritten);
        result.put("DictKey", dictKey);
        RewriterUtils.log(this.logger, query, "In NameRewriter, query used for dict retrieval=[" + dictKey + "]");
        String rewrites = super.getRewriteFromFSA(query, NAME_ENTITY_EXPAND_DICT, dictKey);
        RewriterUtils.log(this.logger, query, "Retrieved rewrites: " + rewrites);
        if (rewrites == null) {
            RewriterUtils.log(this.logger, query, "No rewrite is retrieved");
            return result;
        }
        int maxNumRewrites = 0;
        String maxNumRewritesStr = this.getQPConfig(query, "MaxRewrites");
        if (maxNumRewritesStr != null) {
            maxNumRewrites = Integer.parseInt(maxNumRewritesStr);
            RewriterUtils.log(this.logger, query, "Limiting max number of rewrites to: " + maxNumRewrites);
        } else {
            RewriterUtils.log(this.logger, query, "No limit on number of rewrites");
        }
        String originalAsUnit = this.getQPConfig(query, "OriginalAsUnit");
        String originalAsUnitEquiv = this.getQPConfig(query, "OriginalAsUnitEquiv");
        String rewritesAsUnitEquiv = this.getQPConfig(query, "RewritesAsUnitEquiv");
        String rewritesAsEquiv = this.getQPConfig(query, "RewritesAsEquiv");
        if (originalAsUnitEquiv != null && originalAsUnitEquiv.equalsIgnoreCase("true")) {
            RewriterUtils.log(this.logger, query, "OriginalAsUnitEquiv is enabled");
            query = RewriterFeatures.addUnitToOriginalQuery(query, dictKey, true);
            RewriterUtils.log(this.logger, query, "Query after OriginalAsUnitEquiv: " + query.toDetailString());
            rewritten = true;
        } else if (originalAsUnit != null && originalAsUnit.equalsIgnoreCase("true")) {
            RewriterUtils.log(this.logger, query, "OriginalAsUnit is enabled");
            query = RewriterFeatures.addUnitToOriginalQuery(query, dictKey, false);
            RewriterUtils.log(this.logger, query, "Query after OriginalAsUnit: " + query.toDetailString());
            rewritten = true;
        }
        if (rewritesAsUnitEquiv != null && rewritesAsUnitEquiv.equalsIgnoreCase("true")) {
            RewriterUtils.log(this.logger, query, "RewritesAsUnitEquiv is enabled");
            query = RewriterFeatures.addRewritesAsEquiv(query, dictKey, rewrites, true, maxNumRewrites);
            RewriterUtils.log(this.logger, query, "Query after RewritesAsUnitEquiv: " + query.toDetailString());
            rewritten = true;
        } else if (rewritesAsEquiv != null && rewritesAsEquiv.equalsIgnoreCase("true")) {
            RewriterUtils.log(this.logger, query, "RewritesAsEquiv is enabled");
            query = RewriterFeatures.addRewritesAsEquiv(query, dictKey, rewrites, false, maxNumRewrites);
            RewriterUtils.log(this.logger, query, "Query after RewritesAsEquiv: " + query.toDetailString());
            rewritten = true;
        }
        RewriterUtils.log(this.logger, query, "NameRewriter final query: " + query.toDetailString());
        result.put("Rewritten", rewritten);
        return result;
    }

    @Override
    public boolean getSkipRewriterIfRewritten() {
        return false;
    }

    @Override
    public String getRewriterName() {
        return REWRITER_NAME;
    }

    @Override
    public HashMap<String, String> getDefaultFSAs() {
        HashMap<String, String> defaultDicts = new HashMap<String, String>();
        defaultDicts.put(NAME_ENTITY_EXPAND_DICT, NAME_ENTITY_EXPAND_DICT_FILENAME);
        return defaultDicts;
    }
}

