/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DimensionValues
implements Comparable<DimensionValues> {
    private final String[] values;
    public static final DimensionValues empty = new DimensionValues(new String[0]);

    public static DimensionValues createFrom(String[] values) {
        if (values == null || values.length == 0 || DimensionValues.containsAllNulls(values)) {
            return empty;
        }
        return new DimensionValues(values);
    }

    private DimensionValues(String[] values) {
        if (values == null) {
            throw new NullPointerException("Dimension values cannot be null");
        }
        this.values = Arrays.copyOf(values, values.length);
    }

    public boolean matches(DimensionValues givenValues) {
        for (int i = 0; i < this.size() || i < givenValues.size(); ++i) {
            if (this.matches(this.get(i), givenValues.get(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean matches(String conditionString, String checkString) {
        if (conditionString == null) {
            return true;
        }
        return conditionString.equals(checkString);
    }

    @Override
    public int compareTo(DimensionValues other) {
        for (int i = 0; i < this.size() || i < other.size(); ++i) {
            if (this.get(i) != null && other.get(i) == null) {
                return -1;
            }
            if (this.get(i) != null || other.get(i) == null) continue;
            return 1;
        }
        return 0;
    }

    public boolean isMoreSpecificThan(DimensionValues other) {
        return this.compareTo(other) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DimensionValues)) {
            return false;
        }
        DimensionValues other = (DimensionValues)o;
        for (int i = 0; i < this.size() || i < other.size(); ++i) {
            if (!(this.get(i) == null ? other.get(i) != null : !this.get(i).equals(other.get(i)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        for (String value : this.values) {
            ++i;
            if (value == null) continue;
            hashCode += value.hashCode() * i;
        }
        return hashCode;
    }

    public String toString() {
        return "[" + Arrays.stream(this.values).map(value -> value == null ? "*" : value).collect(Collectors.joining(", ")) + "]";
    }

    public boolean isEmpty() {
        return this == empty;
    }

    private static boolean containsAllNulls(String[] values) {
        for (String value : values) {
            if (value == null) continue;
            return false;
        }
        return true;
    }

    public Map<String, String> asContext(List<String> dimensions) {
        HashMap<String, String> context = new HashMap<String, String>();
        if (dimensions == null) {
            return context;
        }
        for (int i = 0; i < dimensions.size(); ++i) {
            context.put(dimensions.get(i), this.get(i));
        }
        return context;
    }

    public String get(int index) {
        if (index >= this.values.length) {
            return null;
        }
        return this.values[index];
    }

    public int size() {
        return this.values.length;
    }

    public String[] getValues() {
        return Arrays.copyOf(this.values, this.values.length);
    }
}

