/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.profile;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ChainedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> primary;
    private final Map<K, V> secondary;

    ChainedMap(Map<K, V> primary, Map<K, V> secondary) {
        this.primary = primary;
        this.secondary = secondary;
    }

    @Override
    public int size() {
        return this.primary.size() >= this.secondary.size() ? this.countUnique(this.primary, this.secondary) : this.countUnique(this.secondary, this.primary);
    }

    private int countUnique(Map<K, V> large, Map<K, V> small) {
        int size = large.size();
        for (K key : small.keySet()) {
            if (large.containsKey(key)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.primary.isEmpty() && this.secondary.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.primary.containsKey(key) || this.secondary.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.primary.containsValue(value) || this.secondary.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = this.primary.get(key);
        return value != null ? value : this.secondary.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        HashSet<K> keys = new HashSet<K>(this.secondary.keySet());
        keys.addAll(this.primary.keySet());
        return keys;
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        throw new UnsupportedOperationException();
    }
}

